/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.device;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getName name}</li>
 * <li>{@link #getModel model}</li>
 * <li>{@link #getMerchant merchant}</li>
 * <li>{@link #getOrderPrefix orderPrefix}</li>
 * <li>{@link #getTerminalId terminalId}</li>
 * <li>{@link #getTerminalPrefix terminalPrefix}</li>
 * <li>{@link #getSerial serial}</li>
 * <li>{@link #getBuildNumber buildNumber}</li>
 * <li>{@link #getSecureId secureId}</li>
 * <li>{@link #getBuildType buildType}</li>
 * <li>{@link #getCpuId cpuId}</li>
 * <li>{@link #getImei imei}</li>
 * <li>{@link #getImsi imsi}</li>
 * <li>{@link #getSimIccid simIccid}</li>
 * <li>{@link #getDeviceCertificate deviceCertificate}</li>
 * <li>{@link #getPedCertificate pedCertificate}</li>
 * <li>{@link #getDeviceTypeName deviceTypeName}</li>
 * <li>{@link #getProductName productName}</li>
 * <li>{@link #getPinDisabled pinDisabled}</li>
 * <li>{@link #getOfflinePayments offlinePayments}</li>
 * <li>{@link #getOfflinePaymentsAll offlinePaymentsAll}</li>
 * <li>{@link #getOfflinePaymentsLimit offlinePaymentsLimit}</li>
 * <li>{@link #getOfflinePaymentsPromptThreshold offlinePaymentsPromptThreshold}</li>
 * <li>{@link #getOfflinePaymentsTotalPaymentsLimit offlinePaymentsTotalPaymentsLimit}</li>
 * <li>{@link #getOfflinePaymentsLimitDefault offlinePaymentsLimitDefault}</li>
 * <li>{@link #getOfflinePaymentsPromptThresholdDefault offlinePaymentsPromptThresholdDefault}</li>
 * <li>{@link #getOfflinePaymentsTotalPaymentsLimitDefault offlinePaymentsTotalPaymentsLimitDefault}</li>
 * <li>{@link #getOfflinePaymentsMaxLimit offlinePaymentsMaxLimit}</li>
 * <li>{@link #getOfflinePaymentsMaxTotalPaymentsLimit offlinePaymentsMaxTotalPaymentsLimit}</li>
 * <li>{@link #getShowOfflinePayments showOfflinePayments}</li>
 * <li>{@link #getMaxOfflineDays maxOfflineDays}</li>
 * <li>{@link #getAllowStoreAndForward allowStoreAndForward}</li>
 * <li>{@link #getSecureReports secureReports}</li>
 * <li>{@link #getBundleIndicator bundleIndicator}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class Device extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * Name of the device (if entered)
   */
  public java.lang.String getName() {
    return genClient.cacheGet(CacheKey.name);
  }

  public java.lang.String getModel() {
    return genClient.cacheGet(CacheKey.model);
  }

  public com.clover.sdk.v3.base.Reference getMerchant() {
    return genClient.cacheGet(CacheKey.merchant);
  }

  /**
   * A prefix that will be applied to order numbers. This is useful if the merchant and/or customer needs to track which device an order came from.
   */
  public java.lang.String getOrderPrefix() {
    return genClient.cacheGet(CacheKey.orderPrefix);
  }

  /**
   * The merchant device's terminal Id. FD-IPG sets the merchant_device terminal Id for LATAM devices
   */
  public java.lang.String getTerminalId() {
    return genClient.cacheGet(CacheKey.terminalId);
  }

  public java.lang.Integer getTerminalPrefix() {
    return genClient.cacheGet(CacheKey.terminalPrefix);
  }

  /**
   * The device's serial number.
   */
  public java.lang.String getSerial() {
    return genClient.cacheGet(CacheKey.serial);
  }

  public java.lang.Long getBuildNumber() {
    return genClient.cacheGet(CacheKey.buildNumber);
  }

  public java.lang.String getSecureId() {
    return genClient.cacheGet(CacheKey.secureId);
  }

  public com.clover.sdk.v3.device.BuildType getBuildType() {
    return genClient.cacheGet(CacheKey.buildType);
  }

  public java.lang.String getCpuId() {
    return genClient.cacheGet(CacheKey.cpuId);
  }

  /**
   * The IMEI of the device
   */
  public java.lang.String getImei() {
    return genClient.cacheGet(CacheKey.imei);
  }

  /**
   * The IMSI of the SIM in the device (if present)
   */
  public java.lang.String getImsi() {
    return genClient.cacheGet(CacheKey.imsi);
  }

  /**
   * The ICCID of the SIM in the device (if present)
   */
  public java.lang.String getSimIccid() {
    return genClient.cacheGet(CacheKey.simIccid);
  }

  public java.lang.String getDeviceCertificate() {
    return genClient.cacheGet(CacheKey.deviceCertificate);
  }

  public java.lang.String getPedCertificate() {
    return genClient.cacheGet(CacheKey.pedCertificate);
  }

  public java.lang.String getDeviceTypeName() {
    return genClient.cacheGet(CacheKey.deviceTypeName);
  }

  public java.lang.String getProductName() {
    return genClient.cacheGet(CacheKey.productName);
  }

  /**
   * Whether this device has PIN prompt disabled.
   */
  public java.lang.Boolean getPinDisabled() {
    return genClient.cacheGet(CacheKey.pinDisabled);
  }

  public java.lang.Boolean getOfflinePayments() {
    return genClient.cacheGet(CacheKey.offlinePayments);
  }

  public java.lang.Boolean getOfflinePaymentsAll() {
    return genClient.cacheGet(CacheKey.offlinePaymentsAll);
  }

  public java.lang.Long getOfflinePaymentsLimit() {
    return genClient.cacheGet(CacheKey.offlinePaymentsLimit);
  }

  public java.lang.Long getOfflinePaymentsPromptThreshold() {
    return genClient.cacheGet(CacheKey.offlinePaymentsPromptThreshold);
  }

  public java.lang.Long getOfflinePaymentsTotalPaymentsLimit() {
    return genClient.cacheGet(CacheKey.offlinePaymentsTotalPaymentsLimit);
  }

  public java.lang.Long getOfflinePaymentsLimitDefault() {
    return genClient.cacheGet(CacheKey.offlinePaymentsLimitDefault);
  }

  public java.lang.Long getOfflinePaymentsPromptThresholdDefault() {
    return genClient.cacheGet(CacheKey.offlinePaymentsPromptThresholdDefault);
  }

  public java.lang.Long getOfflinePaymentsTotalPaymentsLimitDefault() {
    return genClient.cacheGet(CacheKey.offlinePaymentsTotalPaymentsLimitDefault);
  }

  public java.lang.Long getOfflinePaymentsMaxLimit() {
    return genClient.cacheGet(CacheKey.offlinePaymentsMaxLimit);
  }

  public java.lang.Long getOfflinePaymentsMaxTotalPaymentsLimit() {
    return genClient.cacheGet(CacheKey.offlinePaymentsMaxTotalPaymentsLimit);
  }

  public java.lang.Boolean getShowOfflinePayments() {
    return genClient.cacheGet(CacheKey.showOfflinePayments);
  }

  public java.lang.Long getMaxOfflineDays() {
    return genClient.cacheGet(CacheKey.maxOfflineDays);
  }

  public java.lang.Boolean getAllowStoreAndForward() {
    return genClient.cacheGet(CacheKey.allowStoreAndForward);
  }

  public java.util.List<com.clover.sdk.v3.base.Reference> getSecureReports() {
    return genClient.cacheGet(CacheKey.secureReports);
  }

  public java.lang.String getBundleIndicator() {
    return genClient.cacheGet(CacheKey.bundleIndicator);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    name
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    model
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    merchant
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    orderPrefix
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    terminalId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    terminalPrefix
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
    serial
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    buildNumber
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    secureId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    buildType
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.device.BuildType.class)),
    cpuId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    imei
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    imsi
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    simIccid
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    deviceCertificate
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    pedCertificate
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    deviceTypeName
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    productName
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    pinDisabled
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    offlinePayments
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    offlinePaymentsAll
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    offlinePaymentsLimit
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    offlinePaymentsPromptThreshold
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    offlinePaymentsTotalPaymentsLimit
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    offlinePaymentsLimitDefault
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    offlinePaymentsPromptThresholdDefault
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    offlinePaymentsTotalPaymentsLimitDefault
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    offlinePaymentsMaxLimit
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    offlinePaymentsMaxTotalPaymentsLimit
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    showOfflinePayments
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    maxOfflineDays
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    allowStoreAndForward
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    secureReports
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    bundleIndicator
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<Device> genClient;

  /**
   * Constructs a new empty instance.
   */
  public Device() {
    genClient = new GenericClient<Device>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected Device(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public Device(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public Device(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public Device(Device src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateLength(CacheKey.id, getId(), 36);

    genClient.validateLength(CacheKey.name, getName(), 255);

    genClient.validateLength(CacheKey.model, getModel(), 64);

    genClient.validateLength(CacheKey.orderPrefix, getOrderPrefix(), 1);

    genClient.validateLength(CacheKey.terminalId, getTerminalId(), 8);

    genClient.validateLength(CacheKey.serial, getSerial(), 32);

    genClient.validateLength(CacheKey.secureId, getSecureId(), 32);

    genClient.validateLength(CacheKey.cpuId, getCpuId(), 32);

    genClient.validateLength(CacheKey.imei, getImei(), 15);

    genClient.validateLength(CacheKey.imsi, getImsi(), 22);

    genClient.validateLength(CacheKey.simIccid, getSimIccid(), 22);

    genClient.validateLength(CacheKey.deviceCertificate, getDeviceCertificate(), 1600);

    genClient.validateLength(CacheKey.pedCertificate, getPedCertificate(), 2048);

    genClient.validateLength(CacheKey.bundleIndicator, getBundleIndicator(), 32);
    genClient.validateReferences(CacheKey.merchant);
    genClient.validateReferences(CacheKey.secureReports);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return genClient.cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'model' field is set and is not null */
  public boolean isNotNullModel() {
    return genClient.cacheValueIsNotNull(CacheKey.model);
  }

  /** Checks whether the 'merchant' field is set and is not null */
  public boolean isNotNullMerchant() {
    return genClient.cacheValueIsNotNull(CacheKey.merchant);
  }

  /** Checks whether the 'orderPrefix' field is set and is not null */
  public boolean isNotNullOrderPrefix() {
    return genClient.cacheValueIsNotNull(CacheKey.orderPrefix);
  }

  /** Checks whether the 'terminalId' field is set and is not null */
  public boolean isNotNullTerminalId() {
    return genClient.cacheValueIsNotNull(CacheKey.terminalId);
  }

  /** Checks whether the 'terminalPrefix' field is set and is not null */
  public boolean isNotNullTerminalPrefix() {
    return genClient.cacheValueIsNotNull(CacheKey.terminalPrefix);
  }

  /** Checks whether the 'serial' field is set and is not null */
  public boolean isNotNullSerial() {
    return genClient.cacheValueIsNotNull(CacheKey.serial);
  }

  /** Checks whether the 'buildNumber' field is set and is not null */
  public boolean isNotNullBuildNumber() {
    return genClient.cacheValueIsNotNull(CacheKey.buildNumber);
  }

  /** Checks whether the 'secureId' field is set and is not null */
  public boolean isNotNullSecureId() {
    return genClient.cacheValueIsNotNull(CacheKey.secureId);
  }

  /** Checks whether the 'buildType' field is set and is not null */
  public boolean isNotNullBuildType() {
    return genClient.cacheValueIsNotNull(CacheKey.buildType);
  }

  /** Checks whether the 'cpuId' field is set and is not null */
  public boolean isNotNullCpuId() {
    return genClient.cacheValueIsNotNull(CacheKey.cpuId);
  }

  /** Checks whether the 'imei' field is set and is not null */
  public boolean isNotNullImei() {
    return genClient.cacheValueIsNotNull(CacheKey.imei);
  }

  /** Checks whether the 'imsi' field is set and is not null */
  public boolean isNotNullImsi() {
    return genClient.cacheValueIsNotNull(CacheKey.imsi);
  }

  /** Checks whether the 'simIccid' field is set and is not null */
  public boolean isNotNullSimIccid() {
    return genClient.cacheValueIsNotNull(CacheKey.simIccid);
  }

  /** Checks whether the 'deviceCertificate' field is set and is not null */
  public boolean isNotNullDeviceCertificate() {
    return genClient.cacheValueIsNotNull(CacheKey.deviceCertificate);
  }

  /** Checks whether the 'pedCertificate' field is set and is not null */
  public boolean isNotNullPedCertificate() {
    return genClient.cacheValueIsNotNull(CacheKey.pedCertificate);
  }

  /** Checks whether the 'deviceTypeName' field is set and is not null */
  public boolean isNotNullDeviceTypeName() {
    return genClient.cacheValueIsNotNull(CacheKey.deviceTypeName);
  }

  /** Checks whether the 'productName' field is set and is not null */
  public boolean isNotNullProductName() {
    return genClient.cacheValueIsNotNull(CacheKey.productName);
  }

  /** Checks whether the 'pinDisabled' field is set and is not null */
  public boolean isNotNullPinDisabled() {
    return genClient.cacheValueIsNotNull(CacheKey.pinDisabled);
  }

  /** Checks whether the 'offlinePayments' field is set and is not null */
  public boolean isNotNullOfflinePayments() {
    return genClient.cacheValueIsNotNull(CacheKey.offlinePayments);
  }

  /** Checks whether the 'offlinePaymentsAll' field is set and is not null */
  public boolean isNotNullOfflinePaymentsAll() {
    return genClient.cacheValueIsNotNull(CacheKey.offlinePaymentsAll);
  }

  /** Checks whether the 'offlinePaymentsLimit' field is set and is not null */
  public boolean isNotNullOfflinePaymentsLimit() {
    return genClient.cacheValueIsNotNull(CacheKey.offlinePaymentsLimit);
  }

  /** Checks whether the 'offlinePaymentsPromptThreshold' field is set and is not null */
  public boolean isNotNullOfflinePaymentsPromptThreshold() {
    return genClient.cacheValueIsNotNull(CacheKey.offlinePaymentsPromptThreshold);
  }

  /** Checks whether the 'offlinePaymentsTotalPaymentsLimit' field is set and is not null */
  public boolean isNotNullOfflinePaymentsTotalPaymentsLimit() {
    return genClient.cacheValueIsNotNull(CacheKey.offlinePaymentsTotalPaymentsLimit);
  }

  /** Checks whether the 'offlinePaymentsLimitDefault' field is set and is not null */
  public boolean isNotNullOfflinePaymentsLimitDefault() {
    return genClient.cacheValueIsNotNull(CacheKey.offlinePaymentsLimitDefault);
  }

  /** Checks whether the 'offlinePaymentsPromptThresholdDefault' field is set and is not null */
  public boolean isNotNullOfflinePaymentsPromptThresholdDefault() {
    return genClient.cacheValueIsNotNull(CacheKey.offlinePaymentsPromptThresholdDefault);
  }

  /** Checks whether the 'offlinePaymentsTotalPaymentsLimitDefault' field is set and is not null */
  public boolean isNotNullOfflinePaymentsTotalPaymentsLimitDefault() {
    return genClient.cacheValueIsNotNull(CacheKey.offlinePaymentsTotalPaymentsLimitDefault);
  }

  /** Checks whether the 'offlinePaymentsMaxLimit' field is set and is not null */
  public boolean isNotNullOfflinePaymentsMaxLimit() {
    return genClient.cacheValueIsNotNull(CacheKey.offlinePaymentsMaxLimit);
  }

  /** Checks whether the 'offlinePaymentsMaxTotalPaymentsLimit' field is set and is not null */
  public boolean isNotNullOfflinePaymentsMaxTotalPaymentsLimit() {
    return genClient.cacheValueIsNotNull(CacheKey.offlinePaymentsMaxTotalPaymentsLimit);
  }

  /** Checks whether the 'showOfflinePayments' field is set and is not null */
  public boolean isNotNullShowOfflinePayments() {
    return genClient.cacheValueIsNotNull(CacheKey.showOfflinePayments);
  }

  /** Checks whether the 'maxOfflineDays' field is set and is not null */
  public boolean isNotNullMaxOfflineDays() {
    return genClient.cacheValueIsNotNull(CacheKey.maxOfflineDays);
  }

  /** Checks whether the 'allowStoreAndForward' field is set and is not null */
  public boolean isNotNullAllowStoreAndForward() {
    return genClient.cacheValueIsNotNull(CacheKey.allowStoreAndForward);
  }

  /** Checks whether the 'secureReports' field is set and is not null */
  public boolean isNotNullSecureReports() {
    return genClient.cacheValueIsNotNull(CacheKey.secureReports);
  }

  /** Checks whether the 'secureReports' field is set and is not null and is not empty */
  public boolean isNotEmptySecureReports() { return isNotNullSecureReports() && !getSecureReports().isEmpty(); }

  /** Checks whether the 'bundleIndicator' field is set and is not null */
  public boolean isNotNullBundleIndicator() {
    return genClient.cacheValueIsNotNull(CacheKey.bundleIndicator);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return genClient.cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'model' field has been set, however the value could be null */
  public boolean hasModel() {
    return genClient.cacheHasKey(CacheKey.model);
  }

  /** Checks whether the 'merchant' field has been set, however the value could be null */
  public boolean hasMerchant() {
    return genClient.cacheHasKey(CacheKey.merchant);
  }

  /** Checks whether the 'orderPrefix' field has been set, however the value could be null */
  public boolean hasOrderPrefix() {
    return genClient.cacheHasKey(CacheKey.orderPrefix);
  }

  /** Checks whether the 'terminalId' field has been set, however the value could be null */
  public boolean hasTerminalId() {
    return genClient.cacheHasKey(CacheKey.terminalId);
  }

  /** Checks whether the 'terminalPrefix' field has been set, however the value could be null */
  public boolean hasTerminalPrefix() {
    return genClient.cacheHasKey(CacheKey.terminalPrefix);
  }

  /** Checks whether the 'serial' field has been set, however the value could be null */
  public boolean hasSerial() {
    return genClient.cacheHasKey(CacheKey.serial);
  }

  /** Checks whether the 'buildNumber' field has been set, however the value could be null */
  public boolean hasBuildNumber() {
    return genClient.cacheHasKey(CacheKey.buildNumber);
  }

  /** Checks whether the 'secureId' field has been set, however the value could be null */
  public boolean hasSecureId() {
    return genClient.cacheHasKey(CacheKey.secureId);
  }

  /** Checks whether the 'buildType' field has been set, however the value could be null */
  public boolean hasBuildType() {
    return genClient.cacheHasKey(CacheKey.buildType);
  }

  /** Checks whether the 'cpuId' field has been set, however the value could be null */
  public boolean hasCpuId() {
    return genClient.cacheHasKey(CacheKey.cpuId);
  }

  /** Checks whether the 'imei' field has been set, however the value could be null */
  public boolean hasImei() {
    return genClient.cacheHasKey(CacheKey.imei);
  }

  /** Checks whether the 'imsi' field has been set, however the value could be null */
  public boolean hasImsi() {
    return genClient.cacheHasKey(CacheKey.imsi);
  }

  /** Checks whether the 'simIccid' field has been set, however the value could be null */
  public boolean hasSimIccid() {
    return genClient.cacheHasKey(CacheKey.simIccid);
  }

  /** Checks whether the 'deviceCertificate' field has been set, however the value could be null */
  public boolean hasDeviceCertificate() {
    return genClient.cacheHasKey(CacheKey.deviceCertificate);
  }

  /** Checks whether the 'pedCertificate' field has been set, however the value could be null */
  public boolean hasPedCertificate() {
    return genClient.cacheHasKey(CacheKey.pedCertificate);
  }

  /** Checks whether the 'deviceTypeName' field has been set, however the value could be null */
  public boolean hasDeviceTypeName() {
    return genClient.cacheHasKey(CacheKey.deviceTypeName);
  }

  /** Checks whether the 'productName' field has been set, however the value could be null */
  public boolean hasProductName() {
    return genClient.cacheHasKey(CacheKey.productName);
  }

  /** Checks whether the 'pinDisabled' field has been set, however the value could be null */
  public boolean hasPinDisabled() {
    return genClient.cacheHasKey(CacheKey.pinDisabled);
  }

  /** Checks whether the 'offlinePayments' field has been set, however the value could be null */
  public boolean hasOfflinePayments() {
    return genClient.cacheHasKey(CacheKey.offlinePayments);
  }

  /** Checks whether the 'offlinePaymentsAll' field has been set, however the value could be null */
  public boolean hasOfflinePaymentsAll() {
    return genClient.cacheHasKey(CacheKey.offlinePaymentsAll);
  }

  /** Checks whether the 'offlinePaymentsLimit' field has been set, however the value could be null */
  public boolean hasOfflinePaymentsLimit() {
    return genClient.cacheHasKey(CacheKey.offlinePaymentsLimit);
  }

  /** Checks whether the 'offlinePaymentsPromptThreshold' field has been set, however the value could be null */
  public boolean hasOfflinePaymentsPromptThreshold() {
    return genClient.cacheHasKey(CacheKey.offlinePaymentsPromptThreshold);
  }

  /** Checks whether the 'offlinePaymentsTotalPaymentsLimit' field has been set, however the value could be null */
  public boolean hasOfflinePaymentsTotalPaymentsLimit() {
    return genClient.cacheHasKey(CacheKey.offlinePaymentsTotalPaymentsLimit);
  }

  /** Checks whether the 'offlinePaymentsLimitDefault' field has been set, however the value could be null */
  public boolean hasOfflinePaymentsLimitDefault() {
    return genClient.cacheHasKey(CacheKey.offlinePaymentsLimitDefault);
  }

  /** Checks whether the 'offlinePaymentsPromptThresholdDefault' field has been set, however the value could be null */
  public boolean hasOfflinePaymentsPromptThresholdDefault() {
    return genClient.cacheHasKey(CacheKey.offlinePaymentsPromptThresholdDefault);
  }

  /** Checks whether the 'offlinePaymentsTotalPaymentsLimitDefault' field has been set, however the value could be null */
  public boolean hasOfflinePaymentsTotalPaymentsLimitDefault() {
    return genClient.cacheHasKey(CacheKey.offlinePaymentsTotalPaymentsLimitDefault);
  }

  /** Checks whether the 'offlinePaymentsMaxLimit' field has been set, however the value could be null */
  public boolean hasOfflinePaymentsMaxLimit() {
    return genClient.cacheHasKey(CacheKey.offlinePaymentsMaxLimit);
  }

  /** Checks whether the 'offlinePaymentsMaxTotalPaymentsLimit' field has been set, however the value could be null */
  public boolean hasOfflinePaymentsMaxTotalPaymentsLimit() {
    return genClient.cacheHasKey(CacheKey.offlinePaymentsMaxTotalPaymentsLimit);
  }

  /** Checks whether the 'showOfflinePayments' field has been set, however the value could be null */
  public boolean hasShowOfflinePayments() {
    return genClient.cacheHasKey(CacheKey.showOfflinePayments);
  }

  /** Checks whether the 'maxOfflineDays' field has been set, however the value could be null */
  public boolean hasMaxOfflineDays() {
    return genClient.cacheHasKey(CacheKey.maxOfflineDays);
  }

  /** Checks whether the 'allowStoreAndForward' field has been set, however the value could be null */
  public boolean hasAllowStoreAndForward() {
    return genClient.cacheHasKey(CacheKey.allowStoreAndForward);
  }

  /** Checks whether the 'secureReports' field has been set, however the value could be null */
  public boolean hasSecureReports() {
    return genClient.cacheHasKey(CacheKey.secureReports);
  }

  /** Checks whether the 'bundleIndicator' field has been set, however the value could be null */
  public boolean hasBundleIndicator() {
    return genClient.cacheHasKey(CacheKey.bundleIndicator);
  }


  /**
   * Sets the field 'id'.
   */
  public Device setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'name'.
   */
  public Device setName(java.lang.String name) {
    return genClient.setOther(name, CacheKey.name);
  }

  /**
   * Sets the field 'model'.
   */
  public Device setModel(java.lang.String model) {
    return genClient.setOther(model, CacheKey.model);
  }

  /**
   * Sets the field 'merchant'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Device setMerchant(com.clover.sdk.v3.base.Reference merchant) {
    return genClient.setRecord(merchant, CacheKey.merchant);
  }

  /**
   * Sets the field 'orderPrefix'.
   */
  public Device setOrderPrefix(java.lang.String orderPrefix) {
    return genClient.setOther(orderPrefix, CacheKey.orderPrefix);
  }

  /**
   * Sets the field 'terminalId'.
   */
  public Device setTerminalId(java.lang.String terminalId) {
    return genClient.setOther(terminalId, CacheKey.terminalId);
  }

  /**
   * Sets the field 'terminalPrefix'.
   */
  public Device setTerminalPrefix(java.lang.Integer terminalPrefix) {
    return genClient.setOther(terminalPrefix, CacheKey.terminalPrefix);
  }

  /**
   * Sets the field 'serial'.
   */
  public Device setSerial(java.lang.String serial) {
    return genClient.setOther(serial, CacheKey.serial);
  }

  /**
   * Sets the field 'buildNumber'.
   */
  public Device setBuildNumber(java.lang.Long buildNumber) {
    return genClient.setOther(buildNumber, CacheKey.buildNumber);
  }

  /**
   * Sets the field 'secureId'.
   */
  public Device setSecureId(java.lang.String secureId) {
    return genClient.setOther(secureId, CacheKey.secureId);
  }

  /**
   * Sets the field 'buildType'.
   */
  public Device setBuildType(com.clover.sdk.v3.device.BuildType buildType) {
    return genClient.setOther(buildType, CacheKey.buildType);
  }

  /**
   * Sets the field 'cpuId'.
   */
  public Device setCpuId(java.lang.String cpuId) {
    return genClient.setOther(cpuId, CacheKey.cpuId);
  }

  /**
   * Sets the field 'imei'.
   */
  public Device setImei(java.lang.String imei) {
    return genClient.setOther(imei, CacheKey.imei);
  }

  /**
   * Sets the field 'imsi'.
   */
  public Device setImsi(java.lang.String imsi) {
    return genClient.setOther(imsi, CacheKey.imsi);
  }

  /**
   * Sets the field 'simIccid'.
   */
  public Device setSimIccid(java.lang.String simIccid) {
    return genClient.setOther(simIccid, CacheKey.simIccid);
  }

  /**
   * Sets the field 'deviceCertificate'.
   */
  public Device setDeviceCertificate(java.lang.String deviceCertificate) {
    return genClient.setOther(deviceCertificate, CacheKey.deviceCertificate);
  }

  /**
   * Sets the field 'pedCertificate'.
   */
  public Device setPedCertificate(java.lang.String pedCertificate) {
    return genClient.setOther(pedCertificate, CacheKey.pedCertificate);
  }

  /**
   * Sets the field 'deviceTypeName'.
   */
  public Device setDeviceTypeName(java.lang.String deviceTypeName) {
    return genClient.setOther(deviceTypeName, CacheKey.deviceTypeName);
  }

  /**
   * Sets the field 'productName'.
   */
  public Device setProductName(java.lang.String productName) {
    return genClient.setOther(productName, CacheKey.productName);
  }

  /**
   * Sets the field 'pinDisabled'.
   */
  public Device setPinDisabled(java.lang.Boolean pinDisabled) {
    return genClient.setOther(pinDisabled, CacheKey.pinDisabled);
  }

  /**
   * Sets the field 'offlinePayments'.
   */
  public Device setOfflinePayments(java.lang.Boolean offlinePayments) {
    return genClient.setOther(offlinePayments, CacheKey.offlinePayments);
  }

  /**
   * Sets the field 'offlinePaymentsAll'.
   */
  public Device setOfflinePaymentsAll(java.lang.Boolean offlinePaymentsAll) {
    return genClient.setOther(offlinePaymentsAll, CacheKey.offlinePaymentsAll);
  }

  /**
   * Sets the field 'offlinePaymentsLimit'.
   */
  public Device setOfflinePaymentsLimit(java.lang.Long offlinePaymentsLimit) {
    return genClient.setOther(offlinePaymentsLimit, CacheKey.offlinePaymentsLimit);
  }

  /**
   * Sets the field 'offlinePaymentsPromptThreshold'.
   */
  public Device setOfflinePaymentsPromptThreshold(java.lang.Long offlinePaymentsPromptThreshold) {
    return genClient.setOther(offlinePaymentsPromptThreshold, CacheKey.offlinePaymentsPromptThreshold);
  }

  /**
   * Sets the field 'offlinePaymentsTotalPaymentsLimit'.
   */
  public Device setOfflinePaymentsTotalPaymentsLimit(java.lang.Long offlinePaymentsTotalPaymentsLimit) {
    return genClient.setOther(offlinePaymentsTotalPaymentsLimit, CacheKey.offlinePaymentsTotalPaymentsLimit);
  }

  /**
   * Sets the field 'offlinePaymentsLimitDefault'.
   */
  public Device setOfflinePaymentsLimitDefault(java.lang.Long offlinePaymentsLimitDefault) {
    return genClient.setOther(offlinePaymentsLimitDefault, CacheKey.offlinePaymentsLimitDefault);
  }

  /**
   * Sets the field 'offlinePaymentsPromptThresholdDefault'.
   */
  public Device setOfflinePaymentsPromptThresholdDefault(java.lang.Long offlinePaymentsPromptThresholdDefault) {
    return genClient.setOther(offlinePaymentsPromptThresholdDefault, CacheKey.offlinePaymentsPromptThresholdDefault);
  }

  /**
   * Sets the field 'offlinePaymentsTotalPaymentsLimitDefault'.
   */
  public Device setOfflinePaymentsTotalPaymentsLimitDefault(java.lang.Long offlinePaymentsTotalPaymentsLimitDefault) {
    return genClient.setOther(offlinePaymentsTotalPaymentsLimitDefault, CacheKey.offlinePaymentsTotalPaymentsLimitDefault);
  }

  /**
   * Sets the field 'offlinePaymentsMaxLimit'.
   */
  public Device setOfflinePaymentsMaxLimit(java.lang.Long offlinePaymentsMaxLimit) {
    return genClient.setOther(offlinePaymentsMaxLimit, CacheKey.offlinePaymentsMaxLimit);
  }

  /**
   * Sets the field 'offlinePaymentsMaxTotalPaymentsLimit'.
   */
  public Device setOfflinePaymentsMaxTotalPaymentsLimit(java.lang.Long offlinePaymentsMaxTotalPaymentsLimit) {
    return genClient.setOther(offlinePaymentsMaxTotalPaymentsLimit, CacheKey.offlinePaymentsMaxTotalPaymentsLimit);
  }

  /**
   * Sets the field 'showOfflinePayments'.
   */
  public Device setShowOfflinePayments(java.lang.Boolean showOfflinePayments) {
    return genClient.setOther(showOfflinePayments, CacheKey.showOfflinePayments);
  }

  /**
   * Sets the field 'maxOfflineDays'.
   */
  public Device setMaxOfflineDays(java.lang.Long maxOfflineDays) {
    return genClient.setOther(maxOfflineDays, CacheKey.maxOfflineDays);
  }

  /**
   * Sets the field 'allowStoreAndForward'.
   */
  public Device setAllowStoreAndForward(java.lang.Boolean allowStoreAndForward) {
    return genClient.setOther(allowStoreAndForward, CacheKey.allowStoreAndForward);
  }

  /**
   * Sets the field 'secureReports'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Device setSecureReports(java.util.List<com.clover.sdk.v3.base.Reference> secureReports) {
    return genClient.setArrayRecord(secureReports, CacheKey.secureReports);
  }

  /**
   * Sets the field 'bundleIndicator'.
   */
  public Device setBundleIndicator(java.lang.String bundleIndicator) {
    return genClient.setOther(bundleIndicator, CacheKey.bundleIndicator);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    genClient.clear(CacheKey.name);
  }
  /** Clears the 'model' field, the 'has' method for this field will now return false */
  public void clearModel() {
    genClient.clear(CacheKey.model);
  }
  /** Clears the 'merchant' field, the 'has' method for this field will now return false */
  public void clearMerchant() {
    genClient.clear(CacheKey.merchant);
  }
  /** Clears the 'orderPrefix' field, the 'has' method for this field will now return false */
  public void clearOrderPrefix() {
    genClient.clear(CacheKey.orderPrefix);
  }
  /** Clears the 'terminalId' field, the 'has' method for this field will now return false */
  public void clearTerminalId() {
    genClient.clear(CacheKey.terminalId);
  }
  /** Clears the 'terminalPrefix' field, the 'has' method for this field will now return false */
  public void clearTerminalPrefix() {
    genClient.clear(CacheKey.terminalPrefix);
  }
  /** Clears the 'serial' field, the 'has' method for this field will now return false */
  public void clearSerial() {
    genClient.clear(CacheKey.serial);
  }
  /** Clears the 'buildNumber' field, the 'has' method for this field will now return false */
  public void clearBuildNumber() {
    genClient.clear(CacheKey.buildNumber);
  }
  /** Clears the 'secureId' field, the 'has' method for this field will now return false */
  public void clearSecureId() {
    genClient.clear(CacheKey.secureId);
  }
  /** Clears the 'buildType' field, the 'has' method for this field will now return false */
  public void clearBuildType() {
    genClient.clear(CacheKey.buildType);
  }
  /** Clears the 'cpuId' field, the 'has' method for this field will now return false */
  public void clearCpuId() {
    genClient.clear(CacheKey.cpuId);
  }
  /** Clears the 'imei' field, the 'has' method for this field will now return false */
  public void clearImei() {
    genClient.clear(CacheKey.imei);
  }
  /** Clears the 'imsi' field, the 'has' method for this field will now return false */
  public void clearImsi() {
    genClient.clear(CacheKey.imsi);
  }
  /** Clears the 'simIccid' field, the 'has' method for this field will now return false */
  public void clearSimIccid() {
    genClient.clear(CacheKey.simIccid);
  }
  /** Clears the 'deviceCertificate' field, the 'has' method for this field will now return false */
  public void clearDeviceCertificate() {
    genClient.clear(CacheKey.deviceCertificate);
  }
  /** Clears the 'pedCertificate' field, the 'has' method for this field will now return false */
  public void clearPedCertificate() {
    genClient.clear(CacheKey.pedCertificate);
  }
  /** Clears the 'deviceTypeName' field, the 'has' method for this field will now return false */
  public void clearDeviceTypeName() {
    genClient.clear(CacheKey.deviceTypeName);
  }
  /** Clears the 'productName' field, the 'has' method for this field will now return false */
  public void clearProductName() {
    genClient.clear(CacheKey.productName);
  }
  /** Clears the 'pinDisabled' field, the 'has' method for this field will now return false */
  public void clearPinDisabled() {
    genClient.clear(CacheKey.pinDisabled);
  }
  /** Clears the 'offlinePayments' field, the 'has' method for this field will now return false */
  public void clearOfflinePayments() {
    genClient.clear(CacheKey.offlinePayments);
  }
  /** Clears the 'offlinePaymentsAll' field, the 'has' method for this field will now return false */
  public void clearOfflinePaymentsAll() {
    genClient.clear(CacheKey.offlinePaymentsAll);
  }
  /** Clears the 'offlinePaymentsLimit' field, the 'has' method for this field will now return false */
  public void clearOfflinePaymentsLimit() {
    genClient.clear(CacheKey.offlinePaymentsLimit);
  }
  /** Clears the 'offlinePaymentsPromptThreshold' field, the 'has' method for this field will now return false */
  public void clearOfflinePaymentsPromptThreshold() {
    genClient.clear(CacheKey.offlinePaymentsPromptThreshold);
  }
  /** Clears the 'offlinePaymentsTotalPaymentsLimit' field, the 'has' method for this field will now return false */
  public void clearOfflinePaymentsTotalPaymentsLimit() {
    genClient.clear(CacheKey.offlinePaymentsTotalPaymentsLimit);
  }
  /** Clears the 'offlinePaymentsLimitDefault' field, the 'has' method for this field will now return false */
  public void clearOfflinePaymentsLimitDefault() {
    genClient.clear(CacheKey.offlinePaymentsLimitDefault);
  }
  /** Clears the 'offlinePaymentsPromptThresholdDefault' field, the 'has' method for this field will now return false */
  public void clearOfflinePaymentsPromptThresholdDefault() {
    genClient.clear(CacheKey.offlinePaymentsPromptThresholdDefault);
  }
  /** Clears the 'offlinePaymentsTotalPaymentsLimitDefault' field, the 'has' method for this field will now return false */
  public void clearOfflinePaymentsTotalPaymentsLimitDefault() {
    genClient.clear(CacheKey.offlinePaymentsTotalPaymentsLimitDefault);
  }
  /** Clears the 'offlinePaymentsMaxLimit' field, the 'has' method for this field will now return false */
  public void clearOfflinePaymentsMaxLimit() {
    genClient.clear(CacheKey.offlinePaymentsMaxLimit);
  }
  /** Clears the 'offlinePaymentsMaxTotalPaymentsLimit' field, the 'has' method for this field will now return false */
  public void clearOfflinePaymentsMaxTotalPaymentsLimit() {
    genClient.clear(CacheKey.offlinePaymentsMaxTotalPaymentsLimit);
  }
  /** Clears the 'showOfflinePayments' field, the 'has' method for this field will now return false */
  public void clearShowOfflinePayments() {
    genClient.clear(CacheKey.showOfflinePayments);
  }
  /** Clears the 'maxOfflineDays' field, the 'has' method for this field will now return false */
  public void clearMaxOfflineDays() {
    genClient.clear(CacheKey.maxOfflineDays);
  }
  /** Clears the 'allowStoreAndForward' field, the 'has' method for this field will now return false */
  public void clearAllowStoreAndForward() {
    genClient.clear(CacheKey.allowStoreAndForward);
  }
  /** Clears the 'secureReports' field, the 'has' method for this field will now return false */
  public void clearSecureReports() {
    genClient.clear(CacheKey.secureReports);
  }
  /** Clears the 'bundleIndicator' field, the 'has' method for this field will now return false */
  public void clearBundleIndicator() {
    genClient.clear(CacheKey.bundleIndicator);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public Device copyChanges() {
    Device copy = new Device();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(Device src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new Device(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<Device> CREATOR = new android.os.Parcelable.Creator<Device>() {
    @Override
    public Device createFromParcel(android.os.Parcel in) {
      Device instance = new Device(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public Device[] newArray(int size) {
      return new Device[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<Device> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<Device>() {
    public Class<Device> getCreatedClass() {
      return Device.class;
    }

    @Override
    public Device create(org.json.JSONObject jsonObject) {
      return new Device(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 36;
    public static final boolean NAME_IS_REQUIRED = false;
    public static final long NAME_MAX_LEN = 255;
    public static final boolean MODEL_IS_REQUIRED = false;
    public static final long MODEL_MAX_LEN = 64;
    public static final boolean MERCHANT_IS_REQUIRED = false;
    public static final boolean ORDERPREFIX_IS_REQUIRED = false;
    public static final long ORDERPREFIX_MAX_LEN = 1;
    public static final boolean TERMINALID_IS_REQUIRED = false;
    public static final long TERMINALID_MAX_LEN = 8;
    public static final boolean TERMINALPREFIX_IS_REQUIRED = false;
    public static final boolean SERIAL_IS_REQUIRED = false;
    public static final long SERIAL_MAX_LEN = 32;
    public static final boolean BUILDNUMBER_IS_REQUIRED = false;
    public static final boolean SECUREID_IS_REQUIRED = false;
    public static final long SECUREID_MAX_LEN = 32;
    public static final boolean BUILDTYPE_IS_REQUIRED = false;
    public static final boolean CPUID_IS_REQUIRED = false;
    public static final long CPUID_MAX_LEN = 32;
    public static final boolean IMEI_IS_REQUIRED = false;
    public static final long IMEI_MAX_LEN = 15;
    public static final boolean IMSI_IS_REQUIRED = false;
    public static final long IMSI_MAX_LEN = 22;
    public static final boolean SIMICCID_IS_REQUIRED = false;
    public static final long SIMICCID_MAX_LEN = 22;
    public static final boolean DEVICECERTIFICATE_IS_REQUIRED = false;
    public static final long DEVICECERTIFICATE_MAX_LEN = 1600;
    public static final boolean PEDCERTIFICATE_IS_REQUIRED = false;
    public static final long PEDCERTIFICATE_MAX_LEN = 2048;
    public static final boolean DEVICETYPENAME_IS_REQUIRED = false;
    public static final boolean PRODUCTNAME_IS_REQUIRED = false;
    public static final boolean PINDISABLED_IS_REQUIRED = false;
    public static final boolean OFFLINEPAYMENTS_IS_REQUIRED = false;
    public static final boolean OFFLINEPAYMENTSALL_IS_REQUIRED = false;
    public static final boolean OFFLINEPAYMENTSLIMIT_IS_REQUIRED = false;
    public static final boolean OFFLINEPAYMENTSPROMPTTHRESHOLD_IS_REQUIRED = false;
    public static final boolean OFFLINEPAYMENTSTOTALPAYMENTSLIMIT_IS_REQUIRED = false;
    public static final boolean OFFLINEPAYMENTSLIMITDEFAULT_IS_REQUIRED = false;
    public static final boolean OFFLINEPAYMENTSPROMPTTHRESHOLDDEFAULT_IS_REQUIRED = false;
    public static final boolean OFFLINEPAYMENTSTOTALPAYMENTSLIMITDEFAULT_IS_REQUIRED = false;
    public static final boolean OFFLINEPAYMENTSMAXLIMIT_IS_REQUIRED = false;
    public static final boolean OFFLINEPAYMENTSMAXTOTALPAYMENTSLIMIT_IS_REQUIRED = false;
    public static final boolean SHOWOFFLINEPAYMENTS_IS_REQUIRED = false;
    public static final boolean MAXOFFLINEDAYS_IS_REQUIRED = false;
    public static final boolean ALLOWSTOREANDFORWARD_IS_REQUIRED = false;
    public static final boolean SECUREREPORTS_IS_REQUIRED = false;
    public static final boolean BUNDLEINDICATOR_IS_REQUIRED = false;
    public static final long BUNDLEINDICATOR_MAX_LEN = 32;
  }

}
