/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.device;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getModel model}</li>
 * <li>{@link #getSerial serial}</li>
 * <li>{@link #getAssociatedDevice associatedDevice}</li>
 * <li>{@link #getCpuId cpuId}</li>
 * <li>{@link #getPedCertificate pedCertificate}</li>
 * <li>{@link #getBuildType buildType}</li>
 * <li>{@link #getDeviceType deviceType}</li>
 * <li>{@link #getVersionCode versionCode}</li>
 * <li>{@link #getCurrentRom currentRom}</li>
 * <li>{@link #getSecureReports secureReports}</li>
 * <li>{@link #getCreatedTime createdTime}</li>
 * <li>{@link #getModifiedTime modifiedTime}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class DeviceAccessory extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  public java.lang.String getModel() {
    return genClient.cacheGet(CacheKey.model);
  }

  /**
   * The accessories' serial number.
   */
  public java.lang.String getSerial() {
    return genClient.cacheGet(CacheKey.serial);
  }

  /**
   * The device that this accessory is currently connected to, a 128-bit UUID, not a normal base-13 Clover ID.
   */
  public com.clover.sdk.v3.base.Reference getAssociatedDevice() {
    return genClient.cacheGet(CacheKey.associatedDevice);
  }

  public java.lang.String getCpuId() {
    return genClient.cacheGet(CacheKey.cpuId);
  }

  public java.lang.String getPedCertificate() {
    return genClient.cacheGet(CacheKey.pedCertificate);
  }

  public com.clover.sdk.v3.device.DeviceAccessoryBuildType getBuildType() {
    return genClient.cacheGet(CacheKey.buildType);
  }

  public com.clover.sdk.v3.base.Reference getDeviceType() {
    return genClient.cacheGet(CacheKey.deviceType);
  }

  public java.lang.Long getVersionCode() {
    return genClient.cacheGet(CacheKey.versionCode);
  }

  public com.clover.sdk.v3.base.Reference getCurrentRom() {
    return genClient.cacheGet(CacheKey.currentRom);
  }

  public java.util.List<com.clover.sdk.v3.base.Reference> getSecureReports() {
    return genClient.cacheGet(CacheKey.secureReports);
  }

  public java.lang.Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.createdTime);
  }

  public java.lang.Long getModifiedTime() {
    return genClient.cacheGet(CacheKey.modifiedTime);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    model
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    serial
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    associatedDevice
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    cpuId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    pedCertificate
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    buildType
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.device.DeviceAccessoryBuildType.class)),
    deviceType
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    versionCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    currentRom
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    secureReports
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    createdTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    modifiedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<DeviceAccessory> genClient;

  /**
   * Constructs a new empty instance.
   */
  public DeviceAccessory() {
    genClient = new GenericClient<DeviceAccessory>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected DeviceAccessory(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public DeviceAccessory(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public DeviceAccessory(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public DeviceAccessory(DeviceAccessory src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateLength(CacheKey.id, getId(), 36);

    genClient.validateLength(CacheKey.model, getModel(), 64);

    genClient.validateLength(CacheKey.serial, getSerial(), 32);

    genClient.validateLength(CacheKey.cpuId, getCpuId(), 32);

    genClient.validateLength(CacheKey.pedCertificate, getPedCertificate(), 2048);
    genClient.validateReferences(CacheKey.deviceType);
    genClient.validateReferences(CacheKey.currentRom);
    genClient.validateReferences(CacheKey.secureReports);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'model' field is set and is not null */
  public boolean isNotNullModel() {
    return genClient.cacheValueIsNotNull(CacheKey.model);
  }

  /** Checks whether the 'serial' field is set and is not null */
  public boolean isNotNullSerial() {
    return genClient.cacheValueIsNotNull(CacheKey.serial);
  }

  /** Checks whether the 'associatedDevice' field is set and is not null */
  public boolean isNotNullAssociatedDevice() {
    return genClient.cacheValueIsNotNull(CacheKey.associatedDevice);
  }

  /** Checks whether the 'cpuId' field is set and is not null */
  public boolean isNotNullCpuId() {
    return genClient.cacheValueIsNotNull(CacheKey.cpuId);
  }

  /** Checks whether the 'pedCertificate' field is set and is not null */
  public boolean isNotNullPedCertificate() {
    return genClient.cacheValueIsNotNull(CacheKey.pedCertificate);
  }

  /** Checks whether the 'buildType' field is set and is not null */
  public boolean isNotNullBuildType() {
    return genClient.cacheValueIsNotNull(CacheKey.buildType);
  }

  /** Checks whether the 'deviceType' field is set and is not null */
  public boolean isNotNullDeviceType() {
    return genClient.cacheValueIsNotNull(CacheKey.deviceType);
  }

  /** Checks whether the 'versionCode' field is set and is not null */
  public boolean isNotNullVersionCode() {
    return genClient.cacheValueIsNotNull(CacheKey.versionCode);
  }

  /** Checks whether the 'currentRom' field is set and is not null */
  public boolean isNotNullCurrentRom() {
    return genClient.cacheValueIsNotNull(CacheKey.currentRom);
  }

  /** Checks whether the 'secureReports' field is set and is not null */
  public boolean isNotNullSecureReports() {
    return genClient.cacheValueIsNotNull(CacheKey.secureReports);
  }

  /** Checks whether the 'secureReports' field is set and is not null and is not empty */
  public boolean isNotEmptySecureReports() { return isNotNullSecureReports() && !getSecureReports().isEmpty(); }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field is set and is not null */
  public boolean isNotNullModifiedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.modifiedTime);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'model' field has been set, however the value could be null */
  public boolean hasModel() {
    return genClient.cacheHasKey(CacheKey.model);
  }

  /** Checks whether the 'serial' field has been set, however the value could be null */
  public boolean hasSerial() {
    return genClient.cacheHasKey(CacheKey.serial);
  }

  /** Checks whether the 'associatedDevice' field has been set, however the value could be null */
  public boolean hasAssociatedDevice() {
    return genClient.cacheHasKey(CacheKey.associatedDevice);
  }

  /** Checks whether the 'cpuId' field has been set, however the value could be null */
  public boolean hasCpuId() {
    return genClient.cacheHasKey(CacheKey.cpuId);
  }

  /** Checks whether the 'pedCertificate' field has been set, however the value could be null */
  public boolean hasPedCertificate() {
    return genClient.cacheHasKey(CacheKey.pedCertificate);
  }

  /** Checks whether the 'buildType' field has been set, however the value could be null */
  public boolean hasBuildType() {
    return genClient.cacheHasKey(CacheKey.buildType);
  }

  /** Checks whether the 'deviceType' field has been set, however the value could be null */
  public boolean hasDeviceType() {
    return genClient.cacheHasKey(CacheKey.deviceType);
  }

  /** Checks whether the 'versionCode' field has been set, however the value could be null */
  public boolean hasVersionCode() {
    return genClient.cacheHasKey(CacheKey.versionCode);
  }

  /** Checks whether the 'currentRom' field has been set, however the value could be null */
  public boolean hasCurrentRom() {
    return genClient.cacheHasKey(CacheKey.currentRom);
  }

  /** Checks whether the 'secureReports' field has been set, however the value could be null */
  public boolean hasSecureReports() {
    return genClient.cacheHasKey(CacheKey.secureReports);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field has been set, however the value could be null */
  public boolean hasModifiedTime() {
    return genClient.cacheHasKey(CacheKey.modifiedTime);
  }


  /**
   * Sets the field 'id'.
   */
  public DeviceAccessory setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'model'.
   */
  public DeviceAccessory setModel(java.lang.String model) {
    return genClient.setOther(model, CacheKey.model);
  }

  /**
   * Sets the field 'serial'.
   */
  public DeviceAccessory setSerial(java.lang.String serial) {
    return genClient.setOther(serial, CacheKey.serial);
  }

  /**
   * Sets the field 'associatedDevice'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public DeviceAccessory setAssociatedDevice(com.clover.sdk.v3.base.Reference associatedDevice) {
    return genClient.setRecord(associatedDevice, CacheKey.associatedDevice);
  }

  /**
   * Sets the field 'cpuId'.
   */
  public DeviceAccessory setCpuId(java.lang.String cpuId) {
    return genClient.setOther(cpuId, CacheKey.cpuId);
  }

  /**
   * Sets the field 'pedCertificate'.
   */
  public DeviceAccessory setPedCertificate(java.lang.String pedCertificate) {
    return genClient.setOther(pedCertificate, CacheKey.pedCertificate);
  }

  /**
   * Sets the field 'buildType'.
   */
  public DeviceAccessory setBuildType(com.clover.sdk.v3.device.DeviceAccessoryBuildType buildType) {
    return genClient.setOther(buildType, CacheKey.buildType);
  }

  /**
   * Sets the field 'deviceType'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public DeviceAccessory setDeviceType(com.clover.sdk.v3.base.Reference deviceType) {
    return genClient.setRecord(deviceType, CacheKey.deviceType);
  }

  /**
   * Sets the field 'versionCode'.
   */
  public DeviceAccessory setVersionCode(java.lang.Long versionCode) {
    return genClient.setOther(versionCode, CacheKey.versionCode);
  }

  /**
   * Sets the field 'currentRom'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public DeviceAccessory setCurrentRom(com.clover.sdk.v3.base.Reference currentRom) {
    return genClient.setRecord(currentRom, CacheKey.currentRom);
  }

  /**
   * Sets the field 'secureReports'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public DeviceAccessory setSecureReports(java.util.List<com.clover.sdk.v3.base.Reference> secureReports) {
    return genClient.setArrayRecord(secureReports, CacheKey.secureReports);
  }

  /**
   * Sets the field 'createdTime'.
   */
  public DeviceAccessory setCreatedTime(java.lang.Long createdTime) {
    return genClient.setOther(createdTime, CacheKey.createdTime);
  }

  /**
   * Sets the field 'modifiedTime'.
   */
  public DeviceAccessory setModifiedTime(java.lang.Long modifiedTime) {
    return genClient.setOther(modifiedTime, CacheKey.modifiedTime);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'model' field, the 'has' method for this field will now return false */
  public void clearModel() {
    genClient.clear(CacheKey.model);
  }
  /** Clears the 'serial' field, the 'has' method for this field will now return false */
  public void clearSerial() {
    genClient.clear(CacheKey.serial);
  }
  /** Clears the 'associatedDevice' field, the 'has' method for this field will now return false */
  public void clearAssociatedDevice() {
    genClient.clear(CacheKey.associatedDevice);
  }
  /** Clears the 'cpuId' field, the 'has' method for this field will now return false */
  public void clearCpuId() {
    genClient.clear(CacheKey.cpuId);
  }
  /** Clears the 'pedCertificate' field, the 'has' method for this field will now return false */
  public void clearPedCertificate() {
    genClient.clear(CacheKey.pedCertificate);
  }
  /** Clears the 'buildType' field, the 'has' method for this field will now return false */
  public void clearBuildType() {
    genClient.clear(CacheKey.buildType);
  }
  /** Clears the 'deviceType' field, the 'has' method for this field will now return false */
  public void clearDeviceType() {
    genClient.clear(CacheKey.deviceType);
  }
  /** Clears the 'versionCode' field, the 'has' method for this field will now return false */
  public void clearVersionCode() {
    genClient.clear(CacheKey.versionCode);
  }
  /** Clears the 'currentRom' field, the 'has' method for this field will now return false */
  public void clearCurrentRom() {
    genClient.clear(CacheKey.currentRom);
  }
  /** Clears the 'secureReports' field, the 'has' method for this field will now return false */
  public void clearSecureReports() {
    genClient.clear(CacheKey.secureReports);
  }
  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.createdTime);
  }
  /** Clears the 'modifiedTime' field, the 'has' method for this field will now return false */
  public void clearModifiedTime() {
    genClient.clear(CacheKey.modifiedTime);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public DeviceAccessory copyChanges() {
    DeviceAccessory copy = new DeviceAccessory();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(DeviceAccessory src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new DeviceAccessory(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<DeviceAccessory> CREATOR = new android.os.Parcelable.Creator<DeviceAccessory>() {
    @Override
    public DeviceAccessory createFromParcel(android.os.Parcel in) {
      DeviceAccessory instance = new DeviceAccessory(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public DeviceAccessory[] newArray(int size) {
      return new DeviceAccessory[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<DeviceAccessory> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<DeviceAccessory>() {
    public Class<DeviceAccessory> getCreatedClass() {
      return DeviceAccessory.class;
    }

    @Override
    public DeviceAccessory create(org.json.JSONObject jsonObject) {
      return new DeviceAccessory(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 36;
    public static final boolean MODEL_IS_REQUIRED = false;
    public static final long MODEL_MAX_LEN = 64;
    public static final boolean SERIAL_IS_REQUIRED = false;
    public static final long SERIAL_MAX_LEN = 32;
    public static final boolean ASSOCIATEDDEVICE_IS_REQUIRED = false;
    public static final boolean CPUID_IS_REQUIRED = false;
    public static final long CPUID_MAX_LEN = 32;
    public static final boolean PEDCERTIFICATE_IS_REQUIRED = false;
    public static final long PEDCERTIFICATE_MAX_LEN = 2048;
    public static final boolean BUILDTYPE_IS_REQUIRED = false;
    public static final boolean DEVICETYPE_IS_REQUIRED = false;
    public static final boolean VERSIONCODE_IS_REQUIRED = false;
    public static final boolean CURRENTROM_IS_REQUIRED = false;
    public static final boolean SECUREREPORTS_IS_REQUIRED = false;
    public static final boolean CREATEDTIME_IS_REQUIRED = false;
    public static final boolean MODIFIEDTIME_IS_REQUIRED = false;
  }

}
