/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.device;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getPrice price}</li>
 * <li>{@link #getPricingDescription pricingDescription}</li>
 * <li>{@link #getCountry country}</li>
 * <li>{@link #getDeviceTypeName deviceTypeName}</li>
 * <li>{@link #getEquipmentCode equipmentCode}</li>
 * <li>{@link #getCreatedTime createdTime}</li>
 * <li>{@link #getModifiedTime modifiedTime}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class PeripheralBundleCountry extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  public java.lang.Long getPrice() {
    return genClient.cacheGet(CacheKey.price);
  }

  /**
   * User-friendly description of pricing for peripheral
   */
  public java.lang.String getPricingDescription() {
    return genClient.cacheGet(CacheKey.pricingDescription);
  }

  /**
   * The country of the peripheral bundle country
   */
  public java.lang.String getCountry() {
    return genClient.cacheGet(CacheKey.country);
  }

  public java.lang.String getDeviceTypeName() {
    return genClient.cacheGet(CacheKey.deviceTypeName);
  }

  public java.lang.String getEquipmentCode() {
    return genClient.cacheGet(CacheKey.equipmentCode);
  }

  /**
   * Date/time this bundle was created.
   */
  public java.lang.Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.createdTime);
  }

  /**
   * Date/time this bundle was last modified.
   */
  public java.lang.Long getModifiedTime() {
    return genClient.cacheGet(CacheKey.modifiedTime);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    price
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    pricingDescription
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    country
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    deviceTypeName
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    equipmentCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    createdTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    modifiedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<PeripheralBundleCountry> genClient;

  /**
   * Constructs a new empty instance.
   */
  public PeripheralBundleCountry() {
    genClient = new GenericClient<PeripheralBundleCountry>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected PeripheralBundleCountry(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public PeripheralBundleCountry(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public PeripheralBundleCountry(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public PeripheralBundleCountry(PeripheralBundleCountry src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());

    genClient.validateLength(CacheKey.country, getCountry(), 2);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'price' field is set and is not null */
  public boolean isNotNullPrice() {
    return genClient.cacheValueIsNotNull(CacheKey.price);
  }

  /** Checks whether the 'pricingDescription' field is set and is not null */
  public boolean isNotNullPricingDescription() {
    return genClient.cacheValueIsNotNull(CacheKey.pricingDescription);
  }

  /** Checks whether the 'country' field is set and is not null */
  public boolean isNotNullCountry() {
    return genClient.cacheValueIsNotNull(CacheKey.country);
  }

  /** Checks whether the 'deviceTypeName' field is set and is not null */
  public boolean isNotNullDeviceTypeName() {
    return genClient.cacheValueIsNotNull(CacheKey.deviceTypeName);
  }

  /** Checks whether the 'equipmentCode' field is set and is not null */
  public boolean isNotNullEquipmentCode() {
    return genClient.cacheValueIsNotNull(CacheKey.equipmentCode);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field is set and is not null */
  public boolean isNotNullModifiedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.modifiedTime);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'price' field has been set, however the value could be null */
  public boolean hasPrice() {
    return genClient.cacheHasKey(CacheKey.price);
  }

  /** Checks whether the 'pricingDescription' field has been set, however the value could be null */
  public boolean hasPricingDescription() {
    return genClient.cacheHasKey(CacheKey.pricingDescription);
  }

  /** Checks whether the 'country' field has been set, however the value could be null */
  public boolean hasCountry() {
    return genClient.cacheHasKey(CacheKey.country);
  }

  /** Checks whether the 'deviceTypeName' field has been set, however the value could be null */
  public boolean hasDeviceTypeName() {
    return genClient.cacheHasKey(CacheKey.deviceTypeName);
  }

  /** Checks whether the 'equipmentCode' field has been set, however the value could be null */
  public boolean hasEquipmentCode() {
    return genClient.cacheHasKey(CacheKey.equipmentCode);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field has been set, however the value could be null */
  public boolean hasModifiedTime() {
    return genClient.cacheHasKey(CacheKey.modifiedTime);
  }


  /**
   * Sets the field 'id'.
   */
  public PeripheralBundleCountry setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'price'.
   */
  public PeripheralBundleCountry setPrice(java.lang.Long price) {
    return genClient.setOther(price, CacheKey.price);
  }

  /**
   * Sets the field 'pricingDescription'.
   */
  public PeripheralBundleCountry setPricingDescription(java.lang.String pricingDescription) {
    return genClient.setOther(pricingDescription, CacheKey.pricingDescription);
  }

  /**
   * Sets the field 'country'.
   */
  public PeripheralBundleCountry setCountry(java.lang.String country) {
    return genClient.setOther(country, CacheKey.country);
  }

  /**
   * Sets the field 'deviceTypeName'.
   */
  public PeripheralBundleCountry setDeviceTypeName(java.lang.String deviceTypeName) {
    return genClient.setOther(deviceTypeName, CacheKey.deviceTypeName);
  }

  /**
   * Sets the field 'equipmentCode'.
   */
  public PeripheralBundleCountry setEquipmentCode(java.lang.String equipmentCode) {
    return genClient.setOther(equipmentCode, CacheKey.equipmentCode);
  }

  /**
   * Sets the field 'createdTime'.
   */
  public PeripheralBundleCountry setCreatedTime(java.lang.Long createdTime) {
    return genClient.setOther(createdTime, CacheKey.createdTime);
  }

  /**
   * Sets the field 'modifiedTime'.
   */
  public PeripheralBundleCountry setModifiedTime(java.lang.Long modifiedTime) {
    return genClient.setOther(modifiedTime, CacheKey.modifiedTime);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'price' field, the 'has' method for this field will now return false */
  public void clearPrice() {
    genClient.clear(CacheKey.price);
  }
  /** Clears the 'pricingDescription' field, the 'has' method for this field will now return false */
  public void clearPricingDescription() {
    genClient.clear(CacheKey.pricingDescription);
  }
  /** Clears the 'country' field, the 'has' method for this field will now return false */
  public void clearCountry() {
    genClient.clear(CacheKey.country);
  }
  /** Clears the 'deviceTypeName' field, the 'has' method for this field will now return false */
  public void clearDeviceTypeName() {
    genClient.clear(CacheKey.deviceTypeName);
  }
  /** Clears the 'equipmentCode' field, the 'has' method for this field will now return false */
  public void clearEquipmentCode() {
    genClient.clear(CacheKey.equipmentCode);
  }
  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.createdTime);
  }
  /** Clears the 'modifiedTime' field, the 'has' method for this field will now return false */
  public void clearModifiedTime() {
    genClient.clear(CacheKey.modifiedTime);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public PeripheralBundleCountry copyChanges() {
    PeripheralBundleCountry copy = new PeripheralBundleCountry();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(PeripheralBundleCountry src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new PeripheralBundleCountry(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<PeripheralBundleCountry> CREATOR = new android.os.Parcelable.Creator<PeripheralBundleCountry>() {
    @Override
    public PeripheralBundleCountry createFromParcel(android.os.Parcel in) {
      PeripheralBundleCountry instance = new PeripheralBundleCountry(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public PeripheralBundleCountry[] newArray(int size) {
      return new PeripheralBundleCountry[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<PeripheralBundleCountry> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<PeripheralBundleCountry>() {
    public Class<PeripheralBundleCountry> getCreatedClass() {
      return PeripheralBundleCountry.class;
    }

    @Override
    public PeripheralBundleCountry create(org.json.JSONObject jsonObject) {
      return new PeripheralBundleCountry(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean PRICE_IS_REQUIRED = false;
    public static final boolean PRICINGDESCRIPTION_IS_REQUIRED = false;
    public static final boolean COUNTRY_IS_REQUIRED = false;
    public static final long COUNTRY_MAX_LEN = 2;
    public static final boolean DEVICETYPENAME_IS_REQUIRED = false;
    public static final boolean EQUIPMENTCODE_IS_REQUIRED = false;
    public static final boolean CREATEDTIME_IS_REQUIRED = false;
    public static final boolean MODIFIEDTIME_IS_REQUIRED = false;
  }

}
