/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.employees;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getName name}</li>
 * <li>{@link #getLabel label}</li>
 * <li>{@link #getApp app}</li>
 * <li>{@link #getEmployeeDefault employeeDefault}</li>
 * <li>{@link #getManagerDefault managerDefault}</li>
 * <li>{@link #getPermissions permissions}</li>
 * <li>{@link #getEmployeePermissions employeePermissions}</li>
 * <li>{@link #getRoles roles}</li>
 * <li>{@link #getModule module}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class PermissionSet extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * Key of the permissionSet
   */
  public java.lang.String getName() {
    return genClient.cacheGet(CacheKey.name);
  }

  /**
   * Label of the permissionSet
   */
  public java.lang.String getLabel() {
    return genClient.cacheGet(CacheKey.label);
  }

  public com.clover.sdk.v3.base.Reference getApp() {
    return genClient.cacheGet(CacheKey.app);
  }

  public java.lang.Boolean getEmployeeDefault() {
    return genClient.cacheGet(CacheKey.employeeDefault);
  }

  public java.lang.Boolean getManagerDefault() {
    return genClient.cacheGet(CacheKey.managerDefault);
  }

  /**
   * Bitmap of permissions
   */
  public com.clover.sdk.v3.employees.Permissions getPermissions() {
    return genClient.cacheGet(CacheKey.permissions);
  }

  public java.util.List<com.clover.sdk.v3.employees.EmployeePermission> getEmployeePermissions() {
    return genClient.cacheGet(CacheKey.employeePermissions);
  }

  /**
   * roles enabled for this merchant
   */
  public java.util.List<com.clover.sdk.v3.base.Reference> getRoles() {
    return genClient.cacheGet(CacheKey.roles);
  }

  /**
   * The module associated with this permission set (if any)
   */
  public com.clover.sdk.v3.base.Reference getModule() {
    return genClient.cacheGet(CacheKey.module);
  }



  public static final String AUTHORITY = "com.clover.roles";

  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    name
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    label
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    app
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    employeeDefault
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    managerDefault
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    permissions
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.employees.Permissions.JSON_CREATOR)),
    employeePermissions
        (com.clover.sdk.extractors.EnumListExtractionStrategy.instance(com.clover.sdk.v3.employees.EmployeePermission.class)),
    roles
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    module
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<PermissionSet> genClient;

  /**
   * Constructs a new empty instance.
   */
  public PermissionSet() {
    genClient = new GenericClient<PermissionSet>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected PermissionSet(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public PermissionSet(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public PermissionSet(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public PermissionSet(PermissionSet src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());

    genClient.validateLength(CacheKey.name, getName(), 127);

    genClient.validateLength(CacheKey.label, getLabel(), 127);
    genClient.validateReferences(CacheKey.app);
    genClient.validateReferences(CacheKey.roles);
    genClient.validateReferences(CacheKey.module);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return genClient.cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'label' field is set and is not null */
  public boolean isNotNullLabel() {
    return genClient.cacheValueIsNotNull(CacheKey.label);
  }

  /** Checks whether the 'app' field is set and is not null */
  public boolean isNotNullApp() {
    return genClient.cacheValueIsNotNull(CacheKey.app);
  }

  /** Checks whether the 'employeeDefault' field is set and is not null */
  public boolean isNotNullEmployeeDefault() {
    return genClient.cacheValueIsNotNull(CacheKey.employeeDefault);
  }

  /** Checks whether the 'managerDefault' field is set and is not null */
  public boolean isNotNullManagerDefault() {
    return genClient.cacheValueIsNotNull(CacheKey.managerDefault);
  }

  /** Checks whether the 'permissions' field is set and is not null */
  public boolean isNotNullPermissions() {
    return genClient.cacheValueIsNotNull(CacheKey.permissions);
  }

  /** Checks whether the 'employeePermissions' field is set and is not null */
  public boolean isNotNullEmployeePermissions() {
    return genClient.cacheValueIsNotNull(CacheKey.employeePermissions);
  }

  /** Checks whether the 'employeePermissions' field is set and is not null and is not empty */
  public boolean isNotEmptyEmployeePermissions() { return isNotNullEmployeePermissions() && !getEmployeePermissions().isEmpty(); }

  /** Checks whether the 'roles' field is set and is not null */
  public boolean isNotNullRoles() {
    return genClient.cacheValueIsNotNull(CacheKey.roles);
  }

  /** Checks whether the 'roles' field is set and is not null and is not empty */
  public boolean isNotEmptyRoles() { return isNotNullRoles() && !getRoles().isEmpty(); }

  /** Checks whether the 'module' field is set and is not null */
  public boolean isNotNullModule() {
    return genClient.cacheValueIsNotNull(CacheKey.module);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return genClient.cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'label' field has been set, however the value could be null */
  public boolean hasLabel() {
    return genClient.cacheHasKey(CacheKey.label);
  }

  /** Checks whether the 'app' field has been set, however the value could be null */
  public boolean hasApp() {
    return genClient.cacheHasKey(CacheKey.app);
  }

  /** Checks whether the 'employeeDefault' field has been set, however the value could be null */
  public boolean hasEmployeeDefault() {
    return genClient.cacheHasKey(CacheKey.employeeDefault);
  }

  /** Checks whether the 'managerDefault' field has been set, however the value could be null */
  public boolean hasManagerDefault() {
    return genClient.cacheHasKey(CacheKey.managerDefault);
  }

  /** Checks whether the 'permissions' field has been set, however the value could be null */
  public boolean hasPermissions() {
    return genClient.cacheHasKey(CacheKey.permissions);
  }

  /** Checks whether the 'employeePermissions' field has been set, however the value could be null */
  public boolean hasEmployeePermissions() {
    return genClient.cacheHasKey(CacheKey.employeePermissions);
  }

  /** Checks whether the 'roles' field has been set, however the value could be null */
  public boolean hasRoles() {
    return genClient.cacheHasKey(CacheKey.roles);
  }

  /** Checks whether the 'module' field has been set, however the value could be null */
  public boolean hasModule() {
    return genClient.cacheHasKey(CacheKey.module);
  }


  /**
   * Sets the field 'id'.
   */
  public PermissionSet setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'name'.
   */
  public PermissionSet setName(java.lang.String name) {
    return genClient.setOther(name, CacheKey.name);
  }

  /**
   * Sets the field 'label'.
   */
  public PermissionSet setLabel(java.lang.String label) {
    return genClient.setOther(label, CacheKey.label);
  }

  /**
   * Sets the field 'app'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public PermissionSet setApp(com.clover.sdk.v3.base.Reference app) {
    return genClient.setRecord(app, CacheKey.app);
  }

  /**
   * Sets the field 'employeeDefault'.
   */
  public PermissionSet setEmployeeDefault(java.lang.Boolean employeeDefault) {
    return genClient.setOther(employeeDefault, CacheKey.employeeDefault);
  }

  /**
   * Sets the field 'managerDefault'.
   */
  public PermissionSet setManagerDefault(java.lang.Boolean managerDefault) {
    return genClient.setOther(managerDefault, CacheKey.managerDefault);
  }

  /**
   * Sets the field 'permissions'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public PermissionSet setPermissions(com.clover.sdk.v3.employees.Permissions permissions) {
    return genClient.setRecord(permissions, CacheKey.permissions);
  }

  /**
   * Sets the field 'employeePermissions'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public PermissionSet setEmployeePermissions(java.util.List<com.clover.sdk.v3.employees.EmployeePermission> employeePermissions) {
    return genClient.setArrayOther(employeePermissions, CacheKey.employeePermissions);
  }

  /**
   * Sets the field 'roles'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public PermissionSet setRoles(java.util.List<com.clover.sdk.v3.base.Reference> roles) {
    return genClient.setArrayRecord(roles, CacheKey.roles);
  }

  /**
   * Sets the field 'module'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public PermissionSet setModule(com.clover.sdk.v3.base.Reference module) {
    return genClient.setRecord(module, CacheKey.module);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    genClient.clear(CacheKey.name);
  }
  /** Clears the 'label' field, the 'has' method for this field will now return false */
  public void clearLabel() {
    genClient.clear(CacheKey.label);
  }
  /** Clears the 'app' field, the 'has' method for this field will now return false */
  public void clearApp() {
    genClient.clear(CacheKey.app);
  }
  /** Clears the 'employeeDefault' field, the 'has' method for this field will now return false */
  public void clearEmployeeDefault() {
    genClient.clear(CacheKey.employeeDefault);
  }
  /** Clears the 'managerDefault' field, the 'has' method for this field will now return false */
  public void clearManagerDefault() {
    genClient.clear(CacheKey.managerDefault);
  }
  /** Clears the 'permissions' field, the 'has' method for this field will now return false */
  public void clearPermissions() {
    genClient.clear(CacheKey.permissions);
  }
  /** Clears the 'employeePermissions' field, the 'has' method for this field will now return false */
  public void clearEmployeePermissions() {
    genClient.clear(CacheKey.employeePermissions);
  }
  /** Clears the 'roles' field, the 'has' method for this field will now return false */
  public void clearRoles() {
    genClient.clear(CacheKey.roles);
  }
  /** Clears the 'module' field, the 'has' method for this field will now return false */
  public void clearModule() {
    genClient.clear(CacheKey.module);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public PermissionSet copyChanges() {
    PermissionSet copy = new PermissionSet();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(PermissionSet src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new PermissionSet(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<PermissionSet> CREATOR = new android.os.Parcelable.Creator<PermissionSet>() {
    @Override
    public PermissionSet createFromParcel(android.os.Parcel in) {
      PermissionSet instance = new PermissionSet(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public PermissionSet[] newArray(int size) {
      return new PermissionSet[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<PermissionSet> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<PermissionSet>() {
    public Class<PermissionSet> getCreatedClass() {
      return PermissionSet.class;
    }

    @Override
    public PermissionSet create(org.json.JSONObject jsonObject) {
      return new PermissionSet(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean NAME_IS_REQUIRED = false;
    public static final long NAME_MAX_LEN = 127;
    public static final boolean LABEL_IS_REQUIRED = false;
    public static final long LABEL_MAX_LEN = 127;
    public static final boolean APP_IS_REQUIRED = false;
    public static final boolean EMPLOYEEDEFAULT_IS_REQUIRED = false;
    public static final boolean MANAGERDEFAULT_IS_REQUIRED = false;
    public static final boolean PERMISSIONS_IS_REQUIRED = false;
    public static final boolean EMPLOYEEPERMISSIONS_IS_REQUIRED = false;
    public static final boolean ROLES_IS_REQUIRED = false;
    public static final boolean MODULE_IS_REQUIRED = false;
  }

}
