/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.employees;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getRole role}</li>
 * <li>{@link #getPermissionSet permissionSet}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class PermissionSetRole extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Not a normal Clover ID
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * The role
   */
  public com.clover.sdk.v3.base.Reference getRole() {
    return genClient.cacheGet(CacheKey.role);
  }

  /**
   * The role
   */
  public com.clover.sdk.v3.base.Reference getPermissionSet() {
    return genClient.cacheGet(CacheKey.permissionSet);
  }



  public static final String AUTHORITY = "com.clover.roles";

  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    role
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    permissionSet
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<PermissionSetRole> genClient;

  /**
   * Constructs a new empty instance.
   */
  public PermissionSetRole() {
    genClient = new GenericClient<PermissionSetRole>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected PermissionSetRole(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public PermissionSetRole(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public PermissionSetRole(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public PermissionSetRole(PermissionSetRole src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateLength(CacheKey.id, getId(), 27);
    genClient.validateReferences(CacheKey.role);
    genClient.validateReferences(CacheKey.permissionSet);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'role' field is set and is not null */
  public boolean isNotNullRole() {
    return genClient.cacheValueIsNotNull(CacheKey.role);
  }

  /** Checks whether the 'permissionSet' field is set and is not null */
  public boolean isNotNullPermissionSet() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionSet);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'role' field has been set, however the value could be null */
  public boolean hasRole() {
    return genClient.cacheHasKey(CacheKey.role);
  }

  /** Checks whether the 'permissionSet' field has been set, however the value could be null */
  public boolean hasPermissionSet() {
    return genClient.cacheHasKey(CacheKey.permissionSet);
  }


  /**
   * Sets the field 'id'.
   */
  public PermissionSetRole setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'role'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public PermissionSetRole setRole(com.clover.sdk.v3.base.Reference role) {
    return genClient.setRecord(role, CacheKey.role);
  }

  /**
   * Sets the field 'permissionSet'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public PermissionSetRole setPermissionSet(com.clover.sdk.v3.base.Reference permissionSet) {
    return genClient.setRecord(permissionSet, CacheKey.permissionSet);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'role' field, the 'has' method for this field will now return false */
  public void clearRole() {
    genClient.clear(CacheKey.role);
  }
  /** Clears the 'permissionSet' field, the 'has' method for this field will now return false */
  public void clearPermissionSet() {
    genClient.clear(CacheKey.permissionSet);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public PermissionSetRole copyChanges() {
    PermissionSetRole copy = new PermissionSetRole();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(PermissionSetRole src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new PermissionSetRole(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<PermissionSetRole> CREATOR = new android.os.Parcelable.Creator<PermissionSetRole>() {
    @Override
    public PermissionSetRole createFromParcel(android.os.Parcel in) {
      PermissionSetRole instance = new PermissionSetRole(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public PermissionSetRole[] newArray(int size) {
      return new PermissionSetRole[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<PermissionSetRole> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<PermissionSetRole>() {
    public Class<PermissionSetRole> getCreatedClass() {
      return PermissionSetRole.class;
    }

    @Override
    public PermissionSetRole create(org.json.JSONObject jsonObject) {
      return new PermissionSetRole(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 27;
    public static final boolean ROLE_IS_REQUIRED = false;
    public static final boolean PERMISSIONSET_IS_REQUIRED = false;
  }

}
