/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.entitlements;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * Plan code that will be associated with a particular entitlement.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getCode code}</li>
 * <li>{@link #getDescription description}</li>
 * <li>{@link #getServiceEntitlementNumber serviceEntitlementNumber}</li>
 * <li>{@link #getAlphaId alphaId}</li>
 * <li>{@link #getVerificationValue verificationValue}</li>
 * <li>{@link #getMccCode mccCode}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class EntitlementPlanCode extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  public java.lang.String getCode() {
    return genClient.cacheGet(CacheKey.code);
  }

  /**
   * Plan code description
   */
  public java.lang.String getDescription() {
    return genClient.cacheGet(CacheKey.description);
  }

  public java.lang.String getServiceEntitlementNumber() {
    return genClient.cacheGet(CacheKey.serviceEntitlementNumber);
  }

  /**
   * Alpha ID for entitlements. Supplied by First Data.
   */
  public java.lang.String getAlphaId() {
    return genClient.cacheGet(CacheKey.alphaId);
  }

  /**
   * Verification value
   */
  public java.lang.String getVerificationValue() {
    return genClient.cacheGet(CacheKey.verificationValue);
  }

  /**
   * MCC Code
   */
  public java.lang.Integer getMccCode() {
    return genClient.cacheGet(CacheKey.mccCode);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    code
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    description
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    serviceEntitlementNumber
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    alphaId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    verificationValue
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    mccCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<EntitlementPlanCode> genClient;

  /**
   * Constructs a new empty instance.
   */
  public EntitlementPlanCode() {
    genClient = new GenericClient<EntitlementPlanCode>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected EntitlementPlanCode(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public EntitlementPlanCode(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public EntitlementPlanCode(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public EntitlementPlanCode(EntitlementPlanCode src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());

    genClient.validateNotNull(CacheKey.code, getCode());
    genClient.validateLength(CacheKey.code, getCode(), 10);

    genClient.validateLength(CacheKey.description, getDescription(), 40);

    genClient.validateLength(CacheKey.serviceEntitlementNumber, getServiceEntitlementNumber(), 15);

    genClient.validateLength(CacheKey.alphaId, getAlphaId(), 4);

    genClient.validateLength(CacheKey.verificationValue, getVerificationValue(), 10);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'code' field is set and is not null */
  public boolean isNotNullCode() {
    return genClient.cacheValueIsNotNull(CacheKey.code);
  }

  /** Checks whether the 'description' field is set and is not null */
  public boolean isNotNullDescription() {
    return genClient.cacheValueIsNotNull(CacheKey.description);
  }

  /** Checks whether the 'serviceEntitlementNumber' field is set and is not null */
  public boolean isNotNullServiceEntitlementNumber() {
    return genClient.cacheValueIsNotNull(CacheKey.serviceEntitlementNumber);
  }

  /** Checks whether the 'alphaId' field is set and is not null */
  public boolean isNotNullAlphaId() {
    return genClient.cacheValueIsNotNull(CacheKey.alphaId);
  }

  /** Checks whether the 'verificationValue' field is set and is not null */
  public boolean isNotNullVerificationValue() {
    return genClient.cacheValueIsNotNull(CacheKey.verificationValue);
  }

  /** Checks whether the 'mccCode' field is set and is not null */
  public boolean isNotNullMccCode() {
    return genClient.cacheValueIsNotNull(CacheKey.mccCode);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'code' field has been set, however the value could be null */
  public boolean hasCode() {
    return genClient.cacheHasKey(CacheKey.code);
  }

  /** Checks whether the 'description' field has been set, however the value could be null */
  public boolean hasDescription() {
    return genClient.cacheHasKey(CacheKey.description);
  }

  /** Checks whether the 'serviceEntitlementNumber' field has been set, however the value could be null */
  public boolean hasServiceEntitlementNumber() {
    return genClient.cacheHasKey(CacheKey.serviceEntitlementNumber);
  }

  /** Checks whether the 'alphaId' field has been set, however the value could be null */
  public boolean hasAlphaId() {
    return genClient.cacheHasKey(CacheKey.alphaId);
  }

  /** Checks whether the 'verificationValue' field has been set, however the value could be null */
  public boolean hasVerificationValue() {
    return genClient.cacheHasKey(CacheKey.verificationValue);
  }

  /** Checks whether the 'mccCode' field has been set, however the value could be null */
  public boolean hasMccCode() {
    return genClient.cacheHasKey(CacheKey.mccCode);
  }


  /**
   * Sets the field 'id'.
   */
  public EntitlementPlanCode setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'code'.
   */
  public EntitlementPlanCode setCode(java.lang.String code) {
    return genClient.setOther(code, CacheKey.code);
  }

  /**
   * Sets the field 'description'.
   */
  public EntitlementPlanCode setDescription(java.lang.String description) {
    return genClient.setOther(description, CacheKey.description);
  }

  /**
   * Sets the field 'serviceEntitlementNumber'.
   */
  public EntitlementPlanCode setServiceEntitlementNumber(java.lang.String serviceEntitlementNumber) {
    return genClient.setOther(serviceEntitlementNumber, CacheKey.serviceEntitlementNumber);
  }

  /**
   * Sets the field 'alphaId'.
   */
  public EntitlementPlanCode setAlphaId(java.lang.String alphaId) {
    return genClient.setOther(alphaId, CacheKey.alphaId);
  }

  /**
   * Sets the field 'verificationValue'.
   */
  public EntitlementPlanCode setVerificationValue(java.lang.String verificationValue) {
    return genClient.setOther(verificationValue, CacheKey.verificationValue);
  }

  /**
   * Sets the field 'mccCode'.
   */
  public EntitlementPlanCode setMccCode(java.lang.Integer mccCode) {
    return genClient.setOther(mccCode, CacheKey.mccCode);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'code' field, the 'has' method for this field will now return false */
  public void clearCode() {
    genClient.clear(CacheKey.code);
  }
  /** Clears the 'description' field, the 'has' method for this field will now return false */
  public void clearDescription() {
    genClient.clear(CacheKey.description);
  }
  /** Clears the 'serviceEntitlementNumber' field, the 'has' method for this field will now return false */
  public void clearServiceEntitlementNumber() {
    genClient.clear(CacheKey.serviceEntitlementNumber);
  }
  /** Clears the 'alphaId' field, the 'has' method for this field will now return false */
  public void clearAlphaId() {
    genClient.clear(CacheKey.alphaId);
  }
  /** Clears the 'verificationValue' field, the 'has' method for this field will now return false */
  public void clearVerificationValue() {
    genClient.clear(CacheKey.verificationValue);
  }
  /** Clears the 'mccCode' field, the 'has' method for this field will now return false */
  public void clearMccCode() {
    genClient.clear(CacheKey.mccCode);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public EntitlementPlanCode copyChanges() {
    EntitlementPlanCode copy = new EntitlementPlanCode();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(EntitlementPlanCode src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new EntitlementPlanCode(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<EntitlementPlanCode> CREATOR = new android.os.Parcelable.Creator<EntitlementPlanCode>() {
    @Override
    public EntitlementPlanCode createFromParcel(android.os.Parcel in) {
      EntitlementPlanCode instance = new EntitlementPlanCode(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public EntitlementPlanCode[] newArray(int size) {
      return new EntitlementPlanCode[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<EntitlementPlanCode> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<EntitlementPlanCode>() {
    public Class<EntitlementPlanCode> getCreatedClass() {
      return EntitlementPlanCode.class;
    }

    @Override
    public EntitlementPlanCode create(org.json.JSONObject jsonObject) {
      return new EntitlementPlanCode(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean CODE_IS_REQUIRED = true;
    public static final long CODE_MAX_LEN = 10;
    public static final boolean DESCRIPTION_IS_REQUIRED = false;
    public static final long DESCRIPTION_MAX_LEN = 40;
    public static final boolean SERVICEENTITLEMENTNUMBER_IS_REQUIRED = false;
    public static final long SERVICEENTITLEMENTNUMBER_MAX_LEN = 15;
    public static final boolean ALPHAID_IS_REQUIRED = false;
    public static final long ALPHAID_MAX_LEN = 4;
    public static final boolean VERIFICATIONVALUE_IS_REQUIRED = false;
    public static final long VERIFICATIONVALUE_MAX_LEN = 10;
    public static final boolean MCCCODE_IS_REQUIRED = false;
  }

}
