/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.happyhour;


import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;
import androidx.annotation.Nullable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getName name}</li>
 * <li>{@link #getAmount amount}</li>
 * <li>{@link #getPercentage percentage}</li>
 * <li>{@link #getBeginTimeHours beginTimeHours}</li>
 * <li>{@link #getEndTimeHours endTimeHours}</li>
 * <li>{@link #getBeginTimeMinutes beginTimeMinutes}</li>
 * <li>{@link #getEndTimeMinutes endTimeMinutes}</li>
 * <li>{@link #getCategoryIds categoryIds}</li>
 * <li>{@link #getItemIds itemIds}</li>
 * <li>{@link #getDaysOfWeek daysOfWeek}</li>
 * </ul>
 * <p>
 * 
 */
@SuppressWarnings("all")
public class HappyHourDiscount extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  @Nullable
  public String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * Name of the discount
   */
  @Nullable
  public String getName() {
    return genClient.cacheGet(CacheKey.name);
  }

  /**
   * Discount amount in currency units(e.g. cents)
   */
  @Nullable
  public Long getAmount() {
    return genClient.cacheGet(CacheKey.amount);
  }

  /**
   * Discount amount in percent
   */
  @Nullable
  public Long getPercentage() {
    return genClient.cacheGet(CacheKey.percentage);
  }

  /**
   * Discount begin hours time
   */
  @Nullable
  public Integer getBeginTimeHours() {
    return genClient.cacheGet(CacheKey.beginTimeHours);
  }

  /**
   * Discount end hours time
   */
  @Nullable
  public Integer getEndTimeHours() {
    return genClient.cacheGet(CacheKey.endTimeHours);
  }

  /**
   * Discount begin time minutes
   */
  @Nullable
  public Integer getBeginTimeMinutes() {
    return genClient.cacheGet(CacheKey.beginTimeMinutes);
  }

  /**
   * Discount end time minutes
   */
  @Nullable
  public Integer getEndTimeMinutes() {
    return genClient.cacheGet(CacheKey.endTimeMinutes);
  }

  /**
   * list of category ids associated with this discount.
   */
  @Nullable
  public java.util.List<String> getCategoryIds() {
    return genClient.cacheGet(CacheKey.categoryIds);
  }

  /**
   * list of item ids associated with this discount.
   */
  @Nullable
  public java.util.List<String> getItemIds() {
    return genClient.cacheGet(CacheKey.itemIds);
  }

  /**
   * Days of week on which this discount is applicable
   */
  @Nullable
  public java.util.List<String> getDaysOfWeek() {
    return genClient.cacheGet(CacheKey.daysOfWeek);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    name
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    amount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
    percentage
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
    beginTimeHours
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Integer.class)),
    endTimeHours
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Integer.class)),
    beginTimeMinutes
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Integer.class)),
    endTimeMinutes
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Integer.class)),
    categoryIds
        (com.clover.sdk.extractors.BasicListExtractionStrategy.instance(String.class)),
    itemIds
        (com.clover.sdk.extractors.BasicListExtractionStrategy.instance(String.class)),
    daysOfWeek
        (com.clover.sdk.extractors.BasicListExtractionStrategy.instance(String.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<HappyHourDiscount> genClient;

  /**
   * Constructs a new empty instance.
   */
  public HappyHourDiscount() {
    genClient = new GenericClient<HappyHourDiscount>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected HappyHourDiscount(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public HappyHourDiscount(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public HappyHourDiscount(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public HappyHourDiscount(HappyHourDiscount src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());

    genClient.validateNotNull(CacheKey.name, getName());
    genClient.validateLength(CacheKey.name, getName(), 64);

    genClient.validateMax(CacheKey.amount, getAmount(), 0L);

    genClient.validateMinMax(CacheKey.percentage, getPercentage(), 0L, 100L);

    genClient.validateMinMax(CacheKey.beginTimeHours, getBeginTimeHours(), 0L, 23L);

    genClient.validateMinMax(CacheKey.endTimeHours, getEndTimeHours(), 0L, 23L);

    genClient.validateMinMax(CacheKey.beginTimeMinutes, getBeginTimeMinutes(), 0L, 59L);

    genClient.validateMinMax(CacheKey.endTimeMinutes, getEndTimeMinutes(), 0L, 59L);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return genClient.cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'amount' field is set and is not null */
  public boolean isNotNullAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.amount);
  }

  /** Checks whether the 'percentage' field is set and is not null */
  public boolean isNotNullPercentage() {
    return genClient.cacheValueIsNotNull(CacheKey.percentage);
  }

  /** Checks whether the 'beginTimeHours' field is set and is not null */
  public boolean isNotNullBeginTimeHours() {
    return genClient.cacheValueIsNotNull(CacheKey.beginTimeHours);
  }

  /** Checks whether the 'endTimeHours' field is set and is not null */
  public boolean isNotNullEndTimeHours() {
    return genClient.cacheValueIsNotNull(CacheKey.endTimeHours);
  }

  /** Checks whether the 'beginTimeMinutes' field is set and is not null */
  public boolean isNotNullBeginTimeMinutes() {
    return genClient.cacheValueIsNotNull(CacheKey.beginTimeMinutes);
  }

  /** Checks whether the 'endTimeMinutes' field is set and is not null */
  public boolean isNotNullEndTimeMinutes() {
    return genClient.cacheValueIsNotNull(CacheKey.endTimeMinutes);
  }

  /** Checks whether the 'categoryIds' field is set and is not null */
  public boolean isNotNullCategoryIds() {
    return genClient.cacheValueIsNotNull(CacheKey.categoryIds);
  }

  /** Checks whether the 'categoryIds' field is set and is not null and is not empty */
  public boolean isNotEmptyCategoryIds() { return isNotNullCategoryIds() && !getCategoryIds().isEmpty(); }

  /** Checks whether the 'itemIds' field is set and is not null */
  public boolean isNotNullItemIds() {
    return genClient.cacheValueIsNotNull(CacheKey.itemIds);
  }

  /** Checks whether the 'itemIds' field is set and is not null and is not empty */
  public boolean isNotEmptyItemIds() { return isNotNullItemIds() && !getItemIds().isEmpty(); }

  /** Checks whether the 'daysOfWeek' field is set and is not null */
  public boolean isNotNullDaysOfWeek() {
    return genClient.cacheValueIsNotNull(CacheKey.daysOfWeek);
  }

  /** Checks whether the 'daysOfWeek' field is set and is not null and is not empty */
  public boolean isNotEmptyDaysOfWeek() { return isNotNullDaysOfWeek() && !getDaysOfWeek().isEmpty(); }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return genClient.cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'amount' field has been set, however the value could be null */
  public boolean hasAmount() {
    return genClient.cacheHasKey(CacheKey.amount);
  }

  /** Checks whether the 'percentage' field has been set, however the value could be null */
  public boolean hasPercentage() {
    return genClient.cacheHasKey(CacheKey.percentage);
  }

  /** Checks whether the 'beginTimeHours' field has been set, however the value could be null */
  public boolean hasBeginTimeHours() {
    return genClient.cacheHasKey(CacheKey.beginTimeHours);
  }

  /** Checks whether the 'endTimeHours' field has been set, however the value could be null */
  public boolean hasEndTimeHours() {
    return genClient.cacheHasKey(CacheKey.endTimeHours);
  }

  /** Checks whether the 'beginTimeMinutes' field has been set, however the value could be null */
  public boolean hasBeginTimeMinutes() {
    return genClient.cacheHasKey(CacheKey.beginTimeMinutes);
  }

  /** Checks whether the 'endTimeMinutes' field has been set, however the value could be null */
  public boolean hasEndTimeMinutes() {
    return genClient.cacheHasKey(CacheKey.endTimeMinutes);
  }

  /** Checks whether the 'categoryIds' field has been set, however the value could be null */
  public boolean hasCategoryIds() {
    return genClient.cacheHasKey(CacheKey.categoryIds);
  }

  /** Checks whether the 'itemIds' field has been set, however the value could be null */
  public boolean hasItemIds() {
    return genClient.cacheHasKey(CacheKey.itemIds);
  }

  /** Checks whether the 'daysOfWeek' field has been set, however the value could be null */
  public boolean hasDaysOfWeek() {
    return genClient.cacheHasKey(CacheKey.daysOfWeek);
  }


  /**
   * Sets the field 'id'.
   */
  public HappyHourDiscount setId(@Nullable String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'name'.
   */
  public HappyHourDiscount setName(@Nullable String name) {
    return genClient.setOther(name, CacheKey.name);
  }

  /**
   * Sets the field 'amount'.
   */
  public HappyHourDiscount setAmount(@Nullable Long amount) {
    return genClient.setOther(amount, CacheKey.amount);
  }

  /**
   * Sets the field 'percentage'.
   */
  public HappyHourDiscount setPercentage(@Nullable Long percentage) {
    return genClient.setOther(percentage, CacheKey.percentage);
  }

  /**
   * Sets the field 'beginTimeHours'.
   */
  public HappyHourDiscount setBeginTimeHours(@Nullable Integer beginTimeHours) {
    return genClient.setOther(beginTimeHours, CacheKey.beginTimeHours);
  }

  /**
   * Sets the field 'endTimeHours'.
   */
  public HappyHourDiscount setEndTimeHours(@Nullable Integer endTimeHours) {
    return genClient.setOther(endTimeHours, CacheKey.endTimeHours);
  }

  /**
   * Sets the field 'beginTimeMinutes'.
   */
  public HappyHourDiscount setBeginTimeMinutes(@Nullable Integer beginTimeMinutes) {
    return genClient.setOther(beginTimeMinutes, CacheKey.beginTimeMinutes);
  }

  /**
   * Sets the field 'endTimeMinutes'.
   */
  public HappyHourDiscount setEndTimeMinutes(@Nullable Integer endTimeMinutes) {
    return genClient.setOther(endTimeMinutes, CacheKey.endTimeMinutes);
  }

  /**
   * Sets the field 'categoryIds'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public HappyHourDiscount setCategoryIds(@Nullable java.util.List<String> categoryIds) {
    return genClient.setArrayOther(categoryIds, CacheKey.categoryIds);
  }

  /**
   * Sets the field 'itemIds'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public HappyHourDiscount setItemIds(@Nullable java.util.List<String> itemIds) {
    return genClient.setArrayOther(itemIds, CacheKey.itemIds);
  }

  /**
   * Sets the field 'daysOfWeek'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public HappyHourDiscount setDaysOfWeek(@Nullable java.util.List<String> daysOfWeek) {
    return genClient.setArrayOther(daysOfWeek, CacheKey.daysOfWeek);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    genClient.clear(CacheKey.name);
  }
  /** Clears the 'amount' field, the 'has' method for this field will now return false */
  public void clearAmount() {
    genClient.clear(CacheKey.amount);
  }
  /** Clears the 'percentage' field, the 'has' method for this field will now return false */
  public void clearPercentage() {
    genClient.clear(CacheKey.percentage);
  }
  /** Clears the 'beginTimeHours' field, the 'has' method for this field will now return false */
  public void clearBeginTimeHours() {
    genClient.clear(CacheKey.beginTimeHours);
  }
  /** Clears the 'endTimeHours' field, the 'has' method for this field will now return false */
  public void clearEndTimeHours() {
    genClient.clear(CacheKey.endTimeHours);
  }
  /** Clears the 'beginTimeMinutes' field, the 'has' method for this field will now return false */
  public void clearBeginTimeMinutes() {
    genClient.clear(CacheKey.beginTimeMinutes);
  }
  /** Clears the 'endTimeMinutes' field, the 'has' method for this field will now return false */
  public void clearEndTimeMinutes() {
    genClient.clear(CacheKey.endTimeMinutes);
  }
  /** Clears the 'categoryIds' field, the 'has' method for this field will now return false */
  public void clearCategoryIds() {
    genClient.clear(CacheKey.categoryIds);
  }
  /** Clears the 'itemIds' field, the 'has' method for this field will now return false */
  public void clearItemIds() {
    genClient.clear(CacheKey.itemIds);
  }
  /** Clears the 'daysOfWeek' field, the 'has' method for this field will now return false */
  public void clearDaysOfWeek() {
    genClient.clear(CacheKey.daysOfWeek);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public HappyHourDiscount copyChanges() {
    HappyHourDiscount copy = new HappyHourDiscount();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(HappyHourDiscount src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new HappyHourDiscount(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<HappyHourDiscount> CREATOR = new android.os.Parcelable.Creator<HappyHourDiscount>() {
    @Override
    public HappyHourDiscount createFromParcel(android.os.Parcel in) {
      HappyHourDiscount instance = new HappyHourDiscount(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public HappyHourDiscount[] newArray(int size) {
      return new HappyHourDiscount[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<HappyHourDiscount> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<HappyHourDiscount>() {
    public Class<HappyHourDiscount> getCreatedClass() {
      return HappyHourDiscount.class;
    }

    @Override
    public HappyHourDiscount create(org.json.JSONObject jsonObject) {
      return new HappyHourDiscount(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean NAME_IS_REQUIRED = true;
    public static final long NAME_MAX_LEN = 64;
    public static final boolean AMOUNT_IS_REQUIRED = false;
    public static final long AMOUNT_MAX = 0;
    public static final boolean PERCENTAGE_IS_REQUIRED = false;
    public static final long PERCENTAGE_MIN = 0;
    public static final long PERCENTAGE_MAX = 100;
    public static final boolean BEGINTIMEHOURS_IS_REQUIRED = false;
    public static final long BEGINTIMEHOURS_MIN = 0;
    public static final long BEGINTIMEHOURS_MAX = 23;
    public static final boolean ENDTIMEHOURS_IS_REQUIRED = false;
    public static final long ENDTIMEHOURS_MIN = 0;
    public static final long ENDTIMEHOURS_MAX = 23;
    public static final boolean BEGINTIMEMINUTES_IS_REQUIRED = false;
    public static final long BEGINTIMEMINUTES_MIN = 0;
    public static final long BEGINTIMEMINUTES_MAX = 59;
    public static final boolean ENDTIMEMINUTES_IS_REQUIRED = false;
    public static final long ENDTIMEMINUTES_MIN = 0;
    public static final long ENDTIMEMINUTES_MAX = 59;
    public static final boolean CATEGORYIDS_IS_REQUIRED = false;
    public static final boolean ITEMIDS_IS_REQUIRED = false;
    public static final boolean DAYSOFWEEK_IS_REQUIRED = false;
  }

}
