/**
 * Autogenerated by Avro
 *
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.inventory;


import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getName name}</li>
 * <li>{@link #getSortOrder sortOrder}</li>
 * <li>{@link #getItems items}</li>
 * <li>{@link #getParentCategory parentCategory}</li>
 * <li>{@link #getSubCategories subCategories}</li>
 * <li>{@link #getColorCode colorCode}</li>
 * <li>{@link #getDeleted deleted}</li>
 * <li>{@link #getModifiedTime modifiedTime}</li>
 * <li>{@link #getCanonical canonical}</li>
 * <li>{@link #getMenuSection menuSection}</li>
 * </ul>
 * <p>
 * @see com.clover.sdk.v3.inventory.IInventoryService
 */
@SuppressWarnings("all")
public class Category extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * The name of the category which will appear in Clover Register App.
   */
  public java.lang.String getName() {
    return genClient.cacheGet(CacheKey.name);
  }

  /**
   * Integer used to determine how this category is sorted against other categories.
   */
  public java.lang.Integer getSortOrder() {
    return genClient.cacheGet(CacheKey.sortOrder);
  }

  /**
   * Ordered list of items associated with this category.
   */
  public java.util.List<com.clover.sdk.v3.base.Reference> getItems() {
    return genClient.cacheGet(CacheKey.items);
  }

  /**
   * Reference to parent category
   */
  public com.clover.sdk.v3.base.Reference getParentCategory() {
    return genClient.cacheGet(CacheKey.parentCategory);
  }

  /**
   * List of subcategories under this category.
   */
  public java.util.List<com.clover.sdk.v3.base.Reference> getSubCategories() {
    return genClient.cacheGet(CacheKey.subCategories);
  }

  /**
   * Hex code representation of the color assigned to this category and its items, in the form of #fff, #ffffff, or #ffffffff
   */
  public java.lang.String getColorCode() {
    return genClient.cacheGet(CacheKey.colorCode);
  }

  /**
   * Whether the category has been deleted.
   */
  public java.lang.Boolean getDeleted() {
    return genClient.cacheGet(CacheKey.deleted);
  }

  /**
   * The time this category was last modified
   */
  public java.lang.Long getModifiedTime() {
    return genClient.cacheGet(CacheKey.modifiedTime);
  }

  /**
   * Reference to canonical category
   */
  public com.clover.sdk.v3.base.Reference getCanonical() {
    return genClient.cacheGet(CacheKey.canonical);
  }

  /**
   * Menu Section attribute that can be expanded to menu section specific attributes
   */
  public com.clover.sdk.v3.inventory.MenuSection getMenuSection() {
    return genClient.cacheGet(CacheKey.menuSection);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    name
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    sortOrder
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
    items
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    parentCategory
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    subCategories
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    colorCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    deleted
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    modifiedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    canonical
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    menuSection
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.inventory.MenuSection.JSON_CREATOR)),
    ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<Category> genClient;

  /**
   * Constructs a new empty instance.
   */
  public Category() {
    genClient = new GenericClient<Category>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected Category(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public Category(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public Category(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public Category(Category src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());

    genClient.validateNotNull(CacheKey.name, getName());
    genClient.validateLength(CacheKey.name, getName(), 127);

    genClient.validateLength(CacheKey.colorCode, getColorCode(), 9);
    genClient.validateReferences(CacheKey.items);
    genClient.validateReferences(CacheKey.parentCategory);
    genClient.validateReferences(CacheKey.subCategories);
    genClient.validateReferences(CacheKey.canonical);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return genClient.cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'sortOrder' field is set and is not null */
  public boolean isNotNullSortOrder() {
    return genClient.cacheValueIsNotNull(CacheKey.sortOrder);
  }

  /** Checks whether the 'items' field is set and is not null */
  public boolean isNotNullItems() {
    return genClient.cacheValueIsNotNull(CacheKey.items);
  }

  /** Checks whether the 'items' field is set and is not null and is not empty */
  public boolean isNotEmptyItems() { return isNotNullItems() && !getItems().isEmpty(); }

  /** Checks whether the 'parentCategory' field is set and is not null */
  public boolean isNotNullParentCategory() {
    return genClient.cacheValueIsNotNull(CacheKey.parentCategory);
  }

  /** Checks whether the 'subCategories' field is set and is not null */
  public boolean isNotNullSubCategories() {
    return genClient.cacheValueIsNotNull(CacheKey.subCategories);
  }

  /** Checks whether the 'subCategories' field is set and is not null and is not empty */
  public boolean isNotEmptySubCategories() { return isNotNullSubCategories() && !getSubCategories().isEmpty(); }

  /** Checks whether the 'colorCode' field is set and is not null */
  public boolean isNotNullColorCode() {
    return genClient.cacheValueIsNotNull(CacheKey.colorCode);
  }

  /** Checks whether the 'deleted' field is set and is not null */
  public boolean isNotNullDeleted() {
    return genClient.cacheValueIsNotNull(CacheKey.deleted);
  }

  /** Checks whether the 'modifiedTime' field is set and is not null */
  public boolean isNotNullModifiedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.modifiedTime);
  }

  /** Checks whether the 'canonical' field is set and is not null */
  public boolean isNotNullCanonical() {
    return genClient.cacheValueIsNotNull(CacheKey.canonical);
  }

  /** Checks whether the 'menuSection' field is set and is not null */
  public boolean isNotNullMenuSection() {
    return genClient.cacheValueIsNotNull(CacheKey.menuSection);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return genClient.cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'sortOrder' field has been set, however the value could be null */
  public boolean hasSortOrder() {
    return genClient.cacheHasKey(CacheKey.sortOrder);
  }

  /** Checks whether the 'items' field has been set, however the value could be null */
  public boolean hasItems() {
    return genClient.cacheHasKey(CacheKey.items);
  }

  /** Checks whether the 'parentCategory' field has been set, however the value could be null */
  public boolean hasParentCategory() {
    return genClient.cacheHasKey(CacheKey.parentCategory);
  }

  /** Checks whether the 'subCategories' field has been set, however the value could be null */
  public boolean hasSubCategories() {
    return genClient.cacheHasKey(CacheKey.subCategories);
  }

  /** Checks whether the 'colorCode' field has been set, however the value could be null */
  public boolean hasColorCode() {
    return genClient.cacheHasKey(CacheKey.colorCode);
  }

  /** Checks whether the 'deleted' field has been set, however the value could be null */
  public boolean hasDeleted() {
    return genClient.cacheHasKey(CacheKey.deleted);
  }

  /** Checks whether the 'modifiedTime' field has been set, however the value could be null */
  public boolean hasModifiedTime() {
    return genClient.cacheHasKey(CacheKey.modifiedTime);
  }

  /** Checks whether the 'canonical' field has been set, however the value could be null */
  public boolean hasCanonical() {
    return genClient.cacheHasKey(CacheKey.canonical);
  }

  /** Checks whether the 'menuSection' field has been set, however the value could be null */
  public boolean hasMenuSection() {
    return genClient.cacheHasKey(CacheKey.menuSection);
  }


  /**
   * Sets the field 'id'.
   */
  public Category setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'name'.
   */
  public Category setName(java.lang.String name) {
    return genClient.setOther(name, CacheKey.name);
  }

  /**
   * Sets the field 'sortOrder'.
   */
  public Category setSortOrder(java.lang.Integer sortOrder) {
    return genClient.setOther(sortOrder, CacheKey.sortOrder);
  }

  /**
   * Sets the field 'items'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Category setItems(java.util.List<com.clover.sdk.v3.base.Reference> items) {
    return genClient.setArrayRecord(items, CacheKey.items);
  }

  /**
   * Sets the field 'parentCategory'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Category setParentCategory(com.clover.sdk.v3.base.Reference parentCategory) {
    return genClient.setRecord(parentCategory, CacheKey.parentCategory);
  }

  /**
   * Sets the field 'subCategories'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Category setSubCategories(java.util.List<com.clover.sdk.v3.base.Reference> subCategories) {
    return genClient.setArrayRecord(subCategories, CacheKey.subCategories);
  }

  /**
   * Sets the field 'colorCode'.
   */
  public Category setColorCode(java.lang.String colorCode) {
    return genClient.setOther(colorCode, CacheKey.colorCode);
  }

  /**
   * Sets the field 'deleted'.
   */
  public Category setDeleted(java.lang.Boolean deleted) {
    return genClient.setOther(deleted, CacheKey.deleted);
  }

  /**
   * Sets the field 'modifiedTime'.
   */
  public Category setModifiedTime(java.lang.Long modifiedTime) {
    return genClient.setOther(modifiedTime, CacheKey.modifiedTime);
  }

  /**
   * Sets the field 'canonical'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Category setCanonical(com.clover.sdk.v3.base.Reference canonical) {
    return genClient.setRecord(canonical, CacheKey.canonical);
  }

  /**
   * Sets the field 'menuSection'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Category setMenuSection(com.clover.sdk.v3.inventory.MenuSection menuSection) {
    return genClient.setRecord(menuSection, CacheKey.menuSection);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    genClient.clear(CacheKey.name);
  }
  /** Clears the 'sortOrder' field, the 'has' method for this field will now return false */
  public void clearSortOrder() {
    genClient.clear(CacheKey.sortOrder);
  }
  /** Clears the 'items' field, the 'has' method for this field will now return false */
  public void clearItems() {
    genClient.clear(CacheKey.items);
  }
  /** Clears the 'parentCategory' field, the 'has' method for this field will now return false */
  public void clearParentCategory() {
    genClient.clear(CacheKey.parentCategory);
  }
  /** Clears the 'subCategories' field, the 'has' method for this field will now return false */
  public void clearSubCategories() {
    genClient.clear(CacheKey.subCategories);
  }
  /** Clears the 'colorCode' field, the 'has' method for this field will now return false */
  public void clearColorCode() {
    genClient.clear(CacheKey.colorCode);
  }
  /** Clears the 'deleted' field, the 'has' method for this field will now return false */
  public void clearDeleted() {
    genClient.clear(CacheKey.deleted);
  }
  /** Clears the 'modifiedTime' field, the 'has' method for this field will now return false */
  public void clearModifiedTime() {
    genClient.clear(CacheKey.modifiedTime);
  }
  /** Clears the 'canonical' field, the 'has' method for this field will now return false */
  public void clearCanonical() {
    genClient.clear(CacheKey.canonical);
  }
  /** Clears the 'menuSection' field, the 'has' method for this field will now return false */
  public void clearMenuSection() {
    genClient.clear(CacheKey.menuSection);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public Category copyChanges() {
    Category copy = new Category();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(Category src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new Category(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<Category> CREATOR = new android.os.Parcelable.Creator<Category>() {
    @Override
    public Category createFromParcel(android.os.Parcel in) {
      Category instance = new Category(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public Category[] newArray(int size) {
      return new Category[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<Category> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<Category>() {
    public Class<Category> getCreatedClass() {
      return Category.class;
    }

    @Override
    public Category create(org.json.JSONObject jsonObject) {
      return new Category(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean NAME_IS_REQUIRED = true;
    public static final long NAME_MAX_LEN = 127;
    public static final boolean SORTORDER_IS_REQUIRED = false;
    public static final boolean ITEMS_IS_REQUIRED = false;
    public static final boolean PARENTCATEGORY_IS_REQUIRED = false;
    public static final boolean SUBCATEGORIES_IS_REQUIRED = false;
    public static final boolean COLORCODE_IS_REQUIRED = false;
    public static final long COLORCODE_MAX_LEN = 9;
    public static final boolean DELETED_IS_REQUIRED = false;
    public static final boolean MODIFIEDTIME_IS_REQUIRED = false;
    public static final boolean CANONICAL_IS_REQUIRED = false;
    public static final boolean MENUSECTION_IS_REQUIRED = false;
  }

}
