/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.inventory;


import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getMenuId menuId}</li>
 * <li>{@link #getItemOverrideId itemOverrideId}</li>
 * <li>{@link #getLayoutOverrides layoutOverrides}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class ItemLayoutOverridesMenuObject extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  public String getMenuId() {
    return genClient.cacheGet(CacheKey.menuId);
  }

  public String getItemOverrideId() {
    return genClient.cacheGet(CacheKey.itemOverrideId);
  }

  public java.util.List<com.clover.sdk.v3.inventory.LayoutOverrideObject> getLayoutOverrides() {
    return genClient.cacheGet(CacheKey.layoutOverrides);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    menuId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    itemOverrideId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    layoutOverrides
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.inventory.LayoutOverrideObject.JSON_CREATOR)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<ItemLayoutOverridesMenuObject> genClient;

  /**
   * Constructs a new empty instance.
   */
  public ItemLayoutOverridesMenuObject() {
    genClient = new GenericClient<ItemLayoutOverridesMenuObject>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected ItemLayoutOverridesMenuObject(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public ItemLayoutOverridesMenuObject(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public ItemLayoutOverridesMenuObject(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public ItemLayoutOverridesMenuObject(ItemLayoutOverridesMenuObject src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateLength(CacheKey.menuId, getMenuId(), 13);

    genClient.validateLength(CacheKey.itemOverrideId, getItemOverrideId(), 13);
  }

  /** Checks whether the 'menuId' field is set and is not null */
  public boolean isNotNullMenuId() {
    return genClient.cacheValueIsNotNull(CacheKey.menuId);
  }

  /** Checks whether the 'itemOverrideId' field is set and is not null */
  public boolean isNotNullItemOverrideId() {
    return genClient.cacheValueIsNotNull(CacheKey.itemOverrideId);
  }

  /** Checks whether the 'layoutOverrides' field is set and is not null */
  public boolean isNotNullLayoutOverrides() {
    return genClient.cacheValueIsNotNull(CacheKey.layoutOverrides);
  }

  /** Checks whether the 'layoutOverrides' field is set and is not null and is not empty */
  public boolean isNotEmptyLayoutOverrides() { return isNotNullLayoutOverrides() && !getLayoutOverrides().isEmpty(); }



  /** Checks whether the 'menuId' field has been set, however the value could be null */
  public boolean hasMenuId() {
    return genClient.cacheHasKey(CacheKey.menuId);
  }

  /** Checks whether the 'itemOverrideId' field has been set, however the value could be null */
  public boolean hasItemOverrideId() {
    return genClient.cacheHasKey(CacheKey.itemOverrideId);
  }

  /** Checks whether the 'layoutOverrides' field has been set, however the value could be null */
  public boolean hasLayoutOverrides() {
    return genClient.cacheHasKey(CacheKey.layoutOverrides);
  }


  /**
   * Sets the field 'menuId'.
   */
  public ItemLayoutOverridesMenuObject setMenuId(String menuId) {
    return genClient.setOther(menuId, CacheKey.menuId);
  }

  /**
   * Sets the field 'itemOverrideId'.
   */
  public ItemLayoutOverridesMenuObject setItemOverrideId(String itemOverrideId) {
    return genClient.setOther(itemOverrideId, CacheKey.itemOverrideId);
  }

  /**
   * Sets the field 'layoutOverrides'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public ItemLayoutOverridesMenuObject setLayoutOverrides(java.util.List<com.clover.sdk.v3.inventory.LayoutOverrideObject> layoutOverrides) {
    return genClient.setArrayRecord(layoutOverrides, CacheKey.layoutOverrides);
  }


  /** Clears the 'menuId' field, the 'has' method for this field will now return false */
  public void clearMenuId() {
    genClient.clear(CacheKey.menuId);
  }
  /** Clears the 'itemOverrideId' field, the 'has' method for this field will now return false */
  public void clearItemOverrideId() {
    genClient.clear(CacheKey.itemOverrideId);
  }
  /** Clears the 'layoutOverrides' field, the 'has' method for this field will now return false */
  public void clearLayoutOverrides() {
    genClient.clear(CacheKey.layoutOverrides);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public ItemLayoutOverridesMenuObject copyChanges() {
    ItemLayoutOverridesMenuObject copy = new ItemLayoutOverridesMenuObject();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(ItemLayoutOverridesMenuObject src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new ItemLayoutOverridesMenuObject(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<ItemLayoutOverridesMenuObject> CREATOR = new android.os.Parcelable.Creator<ItemLayoutOverridesMenuObject>() {
    @Override
    public ItemLayoutOverridesMenuObject createFromParcel(android.os.Parcel in) {
      ItemLayoutOverridesMenuObject instance = new ItemLayoutOverridesMenuObject(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public ItemLayoutOverridesMenuObject[] newArray(int size) {
      return new ItemLayoutOverridesMenuObject[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<ItemLayoutOverridesMenuObject> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<ItemLayoutOverridesMenuObject>() {
    public Class<ItemLayoutOverridesMenuObject> getCreatedClass() {
      return ItemLayoutOverridesMenuObject.class;
    }

    @Override
    public ItemLayoutOverridesMenuObject create(org.json.JSONObject jsonObject) {
      return new ItemLayoutOverridesMenuObject(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean MENUID_IS_REQUIRED = false;
    public static final long MENUID_MAX_LEN = 13;
    public static final boolean ITEMOVERRIDEID_IS_REQUIRED = false;
    public static final long ITEMOVERRIDEID_MAX_LEN = 13;
    public static final boolean LAYOUTOVERRIDES_IS_REQUIRED = false;
  }

}
