/**
 * Autogenerated by Avro
 *
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.inventory;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getModifier modifier}</li>
 * <li>{@link #getPrice price}</li>
 * <li>{@link #getName name}</li>
 * <li>{@link #getDescription description}</li>
 * <li>{@link #getImageFilename imageFilename}</li>
 * <li>{@link #getEnabled enabled}</li>
 * <li>{@link #getReasonCode reasonCode}</li>
 * <li>{@link #getCreatedTime createdTime}</li>
 * <li>{@link #getModifiedTime modifiedTime}</li>
 * <li>{@link #getDeletedTime deletedTime}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class MenuModifier extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Modifier id
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * Reference to the modifier
   */
  public com.clover.sdk.v3.base.Reference getModifier() {
    return genClient.cacheGet(CacheKey.modifier);
  }

  /**
   * Modifier price
   */
  public java.lang.Long getPrice() {
    return genClient.cacheGet(CacheKey.price);
  }

  /**
   * Customer facing modifier name
   */
  public java.lang.String getName() {
    return genClient.cacheGet(CacheKey.name);
  }

  /**
   * Modifier description
   */
  public java.lang.String getDescription() {
    return genClient.cacheGet(CacheKey.description);
  }

  /**
   * Modifier image file path
   */
  public java.lang.String getImageFilename() {
    return genClient.cacheGet(CacheKey.imageFilename);
  }

  /**
   * Modifier enabled for menu
   */
  public java.lang.Boolean getEnabled() {
    return genClient.cacheGet(CacheKey.enabled);
  }

  /**
   * Reason for being filtered out
   */
  public java.lang.String getReasonCode() {
    return genClient.cacheGet(CacheKey.reasonCode);
  }

  /**
   * Timestamp when the menu modifier was created
   */
  public java.lang.Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.createdTime);
  }

  /**
   * Timestamp when the menu modifier was last modified
   */
  public java.lang.Long getModifiedTime() {
    return genClient.cacheGet(CacheKey.modifiedTime);
  }

  /**
   * Timestamp when menu modifier was last deleted
   */
  public java.lang.Long getDeletedTime() {
    return genClient.cacheGet(CacheKey.deletedTime);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    modifier
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    price
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    name
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    description
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    imageFilename
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    enabled
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    reasonCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    createdTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    modifiedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    deletedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<MenuModifier> genClient;

  /**
   * Constructs a new empty instance.
   */
  public MenuModifier() {
    genClient = new GenericClient<MenuModifier>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected MenuModifier(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public MenuModifier(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public MenuModifier(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public MenuModifier(MenuModifier src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());

    genClient.validateNotNull(CacheKey.name, getName());
    genClient.validateLength(CacheKey.name, getName(), 127);

    genClient.validateLength(CacheKey.imageFilename, getImageFilename(), 127);

    genClient.validateLength(CacheKey.reasonCode, getReasonCode(), 64);
    genClient.validateReferences(CacheKey.modifier);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'modifier' field is set and is not null */
  public boolean isNotNullModifier() {
    return genClient.cacheValueIsNotNull(CacheKey.modifier);
  }

  /** Checks whether the 'price' field is set and is not null */
  public boolean isNotNullPrice() {
    return genClient.cacheValueIsNotNull(CacheKey.price);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return genClient.cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'description' field is set and is not null */
  public boolean isNotNullDescription() {
    return genClient.cacheValueIsNotNull(CacheKey.description);
  }

  /** Checks whether the 'imageFilename' field is set and is not null */
  public boolean isNotNullImageFilename() {
    return genClient.cacheValueIsNotNull(CacheKey.imageFilename);
  }

  /** Checks whether the 'enabled' field is set and is not null */
  public boolean isNotNullEnabled() {
    return genClient.cacheValueIsNotNull(CacheKey.enabled);
  }

  /** Checks whether the 'reasonCode' field is set and is not null */
  public boolean isNotNullReasonCode() {
    return genClient.cacheValueIsNotNull(CacheKey.reasonCode);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field is set and is not null */
  public boolean isNotNullModifiedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.modifiedTime);
  }

  /** Checks whether the 'deletedTime' field is set and is not null */
  public boolean isNotNullDeletedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.deletedTime);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'modifier' field has been set, however the value could be null */
  public boolean hasModifier() {
    return genClient.cacheHasKey(CacheKey.modifier);
  }

  /** Checks whether the 'price' field has been set, however the value could be null */
  public boolean hasPrice() {
    return genClient.cacheHasKey(CacheKey.price);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return genClient.cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'description' field has been set, however the value could be null */
  public boolean hasDescription() {
    return genClient.cacheHasKey(CacheKey.description);
  }

  /** Checks whether the 'imageFilename' field has been set, however the value could be null */
  public boolean hasImageFilename() {
    return genClient.cacheHasKey(CacheKey.imageFilename);
  }

  /** Checks whether the 'enabled' field has been set, however the value could be null */
  public boolean hasEnabled() {
    return genClient.cacheHasKey(CacheKey.enabled);
  }

  /** Checks whether the 'reasonCode' field has been set, however the value could be null */
  public boolean hasReasonCode() {
    return genClient.cacheHasKey(CacheKey.reasonCode);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field has been set, however the value could be null */
  public boolean hasModifiedTime() {
    return genClient.cacheHasKey(CacheKey.modifiedTime);
  }

  /** Checks whether the 'deletedTime' field has been set, however the value could be null */
  public boolean hasDeletedTime() {
    return genClient.cacheHasKey(CacheKey.deletedTime);
  }


  /**
   * Sets the field 'id'.
   */
  public MenuModifier setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'modifier'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public MenuModifier setModifier(com.clover.sdk.v3.base.Reference modifier) {
    return genClient.setRecord(modifier, CacheKey.modifier);
  }

  /**
   * Sets the field 'price'.
   */
  public MenuModifier setPrice(java.lang.Long price) {
    return genClient.setOther(price, CacheKey.price);
  }

  /**
   * Sets the field 'name'.
   */
  public MenuModifier setName(java.lang.String name) {
    return genClient.setOther(name, CacheKey.name);
  }

  /**
   * Sets the field 'description'.
   */
  public MenuModifier setDescription(java.lang.String description) {
    return genClient.setOther(description, CacheKey.description);
  }

  /**
   * Sets the field 'imageFilename'.
   */
  public MenuModifier setImageFilename(java.lang.String imageFilename) {
    return genClient.setOther(imageFilename, CacheKey.imageFilename);
  }

  /**
   * Sets the field 'enabled'.
   */
  public MenuModifier setEnabled(java.lang.Boolean enabled) {
    return genClient.setOther(enabled, CacheKey.enabled);
  }

  /**
   * Sets the field 'reasonCode'.
   */
  public MenuModifier setReasonCode(java.lang.String reasonCode) {
    return genClient.setOther(reasonCode, CacheKey.reasonCode);
  }

  /**
   * Sets the field 'createdTime'.
   */
  public MenuModifier setCreatedTime(java.lang.Long createdTime) {
    return genClient.setOther(createdTime, CacheKey.createdTime);
  }

  /**
   * Sets the field 'modifiedTime'.
   */
  public MenuModifier setModifiedTime(java.lang.Long modifiedTime) {
    return genClient.setOther(modifiedTime, CacheKey.modifiedTime);
  }

  /**
   * Sets the field 'deletedTime'.
   */
  public MenuModifier setDeletedTime(java.lang.Long deletedTime) {
    return genClient.setOther(deletedTime, CacheKey.deletedTime);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'modifier' field, the 'has' method for this field will now return false */
  public void clearModifier() {
    genClient.clear(CacheKey.modifier);
  }
  /** Clears the 'price' field, the 'has' method for this field will now return false */
  public void clearPrice() {
    genClient.clear(CacheKey.price);
  }
  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    genClient.clear(CacheKey.name);
  }
  /** Clears the 'description' field, the 'has' method for this field will now return false */
  public void clearDescription() {
    genClient.clear(CacheKey.description);
  }
  /** Clears the 'imageFilename' field, the 'has' method for this field will now return false */
  public void clearImageFilename() {
    genClient.clear(CacheKey.imageFilename);
  }
  /** Clears the 'enabled' field, the 'has' method for this field will now return false */
  public void clearEnabled() {
    genClient.clear(CacheKey.enabled);
  }
  /** Clears the 'reasonCode' field, the 'has' method for this field will now return false */
  public void clearReasonCode() {
    genClient.clear(CacheKey.reasonCode);
  }
  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.createdTime);
  }
  /** Clears the 'modifiedTime' field, the 'has' method for this field will now return false */
  public void clearModifiedTime() {
    genClient.clear(CacheKey.modifiedTime);
  }
  /** Clears the 'deletedTime' field, the 'has' method for this field will now return false */
  public void clearDeletedTime() {
    genClient.clear(CacheKey.deletedTime);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public MenuModifier copyChanges() {
    MenuModifier copy = new MenuModifier();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(MenuModifier src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new MenuModifier(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<MenuModifier> CREATOR = new android.os.Parcelable.Creator<MenuModifier>() {
    @Override
    public MenuModifier createFromParcel(android.os.Parcel in) {
      MenuModifier instance = new MenuModifier(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public MenuModifier[] newArray(int size) {
      return new MenuModifier[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<MenuModifier> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<MenuModifier>() {
    public Class<MenuModifier> getCreatedClass() {
      return MenuModifier.class;
    }

    @Override
    public MenuModifier create(org.json.JSONObject jsonObject) {
      return new MenuModifier(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean MODIFIER_IS_REQUIRED = false;
    public static final boolean PRICE_IS_REQUIRED = false;
    public static final boolean NAME_IS_REQUIRED = true;
    public static final long NAME_MAX_LEN = 127;
    public static final boolean DESCRIPTION_IS_REQUIRED = false;
    public static final boolean IMAGEFILENAME_IS_REQUIRED = false;
    public static final long IMAGEFILENAME_MAX_LEN = 127;
    public static final boolean ENABLED_IS_REQUIRED = false;
    public static final boolean REASONCODE_IS_REQUIRED = false;
    public static final long REASONCODE_MAX_LEN = 64;
    public static final boolean CREATEDTIME_IS_REQUIRED = false;
    public static final boolean MODIFIEDTIME_IS_REQUIRED = false;
    public static final boolean DELETEDTIME_IS_REQUIRED = false;
  }

}
