/**
 * Autogenerated by Avro
 *
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.inventory;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getModifierGroup modifierGroup}</li>
 * <li>{@link #getName name}</li>
 * <li>{@link #getDescription description}</li>
 * <li>{@link #getMinRequired minRequired}</li>
 * <li>{@link #getMaxAllowed maxAllowed}</li>
 * <li>{@link #getReasonCode reasonCode}</li>
 * <li>{@link #getImageFilename imageFilename}</li>
 * <li>{@link #getEnabled enabled}</li>
 * <li>{@link #getCreatedTime createdTime}</li>
 * <li>{@link #getModifiedTime modifiedTime}</li>
 * <li>{@link #getDeletedTime deletedTime}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class MenuModifierGroup extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Modifier group id
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * Reference to the modifier group
   */
  public com.clover.sdk.v3.base.Reference getModifierGroup() {
    return genClient.cacheGet(CacheKey.modifierGroup);
  }

  /**
   * Customer facing modifier group name
   */
  public java.lang.String getName() {
    return genClient.cacheGet(CacheKey.name);
  }

  /**
   * Modifier group description
   */
  public java.lang.String getDescription() {
    return genClient.cacheGet(CacheKey.description);
  }

  /**
   * The minimum amount of modifiers from this group that must be applied to associated lineItems
   */
  public java.lang.Integer getMinRequired() {
    return genClient.cacheGet(CacheKey.minRequired);
  }

  /**
   * The maximum amount of modifiers from this group that can be applied to associated lineItems
   */
  public java.lang.Integer getMaxAllowed() {
    return genClient.cacheGet(CacheKey.maxAllowed);
  }

  /**
   * Reason for being filtered out
   */
  public java.lang.String getReasonCode() {
    return genClient.cacheGet(CacheKey.reasonCode);
  }

  /**
   * Modifier group image file path
   */
  public java.lang.String getImageFilename() {
    return genClient.cacheGet(CacheKey.imageFilename);
  }

  /**
   * Modifier group enabled for menu
   */
  public java.lang.Boolean getEnabled() {
    return genClient.cacheGet(CacheKey.enabled);
  }

  /**
   * Timestamp when the menu modifier group was created
   */
  public java.lang.Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.createdTime);
  }

  /**
   * Timestamp when the menu modifier group was last modified
   */
  public java.lang.Long getModifiedTime() {
    return genClient.cacheGet(CacheKey.modifiedTime);
  }

  /**
   * Timestamp when menu modifier group was last deleted
   */
  public java.lang.Long getDeletedTime() {
    return genClient.cacheGet(CacheKey.deletedTime);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    modifierGroup
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    name
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    description
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    minRequired
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
    maxAllowed
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
    reasonCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    imageFilename
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    enabled
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    createdTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    modifiedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    deletedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<MenuModifierGroup> genClient;

  /**
   * Constructs a new empty instance.
   */
  public MenuModifierGroup() {
    genClient = new GenericClient<MenuModifierGroup>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected MenuModifierGroup(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public MenuModifierGroup(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public MenuModifierGroup(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public MenuModifierGroup(MenuModifierGroup src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());

    genClient.validateNotNull(CacheKey.name, getName());
    genClient.validateLength(CacheKey.name, getName(), 127);

    genClient.validateMin(CacheKey.minRequired, getMinRequired(), 0L);

    genClient.validateMinMax(CacheKey.maxAllowed, getMaxAllowed(), 0L, 65535L);

    genClient.validateLength(CacheKey.reasonCode, getReasonCode(), 64);

    genClient.validateLength(CacheKey.imageFilename, getImageFilename(), 127);
    genClient.validateReferences(CacheKey.modifierGroup);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'modifierGroup' field is set and is not null */
  public boolean isNotNullModifierGroup() {
    return genClient.cacheValueIsNotNull(CacheKey.modifierGroup);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return genClient.cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'description' field is set and is not null */
  public boolean isNotNullDescription() {
    return genClient.cacheValueIsNotNull(CacheKey.description);
  }

  /** Checks whether the 'minRequired' field is set and is not null */
  public boolean isNotNullMinRequired() {
    return genClient.cacheValueIsNotNull(CacheKey.minRequired);
  }

  /** Checks whether the 'maxAllowed' field is set and is not null */
  public boolean isNotNullMaxAllowed() {
    return genClient.cacheValueIsNotNull(CacheKey.maxAllowed);
  }

  /** Checks whether the 'reasonCode' field is set and is not null */
  public boolean isNotNullReasonCode() {
    return genClient.cacheValueIsNotNull(CacheKey.reasonCode);
  }

  /** Checks whether the 'imageFilename' field is set and is not null */
  public boolean isNotNullImageFilename() {
    return genClient.cacheValueIsNotNull(CacheKey.imageFilename);
  }

  /** Checks whether the 'enabled' field is set and is not null */
  public boolean isNotNullEnabled() {
    return genClient.cacheValueIsNotNull(CacheKey.enabled);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field is set and is not null */
  public boolean isNotNullModifiedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.modifiedTime);
  }

  /** Checks whether the 'deletedTime' field is set and is not null */
  public boolean isNotNullDeletedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.deletedTime);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'modifierGroup' field has been set, however the value could be null */
  public boolean hasModifierGroup() {
    return genClient.cacheHasKey(CacheKey.modifierGroup);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return genClient.cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'description' field has been set, however the value could be null */
  public boolean hasDescription() {
    return genClient.cacheHasKey(CacheKey.description);
  }

  /** Checks whether the 'minRequired' field has been set, however the value could be null */
  public boolean hasMinRequired() {
    return genClient.cacheHasKey(CacheKey.minRequired);
  }

  /** Checks whether the 'maxAllowed' field has been set, however the value could be null */
  public boolean hasMaxAllowed() {
    return genClient.cacheHasKey(CacheKey.maxAllowed);
  }

  /** Checks whether the 'reasonCode' field has been set, however the value could be null */
  public boolean hasReasonCode() {
    return genClient.cacheHasKey(CacheKey.reasonCode);
  }

  /** Checks whether the 'imageFilename' field has been set, however the value could be null */
  public boolean hasImageFilename() {
    return genClient.cacheHasKey(CacheKey.imageFilename);
  }

  /** Checks whether the 'enabled' field has been set, however the value could be null */
  public boolean hasEnabled() {
    return genClient.cacheHasKey(CacheKey.enabled);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field has been set, however the value could be null */
  public boolean hasModifiedTime() {
    return genClient.cacheHasKey(CacheKey.modifiedTime);
  }

  /** Checks whether the 'deletedTime' field has been set, however the value could be null */
  public boolean hasDeletedTime() {
    return genClient.cacheHasKey(CacheKey.deletedTime);
  }


  /**
   * Sets the field 'id'.
   */
  public MenuModifierGroup setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'modifierGroup'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public MenuModifierGroup setModifierGroup(com.clover.sdk.v3.base.Reference modifierGroup) {
    return genClient.setRecord(modifierGroup, CacheKey.modifierGroup);
  }

  /**
   * Sets the field 'name'.
   */
  public MenuModifierGroup setName(java.lang.String name) {
    return genClient.setOther(name, CacheKey.name);
  }

  /**
   * Sets the field 'description'.
   */
  public MenuModifierGroup setDescription(java.lang.String description) {
    return genClient.setOther(description, CacheKey.description);
  }

  /**
   * Sets the field 'minRequired'.
   */
  public MenuModifierGroup setMinRequired(java.lang.Integer minRequired) {
    return genClient.setOther(minRequired, CacheKey.minRequired);
  }

  /**
   * Sets the field 'maxAllowed'.
   */
  public MenuModifierGroup setMaxAllowed(java.lang.Integer maxAllowed) {
    return genClient.setOther(maxAllowed, CacheKey.maxAllowed);
  }

  /**
   * Sets the field 'reasonCode'.
   */
  public MenuModifierGroup setReasonCode(java.lang.String reasonCode) {
    return genClient.setOther(reasonCode, CacheKey.reasonCode);
  }

  /**
   * Sets the field 'imageFilename'.
   */
  public MenuModifierGroup setImageFilename(java.lang.String imageFilename) {
    return genClient.setOther(imageFilename, CacheKey.imageFilename);
  }

  /**
   * Sets the field 'enabled'.
   */
  public MenuModifierGroup setEnabled(java.lang.Boolean enabled) {
    return genClient.setOther(enabled, CacheKey.enabled);
  }

  /**
   * Sets the field 'createdTime'.
   */
  public MenuModifierGroup setCreatedTime(java.lang.Long createdTime) {
    return genClient.setOther(createdTime, CacheKey.createdTime);
  }

  /**
   * Sets the field 'modifiedTime'.
   */
  public MenuModifierGroup setModifiedTime(java.lang.Long modifiedTime) {
    return genClient.setOther(modifiedTime, CacheKey.modifiedTime);
  }

  /**
   * Sets the field 'deletedTime'.
   */
  public MenuModifierGroup setDeletedTime(java.lang.Long deletedTime) {
    return genClient.setOther(deletedTime, CacheKey.deletedTime);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'modifierGroup' field, the 'has' method for this field will now return false */
  public void clearModifierGroup() {
    genClient.clear(CacheKey.modifierGroup);
  }
  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    genClient.clear(CacheKey.name);
  }
  /** Clears the 'description' field, the 'has' method for this field will now return false */
  public void clearDescription() {
    genClient.clear(CacheKey.description);
  }
  /** Clears the 'minRequired' field, the 'has' method for this field will now return false */
  public void clearMinRequired() {
    genClient.clear(CacheKey.minRequired);
  }
  /** Clears the 'maxAllowed' field, the 'has' method for this field will now return false */
  public void clearMaxAllowed() {
    genClient.clear(CacheKey.maxAllowed);
  }
  /** Clears the 'reasonCode' field, the 'has' method for this field will now return false */
  public void clearReasonCode() {
    genClient.clear(CacheKey.reasonCode);
  }
  /** Clears the 'imageFilename' field, the 'has' method for this field will now return false */
  public void clearImageFilename() {
    genClient.clear(CacheKey.imageFilename);
  }
  /** Clears the 'enabled' field, the 'has' method for this field will now return false */
  public void clearEnabled() {
    genClient.clear(CacheKey.enabled);
  }
  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.createdTime);
  }
  /** Clears the 'modifiedTime' field, the 'has' method for this field will now return false */
  public void clearModifiedTime() {
    genClient.clear(CacheKey.modifiedTime);
  }
  /** Clears the 'deletedTime' field, the 'has' method for this field will now return false */
  public void clearDeletedTime() {
    genClient.clear(CacheKey.deletedTime);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public MenuModifierGroup copyChanges() {
    MenuModifierGroup copy = new MenuModifierGroup();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(MenuModifierGroup src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new MenuModifierGroup(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<MenuModifierGroup> CREATOR = new android.os.Parcelable.Creator<MenuModifierGroup>() {
    @Override
    public MenuModifierGroup createFromParcel(android.os.Parcel in) {
      MenuModifierGroup instance = new MenuModifierGroup(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public MenuModifierGroup[] newArray(int size) {
      return new MenuModifierGroup[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<MenuModifierGroup> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<MenuModifierGroup>() {
    public Class<MenuModifierGroup> getCreatedClass() {
      return MenuModifierGroup.class;
    }

    @Override
    public MenuModifierGroup create(org.json.JSONObject jsonObject) {
      return new MenuModifierGroup(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean MODIFIERGROUP_IS_REQUIRED = false;
    public static final boolean NAME_IS_REQUIRED = true;
    public static final long NAME_MAX_LEN = 127;
    public static final boolean DESCRIPTION_IS_REQUIRED = false;
    public static final boolean MINREQUIRED_IS_REQUIRED = false;
    public static final long MINREQUIRED_MIN = 0;
    public static final boolean MAXALLOWED_IS_REQUIRED = false;
    public static final long MAXALLOWED_MIN = 0;
    public static final long MAXALLOWED_MAX = 65535;
    public static final boolean REASONCODE_IS_REQUIRED = false;
    public static final long REASONCODE_MAX_LEN = 64;
    public static final boolean IMAGEFILENAME_IS_REQUIRED = false;
    public static final long IMAGEFILENAME_MAX_LEN = 127;
    public static final boolean ENABLED_IS_REQUIRED = false;
    public static final boolean CREATEDTIME_IS_REQUIRED = false;
    public static final boolean MODIFIEDTIME_IS_REQUIRED = false;
    public static final boolean DELETEDTIME_IS_REQUIRED = false;
  }

}
