/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.inventory;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * An Override of a particular Modifier in Menus.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getCosUuid cosUuid}</li>
 * <li>{@link #getMenuId menuId}</li>
 * <li>{@link #getId id}</li>
 * <li>{@link #getEnabled enabled}</li>
 * <li>{@link #getReasonCode reasonCode}</li>
 * <li>{@link #getFiltered filtered}</li>
 * <li>{@link #getModifiedTime modifiedTime}</li>
 * <li>{@link #getCreatedTime createdTime}</li>
 * <li>{@link #getDeletedTime deletedTime}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class ModifierOverride extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique Clover identifier.
   */
  public String getCosUuid() {
    return genClient.cacheGet(CacheKey.cosUuid);
  }

  /**
   * Unique Clover identifier.
   */
  public String getMenuId() {
    return genClient.cacheGet(CacheKey.menuId);
  }

  /**
   * Unique Clover identifier.
   */
  public String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * Modifier override enabled.
   */
  public Boolean getEnabled() {
    return genClient.cacheGet(CacheKey.enabled);
  }

  /**
   * Reason code.
   */
  public String getReasonCode() {
    return genClient.cacheGet(CacheKey.reasonCode);
  }

  /**
   * Modifier override filtered.
   */
  public Boolean getFiltered() {
    return genClient.cacheGet(CacheKey.filtered);
  }

  /**
   * Timestamp when modifier was modified.
   */
  public Long getModifiedTime() {
    return genClient.cacheGet(CacheKey.modifiedTime);
  }

  /**
   * Timestamp when modifier was created.
   */
  public Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.createdTime);
  }

  /**
   * Timestamp when modifier was deleted.
   */
  public Long getDeletedTime() {
    return genClient.cacheGet(CacheKey.deletedTime);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    cosUuid
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    menuId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    enabled
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Boolean.class)),
    reasonCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    filtered
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Boolean.class)),
    modifiedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
    createdTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
    deletedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<ModifierOverride> genClient;

  /**
   * Constructs a new empty instance.
   */
  public ModifierOverride() {
    genClient = new GenericClient<ModifierOverride>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected ModifierOverride(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public ModifierOverride(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public ModifierOverride(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public ModifierOverride(ModifierOverride src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.cosUuid, getCosUuid());

    genClient.validateLength(CacheKey.menuId, getMenuId(), 127);

    genClient.validateLength(CacheKey.id, getId(), 127);

    genClient.validateNotNull(CacheKey.reasonCode, getReasonCode());
    genClient.validateLength(CacheKey.reasonCode, getReasonCode(), 127);
  }

  /** Checks whether the 'cosUuid' field is set and is not null */
  public boolean isNotNullCosUuid() {
    return genClient.cacheValueIsNotNull(CacheKey.cosUuid);
  }

  /** Checks whether the 'menuId' field is set and is not null */
  public boolean isNotNullMenuId() {
    return genClient.cacheValueIsNotNull(CacheKey.menuId);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'enabled' field is set and is not null */
  public boolean isNotNullEnabled() {
    return genClient.cacheValueIsNotNull(CacheKey.enabled);
  }

  /** Checks whether the 'reasonCode' field is set and is not null */
  public boolean isNotNullReasonCode() {
    return genClient.cacheValueIsNotNull(CacheKey.reasonCode);
  }

  /** Checks whether the 'filtered' field is set and is not null */
  public boolean isNotNullFiltered() {
    return genClient.cacheValueIsNotNull(CacheKey.filtered);
  }

  /** Checks whether the 'modifiedTime' field is set and is not null */
  public boolean isNotNullModifiedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.modifiedTime);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'deletedTime' field is set and is not null */
  public boolean isNotNullDeletedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.deletedTime);
  }



  /** Checks whether the 'cosUuid' field has been set, however the value could be null */
  public boolean hasCosUuid() {
    return genClient.cacheHasKey(CacheKey.cosUuid);
  }

  /** Checks whether the 'menuId' field has been set, however the value could be null */
  public boolean hasMenuId() {
    return genClient.cacheHasKey(CacheKey.menuId);
  }

  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'enabled' field has been set, however the value could be null */
  public boolean hasEnabled() {
    return genClient.cacheHasKey(CacheKey.enabled);
  }

  /** Checks whether the 'reasonCode' field has been set, however the value could be null */
  public boolean hasReasonCode() {
    return genClient.cacheHasKey(CacheKey.reasonCode);
  }

  /** Checks whether the 'filtered' field has been set, however the value could be null */
  public boolean hasFiltered() {
    return genClient.cacheHasKey(CacheKey.filtered);
  }

  /** Checks whether the 'modifiedTime' field has been set, however the value could be null */
  public boolean hasModifiedTime() {
    return genClient.cacheHasKey(CacheKey.modifiedTime);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'deletedTime' field has been set, however the value could be null */
  public boolean hasDeletedTime() {
    return genClient.cacheHasKey(CacheKey.deletedTime);
  }


  /**
   * Sets the field 'cosUuid'.
   */
  public ModifierOverride setCosUuid(String cosUuid) {
    return genClient.setOther(cosUuid, CacheKey.cosUuid);
  }

  /**
   * Sets the field 'menuId'.
   */
  public ModifierOverride setMenuId(String menuId) {
    return genClient.setOther(menuId, CacheKey.menuId);
  }

  /**
   * Sets the field 'id'.
   */
  public ModifierOverride setId(String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'enabled'.
   */
  public ModifierOverride setEnabled(Boolean enabled) {
    return genClient.setOther(enabled, CacheKey.enabled);
  }

  /**
   * Sets the field 'reasonCode'.
   */
  public ModifierOverride setReasonCode(String reasonCode) {
    return genClient.setOther(reasonCode, CacheKey.reasonCode);
  }

  /**
   * Sets the field 'filtered'.
   */
  public ModifierOverride setFiltered(Boolean filtered) {
    return genClient.setOther(filtered, CacheKey.filtered);
  }

  /**
   * Sets the field 'modifiedTime'.
   */
  public ModifierOverride setModifiedTime(Long modifiedTime) {
    return genClient.setOther(modifiedTime, CacheKey.modifiedTime);
  }

  /**
   * Sets the field 'createdTime'.
   */
  public ModifierOverride setCreatedTime(Long createdTime) {
    return genClient.setOther(createdTime, CacheKey.createdTime);
  }

  /**
   * Sets the field 'deletedTime'.
   */
  public ModifierOverride setDeletedTime(Long deletedTime) {
    return genClient.setOther(deletedTime, CacheKey.deletedTime);
  }


  /** Clears the 'cosUuid' field, the 'has' method for this field will now return false */
  public void clearCosUuid() {
    genClient.clear(CacheKey.cosUuid);
  }
  /** Clears the 'menuId' field, the 'has' method for this field will now return false */
  public void clearMenuId() {
    genClient.clear(CacheKey.menuId);
  }
  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'enabled' field, the 'has' method for this field will now return false */
  public void clearEnabled() {
    genClient.clear(CacheKey.enabled);
  }
  /** Clears the 'reasonCode' field, the 'has' method for this field will now return false */
  public void clearReasonCode() {
    genClient.clear(CacheKey.reasonCode);
  }
  /** Clears the 'filtered' field, the 'has' method for this field will now return false */
  public void clearFiltered() {
    genClient.clear(CacheKey.filtered);
  }
  /** Clears the 'modifiedTime' field, the 'has' method for this field will now return false */
  public void clearModifiedTime() {
    genClient.clear(CacheKey.modifiedTime);
  }
  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.createdTime);
  }
  /** Clears the 'deletedTime' field, the 'has' method for this field will now return false */
  public void clearDeletedTime() {
    genClient.clear(CacheKey.deletedTime);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public ModifierOverride copyChanges() {
    ModifierOverride copy = new ModifierOverride();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(ModifierOverride src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new ModifierOverride(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<ModifierOverride> CREATOR = new android.os.Parcelable.Creator<ModifierOverride>() {
    @Override
    public ModifierOverride createFromParcel(android.os.Parcel in) {
      ModifierOverride instance = new ModifierOverride(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public ModifierOverride[] newArray(int size) {
      return new ModifierOverride[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<ModifierOverride> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<ModifierOverride>() {
    public Class<ModifierOverride> getCreatedClass() {
      return ModifierOverride.class;
    }

    @Override
    public ModifierOverride create(org.json.JSONObject jsonObject) {
      return new ModifierOverride(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean COSUUID_IS_REQUIRED = false;
    public static final long COSUUID_MAX_LEN = 127;
    public static final boolean MENUID_IS_REQUIRED = false;
    public static final long MENUID_MAX_LEN = 127;
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 127;
    public static final boolean ENABLED_IS_REQUIRED = false;
    public static final boolean REASONCODE_IS_REQUIRED = true;
    public static final long REASONCODE_MAX_LEN = 127;
    public static final boolean FILTERED_IS_REQUIRED = false;
    public static final boolean MODIFIEDTIME_IS_REQUIRED = false;
    public static final boolean CREATEDTIME_IS_REQUIRED = false;
    public static final boolean DELETEDTIME_IS_REQUIRED = false;
  }

}
