/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.merchant;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * Bank data for a merchant
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getMerchantRef merchantRef}</li>
 * <li>{@link #getBin bin}</li>
 * <li>{@link #getPayCode payCode}</li>
 * <li>{@link #getClearingCode clearingCode}</li>
 * <li>{@link #getIca ica}</li>
 * <li>{@link #getPayCycle payCycle}</li>
 * <li>{@link #getAchRollup achRollup}</li>
 * <li>{@link #getCreatedTime createdTime}</li>
 * <li>{@link #getModifiedTime modifiedTime}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class MerchantBankProcessing extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  public com.clover.sdk.v3.base.Reference getMerchantRef() {
    return genClient.cacheGet(CacheKey.merchantRef);
  }

  /**
   * Bank identification number of bank
   */
  public java.lang.String getBin() {
    return genClient.cacheGet(CacheKey.bin);
  }

  /**
   * Pay code
   */
  public java.lang.String getPayCode() {
    return genClient.cacheGet(CacheKey.payCode);
  }

  /**
   * Clearing code
   */
  public java.lang.String getClearingCode() {
    return genClient.cacheGet(CacheKey.clearingCode);
  }

  /**
   * Interbank Card Association
   */
  public java.lang.String getIca() {
    return genClient.cacheGet(CacheKey.ica);
  }

  /**
   * Pay cycle
   */
  public java.lang.String getPayCycle() {
    return genClient.cacheGet(CacheKey.payCycle);
  }

  /**
   * ACH rollup
   */
  public java.lang.String getAchRollup() {
    return genClient.cacheGet(CacheKey.achRollup);
  }

  /**
   * Date record created
   */
  public java.lang.Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.createdTime);
  }

  /**
   * Date record modified
   */
  public java.lang.Long getModifiedTime() {
    return genClient.cacheGet(CacheKey.modifiedTime);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    merchantRef
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    bin
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    payCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    clearingCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    ica
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    payCycle
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    achRollup
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    createdTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    modifiedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<MerchantBankProcessing> genClient;

  /**
   * Constructs a new empty instance.
   */
  public MerchantBankProcessing() {
    genClient = new GenericClient<MerchantBankProcessing>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected MerchantBankProcessing(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public MerchantBankProcessing(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public MerchantBankProcessing(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public MerchantBankProcessing(MerchantBankProcessing src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {

    genClient.validateLength(CacheKey.bin, getBin(), 9);

    genClient.validateLength(CacheKey.payCode, getPayCode(), 2);

    genClient.validateLength(CacheKey.clearingCode, getClearingCode(), 3);

    genClient.validateLength(CacheKey.ica, getIca(), 6);

    genClient.validateLength(CacheKey.payCycle, getPayCycle(), 2);

    genClient.validateLength(CacheKey.achRollup, getAchRollup(), 1);
    genClient.validateReferences(CacheKey.merchantRef);
  }

  /** Checks whether the 'merchantRef' field is set and is not null */
  public boolean isNotNullMerchantRef() {
    return genClient.cacheValueIsNotNull(CacheKey.merchantRef);
  }

  /** Checks whether the 'bin' field is set and is not null */
  public boolean isNotNullBin() {
    return genClient.cacheValueIsNotNull(CacheKey.bin);
  }

  /** Checks whether the 'payCode' field is set and is not null */
  public boolean isNotNullPayCode() {
    return genClient.cacheValueIsNotNull(CacheKey.payCode);
  }

  /** Checks whether the 'clearingCode' field is set and is not null */
  public boolean isNotNullClearingCode() {
    return genClient.cacheValueIsNotNull(CacheKey.clearingCode);
  }

  /** Checks whether the 'ica' field is set and is not null */
  public boolean isNotNullIca() {
    return genClient.cacheValueIsNotNull(CacheKey.ica);
  }

  /** Checks whether the 'payCycle' field is set and is not null */
  public boolean isNotNullPayCycle() {
    return genClient.cacheValueIsNotNull(CacheKey.payCycle);
  }

  /** Checks whether the 'achRollup' field is set and is not null */
  public boolean isNotNullAchRollup() {
    return genClient.cacheValueIsNotNull(CacheKey.achRollup);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field is set and is not null */
  public boolean isNotNullModifiedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.modifiedTime);
  }



  /** Checks whether the 'merchantRef' field has been set, however the value could be null */
  public boolean hasMerchantRef() {
    return genClient.cacheHasKey(CacheKey.merchantRef);
  }

  /** Checks whether the 'bin' field has been set, however the value could be null */
  public boolean hasBin() {
    return genClient.cacheHasKey(CacheKey.bin);
  }

  /** Checks whether the 'payCode' field has been set, however the value could be null */
  public boolean hasPayCode() {
    return genClient.cacheHasKey(CacheKey.payCode);
  }

  /** Checks whether the 'clearingCode' field has been set, however the value could be null */
  public boolean hasClearingCode() {
    return genClient.cacheHasKey(CacheKey.clearingCode);
  }

  /** Checks whether the 'ica' field has been set, however the value could be null */
  public boolean hasIca() {
    return genClient.cacheHasKey(CacheKey.ica);
  }

  /** Checks whether the 'payCycle' field has been set, however the value could be null */
  public boolean hasPayCycle() {
    return genClient.cacheHasKey(CacheKey.payCycle);
  }

  /** Checks whether the 'achRollup' field has been set, however the value could be null */
  public boolean hasAchRollup() {
    return genClient.cacheHasKey(CacheKey.achRollup);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field has been set, however the value could be null */
  public boolean hasModifiedTime() {
    return genClient.cacheHasKey(CacheKey.modifiedTime);
  }


  /**
   * Sets the field 'merchantRef'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public MerchantBankProcessing setMerchantRef(com.clover.sdk.v3.base.Reference merchantRef) {
    return genClient.setRecord(merchantRef, CacheKey.merchantRef);
  }

  /**
   * Sets the field 'bin'.
   */
  public MerchantBankProcessing setBin(java.lang.String bin) {
    return genClient.setOther(bin, CacheKey.bin);
  }

  /**
   * Sets the field 'payCode'.
   */
  public MerchantBankProcessing setPayCode(java.lang.String payCode) {
    return genClient.setOther(payCode, CacheKey.payCode);
  }

  /**
   * Sets the field 'clearingCode'.
   */
  public MerchantBankProcessing setClearingCode(java.lang.String clearingCode) {
    return genClient.setOther(clearingCode, CacheKey.clearingCode);
  }

  /**
   * Sets the field 'ica'.
   */
  public MerchantBankProcessing setIca(java.lang.String ica) {
    return genClient.setOther(ica, CacheKey.ica);
  }

  /**
   * Sets the field 'payCycle'.
   */
  public MerchantBankProcessing setPayCycle(java.lang.String payCycle) {
    return genClient.setOther(payCycle, CacheKey.payCycle);
  }

  /**
   * Sets the field 'achRollup'.
   */
  public MerchantBankProcessing setAchRollup(java.lang.String achRollup) {
    return genClient.setOther(achRollup, CacheKey.achRollup);
  }

  /**
   * Sets the field 'createdTime'.
   */
  public MerchantBankProcessing setCreatedTime(java.lang.Long createdTime) {
    return genClient.setOther(createdTime, CacheKey.createdTime);
  }

  /**
   * Sets the field 'modifiedTime'.
   */
  public MerchantBankProcessing setModifiedTime(java.lang.Long modifiedTime) {
    return genClient.setOther(modifiedTime, CacheKey.modifiedTime);
  }


  /** Clears the 'merchantRef' field, the 'has' method for this field will now return false */
  public void clearMerchantRef() {
    genClient.clear(CacheKey.merchantRef);
  }
  /** Clears the 'bin' field, the 'has' method for this field will now return false */
  public void clearBin() {
    genClient.clear(CacheKey.bin);
  }
  /** Clears the 'payCode' field, the 'has' method for this field will now return false */
  public void clearPayCode() {
    genClient.clear(CacheKey.payCode);
  }
  /** Clears the 'clearingCode' field, the 'has' method for this field will now return false */
  public void clearClearingCode() {
    genClient.clear(CacheKey.clearingCode);
  }
  /** Clears the 'ica' field, the 'has' method for this field will now return false */
  public void clearIca() {
    genClient.clear(CacheKey.ica);
  }
  /** Clears the 'payCycle' field, the 'has' method for this field will now return false */
  public void clearPayCycle() {
    genClient.clear(CacheKey.payCycle);
  }
  /** Clears the 'achRollup' field, the 'has' method for this field will now return false */
  public void clearAchRollup() {
    genClient.clear(CacheKey.achRollup);
  }
  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.createdTime);
  }
  /** Clears the 'modifiedTime' field, the 'has' method for this field will now return false */
  public void clearModifiedTime() {
    genClient.clear(CacheKey.modifiedTime);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public MerchantBankProcessing copyChanges() {
    MerchantBankProcessing copy = new MerchantBankProcessing();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(MerchantBankProcessing src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new MerchantBankProcessing(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<MerchantBankProcessing> CREATOR = new android.os.Parcelable.Creator<MerchantBankProcessing>() {
    @Override
    public MerchantBankProcessing createFromParcel(android.os.Parcel in) {
      MerchantBankProcessing instance = new MerchantBankProcessing(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public MerchantBankProcessing[] newArray(int size) {
      return new MerchantBankProcessing[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<MerchantBankProcessing> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<MerchantBankProcessing>() {
    public Class<MerchantBankProcessing> getCreatedClass() {
      return MerchantBankProcessing.class;
    }

    @Override
    public MerchantBankProcessing create(org.json.JSONObject jsonObject) {
      return new MerchantBankProcessing(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean MERCHANTREF_IS_REQUIRED = false;
    public static final boolean BIN_IS_REQUIRED = false;
    public static final long BIN_MAX_LEN = 9;
    public static final boolean PAYCODE_IS_REQUIRED = false;
    public static final long PAYCODE_MAX_LEN = 2;
    public static final boolean CLEARINGCODE_IS_REQUIRED = false;
    public static final long CLEARINGCODE_MAX_LEN = 3;
    public static final boolean ICA_IS_REQUIRED = false;
    public static final long ICA_MAX_LEN = 6;
    public static final boolean PAYCYCLE_IS_REQUIRED = false;
    public static final long PAYCYCLE_MAX_LEN = 2;
    public static final boolean ACHROLLUP_IS_REQUIRED = false;
    public static final long ACHROLLUP_MAX_LEN = 1;
    public static final boolean CREATEDTIME_IS_REQUIRED = false;
    public static final boolean MODIFIEDTIME_IS_REQUIRED = false;
  }

}
