/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.merchant;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getPlanBillable planBillable}</li>
 * <li>{@link #getAppBillable appBillable}</li>
 * <li>{@link #getPlanExportable planExportable}</li>
 * <li>{@link #getAppExportable appExportable}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class MerchantBillingInfo extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Returns true if all plans are billable for the merchant in context.
   */
  public java.lang.Boolean getPlanBillable() {
    return genClient.cacheGet(CacheKey.planBillable);
  }

  /**
   * Returns true if all apps are billable for the merchant in context.
   */
  public java.lang.Boolean getAppBillable() {
    return genClient.cacheGet(CacheKey.appBillable);
  }

  /**
   * Returns true if all plans are exportable for the merchant in context.
   */
  public java.lang.Boolean getPlanExportable() {
    return genClient.cacheGet(CacheKey.planExportable);
  }

  /**
   * Returns true if all apps are exportable for the merchant in context.
   */
  public java.lang.Boolean getAppExportable() {
    return genClient.cacheGet(CacheKey.appExportable);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    planBillable
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    appBillable
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    planExportable
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    appExportable
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<MerchantBillingInfo> genClient;

  /**
   * Constructs a new empty instance.
   */
  public MerchantBillingInfo() {
    genClient = new GenericClient<MerchantBillingInfo>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected MerchantBillingInfo(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public MerchantBillingInfo(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public MerchantBillingInfo(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public MerchantBillingInfo(MerchantBillingInfo src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'planBillable' field is set and is not null */
  public boolean isNotNullPlanBillable() {
    return genClient.cacheValueIsNotNull(CacheKey.planBillable);
  }

  /** Checks whether the 'appBillable' field is set and is not null */
  public boolean isNotNullAppBillable() {
    return genClient.cacheValueIsNotNull(CacheKey.appBillable);
  }

  /** Checks whether the 'planExportable' field is set and is not null */
  public boolean isNotNullPlanExportable() {
    return genClient.cacheValueIsNotNull(CacheKey.planExportable);
  }

  /** Checks whether the 'appExportable' field is set and is not null */
  public boolean isNotNullAppExportable() {
    return genClient.cacheValueIsNotNull(CacheKey.appExportable);
  }



  /** Checks whether the 'planBillable' field has been set, however the value could be null */
  public boolean hasPlanBillable() {
    return genClient.cacheHasKey(CacheKey.planBillable);
  }

  /** Checks whether the 'appBillable' field has been set, however the value could be null */
  public boolean hasAppBillable() {
    return genClient.cacheHasKey(CacheKey.appBillable);
  }

  /** Checks whether the 'planExportable' field has been set, however the value could be null */
  public boolean hasPlanExportable() {
    return genClient.cacheHasKey(CacheKey.planExportable);
  }

  /** Checks whether the 'appExportable' field has been set, however the value could be null */
  public boolean hasAppExportable() {
    return genClient.cacheHasKey(CacheKey.appExportable);
  }


  /**
   * Sets the field 'planBillable'.
   */
  public MerchantBillingInfo setPlanBillable(java.lang.Boolean planBillable) {
    return genClient.setOther(planBillable, CacheKey.planBillable);
  }

  /**
   * Sets the field 'appBillable'.
   */
  public MerchantBillingInfo setAppBillable(java.lang.Boolean appBillable) {
    return genClient.setOther(appBillable, CacheKey.appBillable);
  }

  /**
   * Sets the field 'planExportable'.
   */
  public MerchantBillingInfo setPlanExportable(java.lang.Boolean planExportable) {
    return genClient.setOther(planExportable, CacheKey.planExportable);
  }

  /**
   * Sets the field 'appExportable'.
   */
  public MerchantBillingInfo setAppExportable(java.lang.Boolean appExportable) {
    return genClient.setOther(appExportable, CacheKey.appExportable);
  }


  /** Clears the 'planBillable' field, the 'has' method for this field will now return false */
  public void clearPlanBillable() {
    genClient.clear(CacheKey.planBillable);
  }
  /** Clears the 'appBillable' field, the 'has' method for this field will now return false */
  public void clearAppBillable() {
    genClient.clear(CacheKey.appBillable);
  }
  /** Clears the 'planExportable' field, the 'has' method for this field will now return false */
  public void clearPlanExportable() {
    genClient.clear(CacheKey.planExportable);
  }
  /** Clears the 'appExportable' field, the 'has' method for this field will now return false */
  public void clearAppExportable() {
    genClient.clear(CacheKey.appExportable);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public MerchantBillingInfo copyChanges() {
    MerchantBillingInfo copy = new MerchantBillingInfo();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(MerchantBillingInfo src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new MerchantBillingInfo(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<MerchantBillingInfo> CREATOR = new android.os.Parcelable.Creator<MerchantBillingInfo>() {
    @Override
    public MerchantBillingInfo createFromParcel(android.os.Parcel in) {
      MerchantBillingInfo instance = new MerchantBillingInfo(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public MerchantBillingInfo[] newArray(int size) {
      return new MerchantBillingInfo[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<MerchantBillingInfo> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<MerchantBillingInfo>() {
    public Class<MerchantBillingInfo> getCreatedClass() {
      return MerchantBillingInfo.class;
    }

    @Override
    public MerchantBillingInfo create(org.json.JSONObject jsonObject) {
      return new MerchantBillingInfo(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean PLANBILLABLE_IS_REQUIRED = false;
    public static final boolean APPBILLABLE_IS_REQUIRED = false;
    public static final boolean PLANEXPORTABLE_IS_REQUIRED = false;
    public static final boolean APPEXPORTABLE_IS_REQUIRED = false;
  }

}
