/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.merchant;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * Additional device data collected during merchant boarding.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getMerchantRef merchantRef}</li>
 * <li>{@link #getProductType productType}</li>
 * <li>{@link #getEquipmentNumber equipmentNumber}</li>
 * <li>{@link #getBusinessType businessType}</li>
 * <li>{@link #getStatus status}</li>
 * <li>{@link #getTransArmorIndicator transArmorIndicator}</li>
 * <li>{@link #getForceCloseTime forceCloseTime}</li>
 * <li>{@link #getCreatedTime createdTime}</li>
 * <li>{@link #getModifiedTime modifiedTime}</li>
 * <li>{@link #getSerialNumber serialNumber}</li>
 * <li>{@link #getBundleIndicator bundleIndicator}</li>
 * <li>{@link #getRemovalTime removalTime}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class MerchantDeviceBoarding extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  public com.clover.sdk.v3.base.Reference getMerchantRef() {
    return genClient.cacheGet(CacheKey.merchantRef);
  }

  /**
   * Device product type
   */
  public java.lang.String getProductType() {
    return genClient.cacheGet(CacheKey.productType);
  }

  /**
   * Equipment number
   */
  public java.lang.String getEquipmentNumber() {
    return genClient.cacheGet(CacheKey.equipmentNumber);
  }

  /**
   * Business type
   */
  public java.lang.String getBusinessType() {
    return genClient.cacheGet(CacheKey.businessType);
  }

  /**
   * Device status
   */
  public java.lang.String getStatus() {
    return genClient.cacheGet(CacheKey.status);
  }

  /**
   * TransArmor indicator
   */
  public java.lang.String getTransArmorIndicator() {
    return genClient.cacheGet(CacheKey.transArmorIndicator);
  }

  /**
   * Force close time
   */
  public java.lang.String getForceCloseTime() {
    return genClient.cacheGet(CacheKey.forceCloseTime);
  }

  /**
   * Date record created
   */
  public java.lang.Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.createdTime);
  }

  /**
   * Date record updated
   */
  public java.lang.Long getModifiedTime() {
    return genClient.cacheGet(CacheKey.modifiedTime);
  }

  public java.lang.String getSerialNumber() {
    return genClient.cacheGet(CacheKey.serialNumber);
  }

  public java.lang.String getBundleIndicator() {
    return genClient.cacheGet(CacheKey.bundleIndicator);
  }

  /**
   * Date device removed from merchant
   */
  public java.lang.Long getRemovalTime() {
    return genClient.cacheGet(CacheKey.removalTime);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    merchantRef
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    productType
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    equipmentNumber
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    businessType
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    status
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    transArmorIndicator
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    forceCloseTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    createdTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    modifiedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    serialNumber
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    bundleIndicator
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    removalTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<MerchantDeviceBoarding> genClient;

  /**
   * Constructs a new empty instance.
   */
  public MerchantDeviceBoarding() {
    genClient = new GenericClient<MerchantDeviceBoarding>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected MerchantDeviceBoarding(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public MerchantDeviceBoarding(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public MerchantDeviceBoarding(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public MerchantDeviceBoarding(MerchantDeviceBoarding src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {

    genClient.validateLength(CacheKey.productType, getProductType(), 1);

    genClient.validateLength(CacheKey.equipmentNumber, getEquipmentNumber(), 14);

    genClient.validateLength(CacheKey.businessType, getBusinessType(), 15);

    genClient.validateLength(CacheKey.status, getStatus(), 20);

    genClient.validateLength(CacheKey.transArmorIndicator, getTransArmorIndicator(), 100);

    genClient.validateLength(CacheKey.forceCloseTime, getForceCloseTime(), 3);

    genClient.validateLength(CacheKey.serialNumber, getSerialNumber(), 50);

    genClient.validateLength(CacheKey.bundleIndicator, getBundleIndicator(), 32);
    genClient.validateReferences(CacheKey.merchantRef);
  }

  /** Checks whether the 'merchantRef' field is set and is not null */
  public boolean isNotNullMerchantRef() {
    return genClient.cacheValueIsNotNull(CacheKey.merchantRef);
  }

  /** Checks whether the 'productType' field is set and is not null */
  public boolean isNotNullProductType() {
    return genClient.cacheValueIsNotNull(CacheKey.productType);
  }

  /** Checks whether the 'equipmentNumber' field is set and is not null */
  public boolean isNotNullEquipmentNumber() {
    return genClient.cacheValueIsNotNull(CacheKey.equipmentNumber);
  }

  /** Checks whether the 'businessType' field is set and is not null */
  public boolean isNotNullBusinessType() {
    return genClient.cacheValueIsNotNull(CacheKey.businessType);
  }

  /** Checks whether the 'status' field is set and is not null */
  public boolean isNotNullStatus() {
    return genClient.cacheValueIsNotNull(CacheKey.status);
  }

  /** Checks whether the 'transArmorIndicator' field is set and is not null */
  public boolean isNotNullTransArmorIndicator() {
    return genClient.cacheValueIsNotNull(CacheKey.transArmorIndicator);
  }

  /** Checks whether the 'forceCloseTime' field is set and is not null */
  public boolean isNotNullForceCloseTime() {
    return genClient.cacheValueIsNotNull(CacheKey.forceCloseTime);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field is set and is not null */
  public boolean isNotNullModifiedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.modifiedTime);
  }

  /** Checks whether the 'serialNumber' field is set and is not null */
  public boolean isNotNullSerialNumber() {
    return genClient.cacheValueIsNotNull(CacheKey.serialNumber);
  }

  /** Checks whether the 'bundleIndicator' field is set and is not null */
  public boolean isNotNullBundleIndicator() {
    return genClient.cacheValueIsNotNull(CacheKey.bundleIndicator);
  }

  /** Checks whether the 'removalTime' field is set and is not null */
  public boolean isNotNullRemovalTime() {
    return genClient.cacheValueIsNotNull(CacheKey.removalTime);
  }



  /** Checks whether the 'merchantRef' field has been set, however the value could be null */
  public boolean hasMerchantRef() {
    return genClient.cacheHasKey(CacheKey.merchantRef);
  }

  /** Checks whether the 'productType' field has been set, however the value could be null */
  public boolean hasProductType() {
    return genClient.cacheHasKey(CacheKey.productType);
  }

  /** Checks whether the 'equipmentNumber' field has been set, however the value could be null */
  public boolean hasEquipmentNumber() {
    return genClient.cacheHasKey(CacheKey.equipmentNumber);
  }

  /** Checks whether the 'businessType' field has been set, however the value could be null */
  public boolean hasBusinessType() {
    return genClient.cacheHasKey(CacheKey.businessType);
  }

  /** Checks whether the 'status' field has been set, however the value could be null */
  public boolean hasStatus() {
    return genClient.cacheHasKey(CacheKey.status);
  }

  /** Checks whether the 'transArmorIndicator' field has been set, however the value could be null */
  public boolean hasTransArmorIndicator() {
    return genClient.cacheHasKey(CacheKey.transArmorIndicator);
  }

  /** Checks whether the 'forceCloseTime' field has been set, however the value could be null */
  public boolean hasForceCloseTime() {
    return genClient.cacheHasKey(CacheKey.forceCloseTime);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field has been set, however the value could be null */
  public boolean hasModifiedTime() {
    return genClient.cacheHasKey(CacheKey.modifiedTime);
  }

  /** Checks whether the 'serialNumber' field has been set, however the value could be null */
  public boolean hasSerialNumber() {
    return genClient.cacheHasKey(CacheKey.serialNumber);
  }

  /** Checks whether the 'bundleIndicator' field has been set, however the value could be null */
  public boolean hasBundleIndicator() {
    return genClient.cacheHasKey(CacheKey.bundleIndicator);
  }

  /** Checks whether the 'removalTime' field has been set, however the value could be null */
  public boolean hasRemovalTime() {
    return genClient.cacheHasKey(CacheKey.removalTime);
  }


  /**
   * Sets the field 'merchantRef'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public MerchantDeviceBoarding setMerchantRef(com.clover.sdk.v3.base.Reference merchantRef) {
    return genClient.setRecord(merchantRef, CacheKey.merchantRef);
  }

  /**
   * Sets the field 'productType'.
   */
  public MerchantDeviceBoarding setProductType(java.lang.String productType) {
    return genClient.setOther(productType, CacheKey.productType);
  }

  /**
   * Sets the field 'equipmentNumber'.
   */
  public MerchantDeviceBoarding setEquipmentNumber(java.lang.String equipmentNumber) {
    return genClient.setOther(equipmentNumber, CacheKey.equipmentNumber);
  }

  /**
   * Sets the field 'businessType'.
   */
  public MerchantDeviceBoarding setBusinessType(java.lang.String businessType) {
    return genClient.setOther(businessType, CacheKey.businessType);
  }

  /**
   * Sets the field 'status'.
   */
  public MerchantDeviceBoarding setStatus(java.lang.String status) {
    return genClient.setOther(status, CacheKey.status);
  }

  /**
   * Sets the field 'transArmorIndicator'.
   */
  public MerchantDeviceBoarding setTransArmorIndicator(java.lang.String transArmorIndicator) {
    return genClient.setOther(transArmorIndicator, CacheKey.transArmorIndicator);
  }

  /**
   * Sets the field 'forceCloseTime'.
   */
  public MerchantDeviceBoarding setForceCloseTime(java.lang.String forceCloseTime) {
    return genClient.setOther(forceCloseTime, CacheKey.forceCloseTime);
  }

  /**
   * Sets the field 'createdTime'.
   */
  public MerchantDeviceBoarding setCreatedTime(java.lang.Long createdTime) {
    return genClient.setOther(createdTime, CacheKey.createdTime);
  }

  /**
   * Sets the field 'modifiedTime'.
   */
  public MerchantDeviceBoarding setModifiedTime(java.lang.Long modifiedTime) {
    return genClient.setOther(modifiedTime, CacheKey.modifiedTime);
  }

  /**
   * Sets the field 'serialNumber'.
   */
  public MerchantDeviceBoarding setSerialNumber(java.lang.String serialNumber) {
    return genClient.setOther(serialNumber, CacheKey.serialNumber);
  }

  /**
   * Sets the field 'bundleIndicator'.
   */
  public MerchantDeviceBoarding setBundleIndicator(java.lang.String bundleIndicator) {
    return genClient.setOther(bundleIndicator, CacheKey.bundleIndicator);
  }

  /**
   * Sets the field 'removalTime'.
   */
  public MerchantDeviceBoarding setRemovalTime(java.lang.Long removalTime) {
    return genClient.setOther(removalTime, CacheKey.removalTime);
  }


  /** Clears the 'merchantRef' field, the 'has' method for this field will now return false */
  public void clearMerchantRef() {
    genClient.clear(CacheKey.merchantRef);
  }
  /** Clears the 'productType' field, the 'has' method for this field will now return false */
  public void clearProductType() {
    genClient.clear(CacheKey.productType);
  }
  /** Clears the 'equipmentNumber' field, the 'has' method for this field will now return false */
  public void clearEquipmentNumber() {
    genClient.clear(CacheKey.equipmentNumber);
  }
  /** Clears the 'businessType' field, the 'has' method for this field will now return false */
  public void clearBusinessType() {
    genClient.clear(CacheKey.businessType);
  }
  /** Clears the 'status' field, the 'has' method for this field will now return false */
  public void clearStatus() {
    genClient.clear(CacheKey.status);
  }
  /** Clears the 'transArmorIndicator' field, the 'has' method for this field will now return false */
  public void clearTransArmorIndicator() {
    genClient.clear(CacheKey.transArmorIndicator);
  }
  /** Clears the 'forceCloseTime' field, the 'has' method for this field will now return false */
  public void clearForceCloseTime() {
    genClient.clear(CacheKey.forceCloseTime);
  }
  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.createdTime);
  }
  /** Clears the 'modifiedTime' field, the 'has' method for this field will now return false */
  public void clearModifiedTime() {
    genClient.clear(CacheKey.modifiedTime);
  }
  /** Clears the 'serialNumber' field, the 'has' method for this field will now return false */
  public void clearSerialNumber() {
    genClient.clear(CacheKey.serialNumber);
  }
  /** Clears the 'bundleIndicator' field, the 'has' method for this field will now return false */
  public void clearBundleIndicator() {
    genClient.clear(CacheKey.bundleIndicator);
  }
  /** Clears the 'removalTime' field, the 'has' method for this field will now return false */
  public void clearRemovalTime() {
    genClient.clear(CacheKey.removalTime);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public MerchantDeviceBoarding copyChanges() {
    MerchantDeviceBoarding copy = new MerchantDeviceBoarding();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(MerchantDeviceBoarding src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new MerchantDeviceBoarding(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<MerchantDeviceBoarding> CREATOR = new android.os.Parcelable.Creator<MerchantDeviceBoarding>() {
    @Override
    public MerchantDeviceBoarding createFromParcel(android.os.Parcel in) {
      MerchantDeviceBoarding instance = new MerchantDeviceBoarding(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public MerchantDeviceBoarding[] newArray(int size) {
      return new MerchantDeviceBoarding[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<MerchantDeviceBoarding> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<MerchantDeviceBoarding>() {
    public Class<MerchantDeviceBoarding> getCreatedClass() {
      return MerchantDeviceBoarding.class;
    }

    @Override
    public MerchantDeviceBoarding create(org.json.JSONObject jsonObject) {
      return new MerchantDeviceBoarding(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean MERCHANTREF_IS_REQUIRED = false;
    public static final boolean PRODUCTTYPE_IS_REQUIRED = false;
    public static final long PRODUCTTYPE_MAX_LEN = 1;
    public static final boolean EQUIPMENTNUMBER_IS_REQUIRED = false;
    public static final long EQUIPMENTNUMBER_MAX_LEN = 14;
    public static final boolean BUSINESSTYPE_IS_REQUIRED = false;
    public static final long BUSINESSTYPE_MAX_LEN = 15;
    public static final boolean STATUS_IS_REQUIRED = false;
    public static final long STATUS_MAX_LEN = 20;
    public static final boolean TRANSARMORINDICATOR_IS_REQUIRED = false;
    public static final long TRANSARMORINDICATOR_MAX_LEN = 100;
    public static final boolean FORCECLOSETIME_IS_REQUIRED = false;
    public static final long FORCECLOSETIME_MAX_LEN = 3;
    public static final boolean CREATEDTIME_IS_REQUIRED = false;
    public static final boolean MODIFIEDTIME_IS_REQUIRED = false;
    public static final boolean SERIALNUMBER_IS_REQUIRED = false;
    public static final long SERIALNUMBER_MAX_LEN = 50;
    public static final boolean BUNDLEINDICATOR_IS_REQUIRED = false;
    public static final long BUNDLEINDICATOR_MAX_LEN = 32;
    public static final boolean REMOVALTIME_IS_REQUIRED = false;
  }

}
