/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.merchant;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * Chain/corporate references and legal/billing/banking information for a merchant. Can also represent corporations/franchise organizations without Clover devices.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getMid mid}</li>
 * <li>{@link #getChain chain}</li>
 * <li>{@link #getCorporate corporate}</li>
 * <li>{@link #getAgent agent}</li>
 * <li>{@link #getBank bank}</li>
 * <li>{@link #getBusiness business}</li>
 * <li>{@link #getMaps maps}</li>
 * <li>{@link #getAssociation association}</li>
 * <li>{@link #getCustomer customer}</li>
 * <li>{@link #getBillName billName}</li>
 * <li>{@link #getDbaName dbaName}</li>
 * <li>{@link #getDbaAttention dbaAttention}</li>
 * <li>{@link #getLegalName legalName}</li>
 * <li>{@link #getBillToAttention billToAttention}</li>
 * <li>{@link #getEmail email}</li>
 * <li>{@link #getAbaAccountNumber abaAccountNumber}</li>
 * <li>{@link #getDdaAccountNumber ddaAccountNumber}</li>
 * <li>{@link #getDbaAddress dbaAddress}</li>
 * <li>{@link #getDbaCity dbaCity}</li>
 * <li>{@link #getDbaState dbaState}</li>
 * <li>{@link #getDbaZip dbaZip}</li>
 * <li>{@link #getDbaPhoneNumber dbaPhoneNumber}</li>
 * <li>{@link #getBillCity billCity}</li>
 * <li>{@link #getBillState billState}</li>
 * <li>{@link #getBillZip billZip}</li>
 * <li>{@link #getBillPhoneNumber billPhoneNumber}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class MerchantHierarchy extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Merchant ID
   */
  public java.lang.String getMid() {
    return genClient.cacheGet(CacheKey.mid);
  }

  /**
   * Chain bank
   */
  public java.lang.String getChain() {
    return genClient.cacheGet(CacheKey.chain);
  }

  /**
   * Corporate ID
   */
  public java.lang.String getCorporate() {
    return genClient.cacheGet(CacheKey.corporate);
  }

  /**
   * Agent ID
   */
  public java.lang.String getAgent() {
    return genClient.cacheGet(CacheKey.agent);
  }

  /**
   * Bank ID
   */
  public java.lang.String getBank() {
    return genClient.cacheGet(CacheKey.bank);
  }

  /**
   * Business ID
   */
  public java.lang.String getBusiness() {
    return genClient.cacheGet(CacheKey.business);
  }

  /**
   * MAPS ID
   */
  public java.lang.String getMaps() {
    return genClient.cacheGet(CacheKey.maps);
  }

  /**
   * Association Number
   */
  public java.lang.String getAssociation() {
    return genClient.cacheGet(CacheKey.association);
  }

  /**
   * Customer ID
   */
  public java.lang.String getCustomer() {
    return genClient.cacheGet(CacheKey.customer);
  }

  /**
   * Bill to name
   */
  public java.lang.String getBillName() {
    return genClient.cacheGet(CacheKey.billName);
  }

  /**
   * DBA name
   */
  public java.lang.String getDbaName() {
    return genClient.cacheGet(CacheKey.dbaName);
  }

  /**
   * DBA attention name
   */
  public java.lang.String getDbaAttention() {
    return genClient.cacheGet(CacheKey.dbaAttention);
  }

  /**
   * Legal name
   */
  public java.lang.String getLegalName() {
    return genClient.cacheGet(CacheKey.legalName);
  }

  /**
   * Bill To attention
   */
  public java.lang.String getBillToAttention() {
    return genClient.cacheGet(CacheKey.billToAttention);
  }

  /**
   * Email
   */
  public java.lang.String getEmail() {
    return genClient.cacheGet(CacheKey.email);
  }

  /**
   * ABA account number
   */
  public java.lang.String getAbaAccountNumber() {
    return genClient.cacheGet(CacheKey.abaAccountNumber);
  }

  /**
   * DDA account number
   */
  public java.lang.String getDdaAccountNumber() {
    return genClient.cacheGet(CacheKey.ddaAccountNumber);
  }

  /**
   * DBA address
   */
  public java.lang.String getDbaAddress() {
    return genClient.cacheGet(CacheKey.dbaAddress);
  }

  /**
   * DBA city
   */
  public java.lang.String getDbaCity() {
    return genClient.cacheGet(CacheKey.dbaCity);
  }

  /**
   * DBA state
   */
  public java.lang.String getDbaState() {
    return genClient.cacheGet(CacheKey.dbaState);
  }

  /**
   * DBA zip
   */
  public java.lang.String getDbaZip() {
    return genClient.cacheGet(CacheKey.dbaZip);
  }

  /**
   * DBA phone number
   */
  public java.lang.String getDbaPhoneNumber() {
    return genClient.cacheGet(CacheKey.dbaPhoneNumber);
  }

  /**
   * Bill To city
   */
  public java.lang.String getBillCity() {
    return genClient.cacheGet(CacheKey.billCity);
  }

  /**
   * Bill To state
   */
  public java.lang.String getBillState() {
    return genClient.cacheGet(CacheKey.billState);
  }

  /**
   * Bill To ZIP
   */
  public java.lang.String getBillZip() {
    return genClient.cacheGet(CacheKey.billZip);
  }

  /**
   * Bill To phone number
   */
  public java.lang.String getBillPhoneNumber() {
    return genClient.cacheGet(CacheKey.billPhoneNumber);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    mid
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    chain
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    corporate
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    agent
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    bank
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    business
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    maps
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    association
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    customer
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    billName
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    dbaName
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    dbaAttention
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    legalName
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    billToAttention
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    email
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    abaAccountNumber
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    ddaAccountNumber
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    dbaAddress
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    dbaCity
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    dbaState
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    dbaZip
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    dbaPhoneNumber
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    billCity
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    billState
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    billZip
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    billPhoneNumber
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<MerchantHierarchy> genClient;

  /**
   * Constructs a new empty instance.
   */
  public MerchantHierarchy() {
    genClient = new GenericClient<MerchantHierarchy>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected MerchantHierarchy(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public MerchantHierarchy(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public MerchantHierarchy(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public MerchantHierarchy(MerchantHierarchy src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateLength(CacheKey.mid, getMid(), 31);

    genClient.validateLength(CacheKey.chain, getChain(), 12);

    genClient.validateLength(CacheKey.corporate, getCorporate(), 12);

    genClient.validateLength(CacheKey.agent, getAgent(), 12);

    genClient.validateLength(CacheKey.bank, getBank(), 12);

    genClient.validateLength(CacheKey.business, getBusiness(), 12);

    genClient.validateLength(CacheKey.maps, getMaps(), 12);

    genClient.validateLength(CacheKey.association, getAssociation(), 12);

    genClient.validateLength(CacheKey.customer, getCustomer(), 12);

    genClient.validateLength(CacheKey.billName, getBillName(), 50);

    genClient.validateLength(CacheKey.dbaName, getDbaName(), 50);

    genClient.validateLength(CacheKey.dbaAttention, getDbaAttention(), 50);

    genClient.validateLength(CacheKey.legalName, getLegalName(), 50);

    genClient.validateLength(CacheKey.billToAttention, getBillToAttention(), 50);

    genClient.validateLength(CacheKey.email, getEmail(), 127);

    genClient.validateLength(CacheKey.abaAccountNumber, getAbaAccountNumber(), 40);

    genClient.validateLength(CacheKey.ddaAccountNumber, getDdaAccountNumber(), 40);

    genClient.validateLength(CacheKey.dbaAddress, getDbaAddress(), 255);

    genClient.validateLength(CacheKey.dbaCity, getDbaCity(), 127);

    genClient.validateLength(CacheKey.dbaState, getDbaState(), 127);

    genClient.validateLength(CacheKey.dbaZip, getDbaZip(), 127);

    genClient.validateLength(CacheKey.dbaPhoneNumber, getDbaPhoneNumber(), 21);

    genClient.validateLength(CacheKey.billCity, getBillCity(), 127);

    genClient.validateLength(CacheKey.billState, getBillState(), 127);

    genClient.validateLength(CacheKey.billZip, getBillZip(), 127);

    genClient.validateLength(CacheKey.billPhoneNumber, getBillPhoneNumber(), 21);
  }

  /** Checks whether the 'mid' field is set and is not null */
  public boolean isNotNullMid() {
    return genClient.cacheValueIsNotNull(CacheKey.mid);
  }

  /** Checks whether the 'chain' field is set and is not null */
  public boolean isNotNullChain() {
    return genClient.cacheValueIsNotNull(CacheKey.chain);
  }

  /** Checks whether the 'corporate' field is set and is not null */
  public boolean isNotNullCorporate() {
    return genClient.cacheValueIsNotNull(CacheKey.corporate);
  }

  /** Checks whether the 'agent' field is set and is not null */
  public boolean isNotNullAgent() {
    return genClient.cacheValueIsNotNull(CacheKey.agent);
  }

  /** Checks whether the 'bank' field is set and is not null */
  public boolean isNotNullBank() {
    return genClient.cacheValueIsNotNull(CacheKey.bank);
  }

  /** Checks whether the 'business' field is set and is not null */
  public boolean isNotNullBusiness() {
    return genClient.cacheValueIsNotNull(CacheKey.business);
  }

  /** Checks whether the 'maps' field is set and is not null */
  public boolean isNotNullMaps() {
    return genClient.cacheValueIsNotNull(CacheKey.maps);
  }

  /** Checks whether the 'association' field is set and is not null */
  public boolean isNotNullAssociation() {
    return genClient.cacheValueIsNotNull(CacheKey.association);
  }

  /** Checks whether the 'customer' field is set and is not null */
  public boolean isNotNullCustomer() {
    return genClient.cacheValueIsNotNull(CacheKey.customer);
  }

  /** Checks whether the 'billName' field is set and is not null */
  public boolean isNotNullBillName() {
    return genClient.cacheValueIsNotNull(CacheKey.billName);
  }

  /** Checks whether the 'dbaName' field is set and is not null */
  public boolean isNotNullDbaName() {
    return genClient.cacheValueIsNotNull(CacheKey.dbaName);
  }

  /** Checks whether the 'dbaAttention' field is set and is not null */
  public boolean isNotNullDbaAttention() {
    return genClient.cacheValueIsNotNull(CacheKey.dbaAttention);
  }

  /** Checks whether the 'legalName' field is set and is not null */
  public boolean isNotNullLegalName() {
    return genClient.cacheValueIsNotNull(CacheKey.legalName);
  }

  /** Checks whether the 'billToAttention' field is set and is not null */
  public boolean isNotNullBillToAttention() {
    return genClient.cacheValueIsNotNull(CacheKey.billToAttention);
  }

  /** Checks whether the 'email' field is set and is not null */
  public boolean isNotNullEmail() {
    return genClient.cacheValueIsNotNull(CacheKey.email);
  }

  /** Checks whether the 'abaAccountNumber' field is set and is not null */
  public boolean isNotNullAbaAccountNumber() {
    return genClient.cacheValueIsNotNull(CacheKey.abaAccountNumber);
  }

  /** Checks whether the 'ddaAccountNumber' field is set and is not null */
  public boolean isNotNullDdaAccountNumber() {
    return genClient.cacheValueIsNotNull(CacheKey.ddaAccountNumber);
  }

  /** Checks whether the 'dbaAddress' field is set and is not null */
  public boolean isNotNullDbaAddress() {
    return genClient.cacheValueIsNotNull(CacheKey.dbaAddress);
  }

  /** Checks whether the 'dbaCity' field is set and is not null */
  public boolean isNotNullDbaCity() {
    return genClient.cacheValueIsNotNull(CacheKey.dbaCity);
  }

  /** Checks whether the 'dbaState' field is set and is not null */
  public boolean isNotNullDbaState() {
    return genClient.cacheValueIsNotNull(CacheKey.dbaState);
  }

  /** Checks whether the 'dbaZip' field is set and is not null */
  public boolean isNotNullDbaZip() {
    return genClient.cacheValueIsNotNull(CacheKey.dbaZip);
  }

  /** Checks whether the 'dbaPhoneNumber' field is set and is not null */
  public boolean isNotNullDbaPhoneNumber() {
    return genClient.cacheValueIsNotNull(CacheKey.dbaPhoneNumber);
  }

  /** Checks whether the 'billCity' field is set and is not null */
  public boolean isNotNullBillCity() {
    return genClient.cacheValueIsNotNull(CacheKey.billCity);
  }

  /** Checks whether the 'billState' field is set and is not null */
  public boolean isNotNullBillState() {
    return genClient.cacheValueIsNotNull(CacheKey.billState);
  }

  /** Checks whether the 'billZip' field is set and is not null */
  public boolean isNotNullBillZip() {
    return genClient.cacheValueIsNotNull(CacheKey.billZip);
  }

  /** Checks whether the 'billPhoneNumber' field is set and is not null */
  public boolean isNotNullBillPhoneNumber() {
    return genClient.cacheValueIsNotNull(CacheKey.billPhoneNumber);
  }



  /** Checks whether the 'mid' field has been set, however the value could be null */
  public boolean hasMid() {
    return genClient.cacheHasKey(CacheKey.mid);
  }

  /** Checks whether the 'chain' field has been set, however the value could be null */
  public boolean hasChain() {
    return genClient.cacheHasKey(CacheKey.chain);
  }

  /** Checks whether the 'corporate' field has been set, however the value could be null */
  public boolean hasCorporate() {
    return genClient.cacheHasKey(CacheKey.corporate);
  }

  /** Checks whether the 'agent' field has been set, however the value could be null */
  public boolean hasAgent() {
    return genClient.cacheHasKey(CacheKey.agent);
  }

  /** Checks whether the 'bank' field has been set, however the value could be null */
  public boolean hasBank() {
    return genClient.cacheHasKey(CacheKey.bank);
  }

  /** Checks whether the 'business' field has been set, however the value could be null */
  public boolean hasBusiness() {
    return genClient.cacheHasKey(CacheKey.business);
  }

  /** Checks whether the 'maps' field has been set, however the value could be null */
  public boolean hasMaps() {
    return genClient.cacheHasKey(CacheKey.maps);
  }

  /** Checks whether the 'association' field has been set, however the value could be null */
  public boolean hasAssociation() {
    return genClient.cacheHasKey(CacheKey.association);
  }

  /** Checks whether the 'customer' field has been set, however the value could be null */
  public boolean hasCustomer() {
    return genClient.cacheHasKey(CacheKey.customer);
  }

  /** Checks whether the 'billName' field has been set, however the value could be null */
  public boolean hasBillName() {
    return genClient.cacheHasKey(CacheKey.billName);
  }

  /** Checks whether the 'dbaName' field has been set, however the value could be null */
  public boolean hasDbaName() {
    return genClient.cacheHasKey(CacheKey.dbaName);
  }

  /** Checks whether the 'dbaAttention' field has been set, however the value could be null */
  public boolean hasDbaAttention() {
    return genClient.cacheHasKey(CacheKey.dbaAttention);
  }

  /** Checks whether the 'legalName' field has been set, however the value could be null */
  public boolean hasLegalName() {
    return genClient.cacheHasKey(CacheKey.legalName);
  }

  /** Checks whether the 'billToAttention' field has been set, however the value could be null */
  public boolean hasBillToAttention() {
    return genClient.cacheHasKey(CacheKey.billToAttention);
  }

  /** Checks whether the 'email' field has been set, however the value could be null */
  public boolean hasEmail() {
    return genClient.cacheHasKey(CacheKey.email);
  }

  /** Checks whether the 'abaAccountNumber' field has been set, however the value could be null */
  public boolean hasAbaAccountNumber() {
    return genClient.cacheHasKey(CacheKey.abaAccountNumber);
  }

  /** Checks whether the 'ddaAccountNumber' field has been set, however the value could be null */
  public boolean hasDdaAccountNumber() {
    return genClient.cacheHasKey(CacheKey.ddaAccountNumber);
  }

  /** Checks whether the 'dbaAddress' field has been set, however the value could be null */
  public boolean hasDbaAddress() {
    return genClient.cacheHasKey(CacheKey.dbaAddress);
  }

  /** Checks whether the 'dbaCity' field has been set, however the value could be null */
  public boolean hasDbaCity() {
    return genClient.cacheHasKey(CacheKey.dbaCity);
  }

  /** Checks whether the 'dbaState' field has been set, however the value could be null */
  public boolean hasDbaState() {
    return genClient.cacheHasKey(CacheKey.dbaState);
  }

  /** Checks whether the 'dbaZip' field has been set, however the value could be null */
  public boolean hasDbaZip() {
    return genClient.cacheHasKey(CacheKey.dbaZip);
  }

  /** Checks whether the 'dbaPhoneNumber' field has been set, however the value could be null */
  public boolean hasDbaPhoneNumber() {
    return genClient.cacheHasKey(CacheKey.dbaPhoneNumber);
  }

  /** Checks whether the 'billCity' field has been set, however the value could be null */
  public boolean hasBillCity() {
    return genClient.cacheHasKey(CacheKey.billCity);
  }

  /** Checks whether the 'billState' field has been set, however the value could be null */
  public boolean hasBillState() {
    return genClient.cacheHasKey(CacheKey.billState);
  }

  /** Checks whether the 'billZip' field has been set, however the value could be null */
  public boolean hasBillZip() {
    return genClient.cacheHasKey(CacheKey.billZip);
  }

  /** Checks whether the 'billPhoneNumber' field has been set, however the value could be null */
  public boolean hasBillPhoneNumber() {
    return genClient.cacheHasKey(CacheKey.billPhoneNumber);
  }


  /**
   * Sets the field 'mid'.
   */
  public MerchantHierarchy setMid(java.lang.String mid) {
    return genClient.setOther(mid, CacheKey.mid);
  }

  /**
   * Sets the field 'chain'.
   */
  public MerchantHierarchy setChain(java.lang.String chain) {
    return genClient.setOther(chain, CacheKey.chain);
  }

  /**
   * Sets the field 'corporate'.
   */
  public MerchantHierarchy setCorporate(java.lang.String corporate) {
    return genClient.setOther(corporate, CacheKey.corporate);
  }

  /**
   * Sets the field 'agent'.
   */
  public MerchantHierarchy setAgent(java.lang.String agent) {
    return genClient.setOther(agent, CacheKey.agent);
  }

  /**
   * Sets the field 'bank'.
   */
  public MerchantHierarchy setBank(java.lang.String bank) {
    return genClient.setOther(bank, CacheKey.bank);
  }

  /**
   * Sets the field 'business'.
   */
  public MerchantHierarchy setBusiness(java.lang.String business) {
    return genClient.setOther(business, CacheKey.business);
  }

  /**
   * Sets the field 'maps'.
   */
  public MerchantHierarchy setMaps(java.lang.String maps) {
    return genClient.setOther(maps, CacheKey.maps);
  }

  /**
   * Sets the field 'association'.
   */
  public MerchantHierarchy setAssociation(java.lang.String association) {
    return genClient.setOther(association, CacheKey.association);
  }

  /**
   * Sets the field 'customer'.
   */
  public MerchantHierarchy setCustomer(java.lang.String customer) {
    return genClient.setOther(customer, CacheKey.customer);
  }

  /**
   * Sets the field 'billName'.
   */
  public MerchantHierarchy setBillName(java.lang.String billName) {
    return genClient.setOther(billName, CacheKey.billName);
  }

  /**
   * Sets the field 'dbaName'.
   */
  public MerchantHierarchy setDbaName(java.lang.String dbaName) {
    return genClient.setOther(dbaName, CacheKey.dbaName);
  }

  /**
   * Sets the field 'dbaAttention'.
   */
  public MerchantHierarchy setDbaAttention(java.lang.String dbaAttention) {
    return genClient.setOther(dbaAttention, CacheKey.dbaAttention);
  }

  /**
   * Sets the field 'legalName'.
   */
  public MerchantHierarchy setLegalName(java.lang.String legalName) {
    return genClient.setOther(legalName, CacheKey.legalName);
  }

  /**
   * Sets the field 'billToAttention'.
   */
  public MerchantHierarchy setBillToAttention(java.lang.String billToAttention) {
    return genClient.setOther(billToAttention, CacheKey.billToAttention);
  }

  /**
   * Sets the field 'email'.
   */
  public MerchantHierarchy setEmail(java.lang.String email) {
    return genClient.setOther(email, CacheKey.email);
  }

  /**
   * Sets the field 'abaAccountNumber'.
   */
  public MerchantHierarchy setAbaAccountNumber(java.lang.String abaAccountNumber) {
    return genClient.setOther(abaAccountNumber, CacheKey.abaAccountNumber);
  }

  /**
   * Sets the field 'ddaAccountNumber'.
   */
  public MerchantHierarchy setDdaAccountNumber(java.lang.String ddaAccountNumber) {
    return genClient.setOther(ddaAccountNumber, CacheKey.ddaAccountNumber);
  }

  /**
   * Sets the field 'dbaAddress'.
   */
  public MerchantHierarchy setDbaAddress(java.lang.String dbaAddress) {
    return genClient.setOther(dbaAddress, CacheKey.dbaAddress);
  }

  /**
   * Sets the field 'dbaCity'.
   */
  public MerchantHierarchy setDbaCity(java.lang.String dbaCity) {
    return genClient.setOther(dbaCity, CacheKey.dbaCity);
  }

  /**
   * Sets the field 'dbaState'.
   */
  public MerchantHierarchy setDbaState(java.lang.String dbaState) {
    return genClient.setOther(dbaState, CacheKey.dbaState);
  }

  /**
   * Sets the field 'dbaZip'.
   */
  public MerchantHierarchy setDbaZip(java.lang.String dbaZip) {
    return genClient.setOther(dbaZip, CacheKey.dbaZip);
  }

  /**
   * Sets the field 'dbaPhoneNumber'.
   */
  public MerchantHierarchy setDbaPhoneNumber(java.lang.String dbaPhoneNumber) {
    return genClient.setOther(dbaPhoneNumber, CacheKey.dbaPhoneNumber);
  }

  /**
   * Sets the field 'billCity'.
   */
  public MerchantHierarchy setBillCity(java.lang.String billCity) {
    return genClient.setOther(billCity, CacheKey.billCity);
  }

  /**
   * Sets the field 'billState'.
   */
  public MerchantHierarchy setBillState(java.lang.String billState) {
    return genClient.setOther(billState, CacheKey.billState);
  }

  /**
   * Sets the field 'billZip'.
   */
  public MerchantHierarchy setBillZip(java.lang.String billZip) {
    return genClient.setOther(billZip, CacheKey.billZip);
  }

  /**
   * Sets the field 'billPhoneNumber'.
   */
  public MerchantHierarchy setBillPhoneNumber(java.lang.String billPhoneNumber) {
    return genClient.setOther(billPhoneNumber, CacheKey.billPhoneNumber);
  }


  /** Clears the 'mid' field, the 'has' method for this field will now return false */
  public void clearMid() {
    genClient.clear(CacheKey.mid);
  }
  /** Clears the 'chain' field, the 'has' method for this field will now return false */
  public void clearChain() {
    genClient.clear(CacheKey.chain);
  }
  /** Clears the 'corporate' field, the 'has' method for this field will now return false */
  public void clearCorporate() {
    genClient.clear(CacheKey.corporate);
  }
  /** Clears the 'agent' field, the 'has' method for this field will now return false */
  public void clearAgent() {
    genClient.clear(CacheKey.agent);
  }
  /** Clears the 'bank' field, the 'has' method for this field will now return false */
  public void clearBank() {
    genClient.clear(CacheKey.bank);
  }
  /** Clears the 'business' field, the 'has' method for this field will now return false */
  public void clearBusiness() {
    genClient.clear(CacheKey.business);
  }
  /** Clears the 'maps' field, the 'has' method for this field will now return false */
  public void clearMaps() {
    genClient.clear(CacheKey.maps);
  }
  /** Clears the 'association' field, the 'has' method for this field will now return false */
  public void clearAssociation() {
    genClient.clear(CacheKey.association);
  }
  /** Clears the 'customer' field, the 'has' method for this field will now return false */
  public void clearCustomer() {
    genClient.clear(CacheKey.customer);
  }
  /** Clears the 'billName' field, the 'has' method for this field will now return false */
  public void clearBillName() {
    genClient.clear(CacheKey.billName);
  }
  /** Clears the 'dbaName' field, the 'has' method for this field will now return false */
  public void clearDbaName() {
    genClient.clear(CacheKey.dbaName);
  }
  /** Clears the 'dbaAttention' field, the 'has' method for this field will now return false */
  public void clearDbaAttention() {
    genClient.clear(CacheKey.dbaAttention);
  }
  /** Clears the 'legalName' field, the 'has' method for this field will now return false */
  public void clearLegalName() {
    genClient.clear(CacheKey.legalName);
  }
  /** Clears the 'billToAttention' field, the 'has' method for this field will now return false */
  public void clearBillToAttention() {
    genClient.clear(CacheKey.billToAttention);
  }
  /** Clears the 'email' field, the 'has' method for this field will now return false */
  public void clearEmail() {
    genClient.clear(CacheKey.email);
  }
  /** Clears the 'abaAccountNumber' field, the 'has' method for this field will now return false */
  public void clearAbaAccountNumber() {
    genClient.clear(CacheKey.abaAccountNumber);
  }
  /** Clears the 'ddaAccountNumber' field, the 'has' method for this field will now return false */
  public void clearDdaAccountNumber() {
    genClient.clear(CacheKey.ddaAccountNumber);
  }
  /** Clears the 'dbaAddress' field, the 'has' method for this field will now return false */
  public void clearDbaAddress() {
    genClient.clear(CacheKey.dbaAddress);
  }
  /** Clears the 'dbaCity' field, the 'has' method for this field will now return false */
  public void clearDbaCity() {
    genClient.clear(CacheKey.dbaCity);
  }
  /** Clears the 'dbaState' field, the 'has' method for this field will now return false */
  public void clearDbaState() {
    genClient.clear(CacheKey.dbaState);
  }
  /** Clears the 'dbaZip' field, the 'has' method for this field will now return false */
  public void clearDbaZip() {
    genClient.clear(CacheKey.dbaZip);
  }
  /** Clears the 'dbaPhoneNumber' field, the 'has' method for this field will now return false */
  public void clearDbaPhoneNumber() {
    genClient.clear(CacheKey.dbaPhoneNumber);
  }
  /** Clears the 'billCity' field, the 'has' method for this field will now return false */
  public void clearBillCity() {
    genClient.clear(CacheKey.billCity);
  }
  /** Clears the 'billState' field, the 'has' method for this field will now return false */
  public void clearBillState() {
    genClient.clear(CacheKey.billState);
  }
  /** Clears the 'billZip' field, the 'has' method for this field will now return false */
  public void clearBillZip() {
    genClient.clear(CacheKey.billZip);
  }
  /** Clears the 'billPhoneNumber' field, the 'has' method for this field will now return false */
  public void clearBillPhoneNumber() {
    genClient.clear(CacheKey.billPhoneNumber);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public MerchantHierarchy copyChanges() {
    MerchantHierarchy copy = new MerchantHierarchy();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(MerchantHierarchy src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new MerchantHierarchy(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<MerchantHierarchy> CREATOR = new android.os.Parcelable.Creator<MerchantHierarchy>() {
    @Override
    public MerchantHierarchy createFromParcel(android.os.Parcel in) {
      MerchantHierarchy instance = new MerchantHierarchy(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public MerchantHierarchy[] newArray(int size) {
      return new MerchantHierarchy[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<MerchantHierarchy> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<MerchantHierarchy>() {
    public Class<MerchantHierarchy> getCreatedClass() {
      return MerchantHierarchy.class;
    }

    @Override
    public MerchantHierarchy create(org.json.JSONObject jsonObject) {
      return new MerchantHierarchy(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean MID_IS_REQUIRED = false;
    public static final long MID_MAX_LEN = 31;
    public static final boolean CHAIN_IS_REQUIRED = false;
    public static final long CHAIN_MAX_LEN = 12;
    public static final boolean CORPORATE_IS_REQUIRED = false;
    public static final long CORPORATE_MAX_LEN = 12;
    public static final boolean AGENT_IS_REQUIRED = false;
    public static final long AGENT_MAX_LEN = 12;
    public static final boolean BANK_IS_REQUIRED = false;
    public static final long BANK_MAX_LEN = 12;
    public static final boolean BUSINESS_IS_REQUIRED = false;
    public static final long BUSINESS_MAX_LEN = 12;
    public static final boolean MAPS_IS_REQUIRED = false;
    public static final long MAPS_MAX_LEN = 12;
    public static final boolean ASSOCIATION_IS_REQUIRED = false;
    public static final long ASSOCIATION_MAX_LEN = 12;
    public static final boolean CUSTOMER_IS_REQUIRED = false;
    public static final long CUSTOMER_MAX_LEN = 12;
    public static final boolean BILLNAME_IS_REQUIRED = false;
    public static final long BILLNAME_MAX_LEN = 50;
    public static final boolean DBANAME_IS_REQUIRED = false;
    public static final long DBANAME_MAX_LEN = 50;
    public static final boolean DBAATTENTION_IS_REQUIRED = false;
    public static final long DBAATTENTION_MAX_LEN = 50;
    public static final boolean LEGALNAME_IS_REQUIRED = false;
    public static final long LEGALNAME_MAX_LEN = 50;
    public static final boolean BILLTOATTENTION_IS_REQUIRED = false;
    public static final long BILLTOATTENTION_MAX_LEN = 50;
    public static final boolean EMAIL_IS_REQUIRED = false;
    public static final long EMAIL_MAX_LEN = 127;
    public static final boolean ABAACCOUNTNUMBER_IS_REQUIRED = false;
    public static final long ABAACCOUNTNUMBER_MAX_LEN = 40;
    public static final boolean DDAACCOUNTNUMBER_IS_REQUIRED = false;
    public static final long DDAACCOUNTNUMBER_MAX_LEN = 40;
    public static final boolean DBAADDRESS_IS_REQUIRED = false;
    public static final long DBAADDRESS_MAX_LEN = 255;
    public static final boolean DBACITY_IS_REQUIRED = false;
    public static final long DBACITY_MAX_LEN = 127;
    public static final boolean DBASTATE_IS_REQUIRED = false;
    public static final long DBASTATE_MAX_LEN = 127;
    public static final boolean DBAZIP_IS_REQUIRED = false;
    public static final long DBAZIP_MAX_LEN = 127;
    public static final boolean DBAPHONENUMBER_IS_REQUIRED = false;
    public static final long DBAPHONENUMBER_MAX_LEN = 21;
    public static final boolean BILLCITY_IS_REQUIRED = false;
    public static final long BILLCITY_MAX_LEN = 127;
    public static final boolean BILLSTATE_IS_REQUIRED = false;
    public static final long BILLSTATE_MAX_LEN = 127;
    public static final boolean BILLZIP_IS_REQUIRED = false;
    public static final long BILLZIP_MAX_LEN = 127;
    public static final boolean BILLPHONENUMBER_IS_REQUIRED = false;
    public static final long BILLPHONENUMBER_MAX_LEN = 21;
  }

}
