/**
 * Autogenerated by Avro
 *
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.merchant;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getName name}</li>
 * <li>{@link #getDescription description}</li>
 * <li>{@link #getPrice price}</li>
 * <li>{@link #getTrialDays trialDays}</li>
 * <li>{@link #getTrialRemainingDays trialRemainingDays}</li>
 * <li>{@link #getTrialExpirationTime trialExpirationTime}</li>
 * <li>{@link #getModules modules}</li>
 * <li>{@link #getAppBundle appBundle}</li>
 * <li>{@link #getNumDevicesIncludedWithPrice numDevicesIncludedWithPrice}</li>
 * <li>{@link #getDefaultPlan defaultPlan}</li>
 * <li>{@link #getRecommended recommended}</li>
 * <li>{@link #getPricingModel pricingModel}</li>
 * <li>{@link #getPricingDescription pricingDescription}</li>
 * <li>{@link #getTags tags}</li>
 * <li>{@link #getBogo bogo}</li>
 * <li>{@link #getIncludeAllFeatures includeAllFeatures}</li>
 * <li>{@link #getWeight weight}</li>
 * <li>{@link #getFeatures features}</li>
 * <li>{@link #getTranslatedFeatures translatedFeatures}</li>
 * <li>{@link #getMccs mccs}</li>
 * <li>{@link #getBillToMid billToMid}</li>
 * <li>{@link #getType type}</li>
 * <li>{@link #getPlanCode planCode}</li>
 * <li>{@link #getActivationTime activationTime}</li>
 * <li>{@link #getDeactivationTime deactivationTime}</li>
 * <li>{@link #getMerchantPlanGroup merchantPlanGroup}</li>
 * <li>{@link #getEnforced enforced}</li>
 * <li>{@link #getHidden hidden}</li>
 * <li>{@link #getPlanActionFeeRateSummary planActionFeeRateSummary}</li>
 * <li>{@link #getCreatedTime createdTime}</li>
 * <li>{@link #getModifiedTime modifiedTime}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class MerchantPlan extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * The name of the merchant plan
   */
  public java.lang.String getName() {
    return genClient.cacheGet(CacheKey.name);
  }

  /**
   * Description of the plan
   */
  public java.lang.String getDescription() {
    return genClient.cacheGet(CacheKey.description);
  }

  public java.lang.Long getPrice() {
    return genClient.cacheGet(CacheKey.price);
  }

  /**
   * Transient field, the free trial period, as defined in this plan's group.
   */
  public java.lang.Long getTrialDays() {
    return genClient.cacheGet(CacheKey.trialDays);
  }

  /**
   * Transient field, the free trial period, as defined in this plan's group.
   */
  public java.lang.Long getTrialRemainingDays() {
    return genClient.cacheGet(CacheKey.trialRemainingDays);
  }

  /**
   * Date/time this plan's trial will expire for the merchant with this plan. This is a transient value only applicable to the merchant assigned to this plan.
   */
  public java.lang.Long getTrialExpirationTime() {
    return genClient.cacheGet(CacheKey.trialExpirationTime);
  }

  public java.util.List<com.clover.sdk.v3.merchant.Module> getModules() {
    return genClient.cacheGet(CacheKey.modules);
  }

  public com.clover.sdk.v3.apps.AppBundle getAppBundle() {
    return genClient.cacheGet(CacheKey.appBundle);
  }

  public java.lang.Integer getNumDevicesIncludedWithPrice() {
    return genClient.cacheGet(CacheKey.numDevicesIncludedWithPrice);
  }

  /**
   * If true and multiple plans of this code then treat as default plan for reseller. Cannot use word default.
   */
  public java.lang.Boolean getDefaultPlan() {
    return genClient.cacheGet(CacheKey.defaultPlan);
  }

  /**
   * True if plan metadata indicates this plan should be recommended in OOBE plan selection.
   */
  public java.lang.Boolean getRecommended() {
    return genClient.cacheGet(CacheKey.recommended);
  }

  /**
   * Pricing model for plan. This is calculated based on the plan's flags. This enum is typically used to show appropriate text for the plan's pricing.
   */
  public com.clover.sdk.v3.merchant.MerchantPlanPricingModel getPricingModel() {
    return genClient.cacheGet(CacheKey.pricingModel);
  }

  /**
   * User-friendly description of plan pricing for display
   */
  public java.lang.String getPricingDescription() {
    return genClient.cacheGet(CacheKey.pricingDescription);
  }

  /**
   * Comma separated list of tags.
   */
  public java.util.List<java.lang.String> getTags() {
    return genClient.cacheGet(CacheKey.tags);
  }

  /**
   * If true then plan offers by one device get one free.
   */
  public java.lang.Boolean getBogo() {
    return genClient.cacheGet(CacheKey.bogo);
  }

  /**
   * If true then plan offers by one device get one free.
   */
  public java.lang.Boolean getIncludeAllFeatures() {
    return genClient.cacheGet(CacheKey.includeAllFeatures);
  }

  /**
   * Represents the importance or value the planCode has. Helpful for determining when a merchant is downgrading or upgrading their plan
   */
  public java.lang.Long getWeight() {
    return genClient.cacheGet(CacheKey.weight);
  }

  /**
   * List of feature keys this plan supports. Used by plan selection/summary pages.
   */
  public java.util.List<java.lang.String> getFeatures() {
    return genClient.cacheGet(CacheKey.features);
  }

  /**
   * List of translated feature names this plan supports. Used by plan selection/summary pages.
   */
  public java.util.List<java.lang.String> getTranslatedFeatures() {
    return genClient.cacheGet(CacheKey.translatedFeatures);
  }

  /**
   * List of MCC codes this plan supports or is restricted to. Used for HIPAA MCC processing.
   */
  public java.util.List<java.lang.String> getMccs() {
    return genClient.cacheGet(CacheKey.mccs);
  }

  /**
   * If true then billing will charge monthly fee regardless of device status or count.
   */
  public java.lang.Boolean getBillToMid() {
    return genClient.cacheGet(CacheKey.billToMid);
  }

  /**
   * Type of plan
   */
  public com.clover.sdk.v3.merchant.MerchantPlanType getType() {
    return genClient.cacheGet(CacheKey.type);
  }

  /**
   * First data plan code
   */
  public java.lang.String getPlanCode() {
    return genClient.cacheGet(CacheKey.planCode);
  }

  /**
   * Date/time when this plan becomes active. If null then active now.
   */
  public java.lang.Long getActivationTime() {
    return genClient.cacheGet(CacheKey.activationTime);
  }

  /**
   * Date/time when this plan becomes inactive. If null then no end of life.
   */
  public java.lang.Long getDeactivationTime() {
    return genClient.cacheGet(CacheKey.deactivationTime);
  }

  /**
   * Plan Group of this Plan as associated with merchant in context
   */
  public com.clover.sdk.v3.base.Reference getMerchantPlanGroup() {
    return genClient.cacheGet(CacheKey.merchantPlanGroup);
  }

  /**
   * If true and merchant is assigned this plan then merchant cannot self-serve change from the plan.
   */
  public java.lang.Boolean getEnforced() {
    return genClient.cacheGet(CacheKey.enforced);
  }

  /**
   * If true and a merchant in same plan group is not assigned this plan then merchant cannot see this plan.
   */
  public java.lang.Boolean getHidden() {
    return genClient.cacheGet(CacheKey.hidden);
  }

  public com.clover.sdk.v3.billing.PlanActionFeeRateSummary getPlanActionFeeRateSummary() {
    return genClient.cacheGet(CacheKey.planActionFeeRateSummary);
  }

  /**
   * Date/time this plan was created.
   */
  public java.lang.Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.createdTime);
  }

  /**
   * Date/time this plan was last modified.
   */
  public java.lang.Long getModifiedTime() {
    return genClient.cacheGet(CacheKey.modifiedTime);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    name
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    description
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    price
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    trialDays
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    trialRemainingDays
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    trialExpirationTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    modules
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.merchant.Module.JSON_CREATOR)),
    appBundle
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.apps.AppBundle.JSON_CREATOR)),
    numDevicesIncludedWithPrice
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
    defaultPlan
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    recommended
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    pricingModel
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.merchant.MerchantPlanPricingModel.class)),
    pricingDescription
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    tags
        (com.clover.sdk.extractors.BasicListExtractionStrategy.instance(java.lang.String.class)),
    bogo
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    includeAllFeatures
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    weight
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    features
        (com.clover.sdk.extractors.BasicListExtractionStrategy.instance(java.lang.String.class)),
    translatedFeatures
        (com.clover.sdk.extractors.BasicListExtractionStrategy.instance(java.lang.String.class)),
    mccs
        (com.clover.sdk.extractors.BasicListExtractionStrategy.instance(java.lang.String.class)),
    billToMid
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    type
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.merchant.MerchantPlanType.class)),
    planCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    activationTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    deactivationTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    merchantPlanGroup
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    enforced
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    hidden
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    planActionFeeRateSummary
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.billing.PlanActionFeeRateSummary.JSON_CREATOR)),
    createdTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    modifiedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<MerchantPlan> genClient;

  /**
   * Constructs a new empty instance.
   */
  public MerchantPlan() {
    genClient = new GenericClient<MerchantPlan>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected MerchantPlan(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public MerchantPlan(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public MerchantPlan(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public MerchantPlan(MerchantPlan src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());

    genClient.validateLength(CacheKey.name, getName(), 31);

    genClient.validateLength(CacheKey.description, getDescription(), 2047);

    genClient.validateLength(CacheKey.planCode, getPlanCode(), 50);
    genClient.validateReferences(CacheKey.merchantPlanGroup);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return genClient.cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'description' field is set and is not null */
  public boolean isNotNullDescription() {
    return genClient.cacheValueIsNotNull(CacheKey.description);
  }

  /** Checks whether the 'price' field is set and is not null */
  public boolean isNotNullPrice() {
    return genClient.cacheValueIsNotNull(CacheKey.price);
  }

  /** Checks whether the 'trialDays' field is set and is not null */
  public boolean isNotNullTrialDays() {
    return genClient.cacheValueIsNotNull(CacheKey.trialDays);
  }
  /** Checks whether the 'trialDays' field is set and is not null */
  public boolean isNotNullTrialRemainingDays() {
    return genClient.cacheValueIsNotNull(CacheKey.trialRemainingDays);
  }

  /** Checks whether the 'trialExpirationTime' field is set and is not null */
  public boolean isNotNullTrialExpirationTime() {
    return genClient.cacheValueIsNotNull(CacheKey.trialExpirationTime);
  }

  /** Checks whether the 'modules' field is set and is not null */
  public boolean isNotNullModules() {
    return genClient.cacheValueIsNotNull(CacheKey.modules);
  }

  /** Checks whether the 'modules' field is set and is not null and is not empty */
  public boolean isNotEmptyModules() { return isNotNullModules() && !getModules().isEmpty(); }

  /** Checks whether the 'appBundle' field is set and is not null */
  public boolean isNotNullAppBundle() {
    return genClient.cacheValueIsNotNull(CacheKey.appBundle);
  }

  /** Checks whether the 'numDevicesIncludedWithPrice' field is set and is not null */
  public boolean isNotNullNumDevicesIncludedWithPrice() {
    return genClient.cacheValueIsNotNull(CacheKey.numDevicesIncludedWithPrice);
  }

  /** Checks whether the 'defaultPlan' field is set and is not null */
  public boolean isNotNullDefaultPlan() {
    return genClient.cacheValueIsNotNull(CacheKey.defaultPlan);
  }

  /** Checks whether the 'recommended' field is set and is not null */
  public boolean isNotNullRecommended() {
    return genClient.cacheValueIsNotNull(CacheKey.recommended);
  }

  /** Checks whether the 'pricingModel' field is set and is not null */
  public boolean isNotNullPricingModel() {
    return genClient.cacheValueIsNotNull(CacheKey.pricingModel);
  }

  /** Checks whether the 'pricingDescription' field is set and is not null */
  public boolean isNotNullPricingDescription() {
    return genClient.cacheValueIsNotNull(CacheKey.pricingDescription);
  }

  /** Checks whether the 'tags' field is set and is not null */
  public boolean isNotNullTags() {
    return genClient.cacheValueIsNotNull(CacheKey.tags);
  }

  /** Checks whether the 'tags' field is set and is not null and is not empty */
  public boolean isNotEmptyTags() { return isNotNullTags() && !getTags().isEmpty(); }

  /** Checks whether the 'bogo' field is set and is not null */
  public boolean isNotNullBogo() {
    return genClient.cacheValueIsNotNull(CacheKey.bogo);
  }

  /** Checks whether the 'includeAllFeatures' field is set and is not null */
  public boolean isNotNullIncludeAllFeatures() {
    return genClient.cacheValueIsNotNull(CacheKey.includeAllFeatures);
  }

  /** Checks whether the 'weight' field is set and is not null */
  public boolean isNotNullWeight() {
    return genClient.cacheValueIsNotNull(CacheKey.weight);
  }

  /** Checks whether the 'features' field is set and is not null */
  public boolean isNotNullFeatures() {
    return genClient.cacheValueIsNotNull(CacheKey.features);
  }

  /** Checks whether the 'features' field is set and is not null and is not empty */
  public boolean isNotEmptyFeatures() { return isNotNullFeatures() && !getFeatures().isEmpty(); }

  /** Checks whether the 'translatedFeatures' field is set and is not null */
  public boolean isNotNullTranslatedFeatures() {
    return genClient.cacheValueIsNotNull(CacheKey.translatedFeatures);
  }

  /** Checks whether the 'translatedFeatures' field is set and is not null and is not empty */
  public boolean isNotEmptyTranslatedFeatures() { return isNotNullTranslatedFeatures() && !getTranslatedFeatures().isEmpty(); }

  /** Checks whether the 'mccs' field is set and is not null */
  public boolean isNotNullMccs() {
    return genClient.cacheValueIsNotNull(CacheKey.mccs);
  }

  /** Checks whether the 'mccs' field is set and is not null and is not empty */
  public boolean isNotEmptyMccs() { return isNotNullMccs() && !getMccs().isEmpty(); }

  /** Checks whether the 'billToMid' field is set and is not null */
  public boolean isNotNullBillToMid() {
    return genClient.cacheValueIsNotNull(CacheKey.billToMid);
  }

  /** Checks whether the 'type' field is set and is not null */
  public boolean isNotNullType() {
    return genClient.cacheValueIsNotNull(CacheKey.type);
  }

  /** Checks whether the 'planCode' field is set and is not null */
  public boolean isNotNullPlanCode() {
    return genClient.cacheValueIsNotNull(CacheKey.planCode);
  }

  /** Checks whether the 'activationTime' field is set and is not null */
  public boolean isNotNullActivationTime() {
    return genClient.cacheValueIsNotNull(CacheKey.activationTime);
  }

  /** Checks whether the 'deactivationTime' field is set and is not null */
  public boolean isNotNullDeactivationTime() {
    return genClient.cacheValueIsNotNull(CacheKey.deactivationTime);
  }

  /** Checks whether the 'merchantPlanGroup' field is set and is not null */
  public boolean isNotNullMerchantPlanGroup() {
    return genClient.cacheValueIsNotNull(CacheKey.merchantPlanGroup);
  }

  /** Checks whether the 'enforced' field is set and is not null */
  public boolean isNotNullEnforced() {
    return genClient.cacheValueIsNotNull(CacheKey.enforced);
  }

  /** Checks whether the 'hidden' field is set and is not null */
  public boolean isNotNullHidden() {
    return genClient.cacheValueIsNotNull(CacheKey.hidden);
  }

  /** Checks whether the 'planActionFeeRateSummary' field is set and is not null */
  public boolean isNotNullPlanActionFeeRateSummary() {
    return genClient.cacheValueIsNotNull(CacheKey.planActionFeeRateSummary);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field is set and is not null */
  public boolean isNotNullModifiedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.modifiedTime);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return genClient.cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'description' field has been set, however the value could be null */
  public boolean hasDescription() {
    return genClient.cacheHasKey(CacheKey.description);
  }

  /** Checks whether the 'price' field has been set, however the value could be null */
  public boolean hasPrice() {
    return genClient.cacheHasKey(CacheKey.price);
  }

  /** Checks whether the 'trialDays' field has been set, however the value could be null */
  public boolean hasTrialDays() {
    return genClient.cacheHasKey(CacheKey.trialDays);
  }

  /** Checks whether the 'trialRemainingDays' field has been set, however the value could be null */
  public boolean hasTrialRemainingDays() {
    return genClient.cacheHasKey(CacheKey.trialRemainingDays);
  }

  /** Checks whether the 'trialExpirationTime' field has been set, however the value could be null */
  public boolean hasTrialExpirationTime() {
    return genClient.cacheHasKey(CacheKey.trialExpirationTime);
  }

  /** Checks whether the 'modules' field has been set, however the value could be null */
  public boolean hasModules() {
    return genClient.cacheHasKey(CacheKey.modules);
  }

  /** Checks whether the 'appBundle' field has been set, however the value could be null */
  public boolean hasAppBundle() {
    return genClient.cacheHasKey(CacheKey.appBundle);
  }

  /** Checks whether the 'numDevicesIncludedWithPrice' field has been set, however the value could be null */
  public boolean hasNumDevicesIncludedWithPrice() {
    return genClient.cacheHasKey(CacheKey.numDevicesIncludedWithPrice);
  }

  /** Checks whether the 'defaultPlan' field has been set, however the value could be null */
  public boolean hasDefaultPlan() {
    return genClient.cacheHasKey(CacheKey.defaultPlan);
  }

  /** Checks whether the 'recommended' field has been set, however the value could be null */
  public boolean hasRecommended() {
    return genClient.cacheHasKey(CacheKey.recommended);
  }

  /** Checks whether the 'pricingModel' field has been set, however the value could be null */
  public boolean hasPricingModel() {
    return genClient.cacheHasKey(CacheKey.pricingModel);
  }

  /** Checks whether the 'pricingDescription' field has been set, however the value could be null */
  public boolean hasPricingDescription() {
    return genClient.cacheHasKey(CacheKey.pricingDescription);
  }

  /** Checks whether the 'tags' field has been set, however the value could be null */
  public boolean hasTags() {
    return genClient.cacheHasKey(CacheKey.tags);
  }

  /** Checks whether the 'bogo' field has been set, however the value could be null */
  public boolean hasBogo() {
    return genClient.cacheHasKey(CacheKey.bogo);
  }

  /** Checks whether the 'includeAllFeatures' field has been set, however the value could be null */
  public boolean hasIncludeAllFeatures() {
    return genClient.cacheHasKey(CacheKey.includeAllFeatures);
  }

  /** Checks whether the 'weight' field has been set, however the value could be null */
  public boolean hasWeight() {
    return genClient.cacheHasKey(CacheKey.weight);
  }

  /** Checks whether the 'features' field has been set, however the value could be null */
  public boolean hasFeatures() {
    return genClient.cacheHasKey(CacheKey.features);
  }

  /** Checks whether the 'translatedFeatures' field has been set, however the value could be null */
  public boolean hasTranslatedFeatures() {
    return genClient.cacheHasKey(CacheKey.translatedFeatures);
  }

  /** Checks whether the 'mccs' field has been set, however the value could be null */
  public boolean hasMccs() {
    return genClient.cacheHasKey(CacheKey.mccs);
  }

  /** Checks whether the 'billToMid' field has been set, however the value could be null */
  public boolean hasBillToMid() {
    return genClient.cacheHasKey(CacheKey.billToMid);
  }

  /** Checks whether the 'type' field has been set, however the value could be null */
  public boolean hasType() {
    return genClient.cacheHasKey(CacheKey.type);
  }

  /** Checks whether the 'planCode' field has been set, however the value could be null */
  public boolean hasPlanCode() {
    return genClient.cacheHasKey(CacheKey.planCode);
  }

  /** Checks whether the 'activationTime' field has been set, however the value could be null */
  public boolean hasActivationTime() {
    return genClient.cacheHasKey(CacheKey.activationTime);
  }

  /** Checks whether the 'deactivationTime' field has been set, however the value could be null */
  public boolean hasDeactivationTime() {
    return genClient.cacheHasKey(CacheKey.deactivationTime);
  }

  /** Checks whether the 'merchantPlanGroup' field has been set, however the value could be null */
  public boolean hasMerchantPlanGroup() {
    return genClient.cacheHasKey(CacheKey.merchantPlanGroup);
  }

  /** Checks whether the 'enforced' field has been set, however the value could be null */
  public boolean hasEnforced() {
    return genClient.cacheHasKey(CacheKey.enforced);
  }

  /** Checks whether the 'hidden' field has been set, however the value could be null */
  public boolean hasHidden() {
    return genClient.cacheHasKey(CacheKey.hidden);
  }

  /** Checks whether the 'planActionFeeRateSummary' field has been set, however the value could be null */
  public boolean hasPlanActionFeeRateSummary() {
    return genClient.cacheHasKey(CacheKey.planActionFeeRateSummary);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field has been set, however the value could be null */
  public boolean hasModifiedTime() {
    return genClient.cacheHasKey(CacheKey.modifiedTime);
  }


  /**
   * Sets the field 'id'.
   */
  public MerchantPlan setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'name'.
   */
  public MerchantPlan setName(java.lang.String name) {
    return genClient.setOther(name, CacheKey.name);
  }

  /**
   * Sets the field 'description'.
   */
  public MerchantPlan setDescription(java.lang.String description) {
    return genClient.setOther(description, CacheKey.description);
  }

  /**
   * Sets the field 'price'.
   */
  public MerchantPlan setPrice(java.lang.Long price) {
    return genClient.setOther(price, CacheKey.price);
  }

  /**
   * Sets the field 'trialDays'.
   */
  public MerchantPlan setTrialDays(java.lang.Long trialDays) {
    return genClient.setOther(trialDays, CacheKey.trialDays);
  }

  /**
   * Sets the field 'trialRemainingDays'.
   */
  public MerchantPlan setTrialRemainingDays(java.lang.Long trialRemainingDays) {
    return genClient.setOther(trialRemainingDays, CacheKey.trialRemainingDays);
  }

  /**
   * Sets the field 'trialExpirationTime'.
   */
  public MerchantPlan setTrialExpirationTime(java.lang.Long trialExpirationTime) {
    return genClient.setOther(trialExpirationTime, CacheKey.trialExpirationTime);
  }

  /**
   * Sets the field 'modules'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public MerchantPlan setModules(java.util.List<com.clover.sdk.v3.merchant.Module> modules) {
    return genClient.setArrayRecord(modules, CacheKey.modules);
  }

  /**
   * Sets the field 'appBundle'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public MerchantPlan setAppBundle(com.clover.sdk.v3.apps.AppBundle appBundle) {
    return genClient.setRecord(appBundle, CacheKey.appBundle);
  }

  /**
   * Sets the field 'numDevicesIncludedWithPrice'.
   */
  public MerchantPlan setNumDevicesIncludedWithPrice(java.lang.Integer numDevicesIncludedWithPrice) {
    return genClient.setOther(numDevicesIncludedWithPrice, CacheKey.numDevicesIncludedWithPrice);
  }

  /**
   * Sets the field 'defaultPlan'.
   */
  public MerchantPlan setDefaultPlan(java.lang.Boolean defaultPlan) {
    return genClient.setOther(defaultPlan, CacheKey.defaultPlan);
  }

  /**
   * Sets the field 'recommended'.
   */
  public MerchantPlan setRecommended(java.lang.Boolean recommended) {
    return genClient.setOther(recommended, CacheKey.recommended);
  }

  /**
   * Sets the field 'pricingModel'.
   */
  public MerchantPlan setPricingModel(com.clover.sdk.v3.merchant.MerchantPlanPricingModel pricingModel) {
    return genClient.setOther(pricingModel, CacheKey.pricingModel);
  }

  /**
   * Sets the field 'pricingDescription'.
   */
  public MerchantPlan setPricingDescription(java.lang.String pricingDescription) {
    return genClient.setOther(pricingDescription, CacheKey.pricingDescription);
  }

  /**
   * Sets the field 'tags'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public MerchantPlan setTags(java.util.List<java.lang.String> tags) {
    return genClient.setArrayOther(tags, CacheKey.tags);
  }

  /**
   * Sets the field 'bogo'.
   */
  public MerchantPlan setBogo(java.lang.Boolean bogo) {
    return genClient.setOther(bogo, CacheKey.bogo);
  }

  /**
   * Sets the field 'includeAllFeatures'.
   */
  public MerchantPlan setIncludeAllFeatures(java.lang.Boolean includeAllFeatures) {
    return genClient.setOther(includeAllFeatures, CacheKey.includeAllFeatures);
  }

  /**
   * Sets the field 'weight'.
   */
  public MerchantPlan setWeight(java.lang.Long weight) {
    return genClient.setOther(weight, CacheKey.weight);
  }

  /**
   * Sets the field 'features'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public MerchantPlan setFeatures(java.util.List<java.lang.String> features) {
    return genClient.setArrayOther(features, CacheKey.features);
  }

  /**
   * Sets the field 'translatedFeatures'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public MerchantPlan setTranslatedFeatures(java.util.List<java.lang.String> translatedFeatures) {
    return genClient.setArrayOther(translatedFeatures, CacheKey.translatedFeatures);
  }

  /**
   * Sets the field 'mccs'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public MerchantPlan setMccs(java.util.List<java.lang.String> mccs) {
    return genClient.setArrayOther(mccs, CacheKey.mccs);
  }

  /**
   * Sets the field 'billToMid'.
   */
  public MerchantPlan setBillToMid(java.lang.Boolean billToMid) {
    return genClient.setOther(billToMid, CacheKey.billToMid);
  }

  /**
   * Sets the field 'type'.
   */
  public MerchantPlan setType(com.clover.sdk.v3.merchant.MerchantPlanType type) {
    return genClient.setOther(type, CacheKey.type);
  }

  /**
   * Sets the field 'planCode'.
   */
  public MerchantPlan setPlanCode(java.lang.String planCode) {
    return genClient.setOther(planCode, CacheKey.planCode);
  }

  /**
   * Sets the field 'activationTime'.
   */
  public MerchantPlan setActivationTime(java.lang.Long activationTime) {
    return genClient.setOther(activationTime, CacheKey.activationTime);
  }

  /**
   * Sets the field 'deactivationTime'.
   */
  public MerchantPlan setDeactivationTime(java.lang.Long deactivationTime) {
    return genClient.setOther(deactivationTime, CacheKey.deactivationTime);
  }

  /**
   * Sets the field 'merchantPlanGroup'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public MerchantPlan setMerchantPlanGroup(com.clover.sdk.v3.base.Reference merchantPlanGroup) {
    return genClient.setRecord(merchantPlanGroup, CacheKey.merchantPlanGroup);
  }

  /**
   * Sets the field 'enforced'.
   */
  public MerchantPlan setEnforced(java.lang.Boolean enforced) {
    return genClient.setOther(enforced, CacheKey.enforced);
  }

  /**
   * Sets the field 'hidden'.
   */
  public MerchantPlan setHidden(java.lang.Boolean hidden) {
    return genClient.setOther(hidden, CacheKey.hidden);
  }

  /**
   * Sets the field 'planActionFeeRateSummary'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public MerchantPlan setPlanActionFeeRateSummary(com.clover.sdk.v3.billing.PlanActionFeeRateSummary planActionFeeRateSummary) {
    return genClient.setRecord(planActionFeeRateSummary, CacheKey.planActionFeeRateSummary);
  }

  /**
   * Sets the field 'createdTime'.
   */
  public MerchantPlan setCreatedTime(java.lang.Long createdTime) {
    return genClient.setOther(createdTime, CacheKey.createdTime);
  }

  /**
   * Sets the field 'modifiedTime'.
   */
  public MerchantPlan setModifiedTime(java.lang.Long modifiedTime) {
    return genClient.setOther(modifiedTime, CacheKey.modifiedTime);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    genClient.clear(CacheKey.name);
  }
  /** Clears the 'description' field, the 'has' method for this field will now return false */
  public void clearDescription() {
    genClient.clear(CacheKey.description);
  }
  /** Clears the 'price' field, the 'has' method for this field will now return false */
  public void clearPrice() {
    genClient.clear(CacheKey.price);
  }
  /** Clears the 'trialDays' field, the 'has' method for this field will now return false */
  public void clearTrialDays() {
    genClient.clear(CacheKey.trialRemainingDays);
  }
  /** Clears the 'trialRemainingDays' field, the 'has' method for this field will now return false */
  public void clearTrialRemainingDays() {
    genClient.clear(CacheKey.trialRemainingDays);
  }
  /** Clears the 'trialExpirationTime' field, the 'has' method for this field will now return false */
  public void clearTrialExpirationTime() {
    genClient.clear(CacheKey.trialExpirationTime);
  }
  /** Clears the 'modules' field, the 'has' method for this field will now return false */
  public void clearModules() {
    genClient.clear(CacheKey.modules);
  }
  /** Clears the 'appBundle' field, the 'has' method for this field will now return false */
  public void clearAppBundle() {
    genClient.clear(CacheKey.appBundle);
  }
  /** Clears the 'numDevicesIncludedWithPrice' field, the 'has' method for this field will now return false */
  public void clearNumDevicesIncludedWithPrice() {
    genClient.clear(CacheKey.numDevicesIncludedWithPrice);
  }
  /** Clears the 'defaultPlan' field, the 'has' method for this field will now return false */
  public void clearDefaultPlan() {
    genClient.clear(CacheKey.defaultPlan);
  }
  /** Clears the 'recommended' field, the 'has' method for this field will now return false */
  public void clearRecommended() {
    genClient.clear(CacheKey.recommended);
  }
  /** Clears the 'pricingModel' field, the 'has' method for this field will now return false */
  public void clearPricingModel() {
    genClient.clear(CacheKey.pricingModel);
  }
  /** Clears the 'pricingDescription' field, the 'has' method for this field will now return false */
  public void clearPricingDescription() {
    genClient.clear(CacheKey.pricingDescription);
  }
  /** Clears the 'tags' field, the 'has' method for this field will now return false */
  public void clearTags() {
    genClient.clear(CacheKey.tags);
  }
  /** Clears the 'tags' field, the 'has' method for this field will now return false */
  public void clearBogo() {
    genClient.clear(CacheKey.bogo);
  }
  /** Clears the 'weight' field, the 'has' method for this field will now return false */
  public void clearIncludeAllFeatures() {
    genClient.clear(CacheKey.includeAllFeatures);
  }
  /** Clears the 'weight' field, the 'has' method for this field will now return false */
  public void clearWeight() {
    genClient.clear(CacheKey.weight);
  }
  /** Clears the 'features' field, the 'has' method for this field will now return false */
  public void clearFeatures() {
    genClient.clear(CacheKey.features);
  }
  /** Clears the 'translatedFeatures' field, the 'has' method for this field will now return false */
  public void clearTranslatedFeatures() {
    genClient.clear(CacheKey.translatedFeatures);
  }
  /** Clears the 'mccs' field, the 'has' method for this field will now return false */
  public void clearMccs() {
    genClient.clear(CacheKey.mccs);
  }
  /** Clears the 'billToMid' field, the 'has' method for this field will now return false */
  public void clearBillToMid() {
    genClient.clear(CacheKey.billToMid);
  }
  /** Clears the 'type' field, the 'has' method for this field will now return false */
  public void clearType() {
    genClient.clear(CacheKey.type);
  }
  /** Clears the 'planCode' field, the 'has' method for this field will now return false */
  public void clearPlanCode() {
    genClient.clear(CacheKey.planCode);
  }
  /** Clears the 'activationTime' field, the 'has' method for this field will now return false */
  public void clearActivationTime() {
    genClient.clear(CacheKey.activationTime);
  }
  /** Clears the 'deactivationTime' field, the 'has' method for this field will now return false */
  public void clearDeactivationTime() {
    genClient.clear(CacheKey.deactivationTime);
  }
  /** Clears the 'merchantPlanGroup' field, the 'has' method for this field will now return false */
  public void clearMerchantPlanGroup() {
    genClient.clear(CacheKey.merchantPlanGroup);
  }
  /** Clears the 'enforced' field, the 'has' method for this field will now return false */
  public void clearEnforced() {
    genClient.clear(CacheKey.enforced);
  }
  /** Clears the 'hidden' field, the 'has' method for this field will now return false */
  public void clearHidden() {
    genClient.clear(CacheKey.hidden);
  }
  /** Clears the 'planActionFeeRateSummary' field, the 'has' method for this field will now return false */
  public void clearPlanActionFeeRateSummary() {
    genClient.clear(CacheKey.planActionFeeRateSummary);
  }
  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.createdTime);
  }
  /** Clears the 'modifiedTime' field, the 'has' method for this field will now return false */
  public void clearModifiedTime() {
    genClient.clear(CacheKey.modifiedTime);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public MerchantPlan copyChanges() {
    MerchantPlan copy = new MerchantPlan();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(MerchantPlan src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new MerchantPlan(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<MerchantPlan> CREATOR = new android.os.Parcelable.Creator<MerchantPlan>() {
    @Override
    public MerchantPlan createFromParcel(android.os.Parcel in) {
      MerchantPlan instance = new MerchantPlan(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public MerchantPlan[] newArray(int size) {
      return new MerchantPlan[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<MerchantPlan> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<MerchantPlan>() {
    public Class<MerchantPlan> getCreatedClass() {
      return MerchantPlan.class;
    }

    @Override
    public MerchantPlan create(org.json.JSONObject jsonObject) {
      return new MerchantPlan(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean NAME_IS_REQUIRED = false;
    public static final long NAME_MAX_LEN = 31;
    public static final boolean DESCRIPTION_IS_REQUIRED = false;
    public static final long DESCRIPTION_MAX_LEN = 2047;
    public static final boolean PRICE_IS_REQUIRED = false;
    public static final boolean TRIALDAYS_IS_REQUIRED = false;
    public static final boolean TRIALREMAININGDAYS_IS_REQUIRED = false;
    public static final boolean TRIALEXPIRATIONTIME_IS_REQUIRED = false;
    public static final boolean MODULES_IS_REQUIRED = false;
    public static final boolean APPBUNDLE_IS_REQUIRED = false;
    public static final boolean NUMDEVICESINCLUDEDWITHPRICE_IS_REQUIRED = false;
    public static final boolean DEFAULTPLAN_IS_REQUIRED = false;
    public static final boolean RECOMMENDED_IS_REQUIRED = false;
    public static final boolean PRICINGMODEL_IS_REQUIRED = false;
    public static final boolean PRICINGDESCRIPTION_IS_REQUIRED = false;
    public static final boolean TAGS_IS_REQUIRED = false;
    public static final boolean BOGO_IS_REQUIRED = false;
    public static final boolean INCLUDE_ALL_FEATURES = false;
    public static final boolean WEIGHT_IS_REQUIRED = false;
    public static final boolean FEATURES_IS_REQUIRED = false;
    public static final boolean TRANSLATEDFEATURES_IS_REQUIRED = false;
    public static final boolean MCCS_IS_REQUIRED = false;
    public static final boolean BILLTOMID_IS_REQUIRED = false;
    public static final boolean TYPE_IS_REQUIRED = false;
    public static final boolean PLANCODE_IS_REQUIRED = false;
    public static final long PLANCODE_MAX_LEN = 50;
    public static final boolean ACTIVATIONTIME_IS_REQUIRED = false;
    public static final boolean DEACTIVATIONTIME_IS_REQUIRED = false;
    public static final boolean MERCHANTPLANGROUP_IS_REQUIRED = false;
    public static final boolean ENFORCED_IS_REQUIRED = false;
    public static final boolean HIDDEN_IS_REQUIRED = false;
    public static final boolean PLANACTIONFEERATESUMMARY_IS_REQUIRED = false;
    public static final boolean CREATEDTIME_IS_REQUIRED = false;
    public static final boolean MODIFIEDTIME_IS_REQUIRED = false;
  }

}
