/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.merchant;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getMerchantPlans merchantPlans}</li>
 * <li>{@link #getPeripherals peripherals}</li>
 * <li>{@link #getCurrentMerchantPlan currentMerchantPlan}</li>
 * <li>{@link #getRules rules}</li>
 * <li>{@link #getPlanActionFeeRateSummary planActionFeeRateSummary}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class MerchantPlanMeta extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  public java.util.List<com.clover.sdk.v3.merchant.MerchantPlan> getMerchantPlans() {
    return genClient.cacheGet(CacheKey.merchantPlans);
  }

  public java.util.List<com.clover.sdk.v3.device.PeripheralBundleCountry> getPeripherals() {
    return genClient.cacheGet(CacheKey.peripherals);
  }

  public com.clover.sdk.v3.merchant.MerchantPlan getCurrentMerchantPlan() {
    return genClient.cacheGet(CacheKey.currentMerchantPlan);
  }

  public com.clover.sdk.v3.merchant.MerchantPlanRules getRules() {
    return genClient.cacheGet(CacheKey.rules);
  }

  public com.clover.sdk.v3.billing.PlanActionFeeRateSummary getPlanActionFeeRateSummary() {
    return genClient.cacheGet(CacheKey.planActionFeeRateSummary);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    merchantPlans
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.merchant.MerchantPlan.JSON_CREATOR)),
    peripherals
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.device.PeripheralBundleCountry.JSON_CREATOR)),
    currentMerchantPlan
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.merchant.MerchantPlan.JSON_CREATOR)),
    rules
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.merchant.MerchantPlanRules.JSON_CREATOR)),
    planActionFeeRateSummary
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.billing.PlanActionFeeRateSummary.JSON_CREATOR)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<MerchantPlanMeta> genClient;

  /**
   * Constructs a new empty instance.
   */
  public MerchantPlanMeta() {
    genClient = new GenericClient<MerchantPlanMeta>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected MerchantPlanMeta(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public MerchantPlanMeta(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public MerchantPlanMeta(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public MerchantPlanMeta(MerchantPlanMeta src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'merchantPlans' field is set and is not null */
  public boolean isNotNullMerchantPlans() {
    return genClient.cacheValueIsNotNull(CacheKey.merchantPlans);
  }

  /** Checks whether the 'merchantPlans' field is set and is not null and is not empty */
  public boolean isNotEmptyMerchantPlans() { return isNotNullMerchantPlans() && !getMerchantPlans().isEmpty(); }

  /** Checks whether the 'peripherals' field is set and is not null */
  public boolean isNotNullPeripherals() {
    return genClient.cacheValueIsNotNull(CacheKey.peripherals);
  }

  /** Checks whether the 'peripherals' field is set and is not null and is not empty */
  public boolean isNotEmptyPeripherals() { return isNotNullPeripherals() && !getPeripherals().isEmpty(); }

  /** Checks whether the 'currentMerchantPlan' field is set and is not null */
  public boolean isNotNullCurrentMerchantPlan() {
    return genClient.cacheValueIsNotNull(CacheKey.currentMerchantPlan);
  }

  /** Checks whether the 'rules' field is set and is not null */
  public boolean isNotNullRules() {
    return genClient.cacheValueIsNotNull(CacheKey.rules);
  }

  /** Checks whether the 'planActionFeeRateSummary' field is set and is not null */
  public boolean isNotNullPlanActionFeeRateSummary() {
    return genClient.cacheValueIsNotNull(CacheKey.planActionFeeRateSummary);
  }



  /** Checks whether the 'merchantPlans' field has been set, however the value could be null */
  public boolean hasMerchantPlans() {
    return genClient.cacheHasKey(CacheKey.merchantPlans);
  }

  /** Checks whether the 'peripherals' field has been set, however the value could be null */
  public boolean hasPeripherals() {
    return genClient.cacheHasKey(CacheKey.peripherals);
  }

  /** Checks whether the 'currentMerchantPlan' field has been set, however the value could be null */
  public boolean hasCurrentMerchantPlan() {
    return genClient.cacheHasKey(CacheKey.currentMerchantPlan);
  }

  /** Checks whether the 'rules' field has been set, however the value could be null */
  public boolean hasRules() {
    return genClient.cacheHasKey(CacheKey.rules);
  }

  /** Checks whether the 'planActionFeeRateSummary' field has been set, however the value could be null */
  public boolean hasPlanActionFeeRateSummary() {
    return genClient.cacheHasKey(CacheKey.planActionFeeRateSummary);
  }


  /**
   * Sets the field 'merchantPlans'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public MerchantPlanMeta setMerchantPlans(java.util.List<com.clover.sdk.v3.merchant.MerchantPlan> merchantPlans) {
    return genClient.setArrayRecord(merchantPlans, CacheKey.merchantPlans);
  }

  /**
   * Sets the field 'peripherals'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public MerchantPlanMeta setPeripherals(java.util.List<com.clover.sdk.v3.device.PeripheralBundleCountry> peripherals) {
    return genClient.setArrayRecord(peripherals, CacheKey.peripherals);
  }

  /**
   * Sets the field 'currentMerchantPlan'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public MerchantPlanMeta setCurrentMerchantPlan(com.clover.sdk.v3.merchant.MerchantPlan currentMerchantPlan) {
    return genClient.setRecord(currentMerchantPlan, CacheKey.currentMerchantPlan);
  }

  /**
   * Sets the field 'rules'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public MerchantPlanMeta setRules(com.clover.sdk.v3.merchant.MerchantPlanRules rules) {
    return genClient.setRecord(rules, CacheKey.rules);
  }

  /**
   * Sets the field 'planActionFeeRateSummary'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public MerchantPlanMeta setPlanActionFeeRateSummary(com.clover.sdk.v3.billing.PlanActionFeeRateSummary planActionFeeRateSummary) {
    return genClient.setRecord(planActionFeeRateSummary, CacheKey.planActionFeeRateSummary);
  }


  /** Clears the 'merchantPlans' field, the 'has' method for this field will now return false */
  public void clearMerchantPlans() {
    genClient.clear(CacheKey.merchantPlans);
  }
  /** Clears the 'peripherals' field, the 'has' method for this field will now return false */
  public void clearPeripherals() {
    genClient.clear(CacheKey.peripherals);
  }
  /** Clears the 'currentMerchantPlan' field, the 'has' method for this field will now return false */
  public void clearCurrentMerchantPlan() {
    genClient.clear(CacheKey.currentMerchantPlan);
  }
  /** Clears the 'rules' field, the 'has' method for this field will now return false */
  public void clearRules() {
    genClient.clear(CacheKey.rules);
  }
  /** Clears the 'planActionFeeRateSummary' field, the 'has' method for this field will now return false */
  public void clearPlanActionFeeRateSummary() {
    genClient.clear(CacheKey.planActionFeeRateSummary);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public MerchantPlanMeta copyChanges() {
    MerchantPlanMeta copy = new MerchantPlanMeta();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(MerchantPlanMeta src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new MerchantPlanMeta(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<MerchantPlanMeta> CREATOR = new android.os.Parcelable.Creator<MerchantPlanMeta>() {
    @Override
    public MerchantPlanMeta createFromParcel(android.os.Parcel in) {
      MerchantPlanMeta instance = new MerchantPlanMeta(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public MerchantPlanMeta[] newArray(int size) {
      return new MerchantPlanMeta[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<MerchantPlanMeta> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<MerchantPlanMeta>() {
    public Class<MerchantPlanMeta> getCreatedClass() {
      return MerchantPlanMeta.class;
    }

    @Override
    public MerchantPlanMeta create(org.json.JSONObject jsonObject) {
      return new MerchantPlanMeta(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean MERCHANTPLANS_IS_REQUIRED = false;
    public static final boolean PERIPHERALS_IS_REQUIRED = false;
    public static final boolean CURRENTMERCHANTPLAN_IS_REQUIRED = false;
    public static final boolean RULES_IS_REQUIRED = false;
    public static final boolean PLANACTIONFEERATESUMMARY_IS_REQUIRED = false;
  }

}
