/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.multiplemenu;


import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * A day part that is associated with a particular menu.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getName name}</li>
 * <li>{@link #getStartTime startTime}</li>
 * <li>{@link #getEndTime endTime}</li>
 * <li>{@link #getDays days}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class MenuDayPart extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique Clover identifier.
   */
  public String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * day part name
   */
  public String getName() {
    return genClient.cacheGet(CacheKey.name);
  }

  /**
   * day part start time
   */
  public String getStartTime() {
    return genClient.cacheGet(CacheKey.startTime);
  }

  /**
   * day part end time
   */
  public String getEndTime() {
    return genClient.cacheGet(CacheKey.endTime);
  }

  /**
   * day part specific days
   */
  public String getDays() {
    return genClient.cacheGet(CacheKey.days);
  }

  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    name
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    startTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    endTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    days
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<MenuDayPart> genClient;

  /**
   * Constructs a new empty instance.
   */
  public MenuDayPart() {
    genClient = new GenericClient<MenuDayPart>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected MenuDayPart(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public MenuDayPart(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public MenuDayPart(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public MenuDayPart(MenuDayPart src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());

    genClient.validateNotNull(CacheKey.name, getName());
    genClient.validateLength(CacheKey.name, getName(), 127);

    genClient.validateNotNull(CacheKey.startTime, getStartTime());
    genClient.validateLength(CacheKey.startTime, getStartTime(), 5);
if (getStartTime()!= null && getStartTime().matches("^([0-1][0-9]|2[0-3]):[0-5][0-9]$")) { throw new IllegalArgumentException("Invalid formatting for 'getStartTime()'.");}

    genClient.validateNotNull(CacheKey.endTime, getEndTime());
    genClient.validateLength(CacheKey.endTime, getEndTime(), 5);
if (getEndTime()!= null && getEndTime().matches("^([0-1][0-9]|2[0-3]):[0-5][0-9]$")) { throw new IllegalArgumentException("Invalid formatting for 'getEndTime()'.");}

    genClient.validateNotNull(CacheKey.days, getDays());
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return genClient.cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'startTime' field is set and is not null */
  public boolean isNotNullStartTime() {
    return genClient.cacheValueIsNotNull(CacheKey.startTime);
  }

  /** Checks whether the 'endTime' field is set and is not null */
  public boolean isNotNullEndTime() {
    return genClient.cacheValueIsNotNull(CacheKey.endTime);
  }

  /** Checks whether the 'days' field is set and is not null */
  public boolean isNotNullDays() {
    return genClient.cacheValueIsNotNull(CacheKey.days);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return genClient.cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'startTime' field has been set, however the value could be null */
  public boolean hasStartTime() {
    return genClient.cacheHasKey(CacheKey.startTime);
  }

  /** Checks whether the 'endTime' field has been set, however the value could be null */
  public boolean hasEndTime() {
    return genClient.cacheHasKey(CacheKey.endTime);
  }

  /** Checks whether the 'days' field has been set, however the value could be null */
  public boolean hasDays() {
    return genClient.cacheHasKey(CacheKey.days);
  }


  /**
   * Sets the field 'id'.
   */
  public MenuDayPart setId(String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'name'.
   */
  public MenuDayPart setName(String name) {
    return genClient.setOther(name, CacheKey.name);
  }

  /**
   * Sets the field 'startTime'.
   */
  public MenuDayPart setStartTime(String startTime) {
    return genClient.setOther(startTime, CacheKey.startTime);
  }

  /**
   * Sets the field 'endTime'.
   */
  public MenuDayPart setEndTime(String endTime) {
    return genClient.setOther(endTime, CacheKey.endTime);
  }

  /**
   * Sets the field 'days'.
   */
  public MenuDayPart setDays(String days) {
    return genClient.setOther(days, CacheKey.days);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    genClient.clear(CacheKey.name);
  }
  /** Clears the 'startTime' field, the 'has' method for this field will now return false */
  public void clearStartTime() {
    genClient.clear(CacheKey.startTime);
  }
  /** Clears the 'endTime' field, the 'has' method for this field will now return false */
  public void clearEndTime() {
    genClient.clear(CacheKey.endTime);
  }
  /** Clears the 'days' field, the 'has' method for this field will now return false */
  public void clearDays() {
    genClient.clear(CacheKey.days);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public MenuDayPart copyChanges() {
    MenuDayPart copy = new MenuDayPart();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(MenuDayPart src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new MenuDayPart(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<MenuDayPart> CREATOR = new android.os.Parcelable.Creator<MenuDayPart>() {
    @Override
    public MenuDayPart createFromParcel(android.os.Parcel in) {
      MenuDayPart instance = new MenuDayPart(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public MenuDayPart[] newArray(int size) {
      return new MenuDayPart[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<MenuDayPart> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<MenuDayPart>() {
    public Class<MenuDayPart> getCreatedClass() {
      return MenuDayPart.class;
    }

    @Override
    public MenuDayPart create(org.json.JSONObject jsonObject) {
      return new MenuDayPart(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 127;
    public static final boolean NAME_IS_REQUIRED = true;
    public static final long NAME_MAX_LEN = 127;
    public static final boolean STARTTIME_IS_REQUIRED = true;
    public static final long STARTTIME_MAX_LEN = 5;
    public static final boolean ENDTIME_IS_REQUIRED = true;
    public static final long ENDTIME_MAX_LEN = 5;
    public static final boolean DAYS_IS_REQUIRED = true;
  }

}
