/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.onlineorder;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getAddress address}</li>
 * <li>{@link #getName name}</li>
 * <li>{@link #getPhoneNumber phoneNumber}</li>
 * <li>{@link #getEnabled enabled}</li>
 * <li>{@link #getMenuWalkthroughComplete menuWalkthroughComplete}</li>
 * <li>{@link #getBusinessInfoDone businessInfoDone}</li>
 * <li>{@link #getServiceInfoDone serviceInfoDone}</li>
 * <li>{@link #getStatus status}</li>
 * <li>{@link #getScheduleOrder scheduleOrder}</li>
 * <li>{@link #getScheduleDayRange scheduleDayRange}</li>
 * <li>{@link #getCreatedTime createdTime}</li>
 * <li>{@link #getModifiedTime modifiedTime}</li>
 * <li>{@link #getLeadTime leadTime}</li>
 * <li>{@link #getDeletedTime deletedTime}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class OnlineOrderMerchant extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * merchant id
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * The merchant address
   */
  public com.clover.sdk.v3.base.Address getAddress() {
    return genClient.cacheGet(CacheKey.address);
  }

  /**
   * Customer facing business name
   */
  public java.lang.String getName() {
    return genClient.cacheGet(CacheKey.name);
  }

  public java.lang.String getPhoneNumber() {
    return genClient.cacheGet(CacheKey.phoneNumber);
  }

  /**
   * Restaurant enabled for online ordering
   */
  public java.lang.Boolean getEnabled() {
    return genClient.cacheGet(CacheKey.enabled);
  }

  /**
   * Auto-curation menu walkthrough complete
   */
  public java.lang.Boolean getMenuWalkthroughComplete() {
    return genClient.cacheGet(CacheKey.menuWalkthroughComplete);
  }

  /**
   * Finished collecting business information
   */
  public java.lang.Boolean getBusinessInfoDone() {
    return genClient.cacheGet(CacheKey.businessInfoDone);
  }

  /**
   * Finished collecting service information
   */
  public java.lang.Boolean getServiceInfoDone() {
    return genClient.cacheGet(CacheKey.serviceInfoDone);
  }

  /**
   * Restaurant online order onboarding status
   */
  public com.clover.sdk.v3.onlineorder.Status getStatus() {
    return genClient.cacheGet(CacheKey.status);
  }

  /**
   * If the merchant accepts scheduled order
   */
  public java.lang.Boolean getScheduleOrder() {
    return genClient.cacheGet(CacheKey.scheduleOrder);
  }

  /**
   * Order ahead day range
   */
  public java.lang.Integer getScheduleDayRange() {
    return genClient.cacheGet(CacheKey.scheduleDayRange);
  }

  /**
   * Timestamp when the online ordering merchant was created
   */
  public java.lang.Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.createdTime);
  }

  /**
   * Timestamp when the online ordering merchant was last modified
   */
  public java.lang.Long getModifiedTime() {
    return genClient.cacheGet(CacheKey.modifiedTime);
  }

  /**
   * Number of minutes to tell the customer the order usually takes to prepare
   */
  public java.lang.Integer getLeadTime() {
    return genClient.cacheGet(CacheKey.leadTime);
  }

  /**
   * Timestamp when online ordering merchant was last deleted
   */
  public java.lang.Long getDeletedTime() {
    return genClient.cacheGet(CacheKey.deletedTime);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    address
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Address.JSON_CREATOR)),
    name
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    phoneNumber
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    enabled
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    menuWalkthroughComplete
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    businessInfoDone
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    serviceInfoDone
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    status
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.onlineorder.Status.class)),
    scheduleOrder
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    scheduleDayRange
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
    createdTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    modifiedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    leadTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
    deletedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<OnlineOrderMerchant> genClient;

  /**
   * Constructs a new empty instance.
   */
  public OnlineOrderMerchant() {
    genClient = new GenericClient<OnlineOrderMerchant>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected OnlineOrderMerchant(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public OnlineOrderMerchant(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public OnlineOrderMerchant(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public OnlineOrderMerchant(OnlineOrderMerchant src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());

    genClient.validateLength(CacheKey.name, getName(), 127);

    genClient.validateLength(CacheKey.phoneNumber, getPhoneNumber(), 21);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'address' field is set and is not null */
  public boolean isNotNullAddress() {
    return genClient.cacheValueIsNotNull(CacheKey.address);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return genClient.cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'phoneNumber' field is set and is not null */
  public boolean isNotNullPhoneNumber() {
    return genClient.cacheValueIsNotNull(CacheKey.phoneNumber);
  }

  /** Checks whether the 'enabled' field is set and is not null */
  public boolean isNotNullEnabled() {
    return genClient.cacheValueIsNotNull(CacheKey.enabled);
  }

  /** Checks whether the 'menuWalkthroughComplete' field is set and is not null */
  public boolean isNotNullMenuWalkthroughComplete() {
    return genClient.cacheValueIsNotNull(CacheKey.menuWalkthroughComplete);
  }

  /** Checks whether the 'businessInfoDone' field is set and is not null */
  public boolean isNotNullBusinessInfoDone() {
    return genClient.cacheValueIsNotNull(CacheKey.businessInfoDone);
  }

  /** Checks whether the 'serviceInfoDone' field is set and is not null */
  public boolean isNotNullServiceInfoDone() {
    return genClient.cacheValueIsNotNull(CacheKey.serviceInfoDone);
  }

  /** Checks whether the 'status' field is set and is not null */
  public boolean isNotNullStatus() {
    return genClient.cacheValueIsNotNull(CacheKey.status);
  }

  /** Checks whether the 'scheduleOrder' field is set and is not null */
  public boolean isNotNullScheduleOrder() {
    return genClient.cacheValueIsNotNull(CacheKey.scheduleOrder);
  }

  /** Checks whether the 'scheduleDayRange' field is set and is not null */
  public boolean isNotNullScheduleDayRange() {
    return genClient.cacheValueIsNotNull(CacheKey.scheduleDayRange);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field is set and is not null */
  public boolean isNotNullModifiedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.modifiedTime);
  }

  /** Checks whether the 'leadTime' field is set and is not null */
  public boolean isNotNullLeadTime() {
    return genClient.cacheValueIsNotNull(CacheKey.leadTime);
  }

  /** Checks whether the 'deletedTime' field is set and is not null */
  public boolean isNotNullDeletedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.deletedTime);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'address' field has been set, however the value could be null */
  public boolean hasAddress() {
    return genClient.cacheHasKey(CacheKey.address);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return genClient.cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'phoneNumber' field has been set, however the value could be null */
  public boolean hasPhoneNumber() {
    return genClient.cacheHasKey(CacheKey.phoneNumber);
  }

  /** Checks whether the 'enabled' field has been set, however the value could be null */
  public boolean hasEnabled() {
    return genClient.cacheHasKey(CacheKey.enabled);
  }

  /** Checks whether the 'menuWalkthroughComplete' field has been set, however the value could be null */
  public boolean hasMenuWalkthroughComplete() {
    return genClient.cacheHasKey(CacheKey.menuWalkthroughComplete);
  }

  /** Checks whether the 'businessInfoDone' field has been set, however the value could be null */
  public boolean hasBusinessInfoDone() {
    return genClient.cacheHasKey(CacheKey.businessInfoDone);
  }

  /** Checks whether the 'serviceInfoDone' field has been set, however the value could be null */
  public boolean hasServiceInfoDone() {
    return genClient.cacheHasKey(CacheKey.serviceInfoDone);
  }

  /** Checks whether the 'status' field has been set, however the value could be null */
  public boolean hasStatus() {
    return genClient.cacheHasKey(CacheKey.status);
  }

  /** Checks whether the 'scheduleOrder' field has been set, however the value could be null */
  public boolean hasScheduleOrder() {
    return genClient.cacheHasKey(CacheKey.scheduleOrder);
  }

  /** Checks whether the 'scheduleDayRange' field has been set, however the value could be null */
  public boolean hasScheduleDayRange() {
    return genClient.cacheHasKey(CacheKey.scheduleDayRange);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field has been set, however the value could be null */
  public boolean hasModifiedTime() {
    return genClient.cacheHasKey(CacheKey.modifiedTime);
  }

  /** Checks whether the 'leadTime' field has been set, however the value could be null */
  public boolean hasLeadTime() {
    return genClient.cacheHasKey(CacheKey.leadTime);
  }

  /** Checks whether the 'deletedTime' field has been set, however the value could be null */
  public boolean hasDeletedTime() {
    return genClient.cacheHasKey(CacheKey.deletedTime);
  }


  /**
   * Sets the field 'id'.
   */
  public OnlineOrderMerchant setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'address'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public OnlineOrderMerchant setAddress(com.clover.sdk.v3.base.Address address) {
    return genClient.setRecord(address, CacheKey.address);
  }

  /**
   * Sets the field 'name'.
   */
  public OnlineOrderMerchant setName(java.lang.String name) {
    return genClient.setOther(name, CacheKey.name);
  }

  /**
   * Sets the field 'phoneNumber'.
   */
  public OnlineOrderMerchant setPhoneNumber(java.lang.String phoneNumber) {
    return genClient.setOther(phoneNumber, CacheKey.phoneNumber);
  }

  /**
   * Sets the field 'enabled'.
   */
  public OnlineOrderMerchant setEnabled(java.lang.Boolean enabled) {
    return genClient.setOther(enabled, CacheKey.enabled);
  }

  /**
   * Sets the field 'menuWalkthroughComplete'.
   */
  public OnlineOrderMerchant setMenuWalkthroughComplete(java.lang.Boolean menuWalkthroughComplete) {
    return genClient.setOther(menuWalkthroughComplete, CacheKey.menuWalkthroughComplete);
  }

  /**
   * Sets the field 'businessInfoDone'.
   */
  public OnlineOrderMerchant setBusinessInfoDone(java.lang.Boolean businessInfoDone) {
    return genClient.setOther(businessInfoDone, CacheKey.businessInfoDone);
  }

  /**
   * Sets the field 'serviceInfoDone'.
   */
  public OnlineOrderMerchant setServiceInfoDone(java.lang.Boolean serviceInfoDone) {
    return genClient.setOther(serviceInfoDone, CacheKey.serviceInfoDone);
  }

  /**
   * Sets the field 'status'.
   */
  public OnlineOrderMerchant setStatus(com.clover.sdk.v3.onlineorder.Status status) {
    return genClient.setOther(status, CacheKey.status);
  }

  /**
   * Sets the field 'scheduleOrder'.
   */
  public OnlineOrderMerchant setScheduleOrder(java.lang.Boolean scheduleOrder) {
    return genClient.setOther(scheduleOrder, CacheKey.scheduleOrder);
  }

  /**
   * Sets the field 'scheduleDayRange'.
   */
  public OnlineOrderMerchant setScheduleDayRange(java.lang.Integer scheduleDayRange) {
    return genClient.setOther(scheduleDayRange, CacheKey.scheduleDayRange);
  }

  /**
   * Sets the field 'createdTime'.
   */
  public OnlineOrderMerchant setCreatedTime(java.lang.Long createdTime) {
    return genClient.setOther(createdTime, CacheKey.createdTime);
  }

  /**
   * Sets the field 'modifiedTime'.
   */
  public OnlineOrderMerchant setModifiedTime(java.lang.Long modifiedTime) {
    return genClient.setOther(modifiedTime, CacheKey.modifiedTime);
  }

  /**
   * Sets the field 'leadTime'.
   */
  public OnlineOrderMerchant setLeadTime(java.lang.Integer leadTime) {
    return genClient.setOther(leadTime, CacheKey.leadTime);
  }

  /**
   * Sets the field 'deletedTime'.
   */
  public OnlineOrderMerchant setDeletedTime(java.lang.Long deletedTime) {
    return genClient.setOther(deletedTime, CacheKey.deletedTime);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'address' field, the 'has' method for this field will now return false */
  public void clearAddress() {
    genClient.clear(CacheKey.address);
  }
  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    genClient.clear(CacheKey.name);
  }
  /** Clears the 'phoneNumber' field, the 'has' method for this field will now return false */
  public void clearPhoneNumber() {
    genClient.clear(CacheKey.phoneNumber);
  }
  /** Clears the 'enabled' field, the 'has' method for this field will now return false */
  public void clearEnabled() {
    genClient.clear(CacheKey.enabled);
  }
  /** Clears the 'menuWalkthroughComplete' field, the 'has' method for this field will now return false */
  public void clearMenuWalkthroughComplete() {
    genClient.clear(CacheKey.menuWalkthroughComplete);
  }
  /** Clears the 'businessInfoDone' field, the 'has' method for this field will now return false */
  public void clearBusinessInfoDone() {
    genClient.clear(CacheKey.businessInfoDone);
  }
  /** Clears the 'serviceInfoDone' field, the 'has' method for this field will now return false */
  public void clearServiceInfoDone() {
    genClient.clear(CacheKey.serviceInfoDone);
  }
  /** Clears the 'status' field, the 'has' method for this field will now return false */
  public void clearStatus() {
    genClient.clear(CacheKey.status);
  }
  /** Clears the 'scheduleOrder' field, the 'has' method for this field will now return false */
  public void clearScheduleOrder() {
    genClient.clear(CacheKey.scheduleOrder);
  }
  /** Clears the 'scheduleDayRange' field, the 'has' method for this field will now return false */
  public void clearScheduleDayRange() {
    genClient.clear(CacheKey.scheduleDayRange);
  }
  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.createdTime);
  }
  /** Clears the 'modifiedTime' field, the 'has' method for this field will now return false */
  public void clearModifiedTime() {
    genClient.clear(CacheKey.modifiedTime);
  }
  /** Clears the 'leadTime' field, the 'has' method for this field will now return false */
  public void clearLeadTime() {
    genClient.clear(CacheKey.leadTime);
  }
  /** Clears the 'deletedTime' field, the 'has' method for this field will now return false */
  public void clearDeletedTime() {
    genClient.clear(CacheKey.deletedTime);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public OnlineOrderMerchant copyChanges() {
    OnlineOrderMerchant copy = new OnlineOrderMerchant();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(OnlineOrderMerchant src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new OnlineOrderMerchant(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<OnlineOrderMerchant> CREATOR = new android.os.Parcelable.Creator<OnlineOrderMerchant>() {
    @Override
    public OnlineOrderMerchant createFromParcel(android.os.Parcel in) {
      OnlineOrderMerchant instance = new OnlineOrderMerchant(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public OnlineOrderMerchant[] newArray(int size) {
      return new OnlineOrderMerchant[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<OnlineOrderMerchant> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<OnlineOrderMerchant>() {
    public Class<OnlineOrderMerchant> getCreatedClass() {
      return OnlineOrderMerchant.class;
    }

    @Override
    public OnlineOrderMerchant create(org.json.JSONObject jsonObject) {
      return new OnlineOrderMerchant(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean ADDRESS_IS_REQUIRED = false;
    public static final boolean NAME_IS_REQUIRED = false;
    public static final long NAME_MAX_LEN = 127;
    public static final boolean PHONENUMBER_IS_REQUIRED = false;
    public static final long PHONENUMBER_MAX_LEN = 21;
    public static final boolean ENABLED_IS_REQUIRED = false;
    public static final boolean MENUWALKTHROUGHCOMPLETE_IS_REQUIRED = false;
    public static final boolean BUSINESSINFODONE_IS_REQUIRED = false;
    public static final boolean SERVICEINFODONE_IS_REQUIRED = false;
    public static final boolean STATUS_IS_REQUIRED = false;
    public static final boolean SCHEDULEORDER_IS_REQUIRED = false;
    public static final boolean SCHEDULEDAYRANGE_IS_REQUIRED = false;
    public static final boolean CREATEDTIME_IS_REQUIRED = false;
    public static final boolean MODIFIEDTIME_IS_REQUIRED = false;
    public static final boolean LEADTIME_IS_REQUIRED = false;
    public static final boolean DELETEDTIME_IS_REQUIRED = false;
  }

}
