/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.onlineorder;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getProvider provider}</li>
 * <li>{@link #getStatus status}</li>
 * <li>{@link #getEnabled enabled}</li>
 * <li>{@link #getStartTime startTime}</li>
 * <li>{@link #getCreatedTime createdTime}</li>
 * <li>{@link #getModifiedTime modifiedTime}</li>
 * <li>{@link #getDeletedTime deletedTime}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class OnlineOrderMerchantProvider extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Merchant Provider id
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * Provider
   */
  public com.clover.sdk.v3.onlineorder.OnlineOrderProvider getProvider() {
    return genClient.cacheGet(CacheKey.provider);
  }

  /**
   * Restaurant online order onboarding status
   */
  public com.clover.sdk.v3.onlineorder.OnboardingStatus getStatus() {
    return genClient.cacheGet(CacheKey.status);
  }

  /**
   * If the merchant enable the provider
   */
  public java.lang.Boolean getEnabled() {
    return genClient.cacheGet(CacheKey.enabled);
  }

  /**
   * When the merchant start enabling this provider for the first time
   */
  public java.lang.Long getStartTime() {
    return genClient.cacheGet(CacheKey.startTime);
  }

  /**
   * Timestamp when the online ordering provider was created
   */
  public java.lang.Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.createdTime);
  }

  /**
   * Timestamp when the online ordering provider was last modified
   */
  public java.lang.Long getModifiedTime() {
    return genClient.cacheGet(CacheKey.modifiedTime);
  }

  /**
   * Timestamp when online ordering provider was last deleted
   */
  public java.lang.Long getDeletedTime() {
    return genClient.cacheGet(CacheKey.deletedTime);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    provider
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.onlineorder.OnlineOrderProvider.JSON_CREATOR)),
    status
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.onlineorder.OnboardingStatus.class)),
    enabled
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    startTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    createdTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    modifiedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    deletedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<OnlineOrderMerchantProvider> genClient;

  /**
   * Constructs a new empty instance.
   */
  public OnlineOrderMerchantProvider() {
    genClient = new GenericClient<OnlineOrderMerchantProvider>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected OnlineOrderMerchantProvider(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public OnlineOrderMerchantProvider(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public OnlineOrderMerchantProvider(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public OnlineOrderMerchantProvider(OnlineOrderMerchantProvider src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'provider' field is set and is not null */
  public boolean isNotNullProvider() {
    return genClient.cacheValueIsNotNull(CacheKey.provider);
  }

  /** Checks whether the 'status' field is set and is not null */
  public boolean isNotNullStatus() {
    return genClient.cacheValueIsNotNull(CacheKey.status);
  }

  /** Checks whether the 'enabled' field is set and is not null */
  public boolean isNotNullEnabled() {
    return genClient.cacheValueIsNotNull(CacheKey.enabled);
  }

  /** Checks whether the 'startTime' field is set and is not null */
  public boolean isNotNullStartTime() {
    return genClient.cacheValueIsNotNull(CacheKey.startTime);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field is set and is not null */
  public boolean isNotNullModifiedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.modifiedTime);
  }

  /** Checks whether the 'deletedTime' field is set and is not null */
  public boolean isNotNullDeletedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.deletedTime);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'provider' field has been set, however the value could be null */
  public boolean hasProvider() {
    return genClient.cacheHasKey(CacheKey.provider);
  }

  /** Checks whether the 'status' field has been set, however the value could be null */
  public boolean hasStatus() {
    return genClient.cacheHasKey(CacheKey.status);
  }

  /** Checks whether the 'enabled' field has been set, however the value could be null */
  public boolean hasEnabled() {
    return genClient.cacheHasKey(CacheKey.enabled);
  }

  /** Checks whether the 'startTime' field has been set, however the value could be null */
  public boolean hasStartTime() {
    return genClient.cacheHasKey(CacheKey.startTime);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field has been set, however the value could be null */
  public boolean hasModifiedTime() {
    return genClient.cacheHasKey(CacheKey.modifiedTime);
  }

  /** Checks whether the 'deletedTime' field has been set, however the value could be null */
  public boolean hasDeletedTime() {
    return genClient.cacheHasKey(CacheKey.deletedTime);
  }


  /**
   * Sets the field 'id'.
   */
  public OnlineOrderMerchantProvider setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'provider'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public OnlineOrderMerchantProvider setProvider(com.clover.sdk.v3.onlineorder.OnlineOrderProvider provider) {
    return genClient.setRecord(provider, CacheKey.provider);
  }

  /**
   * Sets the field 'status'.
   */
  public OnlineOrderMerchantProvider setStatus(com.clover.sdk.v3.onlineorder.OnboardingStatus status) {
    return genClient.setOther(status, CacheKey.status);
  }

  /**
   * Sets the field 'enabled'.
   */
  public OnlineOrderMerchantProvider setEnabled(java.lang.Boolean enabled) {
    return genClient.setOther(enabled, CacheKey.enabled);
  }

  /**
   * Sets the field 'startTime'.
   */
  public OnlineOrderMerchantProvider setStartTime(java.lang.Long startTime) {
    return genClient.setOther(startTime, CacheKey.startTime);
  }

  /**
   * Sets the field 'createdTime'.
   */
  public OnlineOrderMerchantProvider setCreatedTime(java.lang.Long createdTime) {
    return genClient.setOther(createdTime, CacheKey.createdTime);
  }

  /**
   * Sets the field 'modifiedTime'.
   */
  public OnlineOrderMerchantProvider setModifiedTime(java.lang.Long modifiedTime) {
    return genClient.setOther(modifiedTime, CacheKey.modifiedTime);
  }

  /**
   * Sets the field 'deletedTime'.
   */
  public OnlineOrderMerchantProvider setDeletedTime(java.lang.Long deletedTime) {
    return genClient.setOther(deletedTime, CacheKey.deletedTime);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'provider' field, the 'has' method for this field will now return false */
  public void clearProvider() {
    genClient.clear(CacheKey.provider);
  }
  /** Clears the 'status' field, the 'has' method for this field will now return false */
  public void clearStatus() {
    genClient.clear(CacheKey.status);
  }
  /** Clears the 'enabled' field, the 'has' method for this field will now return false */
  public void clearEnabled() {
    genClient.clear(CacheKey.enabled);
  }
  /** Clears the 'startTime' field, the 'has' method for this field will now return false */
  public void clearStartTime() {
    genClient.clear(CacheKey.startTime);
  }
  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.createdTime);
  }
  /** Clears the 'modifiedTime' field, the 'has' method for this field will now return false */
  public void clearModifiedTime() {
    genClient.clear(CacheKey.modifiedTime);
  }
  /** Clears the 'deletedTime' field, the 'has' method for this field will now return false */
  public void clearDeletedTime() {
    genClient.clear(CacheKey.deletedTime);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public OnlineOrderMerchantProvider copyChanges() {
    OnlineOrderMerchantProvider copy = new OnlineOrderMerchantProvider();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(OnlineOrderMerchantProvider src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new OnlineOrderMerchantProvider(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<OnlineOrderMerchantProvider> CREATOR = new android.os.Parcelable.Creator<OnlineOrderMerchantProvider>() {
    @Override
    public OnlineOrderMerchantProvider createFromParcel(android.os.Parcel in) {
      OnlineOrderMerchantProvider instance = new OnlineOrderMerchantProvider(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public OnlineOrderMerchantProvider[] newArray(int size) {
      return new OnlineOrderMerchantProvider[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<OnlineOrderMerchantProvider> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<OnlineOrderMerchantProvider>() {
    public Class<OnlineOrderMerchantProvider> getCreatedClass() {
      return OnlineOrderMerchantProvider.class;
    }

    @Override
    public OnlineOrderMerchantProvider create(org.json.JSONObject jsonObject) {
      return new OnlineOrderMerchantProvider(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean PROVIDER_IS_REQUIRED = false;
    public static final boolean STATUS_IS_REQUIRED = false;
    public static final boolean ENABLED_IS_REQUIRED = false;
    public static final boolean STARTTIME_IS_REQUIRED = false;
    public static final boolean CREATEDTIME_IS_REQUIRED = false;
    public static final boolean MODIFIEDTIME_IS_REQUIRED = false;
    public static final boolean DELETEDTIME_IS_REQUIRED = false;
  }

}
