/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.onlineorder;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getOnlineOrderProviderId onlineOrderProviderId}</li>
 * <li>{@link #getType type}</li>
 * <li>{@link #getEnabled enabled}</li>
 * <li>{@link #getStartTime startTime}</li>
 * <li>{@link #getCreatedTime createdTime}</li>
 * <li>{@link #getModifiedTime modifiedTime}</li>
 * <li>{@link #getDeletedTime deletedTime}</li>
 * <li>{@link #getResumeTime resumeTime}</li>
 * <li>{@link #getNote note}</li>
 * <li>{@link #getActivated activated}</li>
 * <li>{@link #getOrderType orderType}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class OnlineOrderService extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * Provider Uuid
   */
  public java.lang.String getOnlineOrderProviderId() {
    return genClient.cacheGet(CacheKey.onlineOrderProviderId);
  }

  public com.clover.sdk.v3.onlineorder.ServiceType getType() {
    return genClient.cacheGet(CacheKey.type);
  }

  /**
   * Service enabled for online order
   */
  public java.lang.Boolean getEnabled() {
    return genClient.cacheGet(CacheKey.enabled);
  }

  /**
   * Timestamp when the merchant started trial for online ordering service
   */
  public java.lang.Long getStartTime() {
    return genClient.cacheGet(CacheKey.startTime);
  }

  /**
   * Timestamp when the online ordering service was created
   */
  public java.lang.Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.createdTime);
  }

  /**
   * Timestamp when the online ordering service was last modified
   */
  public java.lang.Long getModifiedTime() {
    return genClient.cacheGet(CacheKey.modifiedTime);
  }

  /**
   * Timestamp when online ordering service was last deleted
   */
  public java.lang.Long getDeletedTime() {
    return genClient.cacheGet(CacheKey.deletedTime);
  }

  /**
   * Timestamp when the merchant scheduled to resume the online ordering service in the future
   */
  public java.lang.Long getResumeTime() {
    return genClient.cacheGet(CacheKey.resumeTime);
  }

  /**
   * merchant instructions that are specific to service
   */
  public java.lang.String getNote() {
    return genClient.cacheGet(CacheKey.note);
  }

  /**
   * Service subscribe / unsubscribe status
   */
  public java.lang.Boolean getActivated() {
    return genClient.cacheGet(CacheKey.activated);
  }

  public com.clover.sdk.v3.order.OrderType getOrderType() {
    return genClient.cacheGet(CacheKey.orderType);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    onlineOrderProviderId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    type
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.onlineorder.ServiceType.class)),
    enabled
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    startTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    createdTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    modifiedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    deletedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    resumeTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    note
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    activated
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    orderType
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.order.OrderType.JSON_CREATOR)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<OnlineOrderService> genClient;

  /**
   * Constructs a new empty instance.
   */
  public OnlineOrderService() {
    genClient = new GenericClient<OnlineOrderService>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected OnlineOrderService(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public OnlineOrderService(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public OnlineOrderService(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public OnlineOrderService(OnlineOrderService src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());

    genClient.validateNotNull(CacheKey.onlineOrderProviderId, getOnlineOrderProviderId());
    genClient.validateCloverId(CacheKey.onlineOrderProviderId, getOnlineOrderProviderId());

    genClient.validateNotNull(CacheKey.type, getType());

    genClient.validateLength(CacheKey.note, getNote(), 255);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'onlineOrderProviderId' field is set and is not null */
  public boolean isNotNullOnlineOrderProviderId() {
    return genClient.cacheValueIsNotNull(CacheKey.onlineOrderProviderId);
  }

  /** Checks whether the 'type' field is set and is not null */
  public boolean isNotNullType() {
    return genClient.cacheValueIsNotNull(CacheKey.type);
  }

  /** Checks whether the 'enabled' field is set and is not null */
  public boolean isNotNullEnabled() {
    return genClient.cacheValueIsNotNull(CacheKey.enabled);
  }

  /** Checks whether the 'startTime' field is set and is not null */
  public boolean isNotNullStartTime() {
    return genClient.cacheValueIsNotNull(CacheKey.startTime);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field is set and is not null */
  public boolean isNotNullModifiedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.modifiedTime);
  }

  /** Checks whether the 'deletedTime' field is set and is not null */
  public boolean isNotNullDeletedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.deletedTime);
  }

  /** Checks whether the 'resumeTime' field is set and is not null */
  public boolean isNotNullResumeTime() {
    return genClient.cacheValueIsNotNull(CacheKey.resumeTime);
  }

  /** Checks whether the 'note' field is set and is not null */
  public boolean isNotNullNote() {
    return genClient.cacheValueIsNotNull(CacheKey.note);
  }

  /** Checks whether the 'activated' field is set and is not null */
  public boolean isNotNullActivated() {
    return genClient.cacheValueIsNotNull(CacheKey.activated);
  }

  /** Checks whether the 'orderType' field is set and is not null */
  public boolean isNotNullOrderType() {
    return genClient.cacheValueIsNotNull(CacheKey.orderType);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'onlineOrderProviderId' field has been set, however the value could be null */
  public boolean hasOnlineOrderProviderId() {
    return genClient.cacheHasKey(CacheKey.onlineOrderProviderId);
  }

  /** Checks whether the 'type' field has been set, however the value could be null */
  public boolean hasType() {
    return genClient.cacheHasKey(CacheKey.type);
  }

  /** Checks whether the 'enabled' field has been set, however the value could be null */
  public boolean hasEnabled() {
    return genClient.cacheHasKey(CacheKey.enabled);
  }

  /** Checks whether the 'startTime' field has been set, however the value could be null */
  public boolean hasStartTime() {
    return genClient.cacheHasKey(CacheKey.startTime);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field has been set, however the value could be null */
  public boolean hasModifiedTime() {
    return genClient.cacheHasKey(CacheKey.modifiedTime);
  }

  /** Checks whether the 'deletedTime' field has been set, however the value could be null */
  public boolean hasDeletedTime() {
    return genClient.cacheHasKey(CacheKey.deletedTime);
  }

  /** Checks whether the 'resumeTime' field has been set, however the value could be null */
  public boolean hasResumeTime() {
    return genClient.cacheHasKey(CacheKey.resumeTime);
  }

  /** Checks whether the 'note' field has been set, however the value could be null */
  public boolean hasNote() {
    return genClient.cacheHasKey(CacheKey.note);
  }

  /** Checks whether the 'activated' field has been set, however the value could be null */
  public boolean hasActivated() {
    return genClient.cacheHasKey(CacheKey.activated);
  }

  /** Checks whether the 'orderType' field has been set, however the value could be null */
  public boolean hasOrderType() {
    return genClient.cacheHasKey(CacheKey.orderType);
  }


  /**
   * Sets the field 'id'.
   */
  public OnlineOrderService setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'onlineOrderProviderId'.
   */
  public OnlineOrderService setOnlineOrderProviderId(java.lang.String onlineOrderProviderId) {
    return genClient.setOther(onlineOrderProviderId, CacheKey.onlineOrderProviderId);
  }

  /**
   * Sets the field 'type'.
   */
  public OnlineOrderService setType(com.clover.sdk.v3.onlineorder.ServiceType type) {
    return genClient.setOther(type, CacheKey.type);
  }

  /**
   * Sets the field 'enabled'.
   */
  public OnlineOrderService setEnabled(java.lang.Boolean enabled) {
    return genClient.setOther(enabled, CacheKey.enabled);
  }

  /**
   * Sets the field 'startTime'.
   */
  public OnlineOrderService setStartTime(java.lang.Long startTime) {
    return genClient.setOther(startTime, CacheKey.startTime);
  }

  /**
   * Sets the field 'createdTime'.
   */
  public OnlineOrderService setCreatedTime(java.lang.Long createdTime) {
    return genClient.setOther(createdTime, CacheKey.createdTime);
  }

  /**
   * Sets the field 'modifiedTime'.
   */
  public OnlineOrderService setModifiedTime(java.lang.Long modifiedTime) {
    return genClient.setOther(modifiedTime, CacheKey.modifiedTime);
  }

  /**
   * Sets the field 'deletedTime'.
   */
  public OnlineOrderService setDeletedTime(java.lang.Long deletedTime) {
    return genClient.setOther(deletedTime, CacheKey.deletedTime);
  }

  /**
   * Sets the field 'resumeTime'.
   */
  public OnlineOrderService setResumeTime(java.lang.Long resumeTime) {
    return genClient.setOther(resumeTime, CacheKey.resumeTime);
  }

  /**
   * Sets the field 'note'.
   */
  public OnlineOrderService setNote(java.lang.String note) {
    return genClient.setOther(note, CacheKey.note);
  }

  /**
   * Sets the field 'activated'.
   */
  public OnlineOrderService setActivated(java.lang.Boolean activated) {
    return genClient.setOther(activated, CacheKey.activated);
  }

  /**
   * Sets the field 'orderType'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public OnlineOrderService setOrderType(com.clover.sdk.v3.order.OrderType orderType) {
    return genClient.setRecord(orderType, CacheKey.orderType);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'onlineOrderProviderId' field, the 'has' method for this field will now return false */
  public void clearOnlineOrderProviderId() {
    genClient.clear(CacheKey.onlineOrderProviderId);
  }
  /** Clears the 'type' field, the 'has' method for this field will now return false */
  public void clearType() {
    genClient.clear(CacheKey.type);
  }
  /** Clears the 'enabled' field, the 'has' method for this field will now return false */
  public void clearEnabled() {
    genClient.clear(CacheKey.enabled);
  }
  /** Clears the 'startTime' field, the 'has' method for this field will now return false */
  public void clearStartTime() {
    genClient.clear(CacheKey.startTime);
  }
  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.createdTime);
  }
  /** Clears the 'modifiedTime' field, the 'has' method for this field will now return false */
  public void clearModifiedTime() {
    genClient.clear(CacheKey.modifiedTime);
  }
  /** Clears the 'deletedTime' field, the 'has' method for this field will now return false */
  public void clearDeletedTime() {
    genClient.clear(CacheKey.deletedTime);
  }
  /** Clears the 'resumeTime' field, the 'has' method for this field will now return false */
  public void clearResumeTime() {
    genClient.clear(CacheKey.resumeTime);
  }
  /** Clears the 'note' field, the 'has' method for this field will now return false */
  public void clearNote() {
    genClient.clear(CacheKey.note);
  }
  /** Clears the 'activated' field, the 'has' method for this field will now return false */
  public void clearActivated() {
    genClient.clear(CacheKey.activated);
  }
  /** Clears the 'orderType' field, the 'has' method for this field will now return false */
  public void clearOrderType() {
    genClient.clear(CacheKey.orderType);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public OnlineOrderService copyChanges() {
    OnlineOrderService copy = new OnlineOrderService();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(OnlineOrderService src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new OnlineOrderService(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<OnlineOrderService> CREATOR = new android.os.Parcelable.Creator<OnlineOrderService>() {
    @Override
    public OnlineOrderService createFromParcel(android.os.Parcel in) {
      OnlineOrderService instance = new OnlineOrderService(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public OnlineOrderService[] newArray(int size) {
      return new OnlineOrderService[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<OnlineOrderService> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<OnlineOrderService>() {
    public Class<OnlineOrderService> getCreatedClass() {
      return OnlineOrderService.class;
    }

    @Override
    public OnlineOrderService create(org.json.JSONObject jsonObject) {
      return new OnlineOrderService(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean ONLINEORDERPROVIDERID_IS_REQUIRED = true;
    public static final long ONLINEORDERPROVIDERID_MAX_LEN = 13;
    public static final boolean TYPE_IS_REQUIRED = true;
    public static final boolean ENABLED_IS_REQUIRED = false;
    public static final boolean STARTTIME_IS_REQUIRED = false;
    public static final boolean CREATEDTIME_IS_REQUIRED = false;
    public static final boolean MODIFIEDTIME_IS_REQUIRED = false;
    public static final boolean DELETEDTIME_IS_REQUIRED = false;
    public static final boolean RESUMETIME_IS_REQUIRED = false;
    public static final boolean NOTE_IS_REQUIRED = false;
    public static final long NOTE_MAX_LEN = 255;
    public static final boolean ACTIVATED_IS_REQUIRED = false;
    public static final boolean ORDERTYPE_IS_REQUIRED = false;
  }

}
