/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.order;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getOrderId orderId}</li>
 * <li>{@link #getName name}</li>
 * <li>{@link #getAlternateName alternateName}</li>
 * <li>{@link #getPrice price}</li>
 * <li>{@link #getUnitPrice unitPrice}</li>
 * <li>{@link #getQuantity quantity}</li>
 * <li>{@link #getUnitQuantity unitQuantity}</li>
 * <li>{@link #getNote note}</li>
 * <li>{@link #getPrinted printed}</li>
 * <li>{@link #getBinName binName}</li>
 * <li>{@link #getUserData userData}</li>
 * <li>{@link #getDiscounts discounts}</li>
 * <li>{@link #getDiscountAmount discountAmount}</li>
 * <li>{@link #getExchanged exchanged}</li>
 * <li>{@link #getExchangedAmount exchangedAmount}</li>
 * <li>{@link #getModifications modifications}</li>
 * <li>{@link #getRefunded refunded}</li>
 * <li>{@link #getRefundedAmount refundedAmount}</li>
 * <li>{@link #getPercent percent}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class DisplayLineItem extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * The order with which the line item is associated
   */
  public java.lang.String getOrderId() {
    return genClient.cacheGet(CacheKey.orderId);
  }

  /**
   * Line item name
   */
  public java.lang.String getName() {
    return genClient.cacheGet(CacheKey.name);
  }

  /**
   * Alternate name of the line item
   */
  public java.lang.String getAlternateName() {
    return genClient.cacheGet(CacheKey.alternateName);
  }

  /**
   * Formatted total price of the line item
   */
  public java.lang.String getPrice() {
    return genClient.cacheGet(CacheKey.price);
  }

  /**
   * Formatted unit price in cases if applicable
   */
  public java.lang.String getUnitPrice() {
    return genClient.cacheGet(CacheKey.unitPrice);
  }

  /**
   * Formatted quantity
   */
  public java.lang.String getQuantity() {
    return genClient.cacheGet(CacheKey.quantity);
  }

  /**
   * Formatted unit quantity - such as 10 @ $1.99/oz
   */
  public java.lang.String getUnitQuantity() {
    return genClient.cacheGet(CacheKey.unitQuantity);
  }

  public java.lang.String getNote() {
    return genClient.cacheGet(CacheKey.note);
  }

  public java.lang.Boolean getPrinted() {
    return genClient.cacheGet(CacheKey.printed);
  }

  public java.lang.String getBinName() {
    return genClient.cacheGet(CacheKey.binName);
  }

  public java.lang.String getUserData() {
    return genClient.cacheGet(CacheKey.userData);
  }

  public java.util.List<com.clover.sdk.v3.order.DisplayDiscount> getDiscounts() {
    return genClient.cacheGet(CacheKey.discounts);
  }

  public java.lang.String getDiscountAmount() {
    return genClient.cacheGet(CacheKey.discountAmount);
  }

  public java.lang.Boolean getExchanged() {
    return genClient.cacheGet(CacheKey.exchanged);
  }

  /**
   * Formatted exchanged amount
   */
  public java.lang.String getExchangedAmount() {
    return genClient.cacheGet(CacheKey.exchangedAmount);
  }

  public java.util.List<com.clover.sdk.v3.order.DisplayModification> getModifications() {
    return genClient.cacheGet(CacheKey.modifications);
  }

  public java.lang.Boolean getRefunded() {
    return genClient.cacheGet(CacheKey.refunded);
  }

  /**
   * Formatted refunded amount
   */
  public java.lang.String getRefundedAmount() {
    return genClient.cacheGet(CacheKey.refundedAmount);
  }

  public java.lang.String getPercent() {
    return genClient.cacheGet(CacheKey.percent);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    orderId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    name
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    alternateName
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    price
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    unitPrice
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    quantity
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    unitQuantity
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    note
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    printed
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    binName
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    userData
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    discounts
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.order.DisplayDiscount.JSON_CREATOR)),
    discountAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    exchanged
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    exchangedAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    modifications
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.order.DisplayModification.JSON_CREATOR)),
    refunded
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    refundedAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    percent
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<DisplayLineItem> genClient;

  /**
   * Constructs a new empty instance.
   */
  public DisplayLineItem() {
    genClient = new GenericClient<DisplayLineItem>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected DisplayLineItem(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public DisplayLineItem(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public DisplayLineItem(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public DisplayLineItem(DisplayLineItem src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());

    genClient.validateLength(CacheKey.name, getName(), 127);

    genClient.validateLength(CacheKey.alternateName, getAlternateName(), 127);

    genClient.validateLength(CacheKey.note, getNote(), 255);

    genClient.validateLength(CacheKey.binName, getBinName(), 127);

    genClient.validateLength(CacheKey.userData, getUserData(), 255);

    genClient.validateLength(CacheKey.percent, getPercent(), 255);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'orderId' field is set and is not null */
  public boolean isNotNullOrderId() {
    return genClient.cacheValueIsNotNull(CacheKey.orderId);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return genClient.cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'alternateName' field is set and is not null */
  public boolean isNotNullAlternateName() {
    return genClient.cacheValueIsNotNull(CacheKey.alternateName);
  }

  /** Checks whether the 'price' field is set and is not null */
  public boolean isNotNullPrice() {
    return genClient.cacheValueIsNotNull(CacheKey.price);
  }

  /** Checks whether the 'unitPrice' field is set and is not null */
  public boolean isNotNullUnitPrice() {
    return genClient.cacheValueIsNotNull(CacheKey.unitPrice);
  }

  /** Checks whether the 'quantity' field is set and is not null */
  public boolean isNotNullQuantity() {
    return genClient.cacheValueIsNotNull(CacheKey.quantity);
  }

  /** Checks whether the 'unitQuantity' field is set and is not null */
  public boolean isNotNullUnitQuantity() {
    return genClient.cacheValueIsNotNull(CacheKey.unitQuantity);
  }

  /** Checks whether the 'note' field is set and is not null */
  public boolean isNotNullNote() {
    return genClient.cacheValueIsNotNull(CacheKey.note);
  }

  /** Checks whether the 'printed' field is set and is not null */
  public boolean isNotNullPrinted() {
    return genClient.cacheValueIsNotNull(CacheKey.printed);
  }

  /** Checks whether the 'binName' field is set and is not null */
  public boolean isNotNullBinName() {
    return genClient.cacheValueIsNotNull(CacheKey.binName);
  }

  /** Checks whether the 'userData' field is set and is not null */
  public boolean isNotNullUserData() {
    return genClient.cacheValueIsNotNull(CacheKey.userData);
  }

  /** Checks whether the 'discounts' field is set and is not null */
  public boolean isNotNullDiscounts() {
    return genClient.cacheValueIsNotNull(CacheKey.discounts);
  }

  /** Checks whether the 'discounts' field is set and is not null and is not empty */
  public boolean isNotEmptyDiscounts() { return isNotNullDiscounts() && !getDiscounts().isEmpty(); }

  /** Checks whether the 'discountAmount' field is set and is not null */
  public boolean isNotNullDiscountAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.discountAmount);
  }

  /** Checks whether the 'exchanged' field is set and is not null */
  public boolean isNotNullExchanged() {
    return genClient.cacheValueIsNotNull(CacheKey.exchanged);
  }

  /** Checks whether the 'exchangedAmount' field is set and is not null */
  public boolean isNotNullExchangedAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.exchangedAmount);
  }

  /** Checks whether the 'modifications' field is set and is not null */
  public boolean isNotNullModifications() {
    return genClient.cacheValueIsNotNull(CacheKey.modifications);
  }

  /** Checks whether the 'modifications' field is set and is not null and is not empty */
  public boolean isNotEmptyModifications() { return isNotNullModifications() && !getModifications().isEmpty(); }

  /** Checks whether the 'refunded' field is set and is not null */
  public boolean isNotNullRefunded() {
    return genClient.cacheValueIsNotNull(CacheKey.refunded);
  }

  /** Checks whether the 'refundedAmount' field is set and is not null */
  public boolean isNotNullRefundedAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.refundedAmount);
  }

  /** Checks whether the 'percent' field is set and is not null */
  public boolean isNotNullPercent() {
    return genClient.cacheValueIsNotNull(CacheKey.percent);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'orderId' field has been set, however the value could be null */
  public boolean hasOrderId() {
    return genClient.cacheHasKey(CacheKey.orderId);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return genClient.cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'alternateName' field has been set, however the value could be null */
  public boolean hasAlternateName() {
    return genClient.cacheHasKey(CacheKey.alternateName);
  }

  /** Checks whether the 'price' field has been set, however the value could be null */
  public boolean hasPrice() {
    return genClient.cacheHasKey(CacheKey.price);
  }

  /** Checks whether the 'unitPrice' field has been set, however the value could be null */
  public boolean hasUnitPrice() {
    return genClient.cacheHasKey(CacheKey.unitPrice);
  }

  /** Checks whether the 'quantity' field has been set, however the value could be null */
  public boolean hasQuantity() {
    return genClient.cacheHasKey(CacheKey.quantity);
  }

  /** Checks whether the 'unitQuantity' field has been set, however the value could be null */
  public boolean hasUnitQuantity() {
    return genClient.cacheHasKey(CacheKey.unitQuantity);
  }

  /** Checks whether the 'note' field has been set, however the value could be null */
  public boolean hasNote() {
    return genClient.cacheHasKey(CacheKey.note);
  }

  /** Checks whether the 'printed' field has been set, however the value could be null */
  public boolean hasPrinted() {
    return genClient.cacheHasKey(CacheKey.printed);
  }

  /** Checks whether the 'binName' field has been set, however the value could be null */
  public boolean hasBinName() {
    return genClient.cacheHasKey(CacheKey.binName);
  }

  /** Checks whether the 'userData' field has been set, however the value could be null */
  public boolean hasUserData() {
    return genClient.cacheHasKey(CacheKey.userData);
  }

  /** Checks whether the 'discounts' field has been set, however the value could be null */
  public boolean hasDiscounts() {
    return genClient.cacheHasKey(CacheKey.discounts);
  }

  /** Checks whether the 'discountAmount' field has been set, however the value could be null */
  public boolean hasDiscountAmount() {
    return genClient.cacheHasKey(CacheKey.discountAmount);
  }

  /** Checks whether the 'exchanged' field has been set, however the value could be null */
  public boolean hasExchanged() {
    return genClient.cacheHasKey(CacheKey.exchanged);
  }

  /** Checks whether the 'exchangedAmount' field has been set, however the value could be null */
  public boolean hasExchangedAmount() {
    return genClient.cacheHasKey(CacheKey.exchangedAmount);
  }

  /** Checks whether the 'modifications' field has been set, however the value could be null */
  public boolean hasModifications() {
    return genClient.cacheHasKey(CacheKey.modifications);
  }

  /** Checks whether the 'refunded' field has been set, however the value could be null */
  public boolean hasRefunded() {
    return genClient.cacheHasKey(CacheKey.refunded);
  }

  /** Checks whether the 'refundedAmount' field has been set, however the value could be null */
  public boolean hasRefundedAmount() {
    return genClient.cacheHasKey(CacheKey.refundedAmount);
  }

  /** Checks whether the 'percent' field has been set, however the value could be null */
  public boolean hasPercent() {
    return genClient.cacheHasKey(CacheKey.percent);
  }


  /**
   * Sets the field 'id'.
   */
  public DisplayLineItem setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'orderId'.
   */
  public DisplayLineItem setOrderId(java.lang.String orderId) {
    return genClient.setOther(orderId, CacheKey.orderId);
  }

  /**
   * Sets the field 'name'.
   */
  public DisplayLineItem setName(java.lang.String name) {
    return genClient.setOther(name, CacheKey.name);
  }

  /**
   * Sets the field 'alternateName'.
   */
  public DisplayLineItem setAlternateName(java.lang.String alternateName) {
    return genClient.setOther(alternateName, CacheKey.alternateName);
  }

  /**
   * Sets the field 'price'.
   */
  public DisplayLineItem setPrice(java.lang.String price) {
    return genClient.setOther(price, CacheKey.price);
  }

  /**
   * Sets the field 'unitPrice'.
   */
  public DisplayLineItem setUnitPrice(java.lang.String unitPrice) {
    return genClient.setOther(unitPrice, CacheKey.unitPrice);
  }

  /**
   * Sets the field 'quantity'.
   */
  public DisplayLineItem setQuantity(java.lang.String quantity) {
    return genClient.setOther(quantity, CacheKey.quantity);
  }

  /**
   * Sets the field 'unitQuantity'.
   */
  public DisplayLineItem setUnitQuantity(java.lang.String unitQuantity) {
    return genClient.setOther(unitQuantity, CacheKey.unitQuantity);
  }

  /**
   * Sets the field 'note'.
   */
  public DisplayLineItem setNote(java.lang.String note) {
    return genClient.setOther(note, CacheKey.note);
  }

  /**
   * Sets the field 'printed'.
   */
  public DisplayLineItem setPrinted(java.lang.Boolean printed) {
    return genClient.setOther(printed, CacheKey.printed);
  }

  /**
   * Sets the field 'binName'.
   */
  public DisplayLineItem setBinName(java.lang.String binName) {
    return genClient.setOther(binName, CacheKey.binName);
  }

  /**
   * Sets the field 'userData'.
   */
  public DisplayLineItem setUserData(java.lang.String userData) {
    return genClient.setOther(userData, CacheKey.userData);
  }

  /**
   * Sets the field 'discounts'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public DisplayLineItem setDiscounts(java.util.List<com.clover.sdk.v3.order.DisplayDiscount> discounts) {
    return genClient.setArrayRecord(discounts, CacheKey.discounts);
  }

  /**
   * Sets the field 'discountAmount'.
   */
  public DisplayLineItem setDiscountAmount(java.lang.String discountAmount) {
    return genClient.setOther(discountAmount, CacheKey.discountAmount);
  }

  /**
   * Sets the field 'exchanged'.
   */
  public DisplayLineItem setExchanged(java.lang.Boolean exchanged) {
    return genClient.setOther(exchanged, CacheKey.exchanged);
  }

  /**
   * Sets the field 'exchangedAmount'.
   */
  public DisplayLineItem setExchangedAmount(java.lang.String exchangedAmount) {
    return genClient.setOther(exchangedAmount, CacheKey.exchangedAmount);
  }

  /**
   * Sets the field 'modifications'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public DisplayLineItem setModifications(java.util.List<com.clover.sdk.v3.order.DisplayModification> modifications) {
    return genClient.setArrayRecord(modifications, CacheKey.modifications);
  }

  /**
   * Sets the field 'refunded'.
   */
  public DisplayLineItem setRefunded(java.lang.Boolean refunded) {
    return genClient.setOther(refunded, CacheKey.refunded);
  }

  /**
   * Sets the field 'refundedAmount'.
   */
  public DisplayLineItem setRefundedAmount(java.lang.String refundedAmount) {
    return genClient.setOther(refundedAmount, CacheKey.refundedAmount);
  }

  /**
   * Sets the field 'percent'.
   */
  public DisplayLineItem setPercent(java.lang.String percent) {
    return genClient.setOther(percent, CacheKey.percent);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'orderId' field, the 'has' method for this field will now return false */
  public void clearOrderId() {
    genClient.clear(CacheKey.orderId);
  }
  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    genClient.clear(CacheKey.name);
  }
  /** Clears the 'alternateName' field, the 'has' method for this field will now return false */
  public void clearAlternateName() {
    genClient.clear(CacheKey.alternateName);
  }
  /** Clears the 'price' field, the 'has' method for this field will now return false */
  public void clearPrice() {
    genClient.clear(CacheKey.price);
  }
  /** Clears the 'unitPrice' field, the 'has' method for this field will now return false */
  public void clearUnitPrice() {
    genClient.clear(CacheKey.unitPrice);
  }
  /** Clears the 'quantity' field, the 'has' method for this field will now return false */
  public void clearQuantity() {
    genClient.clear(CacheKey.quantity);
  }
  /** Clears the 'unitQuantity' field, the 'has' method for this field will now return false */
  public void clearUnitQuantity() {
    genClient.clear(CacheKey.unitQuantity);
  }
  /** Clears the 'note' field, the 'has' method for this field will now return false */
  public void clearNote() {
    genClient.clear(CacheKey.note);
  }
  /** Clears the 'printed' field, the 'has' method for this field will now return false */
  public void clearPrinted() {
    genClient.clear(CacheKey.printed);
  }
  /** Clears the 'binName' field, the 'has' method for this field will now return false */
  public void clearBinName() {
    genClient.clear(CacheKey.binName);
  }
  /** Clears the 'userData' field, the 'has' method for this field will now return false */
  public void clearUserData() {
    genClient.clear(CacheKey.userData);
  }
  /** Clears the 'discounts' field, the 'has' method for this field will now return false */
  public void clearDiscounts() {
    genClient.clear(CacheKey.discounts);
  }
  /** Clears the 'discountAmount' field, the 'has' method for this field will now return false */
  public void clearDiscountAmount() {
    genClient.clear(CacheKey.discountAmount);
  }
  /** Clears the 'exchanged' field, the 'has' method for this field will now return false */
  public void clearExchanged() {
    genClient.clear(CacheKey.exchanged);
  }
  /** Clears the 'exchangedAmount' field, the 'has' method for this field will now return false */
  public void clearExchangedAmount() {
    genClient.clear(CacheKey.exchangedAmount);
  }
  /** Clears the 'modifications' field, the 'has' method for this field will now return false */
  public void clearModifications() {
    genClient.clear(CacheKey.modifications);
  }
  /** Clears the 'refunded' field, the 'has' method for this field will now return false */
  public void clearRefunded() {
    genClient.clear(CacheKey.refunded);
  }
  /** Clears the 'refundedAmount' field, the 'has' method for this field will now return false */
  public void clearRefundedAmount() {
    genClient.clear(CacheKey.refundedAmount);
  }
  /** Clears the 'percent' field, the 'has' method for this field will now return false */
  public void clearPercent() {
    genClient.clear(CacheKey.percent);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public DisplayLineItem copyChanges() {
    DisplayLineItem copy = new DisplayLineItem();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(DisplayLineItem src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new DisplayLineItem(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<DisplayLineItem> CREATOR = new android.os.Parcelable.Creator<DisplayLineItem>() {
    @Override
    public DisplayLineItem createFromParcel(android.os.Parcel in) {
      DisplayLineItem instance = new DisplayLineItem(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public DisplayLineItem[] newArray(int size) {
      return new DisplayLineItem[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<DisplayLineItem> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<DisplayLineItem>() {
    public Class<DisplayLineItem> getCreatedClass() {
      return DisplayLineItem.class;
    }

    @Override
    public DisplayLineItem create(org.json.JSONObject jsonObject) {
      return new DisplayLineItem(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean ORDERID_IS_REQUIRED = false;
    public static final boolean NAME_IS_REQUIRED = false;
    public static final long NAME_MAX_LEN = 127;
    public static final boolean ALTERNATENAME_IS_REQUIRED = false;
    public static final long ALTERNATENAME_MAX_LEN = 127;
    public static final boolean PRICE_IS_REQUIRED = false;
    public static final boolean UNITPRICE_IS_REQUIRED = false;
    public static final boolean QUANTITY_IS_REQUIRED = false;
    public static final boolean UNITQUANTITY_IS_REQUIRED = false;
    public static final boolean NOTE_IS_REQUIRED = false;
    public static final long NOTE_MAX_LEN = 255;
    public static final boolean PRINTED_IS_REQUIRED = false;
    public static final boolean BINNAME_IS_REQUIRED = false;
    public static final long BINNAME_MAX_LEN = 127;
    public static final boolean USERDATA_IS_REQUIRED = false;
    public static final long USERDATA_MAX_LEN = 255;
    public static final boolean DISCOUNTS_IS_REQUIRED = false;
    public static final boolean DISCOUNTAMOUNT_IS_REQUIRED = false;
    public static final boolean EXCHANGED_IS_REQUIRED = false;
    public static final boolean EXCHANGEDAMOUNT_IS_REQUIRED = false;
    public static final boolean MODIFICATIONS_IS_REQUIRED = false;
    public static final boolean REFUNDED_IS_REQUIRED = false;
    public static final boolean REFUNDEDAMOUNT_IS_REQUIRED = false;
    public static final boolean PERCENT_IS_REQUIRED = false;
    public static final long PERCENT_MAX_LEN = 255;
  }

}
