/**
 * Autogenerated by Avro
 *
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.order;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getItem item}</li>
 * <li>{@link #getColorCode colorCode}</li>
 * <li>{@link #getName name}</li>
 * <li>{@link #getAlternateName alternateName}</li>
 * <li>{@link #getPrice price}</li>
 * <li>{@link #getPriceWithModifiers priceWithModifiers}</li>
 * <li>{@link #getPriceWithModifiersAndItemAndOrderDiscounts priceWithModifiersAndItemAndOrderDiscounts}</li>
 * <li>{@link #getUnitQty unitQty}</li>
 * <li>{@link #getUnitName unitName}</li>
 * <li>{@link #getItemCode itemCode}</li>
 * <li>{@link #getNote note}</li>
 * <li>{@link #getPrinted printed}</li>
 * <li>{@link #getExchangedLineItem exchangedLineItem}</li>
 * <li>{@link #getBinName binName}</li>
 * <li>{@link #getUserData userData}</li>
 * <li>{@link #getCreatedTime createdTime}</li>
 * <li>{@link #getOrderClientCreatedTime orderClientCreatedTime}</li>
 * <li>{@link #getDiscounts discounts}</li>
 * <li>{@link #getOrderLevelDiscounts orderLevelDiscounts}</li>
 * <li>{@link #getDiscountAmount discountAmount}</li>
 * <li>{@link #getOrderLevelDiscountAmount orderLevelDiscountAmount}</li>
 * <li>{@link #getExchanged exchanged}</li>
 * <li>{@link #getModifications modifications}</li>
 * <li>{@link #getTags tags}</li>
 * <li>{@link #getRefunded refunded}</li>
 * <li>{@link #getRefund refund}</li>
 * <li>{@link #getIsRevenue isRevenue}</li>
 * <li>{@link #getTaxRates taxRates}</li>
 * <li>{@link #getPayments payments}</li>
 * <li>{@link #getRevenueAmount revenueAmount}</li>
 * <li>{@link #getQuantitySold quantitySold}</li>
 * <li>{@link #getPrintGroup printGroup}</li>
 * <li>{@link #getHidden hidden}</li>
 * <li>{@link #getPercentage percentage}</li>
 * <li>{@link #getOrderFee orderFee}</li>
 * <li>{@link #getIsOrderFee isOrderFee}</li>
 * <li>{@link #getIsPlatformOrderFee isPlatformOrderFee}</li>
 * <li>{@link #getOrderFeeType orderFeeType}</li>
 * <li>{@link #getUnitQtyDecimalDigits unitQtyDecimalDigits}</li>
 * </ul>
 * <p>
 * @see com.clover.sdk.v3.order.IOrderService
 */
@SuppressWarnings("all")
public class LineItem extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier.
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * A reference to the inventory item that was used to create this line item. Note that since this a reference the item can be changed and deleted any time such that it no longer matches this line item.
   */
  public com.clover.sdk.v3.base.Reference getItem() {
    return genClient.cacheGet(CacheKey.item);
  }

  /**
   * Hex code representation of the color assigned to item in the form of #fff, #ffffff, or #ffffffff. Note that item color can be changed and deleted any time such that it no longer matches this line item
   */
  public java.lang.String getColorCode() {
    return genClient.cacheGet(CacheKey.colorCode);
  }

  /**
   * Line item name.
   */
  public java.lang.String getName() {
    return genClient.cacheGet(CacheKey.name);
  }

  /**
   * Alternate name of the line item.
   */
  public java.lang.String getAlternateName() {
    return genClient.cacheGet(CacheKey.alternateName);
  }

  /**
   * Price of the item, typically in cents of merchant currency. When unit quantity is not null then this is the price for a single unit and is not the complete price.
   */
  public java.lang.Long getPrice() {
    return genClient.cacheGet(CacheKey.price);
  }

  /**
   * Price of item after adding all modifications. This is used only for reporting.
   */
  public java.lang.Long getPriceWithModifiers() {
    return genClient.cacheGet(CacheKey.priceWithModifiers);
  }

  /**
   * Price of item after adding all modifications and subtracting all line item and order level discounts. This is used only for reporting.
   */
  public java.lang.Long getPriceWithModifiersAndItemAndOrderDiscounts() {
    return genClient.cacheGet(CacheKey.priceWithModifiersAndItemAndOrderDiscounts);
  }

  /**
   * This is applicable only if the item is priced by quantity of a unit. The item must have a priceType of PER_UNIT. The value is a fixed-point integer with scaling factor of 1000 (e.g. if charging per ounce, the value should be set to 2500 for 2.5 ounces). To compute the complete price perform the following calculation: PRICE * (UNIT QTY / 1000). If the item doesn’t have a priceType of PER_UNIT, then unitQty is ignored.
   */
  public java.lang.Integer getUnitQty() {
    return genClient.cacheGet(CacheKey.unitQty);
  }

  /**
   * Unit name (e.g. oz, lb, etc) if priced by unit, otherwise null.
   */
  public java.lang.String getUnitName() {
    return genClient.cacheGet(CacheKey.unitName);
  }

  public java.lang.String getItemCode() {
    return genClient.cacheGet(CacheKey.itemCode);
  }

  public java.lang.String getNote() {
    return genClient.cacheGet(CacheKey.note);
  }

  /**
   * True if this line item has been printed out on an order printer at least once already.
   */
  public java.lang.Boolean getPrinted() {
    return genClient.cacheGet(CacheKey.printed);
  }

  public com.clover.sdk.v3.base.Reference getExchangedLineItem() {
    return genClient.cacheGet(CacheKey.exchangedLineItem);
  }

  public java.lang.String getBinName() {
    return genClient.cacheGet(CacheKey.binName);
  }

  public java.lang.String getUserData() {
    return genClient.cacheGet(CacheKey.userData);
  }

  public java.lang.Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.createdTime);
  }

  public java.lang.Long getOrderClientCreatedTime() {
    return genClient.cacheGet(CacheKey.orderClientCreatedTime);
  }

  /**
   * List of discounts applied to the line item. Each line item on an order may have zero or more percentage or amount discounts. Line item discounts are separate from order-level discounts (which are applied to the order subtotal).
   */
  public java.util.List<com.clover.sdk.v3.order.Discount> getDiscounts() {
    return genClient.cacheGet(CacheKey.discounts);
  }

  /**
   * List of order level discounts attributed to this line item. Amounts are rounded to the nearest penny. This is for reporting purposes only. These rounding approximates are not used when calculating the transaction.
   */
  public java.util.List<com.clover.sdk.v3.order.Discount> getOrderLevelDiscounts() {
    return genClient.cacheGet(CacheKey.orderLevelDiscounts);
  }

  /**
   * Unnamed fixed discount amount in cents. Or, in reporting, this may be the calculated sum of all the line item discounts.
   */
  public java.lang.Long getDiscountAmount() {
    return genClient.cacheGet(CacheKey.discountAmount);
  }

  /**
   * The calculated sum of order level discounts attributed, approximately to the nearest cent, to this the line item. This is only used in reporting.
   */
  public java.lang.Long getOrderLevelDiscountAmount() {
    return genClient.cacheGet(CacheKey.orderLevelDiscountAmount);
  }

  public java.lang.Boolean getExchanged() {
    return genClient.cacheGet(CacheKey.exchanged);
  }

  /**
   * List of references to modifications applied to this line item.
   */
  public java.util.List<com.clover.sdk.v3.order.Modification> getModifications() {
    return genClient.cacheGet(CacheKey.modifications);
  }

  /**
   * List of tags associated with this line item.
   */
  public java.util.List<com.clover.sdk.v3.inventory.Tag> getTags() {
    return genClient.cacheGet(CacheKey.tags);
  }

  /**
   * True if this line item has been refunded
   */
  public java.lang.Boolean getRefunded() {
    return genClient.cacheGet(CacheKey.refunded);
  }

  /**
   * direct item refund
   */
  public com.clover.sdk.v3.payments.Refund getRefund() {
    return genClient.cacheGet(CacheKey.refund);
  }

  /**
   * True if this item should be counted as revenue, for example gift cards and donations would not.
   */
  public java.lang.Boolean getIsRevenue() {
    return genClient.cacheGet(CacheKey.isRevenue);
  }

  /**
   * Tax rates that apply to this line item
   */
  public java.util.List<com.clover.sdk.v3.inventory.TaxRate> getTaxRates() {
    return genClient.cacheGet(CacheKey.taxRates);
  }

  /**
   * Payments that apply to this line item
   */
  public java.util.List<com.clover.sdk.v3.payments.LineItemPayment> getPayments() {
    return genClient.cacheGet(CacheKey.payments);
  }

  /**
   * Revenue collected for this. This field is only used in reporting.
   */
  public java.lang.Long getRevenueAmount() {
    return genClient.cacheGet(CacheKey.revenueAmount);
  }

  /**
   * Quantity sold for this line item. This field is only used in reporting
   */
  public java.lang.Double getQuantitySold() {
    return genClient.cacheGet(CacheKey.quantitySold);
  }

  /**
   * Optional reference to the print group that this line item belongs to.
   */
  public com.clover.sdk.v3.base.Reference getPrintGroup() {
    return genClient.cacheGet(CacheKey.printGroup);
  }

  /**
   * True if this line item has been marked as hidden on User Interface like Orders page and receipts
   */
  public java.lang.Boolean getHidden() {
    return genClient.cacheGet(CacheKey.hidden);
  }

  /**
   * For percentage based order fee line item, percent to charge times 10000, e.g. 12.5% will be 125000
   */
  public java.lang.Long getPercentage() {
    return genClient.cacheGet(CacheKey.percentage);
  }

  /**
   * A reference to the inventory order fee that was used to create this line item. Note that since this a reference the order fee can be changed and deleted any time such that it no longer matches this line item.
   */
  public com.clover.sdk.v3.base.Reference getOrderFee() {
    return genClient.cacheGet(CacheKey.orderFee);
  }

  /**
   * True if this line item is an order fee line item
   */
  public java.lang.Boolean getIsOrderFee() {
    return genClient.cacheGet(CacheKey.isOrderFee);
  }

  /**
   * True if this line item is an platform order fee line item
   */
  public java.lang.Boolean getIsPlatformOrderFee() {
    return genClient.cacheGet(CacheKey.isPlatformOrderFee);
  }

  /**
   * Used to define the type of order fee line item.
   * Auto-gratuity enabled orderFee lineItem, has this field set to "AUTO_GRATUITY", otherwise null
   * */
  public java.lang.String getOrderFeeType() {
    return genClient.cacheGet(CacheKey.orderFeeType);
  }


  /**
   * This is applicable only if the item is priced by quantity of a unit.
   * The item must have a priceType of PER_UNIT and has a unitQty.
   * The value represents the decimal digits when the unitQty is collected. (e.g. if charging per ounce, and the weight scale shows 2.50, then value should be set to 2.
   * If the weight scale shows 2.500, then value should be set to 3, etc.). If the item doesn’t have a priceType of PER_UNIT, then unitQtyDecimalDigits is ignored.
   */
  public java.lang.Integer getUnitQtyDecimalDigits() {
    return genClient.cacheGet(CacheKey.unitQtyDecimalDigits);
  }


  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    item
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    colorCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    name
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    alternateName
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    price
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    priceWithModifiers
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    priceWithModifiersAndItemAndOrderDiscounts
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    unitQty
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
    unitName
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    itemCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    note
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    printed
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    exchangedLineItem
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    binName
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    userData
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    createdTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    orderClientCreatedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    discounts
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.order.Discount.JSON_CREATOR)),
    orderLevelDiscounts
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.order.Discount.JSON_CREATOR)),
    discountAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    orderLevelDiscountAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    exchanged
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    modifications
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.order.Modification.JSON_CREATOR)),
    tags
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.inventory.Tag.JSON_CREATOR)),
    refunded
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    refund
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.Refund.JSON_CREATOR)),
    isRevenue
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    taxRates
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.inventory.TaxRate.JSON_CREATOR)),
    payments
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.payments.LineItemPayment.JSON_CREATOR)),
    revenueAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    quantitySold
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Double.class)),
    printGroup
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    hidden
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    percentage
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    orderFee
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    isOrderFee
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    isPlatformOrderFee
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    orderFeeType
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    unitQtyDecimalDigits
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
    ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<LineItem> genClient;

  /**
   * Constructs a new empty instance.
   */
  public LineItem() {
    genClient = new GenericClient<LineItem>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected LineItem(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public LineItem(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public LineItem(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public LineItem(LineItem src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());

    genClient.validateLength(CacheKey.colorCode, getColorCode(), 9);

    genClient.validateLength(CacheKey.name, getName(), 127);

    genClient.validateLength(CacheKey.alternateName, getAlternateName(), 127);

    genClient.validateMin(CacheKey.unitQty, getUnitQty(), 0L);

    genClient.validateLength(CacheKey.unitName, getUnitName(), 64);

    genClient.validateLength(CacheKey.itemCode, getItemCode(), 100);

    genClient.validateLength(CacheKey.note, getNote(), 255);

    genClient.validateLength(CacheKey.binName, getBinName(), 127);

    genClient.validateLength(CacheKey.userData, getUserData(), 255);

    genClient.validateMinMax(CacheKey.percentage, getPercentage(), 0L, 1000000L);

    genClient.validateMinMax(CacheKey.unitQtyDecimalDigits, getUnitQtyDecimalDigits(), 0L, 3L);
    genClient.validateReferences(CacheKey.item);
    genClient.validateReferences(CacheKey.exchangedLineItem);
    genClient.validateReferences(CacheKey.printGroup);
    genClient.validateReferences(CacheKey.orderFee);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'item' field is set and is not null */
  public boolean isNotNullItem() {
    return genClient.cacheValueIsNotNull(CacheKey.item);
  }

  /** Checks whether the 'colorCode' field is set and is not null */
  public boolean isNotNullColorCode() {
    return genClient.cacheValueIsNotNull(CacheKey.colorCode);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return genClient.cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'alternateName' field is set and is not null */
  public boolean isNotNullAlternateName() {
    return genClient.cacheValueIsNotNull(CacheKey.alternateName);
  }

  /** Checks whether the 'price' field is set and is not null */
  public boolean isNotNullPrice() {
    return genClient.cacheValueIsNotNull(CacheKey.price);
  }

  /** Checks whether the 'priceWithModifiers' field is set and is not null */
  public boolean isNotNullPriceWithModifiers() {
    return genClient.cacheValueIsNotNull(CacheKey.priceWithModifiers);
  }

  /** Checks whether the 'priceWithModifiersAndItemAndOrderDiscounts' field is set and is not null */
  public boolean isNotNullPriceWithModifiersAndItemAndOrderDiscounts() {
    return genClient.cacheValueIsNotNull(CacheKey.priceWithModifiersAndItemAndOrderDiscounts);
  }

  /** Checks whether the 'unitQty' field is set and is not null */
  public boolean isNotNullUnitQty() {
    return genClient.cacheValueIsNotNull(CacheKey.unitQty);
  }

  /** Checks whether the 'unitName' field is set and is not null */
  public boolean isNotNullUnitName() {
    return genClient.cacheValueIsNotNull(CacheKey.unitName);
  }

  /** Checks whether the 'itemCode' field is set and is not null */
  public boolean isNotNullItemCode() {
    return genClient.cacheValueIsNotNull(CacheKey.itemCode);
  }

  /** Checks whether the 'note' field is set and is not null */
  public boolean isNotNullNote() {
    return genClient.cacheValueIsNotNull(CacheKey.note);
  }

  /** Checks whether the 'printed' field is set and is not null */
  public boolean isNotNullPrinted() {
    return genClient.cacheValueIsNotNull(CacheKey.printed);
  }

  /** Checks whether the 'exchangedLineItem' field is set and is not null */
  public boolean isNotNullExchangedLineItem() {
    return genClient.cacheValueIsNotNull(CacheKey.exchangedLineItem);
  }

  /** Checks whether the 'binName' field is set and is not null */
  public boolean isNotNullBinName() {
    return genClient.cacheValueIsNotNull(CacheKey.binName);
  }

  /** Checks whether the 'userData' field is set and is not null */
  public boolean isNotNullUserData() {
    return genClient.cacheValueIsNotNull(CacheKey.userData);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'orderClientCreatedTime' field is set and is not null */
  public boolean isNotNullOrderClientCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.orderClientCreatedTime);
  }

  /** Checks whether the 'discounts' field is set and is not null */
  public boolean isNotNullDiscounts() {
    return genClient.cacheValueIsNotNull(CacheKey.discounts);
  }

  /** Checks whether the 'discounts' field is set and is not null and is not empty */
  public boolean isNotEmptyDiscounts() { return isNotNullDiscounts() && !getDiscounts().isEmpty(); }

  /** Checks whether the 'orderLevelDiscounts' field is set and is not null */
  public boolean isNotNullOrderLevelDiscounts() {
    return genClient.cacheValueIsNotNull(CacheKey.orderLevelDiscounts);
  }

  /** Checks whether the 'orderLevelDiscounts' field is set and is not null and is not empty */
  public boolean isNotEmptyOrderLevelDiscounts() { return isNotNullOrderLevelDiscounts() && !getOrderLevelDiscounts().isEmpty(); }

  /** Checks whether the 'discountAmount' field is set and is not null */
  public boolean isNotNullDiscountAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.discountAmount);
  }

  /** Checks whether the 'orderLevelDiscountAmount' field is set and is not null */
  public boolean isNotNullOrderLevelDiscountAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.orderLevelDiscountAmount);
  }

  /** Checks whether the 'exchanged' field is set and is not null */
  public boolean isNotNullExchanged() {
    return genClient.cacheValueIsNotNull(CacheKey.exchanged);
  }

  /** Checks whether the 'modifications' field is set and is not null */
  public boolean isNotNullModifications() {
    return genClient.cacheValueIsNotNull(CacheKey.modifications);
  }

  /** Checks whether the 'modifications' field is set and is not null and is not empty */
  public boolean isNotEmptyModifications() { return isNotNullModifications() && !getModifications().isEmpty(); }

  /** Checks whether the 'tags' field is set and is not null */
  public boolean isNotNullTags() {
    return genClient.cacheValueIsNotNull(CacheKey.tags);
  }

  /** Checks whether the 'tags' field is set and is not null and is not empty */
  public boolean isNotEmptyTags() { return isNotNullTags() && !getTags().isEmpty(); }

  /** Checks whether the 'refunded' field is set and is not null */
  public boolean isNotNullRefunded() {
    return genClient.cacheValueIsNotNull(CacheKey.refunded);
  }

  /** Checks whether the 'refund' field is set and is not null */
  public boolean isNotNullRefund() {
    return genClient.cacheValueIsNotNull(CacheKey.refund);
  }

  /** Checks whether the 'isRevenue' field is set and is not null */
  public boolean isNotNullIsRevenue() {
    return genClient.cacheValueIsNotNull(CacheKey.isRevenue);
  }

  /** Checks whether the 'taxRates' field is set and is not null */
  public boolean isNotNullTaxRates() {
    return genClient.cacheValueIsNotNull(CacheKey.taxRates);
  }

  /** Checks whether the 'taxRates' field is set and is not null and is not empty */
  public boolean isNotEmptyTaxRates() { return isNotNullTaxRates() && !getTaxRates().isEmpty(); }

  /** Checks whether the 'payments' field is set and is not null */
  public boolean isNotNullPayments() {
    return genClient.cacheValueIsNotNull(CacheKey.payments);
  }

  /** Checks whether the 'payments' field is set and is not null and is not empty */
  public boolean isNotEmptyPayments() { return isNotNullPayments() && !getPayments().isEmpty(); }

  /** Checks whether the 'revenueAmount' field is set and is not null */
  public boolean isNotNullRevenueAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.revenueAmount);
  }

  /** Checks whether the 'quantitySold' field is set and is not null */
  public boolean isNotNullQuantitySold() {
    return genClient.cacheValueIsNotNull(CacheKey.quantitySold);
  }

  /** Checks whether the 'printGroup' field is set and is not null */
  public boolean isNotNullPrintGroup() {
    return genClient.cacheValueIsNotNull(CacheKey.printGroup);
  }

  /** Checks whether the 'hidden' field is set and is not null */
  public boolean isNotNullHidden() {
    return genClient.cacheValueIsNotNull(CacheKey.hidden);
  }

  /** Checks whether the 'percentage' field is set and is not null */
  public boolean isNotNullPercentage() {
    return genClient.cacheValueIsNotNull(CacheKey.percentage);
  }

  /** Checks whether the 'orderFee' field is set and is not null */
  public boolean isNotNullOrderFee() {
    return genClient.cacheValueIsNotNull(CacheKey.orderFee);
  }

  /** Checks whether the 'isOrderFee' field is set and is not null */
  public boolean isNotNullIsOrderFee() {
    return genClient.cacheValueIsNotNull(CacheKey.isOrderFee);
  }

  /** Checks whether the 'isPlatformOrderFee' field is set and is not null */
  public boolean isNotNullIsPlatformOrderFee() {
    return genClient.cacheValueIsNotNull(CacheKey.isPlatformOrderFee);
  }


  /** Checks whether the 'orderFeeType' field is set and is not null */
  public boolean isNotNullOrderFeeType() {
    return genClient.cacheValueIsNotNull(CacheKey.orderFeeType);
  }

  /** Checks whether the 'unitQtyDecimalDigits' field is set and is not null */
  public boolean isNotNullUnitQtyDecimalDigits() {
    return genClient.cacheValueIsNotNull(CacheKey.unitQtyDecimalDigits);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'item' field has been set, however the value could be null */
  public boolean hasItem() {
    return genClient.cacheHasKey(CacheKey.item);
  }

  /** Checks whether the 'colorCode' field has been set, however the value could be null */
  public boolean hasColorCode() {
    return genClient.cacheHasKey(CacheKey.colorCode);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return genClient.cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'alternateName' field has been set, however the value could be null */
  public boolean hasAlternateName() {
    return genClient.cacheHasKey(CacheKey.alternateName);
  }

  /** Checks whether the 'price' field has been set, however the value could be null */
  public boolean hasPrice() {
    return genClient.cacheHasKey(CacheKey.price);
  }

  /** Checks whether the 'priceWithModifiers' field has been set, however the value could be null */
  public boolean hasPriceWithModifiers() {
    return genClient.cacheHasKey(CacheKey.priceWithModifiers);
  }

  /** Checks whether the 'priceWithModifiersAndItemAndOrderDiscounts' field has been set, however the value could be null */
  public boolean hasPriceWithModifiersAndItemAndOrderDiscounts() {
    return genClient.cacheHasKey(CacheKey.priceWithModifiersAndItemAndOrderDiscounts);
  }

  /** Checks whether the 'unitQty' field has been set, however the value could be null */
  public boolean hasUnitQty() {
    return genClient.cacheHasKey(CacheKey.unitQty);
  }

  /** Checks whether the 'unitName' field has been set, however the value could be null */
  public boolean hasUnitName() {
    return genClient.cacheHasKey(CacheKey.unitName);
  }

  /** Checks whether the 'itemCode' field has been set, however the value could be null */
  public boolean hasItemCode() {
    return genClient.cacheHasKey(CacheKey.itemCode);
  }

  /** Checks whether the 'note' field has been set, however the value could be null */
  public boolean hasNote() {
    return genClient.cacheHasKey(CacheKey.note);
  }

  /** Checks whether the 'printed' field has been set, however the value could be null */
  public boolean hasPrinted() {
    return genClient.cacheHasKey(CacheKey.printed);
  }

  /** Checks whether the 'exchangedLineItem' field has been set, however the value could be null */
  public boolean hasExchangedLineItem() {
    return genClient.cacheHasKey(CacheKey.exchangedLineItem);
  }

  /** Checks whether the 'binName' field has been set, however the value could be null */
  public boolean hasBinName() {
    return genClient.cacheHasKey(CacheKey.binName);
  }

  /** Checks whether the 'userData' field has been set, however the value could be null */
  public boolean hasUserData() {
    return genClient.cacheHasKey(CacheKey.userData);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'orderClientCreatedTime' field has been set, however the value could be null */
  public boolean hasOrderClientCreatedTime() {
    return genClient.cacheHasKey(CacheKey.orderClientCreatedTime);
  }

  /** Checks whether the 'discounts' field has been set, however the value could be null */
  public boolean hasDiscounts() {
    return genClient.cacheHasKey(CacheKey.discounts);
  }

  /** Checks whether the 'orderLevelDiscounts' field has been set, however the value could be null */
  public boolean hasOrderLevelDiscounts() {
    return genClient.cacheHasKey(CacheKey.orderLevelDiscounts);
  }

  /** Checks whether the 'discountAmount' field has been set, however the value could be null */
  public boolean hasDiscountAmount() {
    return genClient.cacheHasKey(CacheKey.discountAmount);
  }

  /** Checks whether the 'orderLevelDiscountAmount' field has been set, however the value could be null */
  public boolean hasOrderLevelDiscountAmount() {
    return genClient.cacheHasKey(CacheKey.orderLevelDiscountAmount);
  }

  /** Checks whether the 'exchanged' field has been set, however the value could be null */
  public boolean hasExchanged() {
    return genClient.cacheHasKey(CacheKey.exchanged);
  }

  /** Checks whether the 'modifications' field has been set, however the value could be null */
  public boolean hasModifications() {
    return genClient.cacheHasKey(CacheKey.modifications);
  }

  /** Checks whether the 'tags' field has been set, however the value could be null */
  public boolean hasTags() {
    return genClient.cacheHasKey(CacheKey.tags);
  }

  /** Checks whether the 'refunded' field has been set, however the value could be null */
  public boolean hasRefunded() {
    return genClient.cacheHasKey(CacheKey.refunded);
  }

  /** Checks whether the 'refund' field has been set, however the value could be null */
  public boolean hasRefund() {
    return genClient.cacheHasKey(CacheKey.refund);
  }

  /** Checks whether the 'isRevenue' field has been set, however the value could be null */
  public boolean hasIsRevenue() {
    return genClient.cacheHasKey(CacheKey.isRevenue);
  }

  /** Checks whether the 'taxRates' field has been set, however the value could be null */
  public boolean hasTaxRates() {
    return genClient.cacheHasKey(CacheKey.taxRates);
  }

  /** Checks whether the 'payments' field has been set, however the value could be null */
  public boolean hasPayments() {
    return genClient.cacheHasKey(CacheKey.payments);
  }

  /** Checks whether the 'revenueAmount' field has been set, however the value could be null */
  public boolean hasRevenueAmount() {
    return genClient.cacheHasKey(CacheKey.revenueAmount);
  }

  /** Checks whether the 'quantitySold' field has been set, however the value could be null */
  public boolean hasQuantitySold() {
    return genClient.cacheHasKey(CacheKey.quantitySold);
  }

  /** Checks whether the 'printGroup' field has been set, however the value could be null */
  public boolean hasPrintGroup() {
    return genClient.cacheHasKey(CacheKey.printGroup);
  }

  /** Checks whether the 'hidden' field has been set, however the value could be null */
  public boolean hasHidden() {
    return genClient.cacheHasKey(CacheKey.hidden);
  }

  /** Checks whether the 'percentage' field has been set, however the value could be null */
  public boolean hasPercentage() {
    return genClient.cacheHasKey(CacheKey.percentage);
  }

  /** Checks whether the 'orderFee' field has been set, however the value could be null */
  public boolean hasOrderFee() {
    return genClient.cacheHasKey(CacheKey.orderFee);
  }

  /** Checks whether the 'isOrderFee' field has been set, however the value could be null */
  public boolean hasIsOrderFee() {
    return genClient.cacheHasKey(CacheKey.isOrderFee);
  }

  /** Checks whether the 'isPlatformOrderFee' field has been set, however the value could be null */
  public boolean hasIsPlatformOrderFee() {
    return genClient.cacheHasKey(CacheKey.isPlatformOrderFee);
  }

  /** Checks whether the 'orderFeeType' field has been set, however the value could be null */
  public boolean hasOrderFeeType() {
    return genClient.cacheHasKey(CacheKey.orderFeeType);
  }


  /** Checks whether the 'unitQtyDecimalDigits' field has been set, however the value could be null */
  public boolean hasUnitQtyDecimalDigits() {
    return genClient.cacheHasKey(CacheKey.unitQtyDecimalDigits);
  }


  /**
   * Sets the field 'id'.
   */
  public LineItem setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'item'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public LineItem setItem(com.clover.sdk.v3.base.Reference item) {
    return genClient.setRecord(item, CacheKey.item);
  }

  /**
   * Sets the field 'colorCode'.
   */
  public LineItem setColorCode(java.lang.String colorCode) {
    return genClient.setOther(colorCode, CacheKey.colorCode);
  }

  /**
   * Sets the field 'name'.
   */
  public LineItem setName(java.lang.String name) {
    return genClient.setOther(name, CacheKey.name);
  }

  /**
   * Sets the field 'alternateName'.
   */
  public LineItem setAlternateName(java.lang.String alternateName) {
    return genClient.setOther(alternateName, CacheKey.alternateName);
  }

  /**
   * Sets the field 'price'.
   */
  public LineItem setPrice(java.lang.Long price) {
    return genClient.setOther(price, CacheKey.price);
  }

  /**
   * Sets the field 'priceWithModifiers'.
   */
  public LineItem setPriceWithModifiers(java.lang.Long priceWithModifiers) {
    return genClient.setOther(priceWithModifiers, CacheKey.priceWithModifiers);
  }

  /**
   * Sets the field 'priceWithModifiersAndItemAndOrderDiscounts'.
   */
  public LineItem setPriceWithModifiersAndItemAndOrderDiscounts(java.lang.Long priceWithModifiersAndItemAndOrderDiscounts) {
    return genClient.setOther(priceWithModifiersAndItemAndOrderDiscounts, CacheKey.priceWithModifiersAndItemAndOrderDiscounts);
  }

  /**
   * Sets the field 'unitQty'.
   */
  public LineItem setUnitQty(java.lang.Integer unitQty) {
    return genClient.setOther(unitQty, CacheKey.unitQty);
  }

  /**
   * Sets the field 'unitName'.
   */
  public LineItem setUnitName(java.lang.String unitName) {
    return genClient.setOther(unitName, CacheKey.unitName);
  }

  /**
   * Sets the field 'itemCode'.
   */
  public LineItem setItemCode(java.lang.String itemCode) {
    return genClient.setOther(itemCode, CacheKey.itemCode);
  }

  /**
   * Sets the field 'note'.
   */
  public LineItem setNote(java.lang.String note) {
    return genClient.setOther(note, CacheKey.note);
  }

  /**
   * Sets the field 'printed'.
   */
  public LineItem setPrinted(java.lang.Boolean printed) {
    return genClient.setOther(printed, CacheKey.printed);
  }

  /**
   * Sets the field 'exchangedLineItem'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public LineItem setExchangedLineItem(com.clover.sdk.v3.base.Reference exchangedLineItem) {
    return genClient.setRecord(exchangedLineItem, CacheKey.exchangedLineItem);
  }

  /**
   * Sets the field 'binName'.
   */
  public LineItem setBinName(java.lang.String binName) {
    return genClient.setOther(binName, CacheKey.binName);
  }

  /**
   * Sets the field 'userData'.
   */
  public LineItem setUserData(java.lang.String userData) {
    return genClient.setOther(userData, CacheKey.userData);
  }

  /**
   * Sets the field 'createdTime'.
   */
  public LineItem setCreatedTime(java.lang.Long createdTime) {
    return genClient.setOther(createdTime, CacheKey.createdTime);
  }

  /**
   * Sets the field 'orderClientCreatedTime'.
   */
  public LineItem setOrderClientCreatedTime(java.lang.Long orderClientCreatedTime) {
    return genClient.setOther(orderClientCreatedTime, CacheKey.orderClientCreatedTime);
  }

  /**
   * Sets the field 'discounts'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public LineItem setDiscounts(java.util.List<com.clover.sdk.v3.order.Discount> discounts) {
    return genClient.setArrayRecord(discounts, CacheKey.discounts);
  }

  /**
   * Sets the field 'orderLevelDiscounts'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public LineItem setOrderLevelDiscounts(java.util.List<com.clover.sdk.v3.order.Discount> orderLevelDiscounts) {
    return genClient.setArrayRecord(orderLevelDiscounts, CacheKey.orderLevelDiscounts);
  }

  /**
   * Sets the field 'discountAmount'.
   */
  public LineItem setDiscountAmount(java.lang.Long discountAmount) {
    return genClient.setOther(discountAmount, CacheKey.discountAmount);
  }

  /**
   * Sets the field 'orderLevelDiscountAmount'.
   */
  public LineItem setOrderLevelDiscountAmount(java.lang.Long orderLevelDiscountAmount) {
    return genClient.setOther(orderLevelDiscountAmount, CacheKey.orderLevelDiscountAmount);
  }

  /**
   * Sets the field 'exchanged'.
   */
  public LineItem setExchanged(java.lang.Boolean exchanged) {
    return genClient.setOther(exchanged, CacheKey.exchanged);
  }

  /**
   * Sets the field 'modifications'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public LineItem setModifications(java.util.List<com.clover.sdk.v3.order.Modification> modifications) {
    return genClient.setArrayRecord(modifications, CacheKey.modifications);
  }

  /**
   * Sets the field 'tags'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public LineItem setTags(java.util.List<com.clover.sdk.v3.inventory.Tag> tags) {
    return genClient.setArrayRecord(tags, CacheKey.tags);
  }

  /**
   * Sets the field 'refunded'.
   */
  public LineItem setRefunded(java.lang.Boolean refunded) {
    return genClient.setOther(refunded, CacheKey.refunded);
  }

  /**
   * Sets the field 'refund'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public LineItem setRefund(com.clover.sdk.v3.payments.Refund refund) {
    return genClient.setRecord(refund, CacheKey.refund);
  }

  /**
   * Sets the field 'isRevenue'.
   */
  public LineItem setIsRevenue(java.lang.Boolean isRevenue) {
    return genClient.setOther(isRevenue, CacheKey.isRevenue);
  }

  /**
   * Sets the field 'taxRates'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public LineItem setTaxRates(java.util.List<com.clover.sdk.v3.inventory.TaxRate> taxRates) {
    return genClient.setArrayRecord(taxRates, CacheKey.taxRates);
  }

  /**
   * Sets the field 'payments'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public LineItem setPayments(java.util.List<com.clover.sdk.v3.payments.LineItemPayment> payments) {
    return genClient.setArrayRecord(payments, CacheKey.payments);
  }

  /**
   * Sets the field 'revenueAmount'.
   */
  public LineItem setRevenueAmount(java.lang.Long revenueAmount) {
    return genClient.setOther(revenueAmount, CacheKey.revenueAmount);
  }

  /**
   * Sets the field 'quantitySold'.
   */
  public LineItem setQuantitySold(java.lang.Double quantitySold) {
    return genClient.setOther(quantitySold, CacheKey.quantitySold);
  }

  /**
   * Sets the field 'printGroup'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public LineItem setPrintGroup(com.clover.sdk.v3.base.Reference printGroup) {
    return genClient.setRecord(printGroup, CacheKey.printGroup);
  }

  /**
   * Sets the field 'hidden'.
   */
  public LineItem setHidden(java.lang.Boolean hidden) {
    return genClient.setOther(hidden, CacheKey.hidden);
  }

  /**
   * Sets the field 'percentage'.
   */
  public LineItem setPercentage(java.lang.Long percentage) {
    return genClient.setOther(percentage, CacheKey.percentage);
  }

  /**
   * Sets the field 'orderFee'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public LineItem setOrderFee(com.clover.sdk.v3.base.Reference orderFee) {
    return genClient.setRecord(orderFee, CacheKey.orderFee);
  }

  /**
   * Sets the field 'isOrderFee'.
   */
  public LineItem setIsOrderFee(java.lang.Boolean isOrderFee) {
    return genClient.setOther(isOrderFee, CacheKey.isOrderFee);
  }

  /**
   * Sets the field 'isPlatformOrderFee'.
   */
  public LineItem setIsPlatformOrderFee(java.lang.Boolean isPlatformOrderFee) {
    return genClient.setOther(isPlatformOrderFee, CacheKey.isPlatformOrderFee);
  }

  /**
   * Sets the field 'orderFeeType'.
   */
  public LineItem setOrderFeeType(java.lang.String orderFeeType) {
    return genClient.setOther(orderFeeType, CacheKey.orderFeeType);
  }

  /**
   * Sets the field 'unitQtyDecimalDigits'.
   */
  public LineItem setUnitQtyDecimalDigits(java.lang.Integer unitQtyDecimalDigits) {
    return genClient.setOther(unitQtyDecimalDigits, CacheKey.unitQtyDecimalDigits);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'item' field, the 'has' method for this field will now return false */
  public void clearItem() {
    genClient.clear(CacheKey.item);
  }
  /** Clears the 'colorCode' field, the 'has' method for this field will now return false */
  public void clearColorCode() {
    genClient.clear(CacheKey.colorCode);
  }
  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    genClient.clear(CacheKey.name);
  }
  /** Clears the 'alternateName' field, the 'has' method for this field will now return false */
  public void clearAlternateName() {
    genClient.clear(CacheKey.alternateName);
  }
  /** Clears the 'price' field, the 'has' method for this field will now return false */
  public void clearPrice() {
    genClient.clear(CacheKey.price);
  }
  /** Clears the 'priceWithModifiers' field, the 'has' method for this field will now return false */
  public void clearPriceWithModifiers() {
    genClient.clear(CacheKey.priceWithModifiers);
  }
  /** Clears the 'priceWithModifiersAndItemAndOrderDiscounts' field, the 'has' method for this field will now return false */
  public void clearPriceWithModifiersAndItemAndOrderDiscounts() {
    genClient.clear(CacheKey.priceWithModifiersAndItemAndOrderDiscounts);
  }
  /** Clears the 'unitQty' field, the 'has' method for this field will now return false */
  public void clearUnitQty() {
    genClient.clear(CacheKey.unitQty);
  }
  /** Clears the 'unitName' field, the 'has' method for this field will now return false */
  public void clearUnitName() {
    genClient.clear(CacheKey.unitName);
  }
  /** Clears the 'itemCode' field, the 'has' method for this field will now return false */
  public void clearItemCode() {
    genClient.clear(CacheKey.itemCode);
  }
  /** Clears the 'note' field, the 'has' method for this field will now return false */
  public void clearNote() {
    genClient.clear(CacheKey.note);
  }
  /** Clears the 'printed' field, the 'has' method for this field will now return false */
  public void clearPrinted() {
    genClient.clear(CacheKey.printed);
  }
  /** Clears the 'exchangedLineItem' field, the 'has' method for this field will now return false */
  public void clearExchangedLineItem() {
    genClient.clear(CacheKey.exchangedLineItem);
  }
  /** Clears the 'binName' field, the 'has' method for this field will now return false */
  public void clearBinName() {
    genClient.clear(CacheKey.binName);
  }
  /** Clears the 'userData' field, the 'has' method for this field will now return false */
  public void clearUserData() {
    genClient.clear(CacheKey.userData);
  }
  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.createdTime);
  }
  /** Clears the 'orderClientCreatedTime' field, the 'has' method for this field will now return false */
  public void clearOrderClientCreatedTime() {
    genClient.clear(CacheKey.orderClientCreatedTime);
  }
  /** Clears the 'discounts' field, the 'has' method for this field will now return false */
  public void clearDiscounts() {
    genClient.clear(CacheKey.discounts);
  }
  /** Clears the 'orderLevelDiscounts' field, the 'has' method for this field will now return false */
  public void clearOrderLevelDiscounts() {
    genClient.clear(CacheKey.orderLevelDiscounts);
  }
  /** Clears the 'discountAmount' field, the 'has' method for this field will now return false */
  public void clearDiscountAmount() {
    genClient.clear(CacheKey.discountAmount);
  }
  /** Clears the 'orderLevelDiscountAmount' field, the 'has' method for this field will now return false */
  public void clearOrderLevelDiscountAmount() {
    genClient.clear(CacheKey.orderLevelDiscountAmount);
  }
  /** Clears the 'exchanged' field, the 'has' method for this field will now return false */
  public void clearExchanged() {
    genClient.clear(CacheKey.exchanged);
  }
  /** Clears the 'modifications' field, the 'has' method for this field will now return false */
  public void clearModifications() {
    genClient.clear(CacheKey.modifications);
  }
  /** Clears the 'tags' field, the 'has' method for this field will now return false */
  public void clearTags() {
    genClient.clear(CacheKey.tags);
  }
  /** Clears the 'refunded' field, the 'has' method for this field will now return false */
  public void clearRefunded() {
    genClient.clear(CacheKey.refunded);
  }
  /** Clears the 'refund' field, the 'has' method for this field will now return false */
  public void clearRefund() {
    genClient.clear(CacheKey.refund);
  }
  /** Clears the 'isRevenue' field, the 'has' method for this field will now return false */
  public void clearIsRevenue() {
    genClient.clear(CacheKey.isRevenue);
  }
  /** Clears the 'taxRates' field, the 'has' method for this field will now return false */
  public void clearTaxRates() {
    genClient.clear(CacheKey.taxRates);
  }
  /** Clears the 'payments' field, the 'has' method for this field will now return false */
  public void clearPayments() {
    genClient.clear(CacheKey.payments);
  }
  /** Clears the 'revenueAmount' field, the 'has' method for this field will now return false */
  public void clearRevenueAmount() {
    genClient.clear(CacheKey.revenueAmount);
  }
  /** Clears the 'quantitySold' field, the 'has' method for this field will now return false */
  public void clearQuantitySold() {
    genClient.clear(CacheKey.quantitySold);
  }
  /** Clears the 'printGroup' field, the 'has' method for this field will now return false */
  public void clearPrintGroup() {
    genClient.clear(CacheKey.printGroup);
  }
  /** Clears the 'hidden' field, the 'has' method for this field will now return false */
  public void clearHidden() {
    genClient.clear(CacheKey.hidden);
  }
  /** Clears the 'percentage' field, the 'has' method for this field will now return false */
  public void clearPercentage() {
    genClient.clear(CacheKey.percentage);
  }
  /** Clears the 'orderFee' field, the 'has' method for this field will now return false */
  public void clearOrderFee() {
    genClient.clear(CacheKey.orderFee);
  }
  /** Clears the 'isOrderFee' field, the 'has' method for this field will now return false */
  public void clearIsOrderFee() {
    genClient.clear(CacheKey.isOrderFee);
  }
  /** Clears the 'isPlatformOrderFee' field, the 'has' method for this field will now return false */
  public void clearIsPlatformOrderFee() {
    genClient.clear(CacheKey.isPlatformOrderFee);
  }
  /** Clears the 'orderFee' field, the 'has' method for this field will now return false */
  public void clearOrderFeeType() {
    genClient.clear(CacheKey.orderFeeType);
  }
  /** Clears the 'unitQtyDecimalDigits' field, the 'has' method for this field will now return false */
  public void clearUnitQtyDecimalDigits() {
    genClient.clear(CacheKey.unitQtyDecimalDigits);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public LineItem copyChanges() {
    LineItem copy = new LineItem();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(LineItem src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new LineItem(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<LineItem> CREATOR = new android.os.Parcelable.Creator<LineItem>() {
    @Override
    public LineItem createFromParcel(android.os.Parcel in) {
      LineItem instance = new LineItem(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public LineItem[] newArray(int size) {
      return new LineItem[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<LineItem> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<LineItem>() {
    public Class<LineItem> getCreatedClass() {
      return LineItem.class;
    }

    @Override
    public LineItem create(org.json.JSONObject jsonObject) {
      return new LineItem(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean ITEM_IS_REQUIRED = false;
    public static final boolean COLORCODE_IS_REQUIRED = false;
    public static final long COLORCODE_MAX_LEN = 9;
    public static final boolean NAME_IS_REQUIRED = false;
    public static final long NAME_MAX_LEN = 127;
    public static final boolean ALTERNATENAME_IS_REQUIRED = false;
    public static final long ALTERNATENAME_MAX_LEN = 127;
    public static final boolean PRICE_IS_REQUIRED = false;
    public static final boolean PRICEWITHMODIFIERS_IS_REQUIRED = false;
    public static final boolean PRICEWITHMODIFIERSANDITEMANDORDERDISCOUNTS_IS_REQUIRED = false;
    public static final boolean UNITQTY_IS_REQUIRED = false;
    public static final long UNITQTY_MIN = 0;
    public static final boolean UNITNAME_IS_REQUIRED = false;
    public static final long UNITNAME_MAX_LEN = 64;
    public static final boolean ITEMCODE_IS_REQUIRED = false;
    public static final long ITEMCODE_MAX_LEN = 100;
    public static final boolean NOTE_IS_REQUIRED = false;
    public static final long NOTE_MAX_LEN = 255;
    public static final boolean PRINTED_IS_REQUIRED = false;
    public static final boolean EXCHANGEDLINEITEM_IS_REQUIRED = false;
    public static final boolean BINNAME_IS_REQUIRED = false;
    public static final long BINNAME_MAX_LEN = 127;
    public static final boolean USERDATA_IS_REQUIRED = false;
    public static final long USERDATA_MAX_LEN = 255;
    public static final boolean CREATEDTIME_IS_REQUIRED = false;
    public static final boolean ORDERCLIENTCREATEDTIME_IS_REQUIRED = false;
    public static final boolean DISCOUNTS_IS_REQUIRED = false;
    public static final boolean ORDERLEVELDISCOUNTS_IS_REQUIRED = false;
    public static final boolean DISCOUNTAMOUNT_IS_REQUIRED = false;
    public static final boolean ORDERLEVELDISCOUNTAMOUNT_IS_REQUIRED = false;
    public static final boolean EXCHANGED_IS_REQUIRED = false;
    public static final boolean MODIFICATIONS_IS_REQUIRED = false;
    public static final boolean TAGS_IS_REQUIRED = false;
    public static final boolean REFUNDED_IS_REQUIRED = false;
    public static final boolean REFUND_IS_REQUIRED = false;
    public static final boolean ISREVENUE_IS_REQUIRED = false;
    public static final boolean TAXRATES_IS_REQUIRED = false;
    public static final boolean PAYMENTS_IS_REQUIRED = false;
    public static final boolean REVENUEAMOUNT_IS_REQUIRED = false;
    public static final boolean QUANTITYSOLD_IS_REQUIRED = false;
    public static final boolean PRINTGROUP_IS_REQUIRED = false;
    public static final boolean HIDDEN_IS_REQUIRED = false;
    public static final boolean PERCENTAGE_IS_REQUIRED = false;
    public static final long PERCENTAGE_MIN = 0;
    public static final long PERCENTAGE_MAX = 1000000;
    public static final boolean ORDERFEE_IS_REQUIRED = false;
    public static final boolean ISORDERFEE_IS_REQUIRED = false;
    public static final boolean ISPLATFORMORDERFEE_IS_REQUIRED = false;
    public static final boolean ORDERFEETYPE_IS_REQUIRED = false;
    public static final boolean UNITQTYDECIMALDIGITS_IS_REQUIRED = false;
    public static final long UNITQTYDECIMALDIGITS_MIN = 0;
    public static final long UNITQTYDECIMALDIGITS_MAX = 3;
  }

}
