/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.order;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * An immutable event that occurred on a particular line item.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getType type}</li>
 * <li>{@link #getOrderId orderId}</li>
 * <li>{@link #getLineItemId lineItemId}</li>
 * <li>{@link #getClientCreatedTime clientCreatedTime}</li>
 * <li>{@link #getCreatedTime createdTime}</li>
 * <li>{@link #getParentLineItemEvent parentLineItemEvent}</li>
 * <li>{@link #getDeviceId deviceId}</li>
 * <li>{@link #getLineItemInfo}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class LineItemEvent extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique Clover identifier.
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * The event type. This is a String and not an enum because its expected that only clients understand event types, and clients may introduce new types only they understand.
   */
  public java.lang.String getType() {
    return genClient.cacheGet(CacheKey.type);
  }

  /**
   * Reference to the order which this is associated.
   */
  public java.lang.String getOrderId() {
    return genClient.cacheGet(CacheKey.orderId);
  }

  /**
   * A reference to the line item which this is associated.
   */
  public java.lang.String getLineItemId() {
    return genClient.cacheGet(CacheKey.lineItemId);
  }

  /**
   * The time this event was created as supplied by the client. Measured in milliseconds since the Unix epoch.
   */
  public java.lang.Long getClientCreatedTime() {
    return genClient.cacheGet(CacheKey.clientCreatedTime);
  }

  /**
   * The time this event was recorded to the backend. Not to be filled in by the client.
   */
  public java.lang.Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.createdTime);
  }

  /**
   * Reference to its parent line item event
   */
  public com.clover.sdk.v3.base.Reference getParentLineItemEvent() {
    return genClient.cacheGet(CacheKey.parentLineItemEvent);
  }

  /**
   * Used to identify KDS device id where this line item is marked as Ready/complete. Can be null for all other KDS event types
   */
  public java.lang.String getDeviceId() {
    return genClient.cacheGet(CacheKey.deviceId);
  }

  /**
   * Used to identify line item info which is used to supports voided items. Can be null for all other event types
   */
  public java.lang.String getLineItemInfo() {
    return genClient.cacheGet(CacheKey.lineItemInfo);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    type
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    orderId
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    lineItemId
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    clientCreatedTime
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    createdTime
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    parentLineItemEvent
            (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    deviceId
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    lineItemInfo
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<LineItemEvent> genClient;

  /**
   * Constructs a new empty instance.
   */
  public LineItemEvent() {
    genClient = new GenericClient<LineItemEvent>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected LineItemEvent(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public LineItemEvent(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public LineItemEvent(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public LineItemEvent(LineItemEvent src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());

    genClient.validateNotNull(CacheKey.type, getType());

    genClient.validateNotNull(CacheKey.orderId, getOrderId());
    genClient.validateCloverId(CacheKey.orderId, getOrderId());

    genClient.validateCloverId(CacheKey.lineItemId, getLineItemId());

    genClient.validateNotNull(CacheKey.clientCreatedTime, getClientCreatedTime());
    genClient.validateReferences(CacheKey.parentLineItemEvent);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'type' field is set and is not null */
  public boolean isNotNullType() {
    return genClient.cacheValueIsNotNull(CacheKey.type);
  }

  /** Checks whether the 'orderId' field is set and is not null */
  public boolean isNotNullOrderId() {
    return genClient.cacheValueIsNotNull(CacheKey.orderId);
  }

  /** Checks whether the 'lineItemId' field is set and is not null */
  public boolean isNotNullLineItemId() {
    return genClient.cacheValueIsNotNull(CacheKey.lineItemId);
  }

  /** Checks whether the 'clientCreatedTime' field is set and is not null */
  public boolean isNotNullClientCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.clientCreatedTime);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'parentLineItemEvent' field is set and is not null */
  public boolean isNotNullParentLineItemEvent() {
    return genClient.cacheValueIsNotNull(CacheKey.parentLineItemEvent);
  }

  /** Checks whether the 'deviceId' field is set and is not null */
  public boolean isNotNullDeviceId() {
    return genClient.cacheValueIsNotNull(CacheKey.deviceId);
  }

  /** checks whether the 'lineItemInfo' field is set and is not null */
  public boolean isNotNullLineItemInfo() {
    return genClient.cacheValueIsNotNull(CacheKey.lineItemInfo);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'type' field has been set, however the value could be null */
  public boolean hasType() {
    return genClient.cacheHasKey(CacheKey.type);
  }

  /** Checks whether the 'orderId' field has been set, however the value could be null */
  public boolean hasOrderId() {
    return genClient.cacheHasKey(CacheKey.orderId);
  }

  /** Checks whether the 'lineItemId' field has been set, however the value could be null */
  public boolean hasLineItemId() {
    return genClient.cacheHasKey(CacheKey.lineItemId);
  }

  /** Checks whether the 'clientCreatedTime' field has been set, however the value could be null */
  public boolean hasClientCreatedTime() {
    return genClient.cacheHasKey(CacheKey.clientCreatedTime);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'parentLineItemEvent' field has been set, however the value could be null */
  public boolean hasParentLineItemEvent() {
    return genClient.cacheHasKey(CacheKey.parentLineItemEvent);
  }

  /** Checks whether the 'deviceId' field has been set, however the value could be null */
  public boolean hasDeviceId() {
    return genClient.cacheHasKey(CacheKey.deviceId);
  }

  /**
   * Checks whether the 'lineItemInfo' field has been set, however the value could be null
   */
  public boolean hasLineItemInfo() {
    return genClient.cacheHasKey(CacheKey.lineItemInfo);
  }


  /**
   * Sets the field 'id'.
   */
  public LineItemEvent setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'type'.
   */
  public LineItemEvent setType(java.lang.String type) {
    return genClient.setOther(type, CacheKey.type);
  }

  /**
   * Sets the field 'orderId'.
   */
  public LineItemEvent setOrderId(java.lang.String orderId) {
    return genClient.setOther(orderId, CacheKey.orderId);
  }

  /**
   * Sets the field 'lineItemId'.
   */
  public LineItemEvent setLineItemId(java.lang.String lineItemId) {
    return genClient.setOther(lineItemId, CacheKey.lineItemId);
  }

  /**
   * Sets the field 'clientCreatedTime'.
   */
  public LineItemEvent setClientCreatedTime(java.lang.Long clientCreatedTime) {
    return genClient.setOther(clientCreatedTime, CacheKey.clientCreatedTime);
  }

  /**
   * Sets the field 'createdTime'.
   */
  public LineItemEvent setCreatedTime(java.lang.Long createdTime) {
    return genClient.setOther(createdTime, CacheKey.createdTime);
  }

  /**
   * Sets the field 'parentLineItemEvent'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public LineItemEvent setParentLineItemEvent(com.clover.sdk.v3.base.Reference parentLineItemEvent) {
    return genClient.setRecord(parentLineItemEvent, CacheKey.parentLineItemEvent);
  }

  /**
   * Sets the field 'deviceId'.
   */
  public LineItemEvent setDeviceId(java.lang.String deviceId) {
    return genClient.setOther(deviceId, CacheKey.deviceId);
  }

  /**
   * Sets the field 'lineItemInfo'.
   */
  public LineItemEvent setLineItemInfo(java.lang.String lineItemInfo) {
    return genClient.setOther(lineItemInfo, CacheKey.lineItemInfo);
  }
  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'type' field, the 'has' method for this field will now return false */
  public void clearType() {
    genClient.clear(CacheKey.type);
  }
  /** Clears the 'orderId' field, the 'has' method for this field will now return false */
  public void clearOrderId() {
    genClient.clear(CacheKey.orderId);
  }
  /** Clears the 'lineItemId' field, the 'has' method for this field will now return false */
  public void clearLineItemId() {
    genClient.clear(CacheKey.lineItemId);
  }
  /** Clears the 'clientCreatedTime' field, the 'has' method for this field will now return false */
  public void clearClientCreatedTime() {
    genClient.clear(CacheKey.clientCreatedTime);
  }
  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.createdTime);
  }
  /** Clears the 'parentLineItemEvent' field, the 'has' method for this field will now return false */
  public void clearParentLineItemEvent() {
    genClient.clear(CacheKey.parentLineItemEvent);
  }
  /** Clears the 'deviceId' field, the 'has' method for this field will now return false */
  public void clearDeviceId() {
    genClient.clear(CacheKey.deviceId);
  }

  /**
   * Clears the 'lineItemInfo' field, the 'has' method for this field will now return false
   */
  public void clearLineItemInfo() {
    genClient.clear(CacheKey.lineItemInfo);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public LineItemEvent copyChanges() {
    LineItemEvent copy = new LineItemEvent();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(LineItemEvent src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new LineItemEvent(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<LineItemEvent> CREATOR = new android.os.Parcelable.Creator<LineItemEvent>() {
    @Override
    public LineItemEvent createFromParcel(android.os.Parcel in) {
      LineItemEvent instance = new LineItemEvent(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public LineItemEvent[] newArray(int size) {
      return new LineItemEvent[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<LineItemEvent> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<LineItemEvent>() {
    public Class<LineItemEvent> getCreatedClass() {
      return LineItemEvent.class;
    }

    @Override
    public LineItemEvent create(org.json.JSONObject jsonObject) {
      return new LineItemEvent(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean TYPE_IS_REQUIRED = true;
    public static final boolean ORDERID_IS_REQUIRED = true;
    public static final long ORDERID_MAX_LEN = 13;
    public static final boolean LINEITEMID_IS_REQUIRED = false;
    public static final long LINEITEMID_MAX_LEN = 13;
    public static final boolean CLIENTCREATEDTIME_IS_REQUIRED = true;
    public static final boolean CREATEDTIME_IS_REQUIRED = false;
    public static final boolean PARENTLINEITEMEVENT_IS_REQUIRED = false;
    public static final boolean DEVICEID_IS_REQUIRED = false;
    public static final boolean LINE_ITEM_INFO_IS_REQUIRED = false;
  }

}
