/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.order;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * Detailed explanation on why the transaction is getting voided.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getTxError txError}</li>
 * <li>{@link #getVoidReasonCode voidReasonCode}</li>
 * <li>{@link #getDescription description}</li>
 * <li>{@link #getPayFailureMessage payFailureMessage}</li>
 * <li>{@link #getPaymentUuid paymentUuid}</li>
 * <li>{@link #getOrderId orderId}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class VoidReasonDetails extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Transaction Error byte in hex
   */
  public String getTxError() {
    return genClient.cacheGet(CacheKey.txError);
  }

  /**
   * Detailed Reason code
   */
  public VoidReasonCode getVoidReasonCode() {
    return genClient.cacheGet(CacheKey.voidReasonCode);
  }

  /**
   * More detailed reason for voiding the transaction
   */
  public String getDescription() {
    return genClient.cacheGet(CacheKey.description);
  }

  /**
   * Pay Failure Message
   */
  public String getPayFailureMessage() {
    return genClient.cacheGet(CacheKey.payFailureMessage);
  }

  public String getPaymentUuid() {
    return genClient.cacheGet(CacheKey.paymentUuid);
  }

  public String getOrderId() {
    return genClient.cacheGet(CacheKey.orderId);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    txError
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    voidReasonCode
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(VoidReasonCode.class)),
    description
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    payFailureMessage
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    paymentUuid
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    orderId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<VoidReasonDetails> genClient;

  /**
   * Constructs a new empty instance.
   */
  public VoidReasonDetails() {
    genClient = new GenericClient<VoidReasonDetails>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected VoidReasonDetails(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public VoidReasonDetails(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public VoidReasonDetails(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public VoidReasonDetails(VoidReasonDetails src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'txError' field is set and is not null */
  public boolean isNotNullTxError() {
    return genClient.cacheValueIsNotNull(CacheKey.txError);
  }

  /** Checks whether the 'voidReasonCode' field is set and is not null */
  public boolean isNotNullVoidReasonCode() {
    return genClient.cacheValueIsNotNull(CacheKey.voidReasonCode);
  }

  /** Checks whether the 'description' field is set and is not null */
  public boolean isNotNullDescription() {
    return genClient.cacheValueIsNotNull(CacheKey.description);
  }

  /** Checks whether the 'payFailureMessage' field is set and is not null */
  public boolean isNotNullPayFailureMessage() {
    return genClient.cacheValueIsNotNull(CacheKey.payFailureMessage);
  }

  /** Checks whether the 'paymentUuid' field is set and is not null */
  public boolean isNotNullPaymentUuid() {
    return genClient.cacheValueIsNotNull(CacheKey.paymentUuid);
  }

  /** Checks whether the 'orderId' field is set and is not null */
  public boolean isNotNullOrderId() {
    return genClient.cacheValueIsNotNull(CacheKey.orderId);
  }



  /** Checks whether the 'txError' field has been set, however the value could be null */
  public boolean hasTxError() {
    return genClient.cacheHasKey(CacheKey.txError);
  }

  /** Checks whether the 'voidReasonCode' field has been set, however the value could be null */
  public boolean hasVoidReasonCode() {
    return genClient.cacheHasKey(CacheKey.voidReasonCode);
  }

  /** Checks whether the 'description' field has been set, however the value could be null */
  public boolean hasDescription() {
    return genClient.cacheHasKey(CacheKey.description);
  }

  /** Checks whether the 'payFailureMessage' field has been set, however the value could be null */
  public boolean hasPayFailureMessage() {
    return genClient.cacheHasKey(CacheKey.payFailureMessage);
  }

  /** Checks whether the 'paymentUuid' field has been set, however the value could be null */
  public boolean hasPaymentUuid() {
    return genClient.cacheHasKey(CacheKey.paymentUuid);
  }

  /** Checks whether the 'orderId' field has been set, however the value could be null */
  public boolean hasOrderId() {
    return genClient.cacheHasKey(CacheKey.orderId);
  }


  /**
   * Sets the field 'txError'.
   */
  public VoidReasonDetails setTxError(String txError) {
    return genClient.setOther(txError, CacheKey.txError);
  }

  /**
   * Sets the field 'voidReasonCode'.
   */
  public VoidReasonDetails setVoidReasonCode(VoidReasonCode voidReasonCode) {
    return genClient.setOther(voidReasonCode, CacheKey.voidReasonCode);
  }

  /**
   * Sets the field 'description'.
   */
  public VoidReasonDetails setDescription(String description) {
    return genClient.setOther(description, CacheKey.description);
  }

  /**
   * Sets the field 'payFailureMessage'.
   */
  public VoidReasonDetails setPayFailureMessage(String payFailureMessage) {
    return genClient.setOther(payFailureMessage, CacheKey.payFailureMessage);
  }

  /**
   * Sets the field 'paymentUuid'.
   */
  public VoidReasonDetails setPaymentUuid(String paymentUuid) {
    return genClient.setOther(paymentUuid, CacheKey.paymentUuid);
  }

  /**
   * Sets the field 'orderId'.
   */
  public VoidReasonDetails setOrderId(String orderId) {
    return genClient.setOther(orderId, CacheKey.orderId);
  }


  /** Clears the 'txError' field, the 'has' method for this field will now return false */
  public void clearTxError() {
    genClient.clear(CacheKey.txError);
  }
  /** Clears the 'voidReasonCode' field, the 'has' method for this field will now return false */
  public void clearVoidReasonCode() {
    genClient.clear(CacheKey.voidReasonCode);
  }
  /** Clears the 'description' field, the 'has' method for this field will now return false */
  public void clearDescription() {
    genClient.clear(CacheKey.description);
  }
  /** Clears the 'payFailureMessage' field, the 'has' method for this field will now return false */
  public void clearPayFailureMessage() {
    genClient.clear(CacheKey.payFailureMessage);
  }
  /** Clears the 'paymentUuid' field, the 'has' method for this field will now return false */
  public void clearPaymentUuid() {
    genClient.clear(CacheKey.paymentUuid);
  }
  /** Clears the 'orderId' field, the 'has' method for this field will now return false */
  public void clearOrderId() {
    genClient.clear(CacheKey.orderId);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public VoidReasonDetails copyChanges() {
    VoidReasonDetails copy = new VoidReasonDetails();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(VoidReasonDetails src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new VoidReasonDetails(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<VoidReasonDetails> CREATOR = new android.os.Parcelable.Creator<VoidReasonDetails>() {
    @Override
    public VoidReasonDetails createFromParcel(android.os.Parcel in) {
      VoidReasonDetails instance = new VoidReasonDetails(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public VoidReasonDetails[] newArray(int size) {
      return new VoidReasonDetails[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<VoidReasonDetails> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<VoidReasonDetails>() {
    public Class<VoidReasonDetails> getCreatedClass() {
      return VoidReasonDetails.class;
    }

    @Override
    public VoidReasonDetails create(org.json.JSONObject jsonObject) {
      return new VoidReasonDetails(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean TXERROR_IS_REQUIRED = false;
    public static final boolean VOIDREASONCODE_IS_REQUIRED = false;
    public static final boolean DESCRIPTION_IS_REQUIRED = false;
    public static final boolean PAYFAILUREMESSAGE_IS_REQUIRED = false;
    public static final boolean PAYMENTUUID_IS_REQUIRED = false;
    public static final boolean ORDERID_IS_REQUIRED = false;
  }

}
