/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.order;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * For reporting on a removed line item
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getLineItem lineItem}</li>
 * <li>{@link #getMerchant merchant}</li>
 * <li>{@link #getReason reason}</li>
 * <li>{@link #getRemovedBy removedBy}</li>
 * <li>{@link #getApprovedBy approvedBy}</li>
 * <li>{@link #getCreatedBy createdBy}</li>
 * <li>{@link #getDeletedTime deletedTime}</li>
 * <li>{@link #getEnvironment environment}</li>
 * <li>{@link #getClientEventType clientEventType}</li>
 * </ul>
 * <p>
 * @see com.clover.sdk.v3.order.IOrderService
 */
@SuppressWarnings("all")
public class VoidedLineItem extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * The line item that was voided
   */
  public com.clover.sdk.v3.order.LineItem getLineItem() {
    return genClient.cacheGet(CacheKey.lineItem);
  }

  public com.clover.sdk.v3.base.Reference getMerchant() {
    return genClient.cacheGet(CacheKey.merchant);
  }

  /**
   * Why was the line item voided
   */
  public java.lang.String getReason() {
    return genClient.cacheGet(CacheKey.reason);
  }

  /**
   * Employee who voided the item
   */
  public com.clover.sdk.v3.base.Reference getRemovedBy() {
    return genClient.cacheGet(CacheKey.removedBy);
  }

  /**
   * Optional info about employee who approved deletion of line item in case current employee does not have the permission
   */
  public com.clover.sdk.v3.base.Reference getApprovedBy() {
    return genClient.cacheGet(CacheKey.approvedBy);
  }

  /**
   * Employee who created the order from which the line item was voided
   */
  public com.clover.sdk.v3.base.Reference getCreatedBy() {
    return genClient.cacheGet(CacheKey.createdBy);
  }

  /**
   * Timestamp of when this line item was deleted
   */
  public java.lang.Long getDeletedTime() {
    return genClient.cacheGet(CacheKey.deletedTime);
  }

  /**
   * Which environment was this recorded in
   */
  public java.lang.String getEnvironment() {
    return genClient.cacheGet(CacheKey.environment);
  }

  /**
   * What event on the client removed this? Was it because of moving a table? Or was it plain old deleting a line item?
   */
  public com.clover.sdk.v3.order.ClientEventType getClientEventType() {
    return genClient.cacheGet(CacheKey.clientEventType);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    lineItem
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.order.LineItem.JSON_CREATOR)),
    merchant
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    reason
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    removedBy
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    approvedBy
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    createdBy
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    deletedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    environment
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    clientEventType
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.order.ClientEventType.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<VoidedLineItem> genClient;

  /**
   * Constructs a new empty instance.
   */
  public VoidedLineItem() {
    genClient = new GenericClient<VoidedLineItem>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected VoidedLineItem(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public VoidedLineItem(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public VoidedLineItem(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public VoidedLineItem(VoidedLineItem src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateReferences(CacheKey.merchant);
    genClient.validateReferences(CacheKey.removedBy);
    genClient.validateReferences(CacheKey.approvedBy);
    genClient.validateReferences(CacheKey.createdBy);
  }

  /** Checks whether the 'lineItem' field is set and is not null */
  public boolean isNotNullLineItem() {
    return genClient.cacheValueIsNotNull(CacheKey.lineItem);
  }

  /** Checks whether the 'merchant' field is set and is not null */
  public boolean isNotNullMerchant() {
    return genClient.cacheValueIsNotNull(CacheKey.merchant);
  }

  /** Checks whether the 'reason' field is set and is not null */
  public boolean isNotNullReason() {
    return genClient.cacheValueIsNotNull(CacheKey.reason);
  }

  /** Checks whether the 'removedBy' field is set and is not null */
  public boolean isNotNullRemovedBy() {
    return genClient.cacheValueIsNotNull(CacheKey.removedBy);
  }

  /** Checks whether the 'approvedBy' field is set and is not null */
  public boolean isNotNullApprovedBy() {
    return genClient.cacheValueIsNotNull(CacheKey.approvedBy);
  }

  /** Checks whether the 'createdBy' field is set and is not null */
  public boolean isNotNullCreatedBy() {
    return genClient.cacheValueIsNotNull(CacheKey.createdBy);
  }

  /** Checks whether the 'deletedTime' field is set and is not null */
  public boolean isNotNullDeletedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.deletedTime);
  }

  /** Checks whether the 'environment' field is set and is not null */
  public boolean isNotNullEnvironment() {
    return genClient.cacheValueIsNotNull(CacheKey.environment);
  }

  /** Checks whether the 'clientEventType' field is set and is not null */
  public boolean isNotNullClientEventType() {
    return genClient.cacheValueIsNotNull(CacheKey.clientEventType);
  }



  /** Checks whether the 'lineItem' field has been set, however the value could be null */
  public boolean hasLineItem() {
    return genClient.cacheHasKey(CacheKey.lineItem);
  }

  /** Checks whether the 'merchant' field has been set, however the value could be null */
  public boolean hasMerchant() {
    return genClient.cacheHasKey(CacheKey.merchant);
  }

  /** Checks whether the 'reason' field has been set, however the value could be null */
  public boolean hasReason() {
    return genClient.cacheHasKey(CacheKey.reason);
  }

  /** Checks whether the 'removedBy' field has been set, however the value could be null */
  public boolean hasRemovedBy() {
    return genClient.cacheHasKey(CacheKey.removedBy);
  }

  /** Checks whether the 'approvedBy' field has been set, however the value could be null */
  public boolean hasApprovedBy() {
    return genClient.cacheHasKey(CacheKey.approvedBy);
  }

  /** Checks whether the 'createdBy' field has been set, however the value could be null */
  public boolean hasCreatedBy() {
    return genClient.cacheHasKey(CacheKey.createdBy);
  }

  /** Checks whether the 'deletedTime' field has been set, however the value could be null */
  public boolean hasDeletedTime() {
    return genClient.cacheHasKey(CacheKey.deletedTime);
  }

  /** Checks whether the 'environment' field has been set, however the value could be null */
  public boolean hasEnvironment() {
    return genClient.cacheHasKey(CacheKey.environment);
  }

  /** Checks whether the 'clientEventType' field has been set, however the value could be null */
  public boolean hasClientEventType() {
    return genClient.cacheHasKey(CacheKey.clientEventType);
  }


  /**
   * Sets the field 'lineItem'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public VoidedLineItem setLineItem(com.clover.sdk.v3.order.LineItem lineItem) {
    return genClient.setRecord(lineItem, CacheKey.lineItem);
  }

  /**
   * Sets the field 'merchant'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public VoidedLineItem setMerchant(com.clover.sdk.v3.base.Reference merchant) {
    return genClient.setRecord(merchant, CacheKey.merchant);
  }

  /**
   * Sets the field 'reason'.
   */
  public VoidedLineItem setReason(java.lang.String reason) {
    return genClient.setOther(reason, CacheKey.reason);
  }

  /**
   * Sets the field 'removedBy'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public VoidedLineItem setRemovedBy(com.clover.sdk.v3.base.Reference removedBy) {
    return genClient.setRecord(removedBy, CacheKey.removedBy);
  }

  /**
   * Sets the field 'approvedBy'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public VoidedLineItem setApprovedBy(com.clover.sdk.v3.base.Reference approvedBy) {
    return genClient.setRecord(approvedBy, CacheKey.approvedBy);
  }

  /**
   * Sets the field 'createdBy'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public VoidedLineItem setCreatedBy(com.clover.sdk.v3.base.Reference createdBy) {
    return genClient.setRecord(createdBy, CacheKey.createdBy);
  }

  /**
   * Sets the field 'deletedTime'.
   */
  public VoidedLineItem setDeletedTime(java.lang.Long deletedTime) {
    return genClient.setOther(deletedTime, CacheKey.deletedTime);
  }

  /**
   * Sets the field 'environment'.
   */
  public VoidedLineItem setEnvironment(java.lang.String environment) {
    return genClient.setOther(environment, CacheKey.environment);
  }

  /**
   * Sets the field 'clientEventType'.
   */
  public VoidedLineItem setClientEventType(com.clover.sdk.v3.order.ClientEventType clientEventType) {
    return genClient.setOther(clientEventType, CacheKey.clientEventType);
  }


  /** Clears the 'lineItem' field, the 'has' method for this field will now return false */
  public void clearLineItem() {
    genClient.clear(CacheKey.lineItem);
  }
  /** Clears the 'merchant' field, the 'has' method for this field will now return false */
  public void clearMerchant() {
    genClient.clear(CacheKey.merchant);
  }
  /** Clears the 'reason' field, the 'has' method for this field will now return false */
  public void clearReason() {
    genClient.clear(CacheKey.reason);
  }
  /** Clears the 'removedBy' field, the 'has' method for this field will now return false */
  public void clearRemovedBy() {
    genClient.clear(CacheKey.removedBy);
  }
  /** Clears the 'approvedBy' field, the 'has' method for this field will now return false */
  public void clearApprovedBy() {
    genClient.clear(CacheKey.approvedBy);
  }
  /** Clears the 'createdBy' field, the 'has' method for this field will now return false */
  public void clearCreatedBy() {
    genClient.clear(CacheKey.createdBy);
  }
  /** Clears the 'deletedTime' field, the 'has' method for this field will now return false */
  public void clearDeletedTime() {
    genClient.clear(CacheKey.deletedTime);
  }
  /** Clears the 'environment' field, the 'has' method for this field will now return false */
  public void clearEnvironment() {
    genClient.clear(CacheKey.environment);
  }
  /** Clears the 'clientEventType' field, the 'has' method for this field will now return false */
  public void clearClientEventType() {
    genClient.clear(CacheKey.clientEventType);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public VoidedLineItem copyChanges() {
    VoidedLineItem copy = new VoidedLineItem();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(VoidedLineItem src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new VoidedLineItem(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<VoidedLineItem> CREATOR = new android.os.Parcelable.Creator<VoidedLineItem>() {
    @Override
    public VoidedLineItem createFromParcel(android.os.Parcel in) {
      VoidedLineItem instance = new VoidedLineItem(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public VoidedLineItem[] newArray(int size) {
      return new VoidedLineItem[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<VoidedLineItem> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<VoidedLineItem>() {
    public Class<VoidedLineItem> getCreatedClass() {
      return VoidedLineItem.class;
    }

    @Override
    public VoidedLineItem create(org.json.JSONObject jsonObject) {
      return new VoidedLineItem(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean LINEITEM_IS_REQUIRED = false;
    public static final boolean MERCHANT_IS_REQUIRED = false;
    public static final boolean REASON_IS_REQUIRED = false;
    public static final boolean REMOVEDBY_IS_REQUIRED = false;
    public static final boolean APPROVEDBY_IS_REQUIRED = false;
    public static final boolean CREATEDBY_IS_REQUIRED = false;
    public static final boolean DELETEDTIME_IS_REQUIRED = false;
    public static final boolean ENVIRONMENT_IS_REQUIRED = false;
    public static final boolean CLIENTEVENTTYPE_IS_REQUIRED = false;
  }

}
