/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.order;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * Summary of removed items by employee
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getEmployee employee}</li>
 * <li>{@link #getPriceWithQuantityAndModifiersOfRemovedItems priceWithQuantityAndModifiersOfRemovedItems}</li>
 * <li>{@link #getGrossSaleOfEmployee grossSaleOfEmployee}</li>
 * <li>{@link #getItemsRemovalRate itemsRemovalRate}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class VoidedLineItemEmployeeData extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * The employee who performed the event
   */
  public com.clover.sdk.v3.employees.Employee getEmployee() {
    return genClient.cacheGet(CacheKey.employee);
  }

  /**
   * sum of price of all the items multiplied with quantity and includes modifiers.
   */
  public java.lang.Long getPriceWithQuantityAndModifiersOfRemovedItems() {
    return genClient.cacheGet(CacheKey.priceWithQuantityAndModifiersOfRemovedItems);
  }

  /**
   * gross sale of employee over the reporting period
   */
  public java.lang.Long getGrossSaleOfEmployee() {
    return genClient.cacheGet(CacheKey.grossSaleOfEmployee);
  }

  /**
   * removal rate of the employee
   */
  public java.lang.Double getItemsRemovalRate() {
    return genClient.cacheGet(CacheKey.itemsRemovalRate);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    employee
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.employees.Employee.JSON_CREATOR)),
    priceWithQuantityAndModifiersOfRemovedItems
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    grossSaleOfEmployee
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    itemsRemovalRate
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Double.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<VoidedLineItemEmployeeData> genClient;

  /**
   * Constructs a new empty instance.
   */
  public VoidedLineItemEmployeeData() {
    genClient = new GenericClient<VoidedLineItemEmployeeData>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected VoidedLineItemEmployeeData(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public VoidedLineItemEmployeeData(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public VoidedLineItemEmployeeData(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public VoidedLineItemEmployeeData(VoidedLineItemEmployeeData src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'employee' field is set and is not null */
  public boolean isNotNullEmployee() {
    return genClient.cacheValueIsNotNull(CacheKey.employee);
  }

  /** Checks whether the 'priceWithQuantityAndModifiersOfRemovedItems' field is set and is not null */
  public boolean isNotNullPriceWithQuantityAndModifiersOfRemovedItems() {
    return genClient.cacheValueIsNotNull(CacheKey.priceWithQuantityAndModifiersOfRemovedItems);
  }

  /** Checks whether the 'grossSaleOfEmployee' field is set and is not null */
  public boolean isNotNullGrossSaleOfEmployee() {
    return genClient.cacheValueIsNotNull(CacheKey.grossSaleOfEmployee);
  }

  /** Checks whether the 'itemsRemovalRate' field is set and is not null */
  public boolean isNotNullItemsRemovalRate() {
    return genClient.cacheValueIsNotNull(CacheKey.itemsRemovalRate);
  }



  /** Checks whether the 'employee' field has been set, however the value could be null */
  public boolean hasEmployee() {
    return genClient.cacheHasKey(CacheKey.employee);
  }

  /** Checks whether the 'priceWithQuantityAndModifiersOfRemovedItems' field has been set, however the value could be null */
  public boolean hasPriceWithQuantityAndModifiersOfRemovedItems() {
    return genClient.cacheHasKey(CacheKey.priceWithQuantityAndModifiersOfRemovedItems);
  }

  /** Checks whether the 'grossSaleOfEmployee' field has been set, however the value could be null */
  public boolean hasGrossSaleOfEmployee() {
    return genClient.cacheHasKey(CacheKey.grossSaleOfEmployee);
  }

  /** Checks whether the 'itemsRemovalRate' field has been set, however the value could be null */
  public boolean hasItemsRemovalRate() {
    return genClient.cacheHasKey(CacheKey.itemsRemovalRate);
  }


  /**
   * Sets the field 'employee'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public VoidedLineItemEmployeeData setEmployee(com.clover.sdk.v3.employees.Employee employee) {
    return genClient.setRecord(employee, CacheKey.employee);
  }

  /**
   * Sets the field 'priceWithQuantityAndModifiersOfRemovedItems'.
   */
  public VoidedLineItemEmployeeData setPriceWithQuantityAndModifiersOfRemovedItems(java.lang.Long priceWithQuantityAndModifiersOfRemovedItems) {
    return genClient.setOther(priceWithQuantityAndModifiersOfRemovedItems, CacheKey.priceWithQuantityAndModifiersOfRemovedItems);
  }

  /**
   * Sets the field 'grossSaleOfEmployee'.
   */
  public VoidedLineItemEmployeeData setGrossSaleOfEmployee(java.lang.Long grossSaleOfEmployee) {
    return genClient.setOther(grossSaleOfEmployee, CacheKey.grossSaleOfEmployee);
  }

  /**
   * Sets the field 'itemsRemovalRate'.
   */
  public VoidedLineItemEmployeeData setItemsRemovalRate(java.lang.Double itemsRemovalRate) {
    return genClient.setOther(itemsRemovalRate, CacheKey.itemsRemovalRate);
  }


  /** Clears the 'employee' field, the 'has' method for this field will now return false */
  public void clearEmployee() {
    genClient.clear(CacheKey.employee);
  }
  /** Clears the 'priceWithQuantityAndModifiersOfRemovedItems' field, the 'has' method for this field will now return false */
  public void clearPriceWithQuantityAndModifiersOfRemovedItems() {
    genClient.clear(CacheKey.priceWithQuantityAndModifiersOfRemovedItems);
  }
  /** Clears the 'grossSaleOfEmployee' field, the 'has' method for this field will now return false */
  public void clearGrossSaleOfEmployee() {
    genClient.clear(CacheKey.grossSaleOfEmployee);
  }
  /** Clears the 'itemsRemovalRate' field, the 'has' method for this field will now return false */
  public void clearItemsRemovalRate() {
    genClient.clear(CacheKey.itemsRemovalRate);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public VoidedLineItemEmployeeData copyChanges() {
    VoidedLineItemEmployeeData copy = new VoidedLineItemEmployeeData();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(VoidedLineItemEmployeeData src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new VoidedLineItemEmployeeData(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<VoidedLineItemEmployeeData> CREATOR = new android.os.Parcelable.Creator<VoidedLineItemEmployeeData>() {
    @Override
    public VoidedLineItemEmployeeData createFromParcel(android.os.Parcel in) {
      VoidedLineItemEmployeeData instance = new VoidedLineItemEmployeeData(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public VoidedLineItemEmployeeData[] newArray(int size) {
      return new VoidedLineItemEmployeeData[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<VoidedLineItemEmployeeData> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<VoidedLineItemEmployeeData>() {
    public Class<VoidedLineItemEmployeeData> getCreatedClass() {
      return VoidedLineItemEmployeeData.class;
    }

    @Override
    public VoidedLineItemEmployeeData create(org.json.JSONObject jsonObject) {
      return new VoidedLineItemEmployeeData(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean EMPLOYEE_IS_REQUIRED = false;
    public static final boolean PRICEWITHQUANTITYANDMODIFIERSOFREMOVEDITEMS_IS_REQUIRED = false;
    public static final boolean GROSSSALEOFEMPLOYEE_IS_REQUIRED = false;
    public static final boolean ITEMSREMOVALRATE_IS_REQUIRED = false;
  }

}
