/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.pay;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getName name}</li>
 * <li>{@link #getPaymentGatewayApi paymentGatewayApi}</li>
 * <li>{@link #getProduction production}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class PaymentProcessor extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  public java.lang.String getName() {
    return genClient.cacheGet(CacheKey.name);
  }

  public java.lang.String getPaymentGatewayApi() {
    return genClient.cacheGet(CacheKey.paymentGatewayApi);
  }

  public java.lang.Boolean getProduction() {
    return genClient.cacheGet(CacheKey.production);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    name
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    paymentGatewayApi
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    production
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<PaymentProcessor> genClient;

  /**
   * Constructs a new empty instance.
   */
  public PaymentProcessor() {
    genClient = new GenericClient<PaymentProcessor>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected PaymentProcessor(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public PaymentProcessor(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public PaymentProcessor(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public PaymentProcessor(PaymentProcessor src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());

    genClient.validateLength(CacheKey.name, getName(), 127);

    genClient.validateLength(CacheKey.paymentGatewayApi, getPaymentGatewayApi(), 31);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return genClient.cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'paymentGatewayApi' field is set and is not null */
  public boolean isNotNullPaymentGatewayApi() {
    return genClient.cacheValueIsNotNull(CacheKey.paymentGatewayApi);
  }

  /** Checks whether the 'production' field is set and is not null */
  public boolean isNotNullProduction() {
    return genClient.cacheValueIsNotNull(CacheKey.production);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return genClient.cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'paymentGatewayApi' field has been set, however the value could be null */
  public boolean hasPaymentGatewayApi() {
    return genClient.cacheHasKey(CacheKey.paymentGatewayApi);
  }

  /** Checks whether the 'production' field has been set, however the value could be null */
  public boolean hasProduction() {
    return genClient.cacheHasKey(CacheKey.production);
  }


  /**
   * Sets the field 'id'.
   */
  public PaymentProcessor setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'name'.
   */
  public PaymentProcessor setName(java.lang.String name) {
    return genClient.setOther(name, CacheKey.name);
  }

  /**
   * Sets the field 'paymentGatewayApi'.
   */
  public PaymentProcessor setPaymentGatewayApi(java.lang.String paymentGatewayApi) {
    return genClient.setOther(paymentGatewayApi, CacheKey.paymentGatewayApi);
  }

  /**
   * Sets the field 'production'.
   */
  public PaymentProcessor setProduction(java.lang.Boolean production) {
    return genClient.setOther(production, CacheKey.production);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    genClient.clear(CacheKey.name);
  }
  /** Clears the 'paymentGatewayApi' field, the 'has' method for this field will now return false */
  public void clearPaymentGatewayApi() {
    genClient.clear(CacheKey.paymentGatewayApi);
  }
  /** Clears the 'production' field, the 'has' method for this field will now return false */
  public void clearProduction() {
    genClient.clear(CacheKey.production);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public PaymentProcessor copyChanges() {
    PaymentProcessor copy = new PaymentProcessor();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(PaymentProcessor src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new PaymentProcessor(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<PaymentProcessor> CREATOR = new android.os.Parcelable.Creator<PaymentProcessor>() {
    @Override
    public PaymentProcessor createFromParcel(android.os.Parcel in) {
      PaymentProcessor instance = new PaymentProcessor(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public PaymentProcessor[] newArray(int size) {
      return new PaymentProcessor[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<PaymentProcessor> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<PaymentProcessor>() {
    public Class<PaymentProcessor> getCreatedClass() {
      return PaymentProcessor.class;
    }

    @Override
    public PaymentProcessor create(org.json.JSONObject jsonObject) {
      return new PaymentProcessor(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean NAME_IS_REQUIRED = false;
    public static final long NAME_MAX_LEN = 127;
    public static final boolean PAYMENTGATEWAYAPI_IS_REQUIRED = false;
    public static final long PAYMENTGATEWAYAPI_MAX_LEN = 31;
    public static final boolean PRODUCTION_IS_REQUIRED = false;
  }

}
