/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.payment.raw.model;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getConfig config}</li>
 * <li>{@link #getTransactionType transactionType}</li>
 * <li>{@link #getAmount amount}</li>
 * <li>{@link #getCashbackAmount cashbackAmount}</li>
 * <li>{@link #getCurrencyCode currencyCode}</li>
 * <li>{@link #getCurrencyExponent currencyExponent}</li>
 * <li>{@link #getTransactionDate transactionDate}</li>
 * <li>{@link #getTransactionTime transactionTime}</li>
 * <li>{@link #getEmvData emvData}</li>
 * <li>{@link #getEmvTagList emvTagList}</li>
 * <li>{@link #getCardEntryMode cardEntryMode}</li>
 * <li>{@link #getTimeout timeout}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class GetCardDataRequest extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  public java.lang.String getConfig() {
    return genClient.cacheGet(CacheKey.config);
  }

  public java.lang.String getTransactionType() {
    return genClient.cacheGet(CacheKey.transactionType);
  }

  public java.lang.Long getAmount() {
    return genClient.cacheGet(CacheKey.amount);
  }

  public java.lang.Long getCashbackAmount() {
    return genClient.cacheGet(CacheKey.cashbackAmount);
  }

  public java.lang.Integer getCurrencyCode() {
    return genClient.cacheGet(CacheKey.currencyCode);
  }

  public java.lang.Integer getCurrencyExponent() {
    return genClient.cacheGet(CacheKey.currencyExponent);
  }

  public java.lang.String getTransactionDate() {
    return genClient.cacheGet(CacheKey.transactionDate);
  }

  public java.lang.String getTransactionTime() {
    return genClient.cacheGet(CacheKey.transactionTime);
  }

  public java.lang.String getEmvData() {
    return genClient.cacheGet(CacheKey.emvData);
  }

  public java.util.List<java.lang.String> getEmvTagList() {
    return genClient.cacheGet(CacheKey.emvTagList);
  }

  /**
   * Card Entry Mode supported for the transaction. Bits #1 indicates MAG_STRIPE, #2 indicates CONTACT, #3 indicates CONTACTLESS, #4 indicates MANUAL and #5 indicates VAULTED_CARD.
   */
  public java.lang.Integer getCardEntryMode() {
    return genClient.cacheGet(CacheKey.cardEntryMode);
  }

  public java.lang.Long getTimeout() {
    return genClient.cacheGet(CacheKey.timeout);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    config
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    transactionType
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    amount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    cashbackAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    currencyCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
    currencyExponent
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
    transactionDate
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    transactionTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    emvData
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    emvTagList
        (com.clover.sdk.extractors.BasicListExtractionStrategy.instance(java.lang.String.class)),
    cardEntryMode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
    timeout
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<GetCardDataRequest> genClient;

  /**
   * Constructs a new empty instance.
   */
  public GetCardDataRequest() {
    genClient = new GenericClient<GetCardDataRequest>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected GetCardDataRequest(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public GetCardDataRequest(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public GetCardDataRequest(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public GetCardDataRequest(GetCardDataRequest src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'config' field is set and is not null */
  public boolean isNotNullConfig() {
    return genClient.cacheValueIsNotNull(CacheKey.config);
  }

  /** Checks whether the 'transactionType' field is set and is not null */
  public boolean isNotNullTransactionType() {
    return genClient.cacheValueIsNotNull(CacheKey.transactionType);
  }

  /** Checks whether the 'amount' field is set and is not null */
  public boolean isNotNullAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.amount);
  }

  /** Checks whether the 'cashbackAmount' field is set and is not null */
  public boolean isNotNullCashbackAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.cashbackAmount);
  }

  /** Checks whether the 'currencyCode' field is set and is not null */
  public boolean isNotNullCurrencyCode() {
    return genClient.cacheValueIsNotNull(CacheKey.currencyCode);
  }

  /** Checks whether the 'currencyExponent' field is set and is not null */
  public boolean isNotNullCurrencyExponent() {
    return genClient.cacheValueIsNotNull(CacheKey.currencyExponent);
  }

  /** Checks whether the 'transactionDate' field is set and is not null */
  public boolean isNotNullTransactionDate() {
    return genClient.cacheValueIsNotNull(CacheKey.transactionDate);
  }

  /** Checks whether the 'transactionTime' field is set and is not null */
  public boolean isNotNullTransactionTime() {
    return genClient.cacheValueIsNotNull(CacheKey.transactionTime);
  }

  /** Checks whether the 'emvData' field is set and is not null */
  public boolean isNotNullEmvData() {
    return genClient.cacheValueIsNotNull(CacheKey.emvData);
  }

  /** Checks whether the 'emvTagList' field is set and is not null */
  public boolean isNotNullEmvTagList() {
    return genClient.cacheValueIsNotNull(CacheKey.emvTagList);
  }

  /** Checks whether the 'emvTagList' field is set and is not null and is not empty */
  public boolean isNotEmptyEmvTagList() { return isNotNullEmvTagList() && !getEmvTagList().isEmpty(); }

  /** Checks whether the 'cardEntryMode' field is set and is not null */
  public boolean isNotNullCardEntryMode() {
    return genClient.cacheValueIsNotNull(CacheKey.cardEntryMode);
  }

  /** Checks whether the 'timeout' field is set and is not null */
  public boolean isNotNullTimeout() {
    return genClient.cacheValueIsNotNull(CacheKey.timeout);
  }



  /** Checks whether the 'config' field has been set, however the value could be null */
  public boolean hasConfig() {
    return genClient.cacheHasKey(CacheKey.config);
  }

  /** Checks whether the 'transactionType' field has been set, however the value could be null */
  public boolean hasTransactionType() {
    return genClient.cacheHasKey(CacheKey.transactionType);
  }

  /** Checks whether the 'amount' field has been set, however the value could be null */
  public boolean hasAmount() {
    return genClient.cacheHasKey(CacheKey.amount);
  }

  /** Checks whether the 'cashbackAmount' field has been set, however the value could be null */
  public boolean hasCashbackAmount() {
    return genClient.cacheHasKey(CacheKey.cashbackAmount);
  }

  /** Checks whether the 'currencyCode' field has been set, however the value could be null */
  public boolean hasCurrencyCode() {
    return genClient.cacheHasKey(CacheKey.currencyCode);
  }

  /** Checks whether the 'currencyExponent' field has been set, however the value could be null */
  public boolean hasCurrencyExponent() {
    return genClient.cacheHasKey(CacheKey.currencyExponent);
  }

  /** Checks whether the 'transactionDate' field has been set, however the value could be null */
  public boolean hasTransactionDate() {
    return genClient.cacheHasKey(CacheKey.transactionDate);
  }

  /** Checks whether the 'transactionTime' field has been set, however the value could be null */
  public boolean hasTransactionTime() {
    return genClient.cacheHasKey(CacheKey.transactionTime);
  }

  /** Checks whether the 'emvData' field has been set, however the value could be null */
  public boolean hasEmvData() {
    return genClient.cacheHasKey(CacheKey.emvData);
  }

  /** Checks whether the 'emvTagList' field has been set, however the value could be null */
  public boolean hasEmvTagList() {
    return genClient.cacheHasKey(CacheKey.emvTagList);
  }

  /** Checks whether the 'cardEntryMode' field has been set, however the value could be null */
  public boolean hasCardEntryMode() {
    return genClient.cacheHasKey(CacheKey.cardEntryMode);
  }

  /** Checks whether the 'timeout' field has been set, however the value could be null */
  public boolean hasTimeout() {
    return genClient.cacheHasKey(CacheKey.timeout);
  }


  /**
   * Sets the field 'config'.
   */
  public GetCardDataRequest setConfig(java.lang.String config) {
    return genClient.setOther(config, CacheKey.config);
  }

  /**
   * Sets the field 'transactionType'.
   */
  public GetCardDataRequest setTransactionType(java.lang.String transactionType) {
    return genClient.setOther(transactionType, CacheKey.transactionType);
  }

  /**
   * Sets the field 'amount'.
   */
  public GetCardDataRequest setAmount(java.lang.Long amount) {
    return genClient.setOther(amount, CacheKey.amount);
  }

  /**
   * Sets the field 'cashbackAmount'.
   */
  public GetCardDataRequest setCashbackAmount(java.lang.Long cashbackAmount) {
    return genClient.setOther(cashbackAmount, CacheKey.cashbackAmount);
  }

  /**
   * Sets the field 'currencyCode'.
   */
  public GetCardDataRequest setCurrencyCode(java.lang.Integer currencyCode) {
    return genClient.setOther(currencyCode, CacheKey.currencyCode);
  }

  /**
   * Sets the field 'currencyExponent'.
   */
  public GetCardDataRequest setCurrencyExponent(java.lang.Integer currencyExponent) {
    return genClient.setOther(currencyExponent, CacheKey.currencyExponent);
  }

  /**
   * Sets the field 'transactionDate'.
   */
  public GetCardDataRequest setTransactionDate(java.lang.String transactionDate) {
    return genClient.setOther(transactionDate, CacheKey.transactionDate);
  }

  /**
   * Sets the field 'transactionTime'.
   */
  public GetCardDataRequest setTransactionTime(java.lang.String transactionTime) {
    return genClient.setOther(transactionTime, CacheKey.transactionTime);
  }

  /**
   * Sets the field 'emvData'.
   */
  public GetCardDataRequest setEmvData(java.lang.String emvData) {
    return genClient.setOther(emvData, CacheKey.emvData);
  }

  /**
   * Sets the field 'emvTagList'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public GetCardDataRequest setEmvTagList(java.util.List<java.lang.String> emvTagList) {
    return genClient.setArrayOther(emvTagList, CacheKey.emvTagList);
  }

  /**
   * Sets the field 'cardEntryMode'.
   */
  public GetCardDataRequest setCardEntryMode(java.lang.Integer cardEntryMode) {
    return genClient.setOther(cardEntryMode, CacheKey.cardEntryMode);
  }

  /**
   * Sets the field 'timeout'.
   */
  public GetCardDataRequest setTimeout(java.lang.Long timeout) {
    return genClient.setOther(timeout, CacheKey.timeout);
  }


  /** Clears the 'config' field, the 'has' method for this field will now return false */
  public void clearConfig() {
    genClient.clear(CacheKey.config);
  }
  /** Clears the 'transactionType' field, the 'has' method for this field will now return false */
  public void clearTransactionType() {
    genClient.clear(CacheKey.transactionType);
  }
  /** Clears the 'amount' field, the 'has' method for this field will now return false */
  public void clearAmount() {
    genClient.clear(CacheKey.amount);
  }
  /** Clears the 'cashbackAmount' field, the 'has' method for this field will now return false */
  public void clearCashbackAmount() {
    genClient.clear(CacheKey.cashbackAmount);
  }
  /** Clears the 'currencyCode' field, the 'has' method for this field will now return false */
  public void clearCurrencyCode() {
    genClient.clear(CacheKey.currencyCode);
  }
  /** Clears the 'currencyExponent' field, the 'has' method for this field will now return false */
  public void clearCurrencyExponent() {
    genClient.clear(CacheKey.currencyExponent);
  }
  /** Clears the 'transactionDate' field, the 'has' method for this field will now return false */
  public void clearTransactionDate() {
    genClient.clear(CacheKey.transactionDate);
  }
  /** Clears the 'transactionTime' field, the 'has' method for this field will now return false */
  public void clearTransactionTime() {
    genClient.clear(CacheKey.transactionTime);
  }
  /** Clears the 'emvData' field, the 'has' method for this field will now return false */
  public void clearEmvData() {
    genClient.clear(CacheKey.emvData);
  }
  /** Clears the 'emvTagList' field, the 'has' method for this field will now return false */
  public void clearEmvTagList() {
    genClient.clear(CacheKey.emvTagList);
  }
  /** Clears the 'cardEntryMode' field, the 'has' method for this field will now return false */
  public void clearCardEntryMode() {
    genClient.clear(CacheKey.cardEntryMode);
  }
  /** Clears the 'timeout' field, the 'has' method for this field will now return false */
  public void clearTimeout() {
    genClient.clear(CacheKey.timeout);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public GetCardDataRequest copyChanges() {
    GetCardDataRequest copy = new GetCardDataRequest();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(GetCardDataRequest src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new GetCardDataRequest(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<GetCardDataRequest> CREATOR = new android.os.Parcelable.Creator<GetCardDataRequest>() {
    @Override
    public GetCardDataRequest createFromParcel(android.os.Parcel in) {
      GetCardDataRequest instance = new GetCardDataRequest(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public GetCardDataRequest[] newArray(int size) {
      return new GetCardDataRequest[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<GetCardDataRequest> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<GetCardDataRequest>() {
    public Class<GetCardDataRequest> getCreatedClass() {
      return GetCardDataRequest.class;
    }

    @Override
    public GetCardDataRequest create(org.json.JSONObject jsonObject) {
      return new GetCardDataRequest(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean CONFIG_IS_REQUIRED = false;
    public static final boolean TRANSACTIONTYPE_IS_REQUIRED = false;
    public static final boolean AMOUNT_IS_REQUIRED = false;
    public static final boolean CASHBACKAMOUNT_IS_REQUIRED = false;
    public static final boolean CURRENCYCODE_IS_REQUIRED = false;
    public static final boolean CURRENCYEXPONENT_IS_REQUIRED = false;
    public static final boolean TRANSACTIONDATE_IS_REQUIRED = false;
    public static final boolean TRANSACTIONTIME_IS_REQUIRED = false;
    public static final boolean EMVDATA_IS_REQUIRED = false;
    public static final boolean EMVTAGLIST_IS_REQUIRED = false;
    public static final boolean CARDENTRYMODE_IS_REQUIRED = false;
    public static final boolean TIMEOUT_IS_REQUIRED = false;
  }

}
