/**
 * Autogenerated by Avro
 *
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.payments;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getMerchant merchant}</li>
 * <li>{@link #getType type}</li>
 * <li>{@link #getName name}</li>
 * <li>{@link #getAmount amount}</li>
 * <li>{@link #getPercentageDecimal percentageDecimal}</li>
 * <li>{@link #getIsCashbackOnly isCashbackOnly}</li>
 * <li>{@link #getPretax pretax}</li>
 * <li>{@link #getEnabled enabled}</li>
 * <li>{@link #getModifiedTime modifiedTime}</li>
 * <li>{@link #getDeletedTime deletedTime}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class AdditionalCharge extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * The merchant this charge belongs to
   */
  public com.clover.sdk.v3.merchant.Merchant getMerchant() {
    return genClient.cacheGet(CacheKey.merchant);
  }

  /**
   * The type of additional charge
   */
  public com.clover.sdk.v3.payments.AdditionalChargeType getType() {
    return genClient.cacheGet(CacheKey.type);
  }

  /**
   * Will be used for order fees to display name set by merchant
   */
  public java.lang.String getName() {
    return genClient.cacheGet(CacheKey.name);
  }

  /**
   * Optional flat charge amount
   */
  public java.lang.Long getAmount() {
    return genClient.cacheGet(CacheKey.amount);
  }

  /**
   * Optional percent to charge times 10000, e.g. 12.5% will be 125000
   */
  public java.lang.Long getPercentageDecimal() {
    return genClient.cacheGet(CacheKey.percentageDecimal);
  }

  /**
   * If this charge should only apply to transactions with cashback
   */
  public java.lang.Boolean getIsCashbackOnly() {
    return genClient.cacheGet(CacheKey.isCashbackOnly);
  }

  /**
   * If this charge should be applied pretax
   */
  public java.lang.Boolean getPretax() {
    return genClient.cacheGet(CacheKey.pretax);
  }

  /**
   * If this charge is enabled
   */
  public java.lang.Boolean getEnabled() {
    return genClient.cacheGet(CacheKey.enabled);
  }

  /**
   * Last modified time
   */
  public java.lang.Long getModifiedTime() {
    return genClient.cacheGet(CacheKey.modifiedTime);
  }

  /**
   * Deleted time
   */
  public java.lang.Long getDeletedTime() {
    return genClient.cacheGet(CacheKey.deletedTime);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    merchant
            (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.merchant.Merchant.JSON_CREATOR)),
    type
            (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.payments.AdditionalChargeType.class)),
    name
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    amount
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    percentageDecimal
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    isCashbackOnly
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    pretax
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    enabled
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    modifiedTime
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    deletedTime
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<AdditionalCharge> genClient;

  /**
   * Constructs a new empty instance.
   */
  public AdditionalCharge() {
    genClient = new GenericClient<AdditionalCharge>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected AdditionalCharge(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public AdditionalCharge(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public AdditionalCharge(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public AdditionalCharge(AdditionalCharge src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());

    genClient.validateMin(CacheKey.amount, getAmount(), 0L);

    genClient.validateMinMax(CacheKey.percentageDecimal, getPercentageDecimal(), 0L, 1000000L);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'merchant' field is set and is not null */
  public boolean isNotNullMerchant() {
    return genClient.cacheValueIsNotNull(CacheKey.merchant);
  }

  /** Checks whether the 'type' field is set and is not null */
  public boolean isNotNullType() {
    return genClient.cacheValueIsNotNull(CacheKey.type);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return genClient.cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'amount' field is set and is not null */
  public boolean isNotNullAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.amount);
  }

  /** Checks whether the 'percentageDecimal' field is set and is not null */
  public boolean isNotNullPercentageDecimal() {
    return genClient.cacheValueIsNotNull(CacheKey.percentageDecimal);
  }

  /** Checks whether the 'isCashbackOnly' field is set and is not null */
  public boolean isNotNullIsCashbackOnly() {
    return genClient.cacheValueIsNotNull(CacheKey.isCashbackOnly);
  }

  /** Checks whether the 'pretax' field is set and is not null */
  public boolean isNotNullPretax() {
    return genClient.cacheValueIsNotNull(CacheKey.pretax);
  }

  /** Checks whether the 'enabled' field is set and is not null */
  public boolean isNotNullEnabled() {
    return genClient.cacheValueIsNotNull(CacheKey.enabled);
  }

  /** Checks whether the 'modifiedTime' field is set and is not null */
  public boolean isNotNullModifiedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.modifiedTime);
  }

  /** Checks whether the 'deletedTime' field is set and is not null */
  public boolean isNotNullDeletedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.deletedTime);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'merchant' field has been set, however the value could be null */
  public boolean hasMerchant() {
    return genClient.cacheHasKey(CacheKey.merchant);
  }

  /** Checks whether the 'type' field has been set, however the value could be null */
  public boolean hasType() {
    return genClient.cacheHasKey(CacheKey.type);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return genClient.cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'amount' field has been set, however the value could be null */
  public boolean hasAmount() {
    return genClient.cacheHasKey(CacheKey.amount);
  }

  /** Checks whether the 'percentageDecimal' field has been set, however the value could be null */
  public boolean hasPercentageDecimal() {
    return genClient.cacheHasKey(CacheKey.percentageDecimal);
  }

  /** Checks whether the 'isCashbackOnly' field has been set, however the value could be null */
  public boolean hasIsCashbackOnly() {
    return genClient.cacheHasKey(CacheKey.isCashbackOnly);
  }

  /** Checks whether the 'pretax' field has been set, however the value could be null */
  public boolean hasPretax() {
    return genClient.cacheHasKey(CacheKey.pretax);
  }

  /** Checks whether the 'enabled' field has been set, however the value could be null */
  public boolean hasEnabled() {
    return genClient.cacheHasKey(CacheKey.enabled);
  }

  /** Checks whether the 'modifiedTime' field has been set, however the value could be null */
  public boolean hasModifiedTime() {
    return genClient.cacheHasKey(CacheKey.modifiedTime);
  }

  /** Checks whether the 'deletedTime' field has been set, however the value could be null */
  public boolean hasDeletedTime() {
    return genClient.cacheHasKey(CacheKey.deletedTime);
  }


  /**
   * Sets the field 'id'.
   */
  public AdditionalCharge setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'merchant'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public AdditionalCharge setMerchant(com.clover.sdk.v3.merchant.Merchant merchant) {
    return genClient.setRecord(merchant, CacheKey.merchant);
  }

  /**
   * Sets the field 'type'.
   */
  public AdditionalCharge setType(com.clover.sdk.v3.payments.AdditionalChargeType type) {
    return genClient.setOther(type, CacheKey.type);
  }

  /**
   * Sets the field 'name'.
   */
  public AdditionalCharge setName(java.lang.String name) {
    return genClient.setOther(name, CacheKey.name);
  }

  /**
   * Sets the field 'amount'.
   */
  public AdditionalCharge setAmount(java.lang.Long amount) {
    return genClient.setOther(amount, CacheKey.amount);
  }

  /**
   * Sets the field 'percentageDecimal'.
   */
  public AdditionalCharge setPercentageDecimal(java.lang.Long percentageDecimal) {
    return genClient.setOther(percentageDecimal, CacheKey.percentageDecimal);
  }

  /**
   * Sets the field 'isCashbackOnly'.
   */
  public AdditionalCharge setIsCashbackOnly(java.lang.Boolean isCashbackOnly) {
    return genClient.setOther(isCashbackOnly, CacheKey.isCashbackOnly);
  }

  /**
   * Sets the field 'pretax'.
   */
  public AdditionalCharge setPretax(java.lang.Boolean pretax) {
    return genClient.setOther(pretax, CacheKey.pretax);
  }

  /**
   * Sets the field 'enabled'.
   */
  public AdditionalCharge setEnabled(java.lang.Boolean enabled) {
    return genClient.setOther(enabled, CacheKey.enabled);
  }

  /**
   * Sets the field 'modifiedTime'.
   */
  public AdditionalCharge setModifiedTime(java.lang.Long modifiedTime) {
    return genClient.setOther(modifiedTime, CacheKey.modifiedTime);
  }

  /**
   * Sets the field 'deletedTime'.
   */
  public AdditionalCharge setDeletedTime(java.lang.Long deletedTime) {
    return genClient.setOther(deletedTime, CacheKey.deletedTime);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'merchant' field, the 'has' method for this field will now return false */
  public void clearMerchant() {
    genClient.clear(CacheKey.merchant);
  }
  /** Clears the 'type' field, the 'has' method for this field will now return false */
  public void clearType() {
    genClient.clear(CacheKey.type);
  }
  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    genClient.clear(CacheKey.name);
  }
  /** Clears the 'amount' field, the 'has' method for this field will now return false */
  public void clearAmount() {
    genClient.clear(CacheKey.amount);
  }
  /** Clears the 'percentageDecimal' field, the 'has' method for this field will now return false */
  public void clearPercentageDecimal() {
    genClient.clear(CacheKey.percentageDecimal);
  }
  /** Clears the 'isCashbackOnly' field, the 'has' method for this field will now return false */
  public void clearIsCashbackOnly() {
    genClient.clear(CacheKey.isCashbackOnly);
  }
  /** Clears the 'pretax' field, the 'has' method for this field will now return false */
  public void clearPretax() {
    genClient.clear(CacheKey.pretax);
  }
  /** Clears the 'enabled' field, the 'has' method for this field will now return false */
  public void clearEnabled() {
    genClient.clear(CacheKey.enabled);
  }
  /** Clears the 'modifiedTime' field, the 'has' method for this field will now return false */
  public void clearModifiedTime() {
    genClient.clear(CacheKey.modifiedTime);
  }
  /** Clears the 'deletedTime' field, the 'has' method for this field will now return false */
  public void clearDeletedTime() {
    genClient.clear(CacheKey.deletedTime);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public AdditionalCharge copyChanges() {
    AdditionalCharge copy = new AdditionalCharge();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(AdditionalCharge src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new AdditionalCharge(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<AdditionalCharge> CREATOR = new android.os.Parcelable.Creator<AdditionalCharge>() {
    @Override
    public AdditionalCharge createFromParcel(android.os.Parcel in) {
      AdditionalCharge instance = new AdditionalCharge(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public AdditionalCharge[] newArray(int size) {
      return new AdditionalCharge[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<AdditionalCharge> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<AdditionalCharge>() {
    public Class<AdditionalCharge> getCreatedClass() {
      return AdditionalCharge.class;
    }

    @Override
    public AdditionalCharge create(org.json.JSONObject jsonObject) {
      return new AdditionalCharge(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean MERCHANT_IS_REQUIRED = false;
    public static final boolean TYPE_IS_REQUIRED = false;
    public static final boolean NAME_IS_REQUIRED = false;
    public static final boolean AMOUNT_IS_REQUIRED = false;
    public static final long AMOUNT_MIN = 0;
    public static final boolean PERCENTAGEDECIMAL_IS_REQUIRED = false;
    public static final long PERCENTAGEDECIMAL_MIN = 0;
    public static final long PERCENTAGEDECIMAL_MAX = 1000000;
    public static final boolean ISCASHBACKONLY_IS_REQUIRED = false;
    public static final boolean PRETAX_IS_REQUIRED = false;
    public static final boolean ENABLED_IS_REQUIRED = false;
    public static final boolean MODIFIEDTIME_IS_REQUIRED = false;
    public static final boolean DELETEDTIME_IS_REQUIRED = false;
  }

}
