/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.payments;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getMerchant merchant}</li>
 * <li>{@link #getLabel label}</li>
 * <li>{@link #getLabelKey labelKey}</li>
 * <li>{@link #getOrdinal ordinal}</li>
 * <li>{@link #getCreatedTime createdTime}</li>
 * <li>{@link #getModifiedTime modifiedTime}</li>
 * <li>{@link #getDeletedTime deletedTime}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class AnomalyReasons extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  public String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * The merchant this charge belongs to
   */
  public com.clover.sdk.v3.base.Reference getMerchant() {
    return genClient.cacheGet(CacheKey.merchant);
  }

  /**
   * Reason for void/refund
   */
  public String getLabel() {
    return genClient.cacheGet(CacheKey.label);
  }

  /**
   * Label Key for localization
   */
  public String getLabelKey() {
    return genClient.cacheGet(CacheKey.labelKey);
  }

  public Long getOrdinal() {
    return genClient.cacheGet(CacheKey.ordinal);
  }

  public Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.createdTime);
  }

  public Long getModifiedTime() {
    return genClient.cacheGet(CacheKey.modifiedTime);
  }

  /**
   * Deleted time
   */
  public Long getDeletedTime() {
    return genClient.cacheGet(CacheKey.deletedTime);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    merchant
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    label
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    labelKey
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    ordinal
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
    createdTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
    modifiedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
    deletedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<AnomalyReasons> genClient;

  /**
   * Constructs a new empty instance.
   */
  public AnomalyReasons() {
    genClient = new GenericClient<AnomalyReasons>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected AnomalyReasons(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public AnomalyReasons(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public AnomalyReasons(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public AnomalyReasons(AnomalyReasons src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());

    genClient.validateLength(CacheKey.label, getLabel(), 255);

    genClient.validateLength(CacheKey.labelKey, getLabelKey(), 255);
    genClient.validateReferences(CacheKey.merchant);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'merchant' field is set and is not null */
  public boolean isNotNullMerchant() {
    return genClient.cacheValueIsNotNull(CacheKey.merchant);
  }

  /** Checks whether the 'label' field is set and is not null */
  public boolean isNotNullLabel() {
    return genClient.cacheValueIsNotNull(CacheKey.label);
  }

  /** Checks whether the 'labelKey' field is set and is not null */
  public boolean isNotNullLabelKey() {
    return genClient.cacheValueIsNotNull(CacheKey.labelKey);
  }

  /** Checks whether the 'ordinal' field is set and is not null */
  public boolean isNotNullOrdinal() {
    return genClient.cacheValueIsNotNull(CacheKey.ordinal);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field is set and is not null */
  public boolean isNotNullModifiedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.modifiedTime);
  }

  /** Checks whether the 'deletedTime' field is set and is not null */
  public boolean isNotNullDeletedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.deletedTime);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'merchant' field has been set, however the value could be null */
  public boolean hasMerchant() {
    return genClient.cacheHasKey(CacheKey.merchant);
  }

  /** Checks whether the 'label' field has been set, however the value could be null */
  public boolean hasLabel() {
    return genClient.cacheHasKey(CacheKey.label);
  }

  /** Checks whether the 'labelKey' field has been set, however the value could be null */
  public boolean hasLabelKey() {
    return genClient.cacheHasKey(CacheKey.labelKey);
  }

  /** Checks whether the 'ordinal' field has been set, however the value could be null */
  public boolean hasOrdinal() {
    return genClient.cacheHasKey(CacheKey.ordinal);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field has been set, however the value could be null */
  public boolean hasModifiedTime() {
    return genClient.cacheHasKey(CacheKey.modifiedTime);
  }

  /** Checks whether the 'deletedTime' field has been set, however the value could be null */
  public boolean hasDeletedTime() {
    return genClient.cacheHasKey(CacheKey.deletedTime);
  }


  /**
   * Sets the field 'id'.
   */
  public AnomalyReasons setId(String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'merchant'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public AnomalyReasons setMerchant(com.clover.sdk.v3.base.Reference merchant) {
    return genClient.setRecord(merchant, CacheKey.merchant);
  }

  /**
   * Sets the field 'label'.
   */
  public AnomalyReasons setLabel(String label) {
    return genClient.setOther(label, CacheKey.label);
  }

  /**
   * Sets the field 'labelKey'.
   */
  public AnomalyReasons setLabelKey(String labelKey) {
    return genClient.setOther(labelKey, CacheKey.labelKey);
  }

  /**
   * Sets the field 'ordinal'.
   */
  public AnomalyReasons setOrdinal(Long ordinal) {
    return genClient.setOther(ordinal, CacheKey.ordinal);
  }

  /**
   * Sets the field 'createdTime'.
   */
  public AnomalyReasons setCreatedTime(Long createdTime) {
    return genClient.setOther(createdTime, CacheKey.createdTime);
  }

  /**
   * Sets the field 'modifiedTime'.
   */
  public AnomalyReasons setModifiedTime(Long modifiedTime) {
    return genClient.setOther(modifiedTime, CacheKey.modifiedTime);
  }

  /**
   * Sets the field 'deletedTime'.
   */
  public AnomalyReasons setDeletedTime(Long deletedTime) {
    return genClient.setOther(deletedTime, CacheKey.deletedTime);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'merchant' field, the 'has' method for this field will now return false */
  public void clearMerchant() {
    genClient.clear(CacheKey.merchant);
  }
  /** Clears the 'label' field, the 'has' method for this field will now return false */
  public void clearLabel() {
    genClient.clear(CacheKey.label);
  }
  /** Clears the 'labelKey' field, the 'has' method for this field will now return false */
  public void clearLabelKey() {
    genClient.clear(CacheKey.labelKey);
  }
  /** Clears the 'ordinal' field, the 'has' method for this field will now return false */
  public void clearOrdinal() {
    genClient.clear(CacheKey.ordinal);
  }
  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.createdTime);
  }
  /** Clears the 'modifiedTime' field, the 'has' method for this field will now return false */
  public void clearModifiedTime() {
    genClient.clear(CacheKey.modifiedTime);
  }
  /** Clears the 'deletedTime' field, the 'has' method for this field will now return false */
  public void clearDeletedTime() {
    genClient.clear(CacheKey.deletedTime);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public AnomalyReasons copyChanges() {
    AnomalyReasons copy = new AnomalyReasons();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(AnomalyReasons src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new AnomalyReasons(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<AnomalyReasons> CREATOR = new android.os.Parcelable.Creator<AnomalyReasons>() {
    @Override
    public AnomalyReasons createFromParcel(android.os.Parcel in) {
      AnomalyReasons instance = new AnomalyReasons(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public AnomalyReasons[] newArray(int size) {
      return new AnomalyReasons[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<AnomalyReasons> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<AnomalyReasons>() {
    public Class<AnomalyReasons> getCreatedClass() {
      return AnomalyReasons.class;
    }

    @Override
    public AnomalyReasons create(org.json.JSONObject jsonObject) {
      return new AnomalyReasons(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 100;
    public static final boolean MERCHANT_IS_REQUIRED = false;
    public static final boolean LABEL_IS_REQUIRED = false;
    public static final long LABEL_MAX_LEN = 255;
    public static final boolean LABELKEY_IS_REQUIRED = false;
    public static final long LABELKEY_MAX_LEN = 255;
    public static final boolean ORDINAL_IS_REQUIRED = false;
    public static final boolean CREATEDTIME_IS_REQUIRED = false;
    public static final boolean MODIFIEDTIME_IS_REQUIRED = false;
    public static final boolean DELETEDTIME_IS_REQUIRED = false;
  }

}
