/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.payments;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getPaymentIds paymentIds}</li>
 * <li>{@link #getRefundIds refundIds}</li>
 * <li>{@link #getCreditIds creditIds}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class BatchTransactions extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * List of payments in the batch
   */
  public java.util.List<java.lang.String> getPaymentIds() {
    return genClient.cacheGet(CacheKey.paymentIds);
  }

  /**
   * List of refunds in the batch
   */
  public java.util.List<java.lang.String> getRefundIds() {
    return genClient.cacheGet(CacheKey.refundIds);
  }

  /**
   * List of credits in the batch
   */
  public java.util.List<java.lang.String> getCreditIds() {
    return genClient.cacheGet(CacheKey.creditIds);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    paymentIds
        (com.clover.sdk.extractors.BasicListExtractionStrategy.instance(java.lang.String.class)),
    refundIds
        (com.clover.sdk.extractors.BasicListExtractionStrategy.instance(java.lang.String.class)),
    creditIds
        (com.clover.sdk.extractors.BasicListExtractionStrategy.instance(java.lang.String.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<BatchTransactions> genClient;

  /**
   * Constructs a new empty instance.
   */
  public BatchTransactions() {
    genClient = new GenericClient<BatchTransactions>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected BatchTransactions(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public BatchTransactions(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public BatchTransactions(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public BatchTransactions(BatchTransactions src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'paymentIds' field is set and is not null */
  public boolean isNotNullPaymentIds() {
    return genClient.cacheValueIsNotNull(CacheKey.paymentIds);
  }

  /** Checks whether the 'paymentIds' field is set and is not null and is not empty */
  public boolean isNotEmptyPaymentIds() { return isNotNullPaymentIds() && !getPaymentIds().isEmpty(); }

  /** Checks whether the 'refundIds' field is set and is not null */
  public boolean isNotNullRefundIds() {
    return genClient.cacheValueIsNotNull(CacheKey.refundIds);
  }

  /** Checks whether the 'refundIds' field is set and is not null and is not empty */
  public boolean isNotEmptyRefundIds() { return isNotNullRefundIds() && !getRefundIds().isEmpty(); }

  /** Checks whether the 'creditIds' field is set and is not null */
  public boolean isNotNullCreditIds() {
    return genClient.cacheValueIsNotNull(CacheKey.creditIds);
  }

  /** Checks whether the 'creditIds' field is set and is not null and is not empty */
  public boolean isNotEmptyCreditIds() { return isNotNullCreditIds() && !getCreditIds().isEmpty(); }



  /** Checks whether the 'paymentIds' field has been set, however the value could be null */
  public boolean hasPaymentIds() {
    return genClient.cacheHasKey(CacheKey.paymentIds);
  }

  /** Checks whether the 'refundIds' field has been set, however the value could be null */
  public boolean hasRefundIds() {
    return genClient.cacheHasKey(CacheKey.refundIds);
  }

  /** Checks whether the 'creditIds' field has been set, however the value could be null */
  public boolean hasCreditIds() {
    return genClient.cacheHasKey(CacheKey.creditIds);
  }


  /**
   * Sets the field 'paymentIds'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public BatchTransactions setPaymentIds(java.util.List<java.lang.String> paymentIds) {
    return genClient.setArrayOther(paymentIds, CacheKey.paymentIds);
  }

  /**
   * Sets the field 'refundIds'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public BatchTransactions setRefundIds(java.util.List<java.lang.String> refundIds) {
    return genClient.setArrayOther(refundIds, CacheKey.refundIds);
  }

  /**
   * Sets the field 'creditIds'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public BatchTransactions setCreditIds(java.util.List<java.lang.String> creditIds) {
    return genClient.setArrayOther(creditIds, CacheKey.creditIds);
  }


  /** Clears the 'paymentIds' field, the 'has' method for this field will now return false */
  public void clearPaymentIds() {
    genClient.clear(CacheKey.paymentIds);
  }
  /** Clears the 'refundIds' field, the 'has' method for this field will now return false */
  public void clearRefundIds() {
    genClient.clear(CacheKey.refundIds);
  }
  /** Clears the 'creditIds' field, the 'has' method for this field will now return false */
  public void clearCreditIds() {
    genClient.clear(CacheKey.creditIds);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public BatchTransactions copyChanges() {
    BatchTransactions copy = new BatchTransactions();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(BatchTransactions src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new BatchTransactions(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<BatchTransactions> CREATOR = new android.os.Parcelable.Creator<BatchTransactions>() {
    @Override
    public BatchTransactions createFromParcel(android.os.Parcel in) {
      BatchTransactions instance = new BatchTransactions(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public BatchTransactions[] newArray(int size) {
      return new BatchTransactions[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<BatchTransactions> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<BatchTransactions>() {
    public Class<BatchTransactions> getCreatedClass() {
      return BatchTransactions.class;
    }

    @Override
    public BatchTransactions create(org.json.JSONObject jsonObject) {
      return new BatchTransactions(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean PAYMENTIDS_IS_REQUIRED = false;
    public static final boolean REFUNDIDS_IS_REQUIRED = false;
    public static final boolean CREDITIDS_IS_REQUIRED = false;
  }

}
