/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.payments;


import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getInquiryRateId inquiryRateId}</li>
 * <li>{@link #getDccApplied dccApplied}</li>
 * <li>{@link #getForeignCurrencyCode foreignCurrencyCode}</li>
 * <li>{@link #getForeignAmount foreignAmount}</li>
 * <li>{@link #getExchangeRate exchangeRate}</li>
 * <li>{@link #getMarginRatePercentage marginRatePercentage}</li>
 * <li>{@link #getExchangeRateSourceName exchangeRateSourceName}</li>
 * <li>{@link #getExchangeRateSourceTimeStamp exchangeRateSourceTimeStamp}</li>
 * <li>{@link #getDccEligible dccEligible}</li>
 * <li>{@link #getExchangeRateId exchangeRateId}</li>
 * <li>{@link #getRateRequestId rateRequestId}</li>
 * <li>{@link #getBaseAmount baseAmount}</li>
 * <li>{@link #getBaseCurrencyCode baseCurrencyCode}</li>
 * <li>{@link #getValidUntil validUntil}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class DCCInfo extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Inquiry Rate ID (IPG)
   */
  public java.lang.Long getInquiryRateId() {
    return genClient.cacheGet(CacheKey.inquiryRateId);
  }

  /**
   * Flag indicating whether DCC was applied on this txn
   */
  public java.lang.Boolean getDccApplied() {
    return genClient.cacheGet(CacheKey.dccApplied);
  }

  /**
   * Foreign currency code
   */
  public java.lang.String getForeignCurrencyCode() {
    return genClient.cacheGet(CacheKey.foreignCurrencyCode);
  }

  /**
   * Foreign (transaction) amount
   */
  public java.lang.Long getForeignAmount() {
    return genClient.cacheGet(CacheKey.foreignAmount);
  }

  /**
   * Exchange Rate
   */
  public java.lang.Double getExchangeRate() {
    return genClient.cacheGet(CacheKey.exchangeRate);
  }

  /**
   * Margin Rate Percentage
   */
  public java.lang.String getMarginRatePercentage() {
    return genClient.cacheGet(CacheKey.marginRatePercentage);
  }

  /**
   * Exchange Rate Source Name
   */
  public java.lang.String getExchangeRateSourceName() {
    return genClient.cacheGet(CacheKey.exchangeRateSourceName);
  }

  /**
   * Exchange Rate Source Timestamp
   */
  public java.lang.String getExchangeRateSourceTimeStamp() {
    return genClient.cacheGet(CacheKey.exchangeRateSourceTimeStamp);
  }

  /**
   * Flag indicating whether DCC was offered on this txn
   */
  public java.lang.Boolean getDccEligible() {
    return genClient.cacheGet(CacheKey.dccEligible);
  }

  /**
   * Exchange rate from the rate request
   */
  public java.lang.String getExchangeRateId() {
    return genClient.cacheGet(CacheKey.exchangeRateId);
  }

  /**
   * Rate request id from the rate request
   */
  public java.lang.String getRateRequestId() {
    return genClient.cacheGet(CacheKey.rateRequestId);
  }

  /**
   * Amount sent for exchange in rate request
   */
  public java.lang.Long getBaseAmount() {
    return genClient.cacheGet(CacheKey.baseAmount);
  }

  /**
   * Alpha currency code for foreign currency
   */
  public java.lang.String getBaseCurrencyCode() {
    return genClient.cacheGet(CacheKey.baseCurrencyCode);
  }

  /**
   * Date until the DCC rate is guaranteed by the host.
   */
  public java.lang.Long getValidUntil() {
    return genClient.cacheGet(CacheKey.validUntil);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    inquiryRateId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    dccApplied
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    foreignCurrencyCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    foreignAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    exchangeRate
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Double.class)),
    marginRatePercentage
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    exchangeRateSourceName
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    exchangeRateSourceTimeStamp
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    dccEligible
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    exchangeRateId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    rateRequestId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    baseAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    baseCurrencyCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    validUntil
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<DCCInfo> genClient;

  /**
   * Constructs a new empty instance.
   */
  public DCCInfo() {
    genClient = new GenericClient<DCCInfo>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected DCCInfo(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public DCCInfo(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public DCCInfo(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public DCCInfo(DCCInfo src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {

    genClient.validateLength(CacheKey.foreignCurrencyCode, getForeignCurrencyCode(), 3);
  }

  /** Checks whether the 'inquiryRateId' field is set and is not null */
  public boolean isNotNullInquiryRateId() {
    return genClient.cacheValueIsNotNull(CacheKey.inquiryRateId);
  }

  /** Checks whether the 'dccApplied' field is set and is not null */
  public boolean isNotNullDccApplied() {
    return genClient.cacheValueIsNotNull(CacheKey.dccApplied);
  }

  /** Checks whether the 'foreignCurrencyCode' field is set and is not null */
  public boolean isNotNullForeignCurrencyCode() {
    return genClient.cacheValueIsNotNull(CacheKey.foreignCurrencyCode);
  }

  /** Checks whether the 'foreignAmount' field is set and is not null */
  public boolean isNotNullForeignAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.foreignAmount);
  }

  /** Checks whether the 'exchangeRate' field is set and is not null */
  public boolean isNotNullExchangeRate() {
    return genClient.cacheValueIsNotNull(CacheKey.exchangeRate);
  }

  /** Checks whether the 'marginRatePercentage' field is set and is not null */
  public boolean isNotNullMarginRatePercentage() {
    return genClient.cacheValueIsNotNull(CacheKey.marginRatePercentage);
  }

  /** Checks whether the 'exchangeRateSourceName' field is set and is not null */
  public boolean isNotNullExchangeRateSourceName() {
    return genClient.cacheValueIsNotNull(CacheKey.exchangeRateSourceName);
  }

  /** Checks whether the 'exchangeRateSourceTimeStamp' field is set and is not null */
  public boolean isNotNullExchangeRateSourceTimeStamp() {
    return genClient.cacheValueIsNotNull(CacheKey.exchangeRateSourceTimeStamp);
  }

  /** Checks whether the 'dccEligible' field is set and is not null */
  public boolean isNotNullDccEligible() {
    return genClient.cacheValueIsNotNull(CacheKey.dccEligible);
  }

  /** Checks whether the 'exchangeRateId' field is set and is not null */
  public boolean isNotNullExchangeRateId() {
    return genClient.cacheValueIsNotNull(CacheKey.exchangeRateId);
  }

  /** Checks whether the 'rateRequestId' field is set and is not null */
  public boolean isNotNullRateRequestId() {
    return genClient.cacheValueIsNotNull(CacheKey.rateRequestId);
  }

  /** Checks whether the 'baseAmount' field is set and is not null */
  public boolean isNotNullBaseAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.baseAmount);
  }

  /** Checks whether the 'baseCurrencyCode' field is set and is not null */
  public boolean isNotNullBaseCurrencyCode() {
    return genClient.cacheValueIsNotNull(CacheKey.baseCurrencyCode);
  }

  /** Checks whether the 'validUntil' field is set and is not null */
  public boolean isNotNullValidUntil() {
    return genClient.cacheValueIsNotNull(CacheKey.validUntil);
  }



  /** Checks whether the 'inquiryRateId' field has been set, however the value could be null */
  public boolean hasInquiryRateId() {
    return genClient.cacheHasKey(CacheKey.inquiryRateId);
  }

  /** Checks whether the 'dccApplied' field has been set, however the value could be null */
  public boolean hasDccApplied() {
    return genClient.cacheHasKey(CacheKey.dccApplied);
  }

  /** Checks whether the 'foreignCurrencyCode' field has been set, however the value could be null */
  public boolean hasForeignCurrencyCode() {
    return genClient.cacheHasKey(CacheKey.foreignCurrencyCode);
  }

  /** Checks whether the 'foreignAmount' field has been set, however the value could be null */
  public boolean hasForeignAmount() {
    return genClient.cacheHasKey(CacheKey.foreignAmount);
  }

  /** Checks whether the 'exchangeRate' field has been set, however the value could be null */
  public boolean hasExchangeRate() {
    return genClient.cacheHasKey(CacheKey.exchangeRate);
  }

  /** Checks whether the 'marginRatePercentage' field has been set, however the value could be null */
  public boolean hasMarginRatePercentage() {
    return genClient.cacheHasKey(CacheKey.marginRatePercentage);
  }

  /** Checks whether the 'exchangeRateSourceName' field has been set, however the value could be null */
  public boolean hasExchangeRateSourceName() {
    return genClient.cacheHasKey(CacheKey.exchangeRateSourceName);
  }

  /** Checks whether the 'exchangeRateSourceTimeStamp' field has been set, however the value could be null */
  public boolean hasExchangeRateSourceTimeStamp() {
    return genClient.cacheHasKey(CacheKey.exchangeRateSourceTimeStamp);
  }

  /** Checks whether the 'dccEligible' field has been set, however the value could be null */
  public boolean hasDccEligible() {
    return genClient.cacheHasKey(CacheKey.dccEligible);
  }

  /** Checks whether the 'exchangeRateId' field has been set, however the value could be null */
  public boolean hasExchangeRateId() {
    return genClient.cacheHasKey(CacheKey.exchangeRateId);
  }

  /** Checks whether the 'rateRequestId' field has been set, however the value could be null */
  public boolean hasRateRequestId() {
    return genClient.cacheHasKey(CacheKey.rateRequestId);
  }

  /** Checks whether the 'baseAmount' field has been set, however the value could be null */
  public boolean hasBaseAmount() {
    return genClient.cacheHasKey(CacheKey.baseAmount);
  }

  /** Checks whether the 'baseCurrencyCode' field has been set, however the value could be null */
  public boolean hasBaseCurrencyCode() {
    return genClient.cacheHasKey(CacheKey.baseCurrencyCode);
  }

  /** Checks whether the 'validUntil' field has been set, however the value could be null */
  public boolean hasValidUntil() {
    return genClient.cacheHasKey(CacheKey.validUntil);
  }


  /**
   * Sets the field 'inquiryRateId'.
   */
  public DCCInfo setInquiryRateId(java.lang.Long inquiryRateId) {
    return genClient.setOther(inquiryRateId, CacheKey.inquiryRateId);
  }

  /**
   * Sets the field 'dccApplied'.
   */
  public DCCInfo setDccApplied(java.lang.Boolean dccApplied) {
    return genClient.setOther(dccApplied, CacheKey.dccApplied);
  }

  /**
   * Sets the field 'foreignCurrencyCode'.
   */
  public DCCInfo setForeignCurrencyCode(java.lang.String foreignCurrencyCode) {
    return genClient.setOther(foreignCurrencyCode, CacheKey.foreignCurrencyCode);
  }

  /**
   * Sets the field 'foreignAmount'.
   */
  public DCCInfo setForeignAmount(java.lang.Long foreignAmount) {
    return genClient.setOther(foreignAmount, CacheKey.foreignAmount);
  }

  /**
   * Sets the field 'exchangeRate'.
   */
  public DCCInfo setExchangeRate(java.lang.Double exchangeRate) {
    return genClient.setOther(exchangeRate, CacheKey.exchangeRate);
  }

  /**
   * Sets the field 'marginRatePercentage'.
   */
  public DCCInfo setMarginRatePercentage(java.lang.String marginRatePercentage) {
    return genClient.setOther(marginRatePercentage, CacheKey.marginRatePercentage);
  }

  /**
   * Sets the field 'exchangeRateSourceName'.
   */
  public DCCInfo setExchangeRateSourceName(java.lang.String exchangeRateSourceName) {
    return genClient.setOther(exchangeRateSourceName, CacheKey.exchangeRateSourceName);
  }

  /**
   * Sets the field 'exchangeRateSourceTimeStamp'.
   */
  public DCCInfo setExchangeRateSourceTimeStamp(java.lang.String exchangeRateSourceTimeStamp) {
    return genClient.setOther(exchangeRateSourceTimeStamp, CacheKey.exchangeRateSourceTimeStamp);
  }

  /**
   * Sets the field 'dccEligible'.
   */
  public DCCInfo setDccEligible(java.lang.Boolean dccEligible) {
    return genClient.setOther(dccEligible, CacheKey.dccEligible);
  }

  /**
   * Sets the field 'exchangeRateId'.
   */
  public DCCInfo setExchangeRateId(java.lang.String exchangeRateId) {
    return genClient.setOther(exchangeRateId, CacheKey.exchangeRateId);
  }

  /**
   * Sets the field 'rateRequestId'.
   */
  public DCCInfo setRateRequestId(java.lang.String rateRequestId) {
    return genClient.setOther(rateRequestId, CacheKey.rateRequestId);
  }

  /**
   * Sets the field 'baseAmount'.
   */
  public DCCInfo setBaseAmount(java.lang.Long baseAmount) {
    return genClient.setOther(baseAmount, CacheKey.baseAmount);
  }

  /**
   * Sets the field 'baseCurrencyCode'.
   */
  public DCCInfo setBaseCurrencyCode(java.lang.String baseCurrencyCode) {
    return genClient.setOther(baseCurrencyCode, CacheKey.baseCurrencyCode);
  }

  /**
   * Sets the field 'validUntil'.
   */
  public DCCInfo setValidUntil(java.lang.Long validUntil) {
    return genClient.setOther(validUntil, CacheKey.validUntil);
  }


  /** Clears the 'inquiryRateId' field, the 'has' method for this field will now return false */
  public void clearInquiryRateId() {
    genClient.clear(CacheKey.inquiryRateId);
  }
  /** Clears the 'dccApplied' field, the 'has' method for this field will now return false */
  public void clearDccApplied() {
    genClient.clear(CacheKey.dccApplied);
  }
  /** Clears the 'foreignCurrencyCode' field, the 'has' method for this field will now return false */
  public void clearForeignCurrencyCode() {
    genClient.clear(CacheKey.foreignCurrencyCode);
  }
  /** Clears the 'foreignAmount' field, the 'has' method for this field will now return false */
  public void clearForeignAmount() {
    genClient.clear(CacheKey.foreignAmount);
  }
  /** Clears the 'exchangeRate' field, the 'has' method for this field will now return false */
  public void clearExchangeRate() {
    genClient.clear(CacheKey.exchangeRate);
  }
  /** Clears the 'marginRatePercentage' field, the 'has' method for this field will now return false */
  public void clearMarginRatePercentage() {
    genClient.clear(CacheKey.marginRatePercentage);
  }
  /** Clears the 'exchangeRateSourceName' field, the 'has' method for this field will now return false */
  public void clearExchangeRateSourceName() {
    genClient.clear(CacheKey.exchangeRateSourceName);
  }
  /** Clears the 'exchangeRateSourceTimeStamp' field, the 'has' method for this field will now return false */
  public void clearExchangeRateSourceTimeStamp() {
    genClient.clear(CacheKey.exchangeRateSourceTimeStamp);
  }
  /** Clears the 'dccEligible' field, the 'has' method for this field will now return false */
  public void clearDccEligible() {
    genClient.clear(CacheKey.dccEligible);
  }
  /** Clears the 'exchangeRateId' field, the 'has' method for this field will now return false */
  public void clearExchangeRateId() {
    genClient.clear(CacheKey.exchangeRateId);
  }
  /** Clears the 'rateRequestId' field, the 'has' method for this field will now return false */
  public void clearRateRequestId() {
    genClient.clear(CacheKey.rateRequestId);
  }
  /** Clears the 'baseAmount' field, the 'has' method for this field will now return false */
  public void clearBaseAmount() {
    genClient.clear(CacheKey.baseAmount);
  }
  /** Clears the 'baseCurrencyCode' field, the 'has' method for this field will now return false */
  public void clearBaseCurrencyCode() {
    genClient.clear(CacheKey.baseCurrencyCode);
  }
  /** Clears the 'validUntil' field, the 'has' method for this field will now return false */
  public void clearValidUntil() {
    genClient.clear(CacheKey.validUntil);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public DCCInfo copyChanges() {
    DCCInfo copy = new DCCInfo();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(DCCInfo src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new DCCInfo(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<DCCInfo> CREATOR = new android.os.Parcelable.Creator<DCCInfo>() {
    @Override
    public DCCInfo createFromParcel(android.os.Parcel in) {
      DCCInfo instance = new DCCInfo(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public DCCInfo[] newArray(int size) {
      return new DCCInfo[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<DCCInfo> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<DCCInfo>() {
    public Class<DCCInfo> getCreatedClass() {
      return DCCInfo.class;
    }

    @Override
    public DCCInfo create(org.json.JSONObject jsonObject) {
      return new DCCInfo(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean INQUIRYRATEID_IS_REQUIRED = false;
    public static final boolean DCCAPPLIED_IS_REQUIRED = false;
    public static final boolean FOREIGNCURRENCYCODE_IS_REQUIRED = false;
    public static final long FOREIGNCURRENCYCODE_MAX_LEN = 3;
    public static final boolean FOREIGNAMOUNT_IS_REQUIRED = false;
    public static final boolean EXCHANGERATE_IS_REQUIRED = false;
    public static final boolean MARGINRATEPERCENTAGE_IS_REQUIRED = false;
    public static final boolean EXCHANGERATESOURCENAME_IS_REQUIRED = false;
    public static final boolean EXCHANGERATESOURCETIMESTAMP_IS_REQUIRED = false;
    public static final boolean DCCELIGIBLE_IS_REQUIRED = false;
    public static final boolean EXCHANGERATEID_IS_REQUIRED = false;
    public static final boolean RATEREQUESTID_IS_REQUIRED = false;
    public static final boolean BASEAMOUNT_IS_REQUIRED = false;
    public static final boolean BASECURRENCYCODE_IS_REQUIRED = false;
    public static final boolean VALIDUNTIL_IS_REQUIRED = false;
  }

}
