/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.payments;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getDeviceId deviceId}</li>
 * <li>{@link #getDeviceSerial deviceSerial}</li>
 * <li>{@link #getDeviceName deviceName}</li>
 * <li>{@link #getTerminalId terminalId}</li>
 * <li>{@link #getSales sales}</li>
 * <li>{@link #getRefunds refunds}</li>
 * <li>{@link #getNet net}</li>
 * <li>{@link #getGiftCardLoads giftCardLoads}</li>
 * <li>{@link #getGiftCardCashOuts giftCardCashOuts}</li>
 * <li>{@link #getTax tax}</li>
 * <li>{@link #getTips tips}</li>
 * <li>{@link #getCardTotals cardTotals}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class DeviceTotalStats extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Device ID corresponding to these stats
   */
  public java.lang.Long getDeviceId() {
    return genClient.cacheGet(CacheKey.deviceId);
  }

  /**
   * Device serial number corresponding to these stats
   */
  public java.lang.String getDeviceSerial() {
    return genClient.cacheGet(CacheKey.deviceSerial);
  }

  /**
   * Device name corresponding to these stats
   */
  public java.lang.String getDeviceName() {
    return genClient.cacheGet(CacheKey.deviceName);
  }

  /**
   * Terminal ID of Device corresponding to these stats
   */
  public java.lang.String getTerminalId() {
    return genClient.cacheGet(CacheKey.terminalId);
  }

  public com.clover.sdk.v3.payments.BatchTotalType getSales() {
    return genClient.cacheGet(CacheKey.sales);
  }

  public com.clover.sdk.v3.payments.BatchTotalType getRefunds() {
    return genClient.cacheGet(CacheKey.refunds);
  }

  public com.clover.sdk.v3.payments.BatchTotalType getNet() {
    return genClient.cacheGet(CacheKey.net);
  }

  public com.clover.sdk.v3.payments.BatchTotalType getGiftCardLoads() {
    return genClient.cacheGet(CacheKey.giftCardLoads);
  }

  public com.clover.sdk.v3.payments.BatchTotalType getGiftCardCashOuts() {
    return genClient.cacheGet(CacheKey.giftCardCashOuts);
  }

  public com.clover.sdk.v3.payments.BatchTotalType getTax() {
    return genClient.cacheGet(CacheKey.tax);
  }

  public com.clover.sdk.v3.payments.BatchTotalType getTips() {
    return genClient.cacheGet(CacheKey.tips);
  }

  public java.util.List<com.clover.sdk.v3.payments.BatchCardTotal> getCardTotals() {
    return genClient.cacheGet(CacheKey.cardTotals);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    deviceId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    deviceSerial
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    deviceName
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    terminalId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    sales
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.BatchTotalType.JSON_CREATOR)),
    refunds
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.BatchTotalType.JSON_CREATOR)),
    net
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.BatchTotalType.JSON_CREATOR)),
    giftCardLoads
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.BatchTotalType.JSON_CREATOR)),
    giftCardCashOuts
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.BatchTotalType.JSON_CREATOR)),
    tax
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.BatchTotalType.JSON_CREATOR)),
    tips
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.BatchTotalType.JSON_CREATOR)),
    cardTotals
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.payments.BatchCardTotal.JSON_CREATOR)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<DeviceTotalStats> genClient;

  /**
   * Constructs a new empty instance.
   */
  public DeviceTotalStats() {
    genClient = new GenericClient<DeviceTotalStats>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected DeviceTotalStats(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public DeviceTotalStats(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public DeviceTotalStats(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public DeviceTotalStats(DeviceTotalStats src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'deviceId' field is set and is not null */
  public boolean isNotNullDeviceId() {
    return genClient.cacheValueIsNotNull(CacheKey.deviceId);
  }

  /** Checks whether the 'deviceSerial' field is set and is not null */
  public boolean isNotNullDeviceSerial() {
    return genClient.cacheValueIsNotNull(CacheKey.deviceSerial);
  }

  /** Checks whether the 'deviceName' field is set and is not null */
  public boolean isNotNullDeviceName() {
    return genClient.cacheValueIsNotNull(CacheKey.deviceName);
  }

  /** Checks whether the 'terminalId' field is set and is not null */
  public boolean isNotNullTerminalId() {
    return genClient.cacheValueIsNotNull(CacheKey.terminalId);
  }

  /** Checks whether the 'sales' field is set and is not null */
  public boolean isNotNullSales() {
    return genClient.cacheValueIsNotNull(CacheKey.sales);
  }

  /** Checks whether the 'refunds' field is set and is not null */
  public boolean isNotNullRefunds() {
    return genClient.cacheValueIsNotNull(CacheKey.refunds);
  }

  /** Checks whether the 'net' field is set and is not null */
  public boolean isNotNullNet() {
    return genClient.cacheValueIsNotNull(CacheKey.net);
  }

  /** Checks whether the 'giftCardLoads' field is set and is not null */
  public boolean isNotNullGiftCardLoads() {
    return genClient.cacheValueIsNotNull(CacheKey.giftCardLoads);
  }

  /** Checks whether the 'giftCardCashOuts' field is set and is not null */
  public boolean isNotNullGiftCardCashOuts() {
    return genClient.cacheValueIsNotNull(CacheKey.giftCardCashOuts);
  }

  /** Checks whether the 'tax' field is set and is not null */
  public boolean isNotNullTax() {
    return genClient.cacheValueIsNotNull(CacheKey.tax);
  }

  /** Checks whether the 'tips' field is set and is not null */
  public boolean isNotNullTips() {
    return genClient.cacheValueIsNotNull(CacheKey.tips);
  }

  /** Checks whether the 'cardTotals' field is set and is not null */
  public boolean isNotNullCardTotals() {
    return genClient.cacheValueIsNotNull(CacheKey.cardTotals);
  }

  /** Checks whether the 'cardTotals' field is set and is not null and is not empty */
  public boolean isNotEmptyCardTotals() { return isNotNullCardTotals() && !getCardTotals().isEmpty(); }



  /** Checks whether the 'deviceId' field has been set, however the value could be null */
  public boolean hasDeviceId() {
    return genClient.cacheHasKey(CacheKey.deviceId);
  }

  /** Checks whether the 'deviceSerial' field has been set, however the value could be null */
  public boolean hasDeviceSerial() {
    return genClient.cacheHasKey(CacheKey.deviceSerial);
  }

  /** Checks whether the 'deviceName' field has been set, however the value could be null */
  public boolean hasDeviceName() {
    return genClient.cacheHasKey(CacheKey.deviceName);
  }

  /** Checks whether the 'terminalId' field has been set, however the value could be null */
  public boolean hasTerminalId() {
    return genClient.cacheHasKey(CacheKey.terminalId);
  }

  /** Checks whether the 'sales' field has been set, however the value could be null */
  public boolean hasSales() {
    return genClient.cacheHasKey(CacheKey.sales);
  }

  /** Checks whether the 'refunds' field has been set, however the value could be null */
  public boolean hasRefunds() {
    return genClient.cacheHasKey(CacheKey.refunds);
  }

  /** Checks whether the 'net' field has been set, however the value could be null */
  public boolean hasNet() {
    return genClient.cacheHasKey(CacheKey.net);
  }

  /** Checks whether the 'giftCardLoads' field has been set, however the value could be null */
  public boolean hasGiftCardLoads() {
    return genClient.cacheHasKey(CacheKey.giftCardLoads);
  }

  /** Checks whether the 'giftCardCashOuts' field has been set, however the value could be null */
  public boolean hasGiftCardCashOuts() {
    return genClient.cacheHasKey(CacheKey.giftCardCashOuts);
  }

  /** Checks whether the 'tax' field has been set, however the value could be null */
  public boolean hasTax() {
    return genClient.cacheHasKey(CacheKey.tax);
  }

  /** Checks whether the 'tips' field has been set, however the value could be null */
  public boolean hasTips() {
    return genClient.cacheHasKey(CacheKey.tips);
  }

  /** Checks whether the 'cardTotals' field has been set, however the value could be null */
  public boolean hasCardTotals() {
    return genClient.cacheHasKey(CacheKey.cardTotals);
  }


  /**
   * Sets the field 'deviceId'.
   */
  public DeviceTotalStats setDeviceId(java.lang.Long deviceId) {
    return genClient.setOther(deviceId, CacheKey.deviceId);
  }

  /**
   * Sets the field 'deviceSerial'.
   */
  public DeviceTotalStats setDeviceSerial(java.lang.String deviceSerial) {
    return genClient.setOther(deviceSerial, CacheKey.deviceSerial);
  }

  /**
   * Sets the field 'deviceName'.
   */
  public DeviceTotalStats setDeviceName(java.lang.String deviceName) {
    return genClient.setOther(deviceName, CacheKey.deviceName);
  }

  /**
   * Sets the field 'terminalId'.
   */
  public DeviceTotalStats setTerminalId(java.lang.String terminalId) {
    return genClient.setOther(terminalId, CacheKey.terminalId);
  }

  /**
   * Sets the field 'sales'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public DeviceTotalStats setSales(com.clover.sdk.v3.payments.BatchTotalType sales) {
    return genClient.setRecord(sales, CacheKey.sales);
  }

  /**
   * Sets the field 'refunds'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public DeviceTotalStats setRefunds(com.clover.sdk.v3.payments.BatchTotalType refunds) {
    return genClient.setRecord(refunds, CacheKey.refunds);
  }

  /**
   * Sets the field 'net'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public DeviceTotalStats setNet(com.clover.sdk.v3.payments.BatchTotalType net) {
    return genClient.setRecord(net, CacheKey.net);
  }

  /**
   * Sets the field 'giftCardLoads'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public DeviceTotalStats setGiftCardLoads(com.clover.sdk.v3.payments.BatchTotalType giftCardLoads) {
    return genClient.setRecord(giftCardLoads, CacheKey.giftCardLoads);
  }

  /**
   * Sets the field 'giftCardCashOuts'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public DeviceTotalStats setGiftCardCashOuts(com.clover.sdk.v3.payments.BatchTotalType giftCardCashOuts) {
    return genClient.setRecord(giftCardCashOuts, CacheKey.giftCardCashOuts);
  }

  /**
   * Sets the field 'tax'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public DeviceTotalStats setTax(com.clover.sdk.v3.payments.BatchTotalType tax) {
    return genClient.setRecord(tax, CacheKey.tax);
  }

  /**
   * Sets the field 'tips'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public DeviceTotalStats setTips(com.clover.sdk.v3.payments.BatchTotalType tips) {
    return genClient.setRecord(tips, CacheKey.tips);
  }

  /**
   * Sets the field 'cardTotals'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public DeviceTotalStats setCardTotals(java.util.List<com.clover.sdk.v3.payments.BatchCardTotal> cardTotals) {
    return genClient.setArrayRecord(cardTotals, CacheKey.cardTotals);
  }


  /** Clears the 'deviceId' field, the 'has' method for this field will now return false */
  public void clearDeviceId() {
    genClient.clear(CacheKey.deviceId);
  }
  /** Clears the 'deviceSerial' field, the 'has' method for this field will now return false */
  public void clearDeviceSerial() {
    genClient.clear(CacheKey.deviceSerial);
  }
  /** Clears the 'deviceName' field, the 'has' method for this field will now return false */
  public void clearDeviceName() {
    genClient.clear(CacheKey.deviceName);
  }
  /** Clears the 'terminalId' field, the 'has' method for this field will now return false */
  public void clearTerminalId() {
    genClient.clear(CacheKey.terminalId);
  }
  /** Clears the 'sales' field, the 'has' method for this field will now return false */
  public void clearSales() {
    genClient.clear(CacheKey.sales);
  }
  /** Clears the 'refunds' field, the 'has' method for this field will now return false */
  public void clearRefunds() {
    genClient.clear(CacheKey.refunds);
  }
  /** Clears the 'net' field, the 'has' method for this field will now return false */
  public void clearNet() {
    genClient.clear(CacheKey.net);
  }
  /** Clears the 'giftCardLoads' field, the 'has' method for this field will now return false */
  public void clearGiftCardLoads() {
    genClient.clear(CacheKey.giftCardLoads);
  }
  /** Clears the 'giftCardCashOuts' field, the 'has' method for this field will now return false */
  public void clearGiftCardCashOuts() {
    genClient.clear(CacheKey.giftCardCashOuts);
  }
  /** Clears the 'tax' field, the 'has' method for this field will now return false */
  public void clearTax() {
    genClient.clear(CacheKey.tax);
  }
  /** Clears the 'tips' field, the 'has' method for this field will now return false */
  public void clearTips() {
    genClient.clear(CacheKey.tips);
  }
  /** Clears the 'cardTotals' field, the 'has' method for this field will now return false */
  public void clearCardTotals() {
    genClient.clear(CacheKey.cardTotals);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public DeviceTotalStats copyChanges() {
    DeviceTotalStats copy = new DeviceTotalStats();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(DeviceTotalStats src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new DeviceTotalStats(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<DeviceTotalStats> CREATOR = new android.os.Parcelable.Creator<DeviceTotalStats>() {
    @Override
    public DeviceTotalStats createFromParcel(android.os.Parcel in) {
      DeviceTotalStats instance = new DeviceTotalStats(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public DeviceTotalStats[] newArray(int size) {
      return new DeviceTotalStats[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<DeviceTotalStats> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<DeviceTotalStats>() {
    public Class<DeviceTotalStats> getCreatedClass() {
      return DeviceTotalStats.class;
    }

    @Override
    public DeviceTotalStats create(org.json.JSONObject jsonObject) {
      return new DeviceTotalStats(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean DEVICEID_IS_REQUIRED = false;
    public static final boolean DEVICESERIAL_IS_REQUIRED = false;
    public static final boolean DEVICENAME_IS_REQUIRED = false;
    public static final boolean TERMINALID_IS_REQUIRED = false;
    public static final boolean SALES_IS_REQUIRED = false;
    public static final boolean REFUNDS_IS_REQUIRED = false;
    public static final boolean NET_IS_REQUIRED = false;
    public static final boolean GIFTCARDLOADS_IS_REQUIRED = false;
    public static final boolean GIFTCARDCASHOUTS_IS_REQUIRED = false;
    public static final boolean TAX_IS_REQUIRED = false;
    public static final boolean TIPS_IS_REQUIRED = false;
    public static final boolean CARDTOTALS_IS_REQUIRED = false;
  }

}
