/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.payments;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getTrack2 track2}</li>
 * <li>{@link #getCardNumber cardNumber}</li>
 * <li>{@link #getIsManuallyEntered isManuallyEntered}</li>
 * <li>{@link #getDeviceSerial deviceSerial}</li>
 * <li>{@link #getVirtual virtual}</li>
 * <li>{@link #getPromoCode promoCode}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class GiftCard extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Track 2 Card Data
   */
  public java.lang.String getTrack2() {
    return genClient.cacheGet(CacheKey.track2);
  }

  /**
   * Embossed Card Number
   */
  public java.lang.String getCardNumber() {
    return genClient.cacheGet(CacheKey.cardNumber);
  }

  /**
   * Was Account Number Manually Entered
   */
  public java.lang.Boolean getIsManuallyEntered() {
    return genClient.cacheGet(CacheKey.isManuallyEntered);
  }

  public java.lang.String getDeviceSerial() {
    return genClient.cacheGet(CacheKey.deviceSerial);
  }

  /**
   * Is this a virtual gift card
   */
  public java.lang.Boolean getVirtual() {
    return genClient.cacheGet(CacheKey.virtual);
  }

  /**
   * Virtual Promo Code
   */
  public java.lang.String getPromoCode() {
    return genClient.cacheGet(CacheKey.promoCode);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    track2
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    cardNumber
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    isManuallyEntered
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    deviceSerial
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    virtual
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    promoCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<GiftCard> genClient;

  /**
   * Constructs a new empty instance.
   */
  public GiftCard() {
    genClient = new GenericClient<GiftCard>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected GiftCard(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public GiftCard(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public GiftCard(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public GiftCard(GiftCard src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'track2' field is set and is not null */
  public boolean isNotNullTrack2() {
    return genClient.cacheValueIsNotNull(CacheKey.track2);
  }

  /** Checks whether the 'cardNumber' field is set and is not null */
  public boolean isNotNullCardNumber() {
    return genClient.cacheValueIsNotNull(CacheKey.cardNumber);
  }

  /** Checks whether the 'isManuallyEntered' field is set and is not null */
  public boolean isNotNullIsManuallyEntered() {
    return genClient.cacheValueIsNotNull(CacheKey.isManuallyEntered);
  }

  /** Checks whether the 'deviceSerial' field is set and is not null */
  public boolean isNotNullDeviceSerial() {
    return genClient.cacheValueIsNotNull(CacheKey.deviceSerial);
  }

  /** Checks whether the 'virtual' field is set and is not null */
  public boolean isNotNullVirtual() {
    return genClient.cacheValueIsNotNull(CacheKey.virtual);
  }

  /** Checks whether the 'promoCode' field is set and is not null */
  public boolean isNotNullPromoCode() {
    return genClient.cacheValueIsNotNull(CacheKey.promoCode);
  }



  /** Checks whether the 'track2' field has been set, however the value could be null */
  public boolean hasTrack2() {
    return genClient.cacheHasKey(CacheKey.track2);
  }

  /** Checks whether the 'cardNumber' field has been set, however the value could be null */
  public boolean hasCardNumber() {
    return genClient.cacheHasKey(CacheKey.cardNumber);
  }

  /** Checks whether the 'isManuallyEntered' field has been set, however the value could be null */
  public boolean hasIsManuallyEntered() {
    return genClient.cacheHasKey(CacheKey.isManuallyEntered);
  }

  /** Checks whether the 'deviceSerial' field has been set, however the value could be null */
  public boolean hasDeviceSerial() {
    return genClient.cacheHasKey(CacheKey.deviceSerial);
  }

  /** Checks whether the 'virtual' field has been set, however the value could be null */
  public boolean hasVirtual() {
    return genClient.cacheHasKey(CacheKey.virtual);
  }

  /** Checks whether the 'promoCode' field has been set, however the value could be null */
  public boolean hasPromoCode() {
    return genClient.cacheHasKey(CacheKey.promoCode);
  }


  /**
   * Sets the field 'track2'.
   */
  public GiftCard setTrack2(java.lang.String track2) {
    return genClient.setOther(track2, CacheKey.track2);
  }

  /**
   * Sets the field 'cardNumber'.
   */
  public GiftCard setCardNumber(java.lang.String cardNumber) {
    return genClient.setOther(cardNumber, CacheKey.cardNumber);
  }

  /**
   * Sets the field 'isManuallyEntered'.
   */
  public GiftCard setIsManuallyEntered(java.lang.Boolean isManuallyEntered) {
    return genClient.setOther(isManuallyEntered, CacheKey.isManuallyEntered);
  }

  /**
   * Sets the field 'deviceSerial'.
   */
  public GiftCard setDeviceSerial(java.lang.String deviceSerial) {
    return genClient.setOther(deviceSerial, CacheKey.deviceSerial);
  }

  /**
   * Sets the field 'virtual'.
   */
  public GiftCard setVirtual(java.lang.Boolean virtual) {
    return genClient.setOther(virtual, CacheKey.virtual);
  }

  /**
   * Sets the field 'promoCode'.
   */
  public GiftCard setPromoCode(java.lang.String promoCode) {
    return genClient.setOther(promoCode, CacheKey.promoCode);
  }


  /** Clears the 'track2' field, the 'has' method for this field will now return false */
  public void clearTrack2() {
    genClient.clear(CacheKey.track2);
  }
  /** Clears the 'cardNumber' field, the 'has' method for this field will now return false */
  public void clearCardNumber() {
    genClient.clear(CacheKey.cardNumber);
  }
  /** Clears the 'isManuallyEntered' field, the 'has' method for this field will now return false */
  public void clearIsManuallyEntered() {
    genClient.clear(CacheKey.isManuallyEntered);
  }
  /** Clears the 'deviceSerial' field, the 'has' method for this field will now return false */
  public void clearDeviceSerial() {
    genClient.clear(CacheKey.deviceSerial);
  }
  /** Clears the 'virtual' field, the 'has' method for this field will now return false */
  public void clearVirtual() {
    genClient.clear(CacheKey.virtual);
  }
  /** Clears the 'promoCode' field, the 'has' method for this field will now return false */
  public void clearPromoCode() {
    genClient.clear(CacheKey.promoCode);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public GiftCard copyChanges() {
    GiftCard copy = new GiftCard();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(GiftCard src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new GiftCard(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<GiftCard> CREATOR = new android.os.Parcelable.Creator<GiftCard>() {
    @Override
    public GiftCard createFromParcel(android.os.Parcel in) {
      GiftCard instance = new GiftCard(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public GiftCard[] newArray(int size) {
      return new GiftCard[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<GiftCard> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<GiftCard>() {
    public Class<GiftCard> getCreatedClass() {
      return GiftCard.class;
    }

    @Override
    public GiftCard create(org.json.JSONObject jsonObject) {
      return new GiftCard(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean TRACK2_IS_REQUIRED = false;
    public static final boolean CARDNUMBER_IS_REQUIRED = false;
    public static final boolean ISMANUALLYENTERED_IS_REQUIRED = false;
    public static final boolean DEVICESERIAL_IS_REQUIRED = false;
    public static final boolean VIRTUAL_IS_REQUIRED = false;
    public static final boolean PROMOCODE_IS_REQUIRED = false;
  }

}
