/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.payments;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getAmount amount}</li>
 * <li>{@link #getCardTransaction cardTransaction}</li>
 * <li>{@link #getResult result}</li>
 * <li>{@link #getCreatedTime createdTime}</li>
 * <li>{@link #getEmployee employee}</li>
 * <li>{@link #getIncrementAmount incrementAmount}</li>
 * <li>{@link #getAdditionalCharges additionalCharges}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class IncrementalAuthorization extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * Amount of the incremental authorization
   */
  public java.lang.Long getAmount() {
    return genClient.cacheGet(CacheKey.amount);
  }

  public com.clover.sdk.v3.payments.CardTransaction getCardTransaction() {
    return genClient.cacheGet(CacheKey.cardTransaction);
  }

  /**
   * Result of the incremental auth
   */
  public com.clover.sdk.v3.payments.Result getResult() {
    return genClient.cacheGet(CacheKey.result);
  }

  /**
   * Created time on the server
   */
  public java.lang.Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.createdTime);
  }

  /**
   * The employee who processed the incremental Auth
   */
  public com.clover.sdk.v3.base.Reference getEmployee() {
    return genClient.cacheGet(CacheKey.employee);
  }

  /**
   * Amount of the incremental authorization
   */
  public Long getIncrementAmount() {
    return genClient.cacheGet(CacheKey.incrementAmount);
  }

  public java.util.List<com.clover.sdk.v3.payments.AdditionalChargeAmount> getAdditionalCharges() {
    return genClient.cacheGet(CacheKey.additionalCharges);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    amount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    cardTransaction
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.CardTransaction.JSON_CREATOR)),
    result
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.payments.Result.class)),
    createdTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    employee
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    incrementAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    additionalCharges
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.payments.AdditionalChargeAmount.JSON_CREATOR)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<IncrementalAuthorization> genClient;

  /**
   * Constructs a new empty instance.
   */
  public IncrementalAuthorization() {
    genClient = new GenericClient<IncrementalAuthorization>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected IncrementalAuthorization(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public IncrementalAuthorization(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public IncrementalAuthorization(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public IncrementalAuthorization(IncrementalAuthorization src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());
    genClient.validateReferences(CacheKey.employee);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'amount' field is set and is not null */
  public boolean isNotNullAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.amount);
  }

  /** Checks whether the 'cardTransaction' field is set and is not null */
  public boolean isNotNullCardTransaction() {
    return genClient.cacheValueIsNotNull(CacheKey.cardTransaction);
  }

  /** Checks whether the 'result' field is set and is not null */
  public boolean isNotNullResult() {
    return genClient.cacheValueIsNotNull(CacheKey.result);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'employee' field is set and is not null */
  public boolean isNotNullEmployee() {
    return genClient.cacheValueIsNotNull(CacheKey.employee);
  }

  /** Checks whether the 'incrementAmount' field is set and is not null */
  public boolean isNotNullIncrementAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.incrementAmount);
  }

  /** Checks whether the 'additionalCharges' field is set and is not null */
  public boolean isNotNullAdditionalCharges() {
    return genClient.cacheValueIsNotNull(CacheKey.additionalCharges);
  }

  /** Checks whether the 'additionalCharges' field is set and is not null and is not empty */
  public boolean isNotEmptyAdditionalCharges() { return isNotNullAdditionalCharges() && !getAdditionalCharges().isEmpty(); }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'amount' field has been set, however the value could be null */
  public boolean hasAmount() {
    return genClient.cacheHasKey(CacheKey.amount);
  }

  /** Checks whether the 'cardTransaction' field has been set, however the value could be null */
  public boolean hasCardTransaction() {
    return genClient.cacheHasKey(CacheKey.cardTransaction);
  }

  /** Checks whether the 'result' field has been set, however the value could be null */
  public boolean hasResult() {
    return genClient.cacheHasKey(CacheKey.result);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'employee' field has been set, however the value could be null */
  public boolean hasEmployee() {
    return genClient.cacheHasKey(CacheKey.employee);
  }

  /** Checks whether the 'incrementAmount' field has been set, however the value could be null */
  public boolean hasIncrementAmount() {
    return genClient.cacheHasKey(CacheKey.incrementAmount);
  }

  /** Checks whether the 'additionalCharges' field has been set, however the value could be null */
  public boolean hasAdditionalCharges() {
    return genClient.cacheHasKey(CacheKey.additionalCharges);
  }


  /**
   * Sets the field 'id'.
   */
  public IncrementalAuthorization setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'amount'.
   */
  public IncrementalAuthorization setAmount(java.lang.Long amount) {
    return genClient.setOther(amount, CacheKey.amount);
  }

  /**
   * Sets the field 'cardTransaction'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public IncrementalAuthorization setCardTransaction(com.clover.sdk.v3.payments.CardTransaction cardTransaction) {
    return genClient.setRecord(cardTransaction, CacheKey.cardTransaction);
  }

  /**
   * Sets the field 'result'.
   */
  public IncrementalAuthorization setResult(com.clover.sdk.v3.payments.Result result) {
    return genClient.setOther(result, CacheKey.result);
  }

  /**
   * Sets the field 'createdTime'.
   */
  public IncrementalAuthorization setCreatedTime(java.lang.Long createdTime) {
    return genClient.setOther(createdTime, CacheKey.createdTime);
  }

  /**
   * Sets the field 'employee'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public IncrementalAuthorization setEmployee(com.clover.sdk.v3.base.Reference employee) {
    return genClient.setRecord(employee, CacheKey.employee);
  }

  /**
   * Sets the field 'incrementAmount'.
   */
  public IncrementalAuthorization setIncrementAmount(java.lang.Long incrementAmount) {
    return genClient.setOther(incrementAmount, CacheKey.incrementAmount);
  }

  /**
   * Sets the field 'additionalCharges'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public IncrementalAuthorization setAdditionalCharges(java.util.List<AdditionalChargeAmount> additionalCharges) {
    return genClient.setArrayRecord(additionalCharges, CacheKey.additionalCharges);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'amount' field, the 'has' method for this field will now return false */
  public void clearAmount() {
    genClient.clear(CacheKey.amount);
  }
  /** Clears the 'cardTransaction' field, the 'has' method for this field will now return false */
  public void clearCardTransaction() {
    genClient.clear(CacheKey.cardTransaction);
  }
  /** Clears the 'result' field, the 'has' method for this field will now return false */
  public void clearResult() {
    genClient.clear(CacheKey.result);
  }
  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.createdTime);
  }
  /** Clears the 'employee' field, the 'has' method for this field will now return false */
  public void clearEmployee() {
    genClient.clear(CacheKey.employee);
  }
  /** Clears the 'incrementAmount' field, the 'has' method for this field will now return false */
  public void clearIncrementAmount() {
    genClient.clear(CacheKey.incrementAmount);
  }
  /** Clears the 'additionalCharges' field, the 'has' method for this field will now return false */
  public void clearAdditionalCharges() {
    genClient.clear(CacheKey.additionalCharges);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public IncrementalAuthorization copyChanges() {
    IncrementalAuthorization copy = new IncrementalAuthorization();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(IncrementalAuthorization src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new IncrementalAuthorization(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<IncrementalAuthorization> CREATOR = new android.os.Parcelable.Creator<IncrementalAuthorization>() {
    @Override
    public IncrementalAuthorization createFromParcel(android.os.Parcel in) {
      IncrementalAuthorization instance = new IncrementalAuthorization(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public IncrementalAuthorization[] newArray(int size) {
      return new IncrementalAuthorization[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<IncrementalAuthorization> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<IncrementalAuthorization>() {
    public Class<IncrementalAuthorization> getCreatedClass() {
      return IncrementalAuthorization.class;
    }

    @Override
    public IncrementalAuthorization create(org.json.JSONObject jsonObject) {
      return new IncrementalAuthorization(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean AMOUNT_IS_REQUIRED = false;
    public static final boolean CARDTRANSACTION_IS_REQUIRED = false;
    public static final boolean RESULT_IS_REQUIRED = false;
    public static final boolean CREATEDTIME_IS_REQUIRED = false;
    public static final boolean EMPLOYEE_IS_REQUIRED = false;
    public static final boolean INCREMENTAMOUNT_IS_REQUIRED = false;
    public static final boolean ADDITIONALCHARGES_IS_REQUIRED = false;
  }

}
