/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.payments;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getItemDescription itemDescription}</li>
 * <li>{@link #getProductCode productCode}</li>
 * <li>{@link #getUnitCost unitCost}</li>
 * <li>{@link #getQuantity quantity}</li>
 * <li>{@link #getDiscountAmount discountAmount}</li>
 * <li>{@link #getTaxAmount taxAmount}</li>
 * <li>{@link #getUnitOfMeasure unitOfMeasure}</li>
 * <li>{@link #getCommodityCode commodityCode}</li>
 * <li>{@link #getDiscountRate discountRate}</li>
 * <li>{@link #getTaxAmount1 taxAmount1}</li>
 * <li>{@link #getTaxType1 taxType1}</li>
 * <li>{@link #getItemTaxRate1 itemTaxRate1}</li>
 * <li>{@link #getTaxAmount1TaxId taxAmount1TaxId}</li>
 * <li>{@link #getTaxAmountIndicator taxAmountIndicator}</li>
 * <li>{@link #getTaxTypeIdentifier taxTypeIdentifier}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class Level3LineItem extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Level3 - Line Item Merchandise Description, upto 26 characters
   */
  public String getItemDescription() {
    return genClient.cacheGet(CacheKey.itemDescription);
  }

  /**
   * Item product code
   */
  public String getProductCode() {
    return genClient.cacheGet(CacheKey.productCode);
  }

  /**
   * Line item price
   */
  public Long getUnitCost() {
    return genClient.cacheGet(CacheKey.unitCost);
  }

  /**
   * Line item quantity
   */
  public Long getQuantity() {
    return genClient.cacheGet(CacheKey.quantity);
  }

  /**
   * Item discount
   */
  public Long getDiscountAmount() {
    return genClient.cacheGet(CacheKey.discountAmount);
  }

  /**
   * Item Local Tax Amount
   */
  public Long getTaxAmount() {
    return genClient.cacheGet(CacheKey.taxAmount);
  }

  /**
   * Line item unit of measure
   */
  public String getUnitOfMeasure() {
    return genClient.cacheGet(CacheKey.unitOfMeasure);
  }

  /**
   * Line item commodity code
   */
  public String getCommodityCode() {
    return genClient.cacheGet(CacheKey.commodityCode);
  }

  /**
   * Line item discount rate
   */
  public Long getDiscountRate() {
    return genClient.cacheGet(CacheKey.discountRate);
  }

  /**
   * Specific tax amount collected in relationship to a type of tax (MasterCard) OR VAT or other tax amount.(Visa)
   */
  public Long getTaxAmount1() {
    return genClient.cacheGet(CacheKey.taxAmount1);
  }

  /**
   * Indicator used to further define tax categories of other tax amount
   */
  public String getTaxType1() {
    return genClient.cacheGet(CacheKey.taxType1);
  }

  /**
   * Specific tax rate in relationship to a type of tax collected
   */
  public Long getItemTaxRate1() {
    return genClient.cacheGet(CacheKey.itemTaxRate1);
  }

  /**
   * Identification number used by the card acceptor with the tax authority in relationship to a specific tax amount (MasterCard)
   */
  public String getTaxAmount1TaxId() {
    return genClient.cacheGet(CacheKey.taxAmount1TaxId);
  }

  /**
   * Tax Included in total purchase amount (Y/N)
   */
  public Boolean getTaxAmountIndicator() {
    return genClient.cacheGet(CacheKey.taxAmountIndicator);
  }

  /**
   * Other Tax Type Identifier
   */
  public TaxTypeIdentifier getTaxTypeIdentifier() {
    return genClient.cacheGet(CacheKey.taxTypeIdentifier);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    itemDescription
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    productCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    unitCost
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
    quantity
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
    discountAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
    taxAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
    unitOfMeasure
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    commodityCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    discountRate
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
    taxAmount1
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
    taxType1
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    itemTaxRate1
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
    taxAmount1TaxId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    taxAmountIndicator
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Boolean.class)),
    taxTypeIdentifier
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(TaxTypeIdentifier.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<Level3LineItem> genClient;

  /**
   * Constructs a new empty instance.
   */
  public Level3LineItem() {
    genClient = new GenericClient<Level3LineItem>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected Level3LineItem(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public Level3LineItem(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public Level3LineItem(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public Level3LineItem(Level3LineItem src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {

    genClient.validateLength(CacheKey.productCode, getProductCode(), 12);

    genClient.validateLength(CacheKey.unitOfMeasure, getUnitOfMeasure(), 12);

    genClient.validateLength(CacheKey.commodityCode, getCommodityCode(), 12);

    genClient.validateLength(CacheKey.taxType1, getTaxType1(), 4);

    genClient.validateLength(CacheKey.taxAmount1TaxId, getTaxAmount1TaxId(), 15);
  }

  /** Checks whether the 'itemDescription' field is set and is not null */
  public boolean isNotNullItemDescription() {
    return genClient.cacheValueIsNotNull(CacheKey.itemDescription);
  }

  /** Checks whether the 'productCode' field is set and is not null */
  public boolean isNotNullProductCode() {
    return genClient.cacheValueIsNotNull(CacheKey.productCode);
  }

  /** Checks whether the 'unitCost' field is set and is not null */
  public boolean isNotNullUnitCost() {
    return genClient.cacheValueIsNotNull(CacheKey.unitCost);
  }

  /** Checks whether the 'quantity' field is set and is not null */
  public boolean isNotNullQuantity() {
    return genClient.cacheValueIsNotNull(CacheKey.quantity);
  }

  /** Checks whether the 'discountAmount' field is set and is not null */
  public boolean isNotNullDiscountAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.discountAmount);
  }

  /** Checks whether the 'taxAmount' field is set and is not null */
  public boolean isNotNullTaxAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.taxAmount);
  }

  /** Checks whether the 'unitOfMeasure' field is set and is not null */
  public boolean isNotNullUnitOfMeasure() {
    return genClient.cacheValueIsNotNull(CacheKey.unitOfMeasure);
  }

  /** Checks whether the 'commodityCode' field is set and is not null */
  public boolean isNotNullCommodityCode() {
    return genClient.cacheValueIsNotNull(CacheKey.commodityCode);
  }

  /** Checks whether the 'discountRate' field is set and is not null */
  public boolean isNotNullDiscountRate() {
    return genClient.cacheValueIsNotNull(CacheKey.discountRate);
  }

  /** Checks whether the 'taxAmount1' field is set and is not null */
  public boolean isNotNullTaxAmount1() {
    return genClient.cacheValueIsNotNull(CacheKey.taxAmount1);
  }

  /** Checks whether the 'taxType1' field is set and is not null */
  public boolean isNotNullTaxType1() {
    return genClient.cacheValueIsNotNull(CacheKey.taxType1);
  }

  /** Checks whether the 'itemTaxRate1' field is set and is not null */
  public boolean isNotNullItemTaxRate1() {
    return genClient.cacheValueIsNotNull(CacheKey.itemTaxRate1);
  }

  /** Checks whether the 'taxAmount1TaxId' field is set and is not null */
  public boolean isNotNullTaxAmount1TaxId() {
    return genClient.cacheValueIsNotNull(CacheKey.taxAmount1TaxId);
  }

  /** Checks whether the 'taxAmountIndicator' field is set and is not null */
  public boolean isNotNullTaxAmountIndicator() {
    return genClient.cacheValueIsNotNull(CacheKey.taxAmountIndicator);
  }

  /** Checks whether the 'taxTypeIdentifier' field is set and is not null */
  public boolean isNotNullTaxTypeIdentifier() {
    return genClient.cacheValueIsNotNull(CacheKey.taxTypeIdentifier);
  }



  /** Checks whether the 'itemDescription' field has been set, however the value could be null */
  public boolean hasItemDescription() {
    return genClient.cacheHasKey(CacheKey.itemDescription);
  }

  /** Checks whether the 'productCode' field has been set, however the value could be null */
  public boolean hasProductCode() {
    return genClient.cacheHasKey(CacheKey.productCode);
  }

  /** Checks whether the 'unitCost' field has been set, however the value could be null */
  public boolean hasUnitCost() {
    return genClient.cacheHasKey(CacheKey.unitCost);
  }

  /** Checks whether the 'quantity' field has been set, however the value could be null */
  public boolean hasQuantity() {
    return genClient.cacheHasKey(CacheKey.quantity);
  }

  /** Checks whether the 'discountAmount' field has been set, however the value could be null */
  public boolean hasDiscountAmount() {
    return genClient.cacheHasKey(CacheKey.discountAmount);
  }

  /** Checks whether the 'taxAmount' field has been set, however the value could be null */
  public boolean hasTaxAmount() {
    return genClient.cacheHasKey(CacheKey.taxAmount);
  }

  /** Checks whether the 'unitOfMeasure' field has been set, however the value could be null */
  public boolean hasUnitOfMeasure() {
    return genClient.cacheHasKey(CacheKey.unitOfMeasure);
  }

  /** Checks whether the 'commodityCode' field has been set, however the value could be null */
  public boolean hasCommodityCode() {
    return genClient.cacheHasKey(CacheKey.commodityCode);
  }

  /** Checks whether the 'discountRate' field has been set, however the value could be null */
  public boolean hasDiscountRate() {
    return genClient.cacheHasKey(CacheKey.discountRate);
  }

  /** Checks whether the 'taxAmount1' field has been set, however the value could be null */
  public boolean hasTaxAmount1() {
    return genClient.cacheHasKey(CacheKey.taxAmount1);
  }

  /** Checks whether the 'taxType1' field has been set, however the value could be null */
  public boolean hasTaxType1() {
    return genClient.cacheHasKey(CacheKey.taxType1);
  }

  /** Checks whether the 'itemTaxRate1' field has been set, however the value could be null */
  public boolean hasItemTaxRate1() {
    return genClient.cacheHasKey(CacheKey.itemTaxRate1);
  }

  /** Checks whether the 'taxAmount1TaxId' field has been set, however the value could be null */
  public boolean hasTaxAmount1TaxId() {
    return genClient.cacheHasKey(CacheKey.taxAmount1TaxId);
  }

  /** Checks whether the 'taxAmountIndicator' field has been set, however the value could be null */
  public boolean hasTaxAmountIndicator() {
    return genClient.cacheHasKey(CacheKey.taxAmountIndicator);
  }

  /** Checks whether the 'taxTypeIdentifier' field has been set, however the value could be null */
  public boolean hasTaxTypeIdentifier() {
    return genClient.cacheHasKey(CacheKey.taxTypeIdentifier);
  }


  /**
   * Sets the field 'itemDescription'.
   */
  public Level3LineItem setItemDescription(String itemDescription) {
    return genClient.setOther(itemDescription, CacheKey.itemDescription);
  }

  /**
   * Sets the field 'productCode'.
   */
  public Level3LineItem setProductCode(String productCode) {
    return genClient.setOther(productCode, CacheKey.productCode);
  }

  /**
   * Sets the field 'unitCost'.
   */
  public Level3LineItem setUnitCost(Long unitCost) {
    return genClient.setOther(unitCost, CacheKey.unitCost);
  }

  /**
   * Sets the field 'quantity'.
   */
  public Level3LineItem setQuantity(Long quantity) {
    return genClient.setOther(quantity, CacheKey.quantity);
  }

  /**
   * Sets the field 'discountAmount'.
   */
  public Level3LineItem setDiscountAmount(Long discountAmount) {
    return genClient.setOther(discountAmount, CacheKey.discountAmount);
  }

  /**
   * Sets the field 'taxAmount'.
   */
  public Level3LineItem setTaxAmount(Long taxAmount) {
    return genClient.setOther(taxAmount, CacheKey.taxAmount);
  }

  /**
   * Sets the field 'unitOfMeasure'.
   */
  public Level3LineItem setUnitOfMeasure(String unitOfMeasure) {
    return genClient.setOther(unitOfMeasure, CacheKey.unitOfMeasure);
  }

  /**
   * Sets the field 'commodityCode'.
   */
  public Level3LineItem setCommodityCode(String commodityCode) {
    return genClient.setOther(commodityCode, CacheKey.commodityCode);
  }

  /**
   * Sets the field 'discountRate'.
   */
  public Level3LineItem setDiscountRate(Long discountRate) {
    return genClient.setOther(discountRate, CacheKey.discountRate);
  }

  /**
   * Sets the field 'taxAmount1'.
   */
  public Level3LineItem setTaxAmount1(Long taxAmount1) {
    return genClient.setOther(taxAmount1, CacheKey.taxAmount1);
  }

  /**
   * Sets the field 'taxType1'.
   */
  public Level3LineItem setTaxType1(String taxType1) {
    return genClient.setOther(taxType1, CacheKey.taxType1);
  }

  /**
   * Sets the field 'itemTaxRate1'.
   */
  public Level3LineItem setItemTaxRate1(Long itemTaxRate1) {
    return genClient.setOther(itemTaxRate1, CacheKey.itemTaxRate1);
  }

  /**
   * Sets the field 'taxAmount1TaxId'.
   */
  public Level3LineItem setTaxAmount1TaxId(String taxAmount1TaxId) {
    return genClient.setOther(taxAmount1TaxId, CacheKey.taxAmount1TaxId);
  }

  /**
   * Sets the field 'taxAmountIndicator'.
   */
  public Level3LineItem setTaxAmountIndicator(Boolean taxAmountIndicator) {
    return genClient.setOther(taxAmountIndicator, CacheKey.taxAmountIndicator);
  }

  /**
   * Sets the field 'taxTypeIdentifier'.
   */
  public Level3LineItem setTaxTypeIdentifier(TaxTypeIdentifier taxTypeIdentifier) {
    return genClient.setOther(taxTypeIdentifier, CacheKey.taxTypeIdentifier);
  }


  /** Clears the 'itemDescription' field, the 'has' method for this field will now return false */
  public void clearItemDescription() {
    genClient.clear(CacheKey.itemDescription);
  }
  /** Clears the 'productCode' field, the 'has' method for this field will now return false */
  public void clearProductCode() {
    genClient.clear(CacheKey.productCode);
  }
  /** Clears the 'unitCost' field, the 'has' method for this field will now return false */
  public void clearUnitCost() {
    genClient.clear(CacheKey.unitCost);
  }
  /** Clears the 'quantity' field, the 'has' method for this field will now return false */
  public void clearQuantity() {
    genClient.clear(CacheKey.quantity);
  }
  /** Clears the 'discountAmount' field, the 'has' method for this field will now return false */
  public void clearDiscountAmount() {
    genClient.clear(CacheKey.discountAmount);
  }
  /** Clears the 'taxAmount' field, the 'has' method for this field will now return false */
  public void clearTaxAmount() {
    genClient.clear(CacheKey.taxAmount);
  }
  /** Clears the 'unitOfMeasure' field, the 'has' method for this field will now return false */
  public void clearUnitOfMeasure() {
    genClient.clear(CacheKey.unitOfMeasure);
  }
  /** Clears the 'commodityCode' field, the 'has' method for this field will now return false */
  public void clearCommodityCode() {
    genClient.clear(CacheKey.commodityCode);
  }
  /** Clears the 'discountRate' field, the 'has' method for this field will now return false */
  public void clearDiscountRate() {
    genClient.clear(CacheKey.discountRate);
  }
  /** Clears the 'taxAmount1' field, the 'has' method for this field will now return false */
  public void clearTaxAmount1() {
    genClient.clear(CacheKey.taxAmount1);
  }
  /** Clears the 'taxType1' field, the 'has' method for this field will now return false */
  public void clearTaxType1() {
    genClient.clear(CacheKey.taxType1);
  }
  /** Clears the 'itemTaxRate1' field, the 'has' method for this field will now return false */
  public void clearItemTaxRate1() {
    genClient.clear(CacheKey.itemTaxRate1);
  }
  /** Clears the 'taxAmount1TaxId' field, the 'has' method for this field will now return false */
  public void clearTaxAmount1TaxId() {
    genClient.clear(CacheKey.taxAmount1TaxId);
  }
  /** Clears the 'taxAmountIndicator' field, the 'has' method for this field will now return false */
  public void clearTaxAmountIndicator() {
    genClient.clear(CacheKey.taxAmountIndicator);
  }
  /** Clears the 'taxTypeIdentifier' field, the 'has' method for this field will now return false */
  public void clearTaxTypeIdentifier() {
    genClient.clear(CacheKey.taxTypeIdentifier);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public Level3LineItem copyChanges() {
    Level3LineItem copy = new Level3LineItem();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(Level3LineItem src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new Level3LineItem(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<Level3LineItem> CREATOR = new android.os.Parcelable.Creator<Level3LineItem>() {
    @Override
    public Level3LineItem createFromParcel(android.os.Parcel in) {
      Level3LineItem instance = new Level3LineItem(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public Level3LineItem[] newArray(int size) {
      return new Level3LineItem[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<Level3LineItem> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<Level3LineItem>() {
    public Class<Level3LineItem> getCreatedClass() {
      return Level3LineItem.class;
    }

    @Override
    public Level3LineItem create(org.json.JSONObject jsonObject) {
      return new Level3LineItem(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ITEMDESCRIPTION_IS_REQUIRED = false;
    public static final boolean PRODUCTCODE_IS_REQUIRED = false;
    public static final long PRODUCTCODE_MAX_LEN = 12;
    public static final boolean UNITCOST_IS_REQUIRED = false;
    public static final boolean QUANTITY_IS_REQUIRED = false;
    public static final boolean DISCOUNTAMOUNT_IS_REQUIRED = false;
    public static final boolean TAXAMOUNT_IS_REQUIRED = false;
    public static final boolean UNITOFMEASURE_IS_REQUIRED = false;
    public static final long UNITOFMEASURE_MAX_LEN = 12;
    public static final boolean COMMODITYCODE_IS_REQUIRED = false;
    public static final long COMMODITYCODE_MAX_LEN = 12;
    public static final boolean DISCOUNTRATE_IS_REQUIRED = false;
    public static final boolean TAXAMOUNT1_IS_REQUIRED = false;
    public static final boolean TAXTYPE1_IS_REQUIRED = false;
    public static final long TAXTYPE1_MAX_LEN = 4;
    public static final boolean ITEMTAXRATE1_IS_REQUIRED = false;
    public static final boolean TAXAMOUNT1TAXID_IS_REQUIRED = false;
    public static final long TAXAMOUNT1TAXID_MAX_LEN = 15;
    public static final boolean TAXAMOUNTINDICATOR_IS_REQUIRED = false;
    public static final boolean TAXTYPEIDENTIFIER_IS_REQUIRED = false;
  }

}
