/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.payments;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getTranSource tranSource}</li>
 * <li>{@link #getTranChannel tranChannel}</li>
 * <li>{@link #getTranType tranType}</li>
 * <li>{@link #getMerchantId merchantId}</li>
 * <li>{@link #getTerminalId terminalId}</li>
 * <li>{@link #getTenderType tenderType}</li>
 * <li>{@link #getEntryMethod entryMethod}</li>
 * <li>{@link #getTransactionAmount transactionAmount}</li>
 * <li>{@link #getTransactionCurrency transactionCurrency}</li>
 * <li>{@link #getFpTransactionId fpTransactionId}</li>
 * <li>{@link #getMrn mrn}</li>
 * <li>{@link #getRefundTxnId refundTxnId}</li>
 * <li>{@link #getTransactionStatus transactionStatus}</li>
 * <li>{@link #getTransactionStatusDescription transactionStatusDescription}</li>
 * <li>{@link #getRrn rrn}</li>
 * <li>{@link #getBatchNo batchNo}</li>
 * <li>{@link #getInvoiceNo invoiceNo}</li>
 * <li>{@link #getCardScheme cardScheme}</li>
 * <li>{@link #getQrType qrType}</li>
 * <li>{@link #getTransactionDateTime transactionDateTime}</li>
 * <li>{@link #getAuthCode authCode}</li>
 * <li>{@link #getPan pan}</li>
 * <li>{@link #getCustomerMobile customerMobile}</li>
 * <li>{@link #getCustomerName customerName}</li>
 * <li>{@link #getCustomerRemarks customerRemarks}</li>
 * <li>{@link #getEmiDetails emiDetails}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class OceanGatewayInfo extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * This field contains transaction source returned from Ocean as part of Notification for a transaction
   */
  public String getTranSource() {
    return genClient.cacheGet(CacheKey.tranSource);
  }

  /**
   * This field contains LPM type info returned from Ocean as part of Notification for a transaction
   */
  public String getTranChannel() {
    return genClient.cacheGet(CacheKey.tranChannel);
  }

  /**
   * This field contains transaction type info returned from Ocean as part of Notification for a transaction
   */
  public String getTranType() {
    return genClient.cacheGet(CacheKey.tranType);
  }

  /**
   * This field contains MerchantId returned from Ocean as part of Notification for a transaction
   */
  public String getMerchantId() {
    return genClient.cacheGet(CacheKey.merchantId);
  }

  /**
   * This field contains TerminalId returned from Ocean as part of Notification for a transaction
   */
  public String getTerminalId() {
    return genClient.cacheGet(CacheKey.terminalId);
  }

  /**
   * This field contains tender type info returned from Ocean as part of Notification for a transaction
   */
  public String getTenderType() {
    return genClient.cacheGet(CacheKey.tenderType);
  }

  /**
   * This field contains the entry method returned from Ocean as part of Notification for a transaction
   */
  public String getEntryMethod() {
    return genClient.cacheGet(CacheKey.entryMethod);
  }

  /**
   * This field contains the transaction amount returned from Ocean as part of Notification for a transaction
   */
  public String getTransactionAmount() {
    return genClient.cacheGet(CacheKey.transactionAmount);
  }

  /**
   * This field contains the transaction currency returned from Ocean as part of Notification for a transaction
   */
  public String getTransactionCurrency() {
    return genClient.cacheGet(CacheKey.transactionCurrency);
  }

  /**
   * This field contains the ocean generated transaction Id for a transaction
   */
  public String getFpTransactionId() {
    return genClient.cacheGet(CacheKey.fpTransactionId);
  }

  /**
   * This field contains the reference id provided by clover for a transaction
   */
  public String getMrn() {
    return genClient.cacheGet(CacheKey.mrn);
  }

  /**
   * This field contains the refund transaction id returned from Ocean for a transaction
   */
  public String getRefundTxnId() {
    return genClient.cacheGet(CacheKey.refundTxnId);
  }

  /**
   * This field contains the transaction status returned from Ocean as part of Notification for a transaction
   */
  public String getTransactionStatus() {
    return genClient.cacheGet(CacheKey.transactionStatus);
  }

  /**
   * This field contains the transaction status description returned from Ocean as part of Notification for a transaction
   */
  public String getTransactionStatusDescription() {
    return genClient.cacheGet(CacheKey.transactionStatusDescription);
  }

  /**
   * This field contains rrn number (reference provided by bank) returned from Ocean as part of Notification for a transaction
   */
  public String getRrn() {
    return genClient.cacheGet(CacheKey.rrn);
  }

  /**
   * This field contains batch number returned from Ocean as part of Notification for a transaction
   */
  public String getBatchNo() {
    return genClient.cacheGet(CacheKey.batchNo);
  }

  /**
   * This field contains invoice number returned from Ocean as part of Notification for a transaction
   */
  public String getInvoiceNo() {
    return genClient.cacheGet(CacheKey.invoiceNo);
  }

  /**
   * This field contains Customer LPM information returned from Ocean as part of Notification for a transaction
   */
  public String getCardScheme() {
    return genClient.cacheGet(CacheKey.cardScheme);
  }

  /**
   * This field contains qr tpe either static or dynamic information returned from Ocean as part of Notification for a transaction
   */
  public String getQrType() {
    return genClient.cacheGet(CacheKey.qrType);
  }

  /**
   * This field contains transaction completion date info returned from Ocean as part of Notification for a transaction
   */
  public String getTransactionDateTime() {
    return genClient.cacheGet(CacheKey.transactionDateTime);
  }

  /**
   * This field contains Authorization Code returned from Ocean as part of Notification for a transaction
   */
  public String getAuthCode() {
    return genClient.cacheGet(CacheKey.authCode);
  }

  /**
   * This field contains pan information like masked virtual payment address,vehicle info,userId returned from Ocean as part of Notification for a transaction
   */
  public String getPan() {
    return genClient.cacheGet(CacheKey.pan);
  }

  /**
   * This field contains customer mobile info returned from Ocean as part of Notification for a transaction
   */
  public String getCustomerMobile() {
    return genClient.cacheGet(CacheKey.customerMobile);
  }

  /**
   * This field contains customer name returned from Ocean as part of Notification for a transaction
   */
  public String getCustomerName() {
    return genClient.cacheGet(CacheKey.customerName);
  }

  /**
   * This field contains customer remarks returned from Ocean as part of Notification for a transaction
   */
  public String getCustomerRemarks() {
    return genClient.cacheGet(CacheKey.customerRemarks);
  }

  /**
   * This field indicates the EMI details of a customer returned from Ocean as part of Notification for a transaction
   */
  public EMIDetails getEmiDetails() {
    return genClient.cacheGet(CacheKey.emiDetails);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    tranSource
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    tranChannel
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    tranType
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    merchantId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    terminalId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    tenderType
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    entryMethod
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    transactionAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    transactionCurrency
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    fpTransactionId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    mrn
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    refundTxnId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    transactionStatus
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    transactionStatusDescription
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    rrn
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    batchNo
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    invoiceNo
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    cardScheme
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    qrType
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    transactionDateTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    authCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    pan
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    customerMobile
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    customerName
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    customerRemarks
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    emiDetails
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(EMIDetails.JSON_CREATOR)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<OceanGatewayInfo> genClient;

  /**
   * Constructs a new empty instance.
   */
  public OceanGatewayInfo() {
    genClient = new GenericClient<OceanGatewayInfo>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected OceanGatewayInfo(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public OceanGatewayInfo(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public OceanGatewayInfo(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public OceanGatewayInfo(OceanGatewayInfo src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'tranSource' field is set and is not null */
  public boolean isNotNullTranSource() {
    return genClient.cacheValueIsNotNull(CacheKey.tranSource);
  }

  /** Checks whether the 'tranChannel' field is set and is not null */
  public boolean isNotNullTranChannel() {
    return genClient.cacheValueIsNotNull(CacheKey.tranChannel);
  }

  /** Checks whether the 'tranType' field is set and is not null */
  public boolean isNotNullTranType() {
    return genClient.cacheValueIsNotNull(CacheKey.tranType);
  }

  /** Checks whether the 'merchantId' field is set and is not null */
  public boolean isNotNullMerchantId() {
    return genClient.cacheValueIsNotNull(CacheKey.merchantId);
  }

  /** Checks whether the 'terminalId' field is set and is not null */
  public boolean isNotNullTerminalId() {
    return genClient.cacheValueIsNotNull(CacheKey.terminalId);
  }

  /** Checks whether the 'tenderType' field is set and is not null */
  public boolean isNotNullTenderType() {
    return genClient.cacheValueIsNotNull(CacheKey.tenderType);
  }

  /** Checks whether the 'entryMethod' field is set and is not null */
  public boolean isNotNullEntryMethod() {
    return genClient.cacheValueIsNotNull(CacheKey.entryMethod);
  }

  /** Checks whether the 'transactionAmount' field is set and is not null */
  public boolean isNotNullTransactionAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.transactionAmount);
  }

  /** Checks whether the 'transactionCurrency' field is set and is not null */
  public boolean isNotNullTransactionCurrency() {
    return genClient.cacheValueIsNotNull(CacheKey.transactionCurrency);
  }

  /** Checks whether the 'fpTransactionId' field is set and is not null */
  public boolean isNotNullFpTransactionId() {
    return genClient.cacheValueIsNotNull(CacheKey.fpTransactionId);
  }

  /** Checks whether the 'mrn' field is set and is not null */
  public boolean isNotNullMrn() {
    return genClient.cacheValueIsNotNull(CacheKey.mrn);
  }

  /** Checks whether the 'refundTxnId' field is set and is not null */
  public boolean isNotNullRefundTxnId() {
    return genClient.cacheValueIsNotNull(CacheKey.refundTxnId);
  }

  /** Checks whether the 'transactionStatus' field is set and is not null */
  public boolean isNotNullTransactionStatus() {
    return genClient.cacheValueIsNotNull(CacheKey.transactionStatus);
  }

  /** Checks whether the 'transactionStatusDescription' field is set and is not null */
  public boolean isNotNullTransactionStatusDescription() {
    return genClient.cacheValueIsNotNull(CacheKey.transactionStatusDescription);
  }

  /** Checks whether the 'rrn' field is set and is not null */
  public boolean isNotNullRrn() {
    return genClient.cacheValueIsNotNull(CacheKey.rrn);
  }

  /** Checks whether the 'batchNo' field is set and is not null */
  public boolean isNotNullBatchNo() {
    return genClient.cacheValueIsNotNull(CacheKey.batchNo);
  }

  /** Checks whether the 'invoiceNo' field is set and is not null */
  public boolean isNotNullInvoiceNo() {
    return genClient.cacheValueIsNotNull(CacheKey.invoiceNo);
  }

  /** Checks whether the 'cardScheme' field is set and is not null */
  public boolean isNotNullCardScheme() {
    return genClient.cacheValueIsNotNull(CacheKey.cardScheme);
  }

  /** Checks whether the 'qrType' field is set and is not null */
  public boolean isNotNullQrType() {
    return genClient.cacheValueIsNotNull(CacheKey.qrType);
  }

  /** Checks whether the 'transactionDateTime' field is set and is not null */
  public boolean isNotNullTransactionDateTime() {
    return genClient.cacheValueIsNotNull(CacheKey.transactionDateTime);
  }

  /** Checks whether the 'authCode' field is set and is not null */
  public boolean isNotNullAuthCode() {
    return genClient.cacheValueIsNotNull(CacheKey.authCode);
  }

  /** Checks whether the 'pan' field is set and is not null */
  public boolean isNotNullPan() {
    return genClient.cacheValueIsNotNull(CacheKey.pan);
  }

  /** Checks whether the 'customerMobile' field is set and is not null */
  public boolean isNotNullCustomerMobile() {
    return genClient.cacheValueIsNotNull(CacheKey.customerMobile);
  }

  /** Checks whether the 'customerName' field is set and is not null */
  public boolean isNotNullCustomerName() {
    return genClient.cacheValueIsNotNull(CacheKey.customerName);
  }

  /** Checks whether the 'customerRemarks' field is set and is not null */
  public boolean isNotNullCustomerRemarks() {
    return genClient.cacheValueIsNotNull(CacheKey.customerRemarks);
  }

  /** Checks whether the 'emiDetails' field is set and is not null */
  public boolean isNotNullEmiDetails() {
    return genClient.cacheValueIsNotNull(CacheKey.emiDetails);
  }



  /** Checks whether the 'tranSource' field has been set, however the value could be null */
  public boolean hasTranSource() {
    return genClient.cacheHasKey(CacheKey.tranSource);
  }

  /** Checks whether the 'tranChannel' field has been set, however the value could be null */
  public boolean hasTranChannel() {
    return genClient.cacheHasKey(CacheKey.tranChannel);
  }

  /** Checks whether the 'tranType' field has been set, however the value could be null */
  public boolean hasTranType() {
    return genClient.cacheHasKey(CacheKey.tranType);
  }

  /** Checks whether the 'merchantId' field has been set, however the value could be null */
  public boolean hasMerchantId() {
    return genClient.cacheHasKey(CacheKey.merchantId);
  }

  /** Checks whether the 'terminalId' field has been set, however the value could be null */
  public boolean hasTerminalId() {
    return genClient.cacheHasKey(CacheKey.terminalId);
  }

  /** Checks whether the 'tenderType' field has been set, however the value could be null */
  public boolean hasTenderType() {
    return genClient.cacheHasKey(CacheKey.tenderType);
  }

  /** Checks whether the 'entryMethod' field has been set, however the value could be null */
  public boolean hasEntryMethod() {
    return genClient.cacheHasKey(CacheKey.entryMethod);
  }

  /** Checks whether the 'transactionAmount' field has been set, however the value could be null */
  public boolean hasTransactionAmount() {
    return genClient.cacheHasKey(CacheKey.transactionAmount);
  }

  /** Checks whether the 'transactionCurrency' field has been set, however the value could be null */
  public boolean hasTransactionCurrency() {
    return genClient.cacheHasKey(CacheKey.transactionCurrency);
  }

  /** Checks whether the 'fpTransactionId' field has been set, however the value could be null */
  public boolean hasFpTransactionId() {
    return genClient.cacheHasKey(CacheKey.fpTransactionId);
  }

  /** Checks whether the 'mrn' field has been set, however the value could be null */
  public boolean hasMrn() {
    return genClient.cacheHasKey(CacheKey.mrn);
  }

  /** Checks whether the 'refundTxnId' field has been set, however the value could be null */
  public boolean hasRefundTxnId() {
    return genClient.cacheHasKey(CacheKey.refundTxnId);
  }

  /** Checks whether the 'transactionStatus' field has been set, however the value could be null */
  public boolean hasTransactionStatus() {
    return genClient.cacheHasKey(CacheKey.transactionStatus);
  }

  /** Checks whether the 'transactionStatusDescription' field has been set, however the value could be null */
  public boolean hasTransactionStatusDescription() {
    return genClient.cacheHasKey(CacheKey.transactionStatusDescription);
  }

  /** Checks whether the 'rrn' field has been set, however the value could be null */
  public boolean hasRrn() {
    return genClient.cacheHasKey(CacheKey.rrn);
  }

  /** Checks whether the 'batchNo' field has been set, however the value could be null */
  public boolean hasBatchNo() {
    return genClient.cacheHasKey(CacheKey.batchNo);
  }

  /** Checks whether the 'invoiceNo' field has been set, however the value could be null */
  public boolean hasInvoiceNo() {
    return genClient.cacheHasKey(CacheKey.invoiceNo);
  }

  /** Checks whether the 'cardScheme' field has been set, however the value could be null */
  public boolean hasCardScheme() {
    return genClient.cacheHasKey(CacheKey.cardScheme);
  }

  /** Checks whether the 'qrType' field has been set, however the value could be null */
  public boolean hasQrType() {
    return genClient.cacheHasKey(CacheKey.qrType);
  }

  /** Checks whether the 'transactionDateTime' field has been set, however the value could be null */
  public boolean hasTransactionDateTime() {
    return genClient.cacheHasKey(CacheKey.transactionDateTime);
  }

  /** Checks whether the 'authCode' field has been set, however the value could be null */
  public boolean hasAuthCode() {
    return genClient.cacheHasKey(CacheKey.authCode);
  }

  /** Checks whether the 'pan' field has been set, however the value could be null */
  public boolean hasPan() {
    return genClient.cacheHasKey(CacheKey.pan);
  }

  /** Checks whether the 'customerMobile' field has been set, however the value could be null */
  public boolean hasCustomerMobile() {
    return genClient.cacheHasKey(CacheKey.customerMobile);
  }

  /** Checks whether the 'customerName' field has been set, however the value could be null */
  public boolean hasCustomerName() {
    return genClient.cacheHasKey(CacheKey.customerName);
  }

  /** Checks whether the 'customerRemarks' field has been set, however the value could be null */
  public boolean hasCustomerRemarks() {
    return genClient.cacheHasKey(CacheKey.customerRemarks);
  }

  /** Checks whether the 'emiDetails' field has been set, however the value could be null */
  public boolean hasEmiDetails() {
    return genClient.cacheHasKey(CacheKey.emiDetails);
  }


  /**
   * Sets the field 'tranSource'.
   */
  public OceanGatewayInfo setTranSource(String tranSource) {
    return genClient.setOther(tranSource, CacheKey.tranSource);
  }

  /**
   * Sets the field 'tranChannel'.
   */
  public OceanGatewayInfo setTranChannel(String tranChannel) {
    return genClient.setOther(tranChannel, CacheKey.tranChannel);
  }

  /**
   * Sets the field 'tranType'.
   */
  public OceanGatewayInfo setTranType(String tranType) {
    return genClient.setOther(tranType, CacheKey.tranType);
  }

  /**
   * Sets the field 'merchantId'.
   */
  public OceanGatewayInfo setMerchantId(String merchantId) {
    return genClient.setOther(merchantId, CacheKey.merchantId);
  }

  /**
   * Sets the field 'terminalId'.
   */
  public OceanGatewayInfo setTerminalId(String terminalId) {
    return genClient.setOther(terminalId, CacheKey.terminalId);
  }

  /**
   * Sets the field 'tenderType'.
   */
  public OceanGatewayInfo setTenderType(String tenderType) {
    return genClient.setOther(tenderType, CacheKey.tenderType);
  }

  /**
   * Sets the field 'entryMethod'.
   */
  public OceanGatewayInfo setEntryMethod(String entryMethod) {
    return genClient.setOther(entryMethod, CacheKey.entryMethod);
  }

  /**
   * Sets the field 'transactionAmount'.
   */
  public OceanGatewayInfo setTransactionAmount(String transactionAmount) {
    return genClient.setOther(transactionAmount, CacheKey.transactionAmount);
  }

  /**
   * Sets the field 'transactionCurrency'.
   */
  public OceanGatewayInfo setTransactionCurrency(String transactionCurrency) {
    return genClient.setOther(transactionCurrency, CacheKey.transactionCurrency);
  }

  /**
   * Sets the field 'fpTransactionId'.
   */
  public OceanGatewayInfo setFpTransactionId(String fpTransactionId) {
    return genClient.setOther(fpTransactionId, CacheKey.fpTransactionId);
  }

  /**
   * Sets the field 'mrn'.
   */
  public OceanGatewayInfo setMrn(String mrn) {
    return genClient.setOther(mrn, CacheKey.mrn);
  }

  /**
   * Sets the field 'refundTxnId'.
   */
  public OceanGatewayInfo setRefundTxnId(String refundTxnId) {
    return genClient.setOther(refundTxnId, CacheKey.refundTxnId);
  }

  /**
   * Sets the field 'transactionStatus'.
   */
  public OceanGatewayInfo setTransactionStatus(String transactionStatus) {
    return genClient.setOther(transactionStatus, CacheKey.transactionStatus);
  }

  /**
   * Sets the field 'transactionStatusDescription'.
   */
  public OceanGatewayInfo setTransactionStatusDescription(String transactionStatusDescription) {
    return genClient.setOther(transactionStatusDescription, CacheKey.transactionStatusDescription);
  }

  /**
   * Sets the field 'rrn'.
   */
  public OceanGatewayInfo setRrn(String rrn) {
    return genClient.setOther(rrn, CacheKey.rrn);
  }

  /**
   * Sets the field 'batchNo'.
   */
  public OceanGatewayInfo setBatchNo(String batchNo) {
    return genClient.setOther(batchNo, CacheKey.batchNo);
  }

  /**
   * Sets the field 'invoiceNo'.
   */
  public OceanGatewayInfo setInvoiceNo(String invoiceNo) {
    return genClient.setOther(invoiceNo, CacheKey.invoiceNo);
  }

  /**
   * Sets the field 'cardScheme'.
   */
  public OceanGatewayInfo setCardScheme(String cardScheme) {
    return genClient.setOther(cardScheme, CacheKey.cardScheme);
  }

  /**
   * Sets the field 'qrType'.
   */
  public OceanGatewayInfo setQrType(String qrType) {
    return genClient.setOther(qrType, CacheKey.qrType);
  }

  /**
   * Sets the field 'transactionDateTime'.
   */
  public OceanGatewayInfo setTransactionDateTime(String transactionDateTime) {
    return genClient.setOther(transactionDateTime, CacheKey.transactionDateTime);
  }

  /**
   * Sets the field 'authCode'.
   */
  public OceanGatewayInfo setAuthCode(String authCode) {
    return genClient.setOther(authCode, CacheKey.authCode);
  }

  /**
   * Sets the field 'pan'.
   */
  public OceanGatewayInfo setPan(String pan) {
    return genClient.setOther(pan, CacheKey.pan);
  }

  /**
   * Sets the field 'customerMobile'.
   */
  public OceanGatewayInfo setCustomerMobile(String customerMobile) {
    return genClient.setOther(customerMobile, CacheKey.customerMobile);
  }

  /**
   * Sets the field 'customerName'.
   */
  public OceanGatewayInfo setCustomerName(String customerName) {
    return genClient.setOther(customerName, CacheKey.customerName);
  }

  /**
   * Sets the field 'customerRemarks'.
   */
  public OceanGatewayInfo setCustomerRemarks(String customerRemarks) {
    return genClient.setOther(customerRemarks, CacheKey.customerRemarks);
  }

  /**
   * Sets the field 'emiDetails'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public OceanGatewayInfo setEmiDetails(EMIDetails emiDetails) {
    return genClient.setRecord(emiDetails, CacheKey.emiDetails);
  }


  /** Clears the 'tranSource' field, the 'has' method for this field will now return false */
  public void clearTranSource() {
    genClient.clear(CacheKey.tranSource);
  }
  /** Clears the 'tranChannel' field, the 'has' method for this field will now return false */
  public void clearTranChannel() {
    genClient.clear(CacheKey.tranChannel);
  }
  /** Clears the 'tranType' field, the 'has' method for this field will now return false */
  public void clearTranType() {
    genClient.clear(CacheKey.tranType);
  }
  /** Clears the 'merchantId' field, the 'has' method for this field will now return false */
  public void clearMerchantId() {
    genClient.clear(CacheKey.merchantId);
  }
  /** Clears the 'terminalId' field, the 'has' method for this field will now return false */
  public void clearTerminalId() {
    genClient.clear(CacheKey.terminalId);
  }
  /** Clears the 'tenderType' field, the 'has' method for this field will now return false */
  public void clearTenderType() {
    genClient.clear(CacheKey.tenderType);
  }
  /** Clears the 'entryMethod' field, the 'has' method for this field will now return false */
  public void clearEntryMethod() {
    genClient.clear(CacheKey.entryMethod);
  }
  /** Clears the 'transactionAmount' field, the 'has' method for this field will now return false */
  public void clearTransactionAmount() {
    genClient.clear(CacheKey.transactionAmount);
  }
  /** Clears the 'transactionCurrency' field, the 'has' method for this field will now return false */
  public void clearTransactionCurrency() {
    genClient.clear(CacheKey.transactionCurrency);
  }
  /** Clears the 'fpTransactionId' field, the 'has' method for this field will now return false */
  public void clearFpTransactionId() {
    genClient.clear(CacheKey.fpTransactionId);
  }
  /** Clears the 'mrn' field, the 'has' method for this field will now return false */
  public void clearMrn() {
    genClient.clear(CacheKey.mrn);
  }
  /** Clears the 'refundTxnId' field, the 'has' method for this field will now return false */
  public void clearRefundTxnId() {
    genClient.clear(CacheKey.refundTxnId);
  }
  /** Clears the 'transactionStatus' field, the 'has' method for this field will now return false */
  public void clearTransactionStatus() {
    genClient.clear(CacheKey.transactionStatus);
  }
  /** Clears the 'transactionStatusDescription' field, the 'has' method for this field will now return false */
  public void clearTransactionStatusDescription() {
    genClient.clear(CacheKey.transactionStatusDescription);
  }
  /** Clears the 'rrn' field, the 'has' method for this field will now return false */
  public void clearRrn() {
    genClient.clear(CacheKey.rrn);
  }
  /** Clears the 'batchNo' field, the 'has' method for this field will now return false */
  public void clearBatchNo() {
    genClient.clear(CacheKey.batchNo);
  }
  /** Clears the 'invoiceNo' field, the 'has' method for this field will now return false */
  public void clearInvoiceNo() {
    genClient.clear(CacheKey.invoiceNo);
  }
  /** Clears the 'cardScheme' field, the 'has' method for this field will now return false */
  public void clearCardScheme() {
    genClient.clear(CacheKey.cardScheme);
  }
  /** Clears the 'qrType' field, the 'has' method for this field will now return false */
  public void clearQrType() {
    genClient.clear(CacheKey.qrType);
  }
  /** Clears the 'transactionDateTime' field, the 'has' method for this field will now return false */
  public void clearTransactionDateTime() {
    genClient.clear(CacheKey.transactionDateTime);
  }
  /** Clears the 'authCode' field, the 'has' method for this field will now return false */
  public void clearAuthCode() {
    genClient.clear(CacheKey.authCode);
  }
  /** Clears the 'pan' field, the 'has' method for this field will now return false */
  public void clearPan() {
    genClient.clear(CacheKey.pan);
  }
  /** Clears the 'customerMobile' field, the 'has' method for this field will now return false */
  public void clearCustomerMobile() {
    genClient.clear(CacheKey.customerMobile);
  }
  /** Clears the 'customerName' field, the 'has' method for this field will now return false */
  public void clearCustomerName() {
    genClient.clear(CacheKey.customerName);
  }
  /** Clears the 'customerRemarks' field, the 'has' method for this field will now return false */
  public void clearCustomerRemarks() {
    genClient.clear(CacheKey.customerRemarks);
  }
  /** Clears the 'emiDetails' field, the 'has' method for this field will now return false */
  public void clearEmiDetails() {
    genClient.clear(CacheKey.emiDetails);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public OceanGatewayInfo copyChanges() {
    OceanGatewayInfo copy = new OceanGatewayInfo();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(OceanGatewayInfo src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new OceanGatewayInfo(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<OceanGatewayInfo> CREATOR = new android.os.Parcelable.Creator<OceanGatewayInfo>() {
    @Override
    public OceanGatewayInfo createFromParcel(android.os.Parcel in) {
      OceanGatewayInfo instance = new OceanGatewayInfo(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public OceanGatewayInfo[] newArray(int size) {
      return new OceanGatewayInfo[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<OceanGatewayInfo> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<OceanGatewayInfo>() {
    public Class<OceanGatewayInfo> getCreatedClass() {
      return OceanGatewayInfo.class;
    }

    @Override
    public OceanGatewayInfo create(org.json.JSONObject jsonObject) {
      return new OceanGatewayInfo(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean TRANSOURCE_IS_REQUIRED = false;
    public static final boolean TRANCHANNEL_IS_REQUIRED = false;
    public static final boolean TRANTYPE_IS_REQUIRED = false;
    public static final boolean MERCHANTID_IS_REQUIRED = false;
    public static final boolean TERMINALID_IS_REQUIRED = false;
    public static final boolean TENDERTYPE_IS_REQUIRED = false;
    public static final boolean ENTRYMETHOD_IS_REQUIRED = false;
    public static final boolean TRANSACTIONAMOUNT_IS_REQUIRED = false;
    public static final boolean TRANSACTIONCURRENCY_IS_REQUIRED = false;
    public static final boolean FPTRANSACTIONID_IS_REQUIRED = false;
    public static final boolean MRN_IS_REQUIRED = false;
    public static final boolean REFUNDTXNID_IS_REQUIRED = false;
    public static final boolean TRANSACTIONSTATUS_IS_REQUIRED = false;
    public static final boolean TRANSACTIONSTATUSDESCRIPTION_IS_REQUIRED = false;
    public static final boolean RRN_IS_REQUIRED = false;
    public static final boolean BATCHNO_IS_REQUIRED = false;
    public static final boolean INVOICENO_IS_REQUIRED = false;
    public static final boolean CARDSCHEME_IS_REQUIRED = false;
    public static final boolean QRTYPE_IS_REQUIRED = false;
    public static final boolean TRANSACTIONDATETIME_IS_REQUIRED = false;
    public static final boolean AUTHCODE_IS_REQUIRED = false;
    public static final boolean PAN_IS_REQUIRED = false;
    public static final boolean CUSTOMERMOBILE_IS_REQUIRED = false;
    public static final boolean CUSTOMERNAME_IS_REQUIRED = false;
    public static final boolean CUSTOMERREMARKS_IS_REQUIRED = false;
    public static final boolean EMIDETAILS_IS_REQUIRED = false;
  }

}
