/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.payments;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * PayPal/Venmo Callback request object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getPayerId payerId}</li>
 * <li>{@link #getMerchantRefId merchantRefId}</li>
 * <li>{@link #getTimestamp timestamp}</li>
 * <li>{@link #getQrcRefId qrcRefId}</li>
 * <li>{@link #getTransactionId transactionId}</li>
 * <li>{@link #getDeviceUUID deviceUUID}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class PayPalCallbackRequest extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * payer_id provided as part of merchant-presented QR code (MPQRC) id. Encrypted account number of the merchant.
   */
  public java.lang.String getPayerId() {
    return genClient.cacheGet(CacheKey.payerId);
  }

  /**
   * merchant_ref_id provided as part of MPQRC's id. Unique identifier that merchant sends to identify their request.
   */
  public java.lang.String getMerchantRefId() {
    return genClient.cacheGet(CacheKey.merchantRefId);
  }

  /**
   * time_stamp provided as part of MPQRC's id. Specifies the current system time.
   */
  public java.lang.String getTimestamp() {
    return genClient.cacheGet(CacheKey.timestamp);
  }

  /**
   * Unique id used by Clover to make the payment call.
   */
  public java.lang.String getQrcRefId() {
    return genClient.cacheGet(CacheKey.qrcRefId);
  }

  /**
   * UUID of payment. Used only on the client.
   */
  public java.lang.String getTransactionId() {
    return genClient.cacheGet(CacheKey.transactionId);
  }

  /**
   * UUID of Clover device.
   */
  public java.lang.String getDeviceUUID() {
    return genClient.cacheGet(CacheKey.deviceUUID);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    payerId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    merchantRefId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    timestamp
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    qrcRefId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    transactionId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    deviceUUID
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<PayPalCallbackRequest> genClient;

  /**
   * Constructs a new empty instance.
   */
  public PayPalCallbackRequest() {
    genClient = new GenericClient<PayPalCallbackRequest>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected PayPalCallbackRequest(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public PayPalCallbackRequest(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public PayPalCallbackRequest(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public PayPalCallbackRequest(PayPalCallbackRequest src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'payerId' field is set and is not null */
  public boolean isNotNullPayerId() {
    return genClient.cacheValueIsNotNull(CacheKey.payerId);
  }

  /** Checks whether the 'merchantRefId' field is set and is not null */
  public boolean isNotNullMerchantRefId() {
    return genClient.cacheValueIsNotNull(CacheKey.merchantRefId);
  }

  /** Checks whether the 'timestamp' field is set and is not null */
  public boolean isNotNullTimestamp() {
    return genClient.cacheValueIsNotNull(CacheKey.timestamp);
  }

  /** Checks whether the 'qrcRefId' field is set and is not null */
  public boolean isNotNullQrcRefId() {
    return genClient.cacheValueIsNotNull(CacheKey.qrcRefId);
  }

  /** Checks whether the 'transactionId' field is set and is not null */
  public boolean isNotNullTransactionId() {
    return genClient.cacheValueIsNotNull(CacheKey.transactionId);
  }

  /** Checks whether the 'deviceUUID' field is set and is not null */
  public boolean isNotNullDeviceUUID() {
    return genClient.cacheValueIsNotNull(CacheKey.deviceUUID);
  }



  /** Checks whether the 'payerId' field has been set, however the value could be null */
  public boolean hasPayerId() {
    return genClient.cacheHasKey(CacheKey.payerId);
  }

  /** Checks whether the 'merchantRefId' field has been set, however the value could be null */
  public boolean hasMerchantRefId() {
    return genClient.cacheHasKey(CacheKey.merchantRefId);
  }

  /** Checks whether the 'timestamp' field has been set, however the value could be null */
  public boolean hasTimestamp() {
    return genClient.cacheHasKey(CacheKey.timestamp);
  }

  /** Checks whether the 'qrcRefId' field has been set, however the value could be null */
  public boolean hasQrcRefId() {
    return genClient.cacheHasKey(CacheKey.qrcRefId);
  }

  /** Checks whether the 'transactionId' field has been set, however the value could be null */
  public boolean hasTransactionId() {
    return genClient.cacheHasKey(CacheKey.transactionId);
  }

  /** Checks whether the 'deviceUUID' field has been set, however the value could be null */
  public boolean hasDeviceUUID() {
    return genClient.cacheHasKey(CacheKey.deviceUUID);
  }


  /**
   * Sets the field 'payerId'.
   */
  public PayPalCallbackRequest setPayerId(java.lang.String payerId) {
    return genClient.setOther(payerId, CacheKey.payerId);
  }

  /**
   * Sets the field 'merchantRefId'.
   */
  public PayPalCallbackRequest setMerchantRefId(java.lang.String merchantRefId) {
    return genClient.setOther(merchantRefId, CacheKey.merchantRefId);
  }

  /**
   * Sets the field 'timestamp'.
   */
  public PayPalCallbackRequest setTimestamp(java.lang.String timestamp) {
    return genClient.setOther(timestamp, CacheKey.timestamp);
  }

  /**
   * Sets the field 'qrcRefId'.
   */
  public PayPalCallbackRequest setQrcRefId(java.lang.String qrcRefId) {
    return genClient.setOther(qrcRefId, CacheKey.qrcRefId);
  }

  /**
   * Sets the field 'transactionId'.
   */
  public PayPalCallbackRequest setTransactionId(java.lang.String transactionId) {
    return genClient.setOther(transactionId, CacheKey.transactionId);
  }

  /**
   * Sets the field 'deviceUUID'.
   */
  public PayPalCallbackRequest setDeviceUUID(java.lang.String deviceUUID) {
    return genClient.setOther(deviceUUID, CacheKey.deviceUUID);
  }


  /** Clears the 'payerId' field, the 'has' method for this field will now return false */
  public void clearPayerId() {
    genClient.clear(CacheKey.payerId);
  }
  /** Clears the 'merchantRefId' field, the 'has' method for this field will now return false */
  public void clearMerchantRefId() {
    genClient.clear(CacheKey.merchantRefId);
  }
  /** Clears the 'timestamp' field, the 'has' method for this field will now return false */
  public void clearTimestamp() {
    genClient.clear(CacheKey.timestamp);
  }
  /** Clears the 'qrcRefId' field, the 'has' method for this field will now return false */
  public void clearQrcRefId() {
    genClient.clear(CacheKey.qrcRefId);
  }
  /** Clears the 'transactionId' field, the 'has' method for this field will now return false */
  public void clearTransactionId() {
    genClient.clear(CacheKey.transactionId);
  }
  /** Clears the 'deviceUUID' field, the 'has' method for this field will now return false */
  public void clearDeviceUUID() {
    genClient.clear(CacheKey.deviceUUID);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public PayPalCallbackRequest copyChanges() {
    PayPalCallbackRequest copy = new PayPalCallbackRequest();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(PayPalCallbackRequest src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new PayPalCallbackRequest(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<PayPalCallbackRequest> CREATOR = new android.os.Parcelable.Creator<PayPalCallbackRequest>() {
    @Override
    public PayPalCallbackRequest createFromParcel(android.os.Parcel in) {
      PayPalCallbackRequest instance = new PayPalCallbackRequest(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public PayPalCallbackRequest[] newArray(int size) {
      return new PayPalCallbackRequest[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<PayPalCallbackRequest> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<PayPalCallbackRequest>() {
    public Class<PayPalCallbackRequest> getCreatedClass() {
      return PayPalCallbackRequest.class;
    }

    @Override
    public PayPalCallbackRequest create(org.json.JSONObject jsonObject) {
      return new PayPalCallbackRequest(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean PAYERID_IS_REQUIRED = false;
    public static final boolean MERCHANTREFID_IS_REQUIRED = false;
    public static final boolean TIMESTAMP_IS_REQUIRED = false;
    public static final boolean QRCREFID_IS_REQUIRED = false;
    public static final boolean TRANSACTIONID_IS_REQUIRED = false;
    public static final boolean DEVICEUUID_IS_REQUIRED = false;
  }

}
