/**
 * Autogenerated by Avro
 *
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.payments;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getOrder order}</li>
 * <li>{@link #getDevice device}</li>
 * <li>{@link #getTender tender}</li>
 * <li>{@link #getAmount amount}</li>
 * <li>{@link #getTipAmount tipAmount}</li>
 * <li>{@link #getTaxAmount taxAmount}</li>
 * <li>{@link #getCashbackAmount cashbackAmount}</li>
 * <li>{@link #getCashTendered cashTendered}</li>
 * <li>{@link #getExternalPaymentId externalPaymentId}</li>
 * <li>{@link #getEmployee employee}</li>
 * <li>{@link #getCreatedTime createdTime}</li>
 * <li>{@link #getClientCreatedTime clientCreatedTime}</li>
 * <li>{@link #getGatewayProcessingTime gatewayProcessingTime}</li>
 * <li>{@link #getModifiedTime modifiedTime}</li>
 * <li>{@link #getOffline offline}</li>
 * <li>{@link #getResult result}</li>
 * <li>{@link #getCardTransaction cardTransaction}</li>
 * <li>{@link #getServiceCharge serviceCharge}</li>
 * <li>{@link #getAttributes attributes}</li>
 * <li>{@link #getAdditionalCharges additionalCharges}</li>
 * <li>{@link #getTaxRates taxRates}</li>
 * <li>{@link #getRefunds refunds}</li>
 * <li>{@link #getNote note}</li>
 * <li>{@link #getLineItemPayments lineItemPayments}</li>
 * <li>{@link #getAuthorization authorization}</li>
 * <li>{@link #getVoidPaymentRef voidPaymentRef}</li>
 * <li>{@link #getVoidReason voidReason}</li>
 * <li>{@link #getVoidReasonDetails voidReasonDetails}</li>
 * <li>{@link #getDccInfo dccInfo}</li>
 * <li>{@link #getTransactionSettings transactionSettings}</li>
 * <li>{@link #getGermanInfo germanInfo}</li>
 * <li>{@link #getAppTracking appTracking}</li>
 * <li>{@link #getCashAdvanceExtra cashAdvanceExtra}</li>
 * <li>{@link #getTransactionInfo transactionInfo}</li>
 * <li>{@link #getSignatureDisclaimer signatureDisclaimer}</li>
 * <li>{@link #getExternalReferenceId externalReferenceId}</li>
 * <li>{@link #getMerchant merchant}</li>
 * <li>{@link #getIncrements increments}</li>
 * <li>{@link #getPurchaseCardL2 purchaseCardL2}</li>
 * <li>{@link #getPurchaseCardL3 purchaseCardL3}</li>
 * <li>{@link #getOceanGatewayInfo oceanGatewayInfo}</li>
 * <li>{@link #getTerminalManagementComponents terminalManagementComponents}</li>
 * <li>{@link #getEmiInfo emiInfo}</li>
 * <li>{@link #getCloseoutBatchInfo closeoutBatchInfo}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class Payment extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * The order with which the payment is associated
   */
  public com.clover.sdk.v3.base.Reference getOrder() {
    return genClient.cacheGet(CacheKey.order);
  }

  /**
   * Device which processed the transaction for this payment, a 128-bit UUID, not a normal base-13 Clover ID.
   */
  public com.clover.sdk.v3.base.Reference getDevice() {
    return genClient.cacheGet(CacheKey.device);
  }

  /**
   * The tender type associated with this payment, e.g. credit card, cash, etc.
   */
  public com.clover.sdk.v3.base.Tender getTender() {
    return genClient.cacheGet(CacheKey.tender);
  }

  /**
   * Total amount paid
   */
  public java.lang.Long getAmount() {
    return genClient.cacheGet(CacheKey.amount);
  }

  /**
   * Amount paid in tips
   */
  public java.lang.Long getTipAmount() {
    return genClient.cacheGet(CacheKey.tipAmount);
  }

  /**
   * Amount paid in tax
   */
  public java.lang.Long getTaxAmount() {
    return genClient.cacheGet(CacheKey.taxAmount);
  }

  /**
   * Amount given back in a cash back transaction
   */
  public java.lang.Long getCashbackAmount() {
    return genClient.cacheGet(CacheKey.cashbackAmount);
  }

  /**
   * Amount of cash given by the customer
   */
  public java.lang.Long getCashTendered() {
    return genClient.cacheGet(CacheKey.cashTendered);
  }

  public java.lang.String getExternalPaymentId() {
    return genClient.cacheGet(CacheKey.externalPaymentId);
  }

  /**
   * The employee who processed the payment
   */
  public com.clover.sdk.v3.base.Reference getEmployee() {
    return genClient.cacheGet(CacheKey.employee);
  }

  /**
   * Time payment was recorded on server
   */
  public java.lang.Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.createdTime);
  }

  public java.lang.Long getClientCreatedTime() {
    return genClient.cacheGet(CacheKey.clientCreatedTime);
  }

  /**
   * The time when the transaction was processed by the gateway
   */
  public java.lang.Long getGatewayProcessingTime() {
    return genClient.cacheGet(CacheKey.gatewayProcessingTime);
  }

  /**
   * Last modified time of the payment
   */
  public java.lang.Long getModifiedTime() {
    return genClient.cacheGet(CacheKey.modifiedTime);
  }

  public java.lang.Boolean getOffline() {
    return genClient.cacheGet(CacheKey.offline);
  }

  public com.clover.sdk.v3.payments.Result getResult() {
    return genClient.cacheGet(CacheKey.result);
  }

  /**
   * Information about the card used for credit/debit card payments
   */
  public com.clover.sdk.v3.payments.CardTransaction getCardTransaction() {
    return genClient.cacheGet(CacheKey.cardTransaction);
  }

  /**
   * Amount record as a service charge
   */
  public com.clover.sdk.v3.payments.ServiceChargeAmount getServiceCharge() {
    return genClient.cacheGet(CacheKey.serviceCharge);
  }

  public java.util.Map<java.lang.String,java.lang.String> getAttributes() {
    return genClient.cacheGet(CacheKey.attributes);
  }

  public java.util.List<com.clover.sdk.v3.payments.AdditionalChargeAmount> getAdditionalCharges() {
    return genClient.cacheGet(CacheKey.additionalCharges);
  }

  public java.util.List<com.clover.sdk.v3.payments.PaymentTaxRate> getTaxRates() {
    return genClient.cacheGet(CacheKey.taxRates);
  }

  public java.util.List<com.clover.sdk.v3.payments.Refund> getRefunds() {
    return genClient.cacheGet(CacheKey.refunds);
  }

  public java.lang.String getNote() {
    return genClient.cacheGet(CacheKey.note);
  }

  public java.util.List<com.clover.sdk.v3.payments.LineItemPayment> getLineItemPayments() {
    return genClient.cacheGet(CacheKey.lineItemPayments);
  }

  /**
   * Authorization which this payment is associated to (opening or closing payment) if one exists
   */
  public com.clover.sdk.v3.base.Reference getAuthorization() {
    return genClient.cacheGet(CacheKey.authorization);
  }

  /**
   * If voided, the corresponding successful payment, and vice versa
   */
  public com.clover.sdk.v3.base.Reference getVoidPaymentRef() {
    return genClient.cacheGet(CacheKey.voidPaymentRef);
  }

  /**
   * If voided, the reason why (when available)
   */
  public com.clover.sdk.v3.order.VoidReason getVoidReason() {
    return genClient.cacheGet(CacheKey.voidReason);
  }

  /**
   * Detailed explanation on why the transaction is getting voided
   */
  public com.clover.sdk.v3.order.VoidReasonDetails getVoidReasonDetails() {
    return genClient.cacheGet(CacheKey.voidReasonDetails);
  }

  /**
   * Dynamic Currency Conversion information
   */
  public com.clover.sdk.v3.payments.DCCInfo getDccInfo() {
    return genClient.cacheGet(CacheKey.dccInfo);
  }

  /**
   * Per transaction settings for the payment
   */
  public com.clover.sdk.v3.payments.TransactionSettings getTransactionSettings() {
    return genClient.cacheGet(CacheKey.transactionSettings);
  }

  /**
   * German region-specific information
   */
  public com.clover.sdk.v3.payments.GermanInfo getGermanInfo() {
    return genClient.cacheGet(CacheKey.germanInfo);
  }

  /**
   * Tracking information for the app that created this payment.
   */
  public com.clover.sdk.v3.apps.AppTracking getAppTracking() {
    return genClient.cacheGet(CacheKey.appTracking);
  }

  /**
   * Information specific to cash advance transactions.
   */
  public com.clover.sdk.v3.payments.CashAdvanceExtra getCashAdvanceExtra() {
    return genClient.cacheGet(CacheKey.cashAdvanceExtra);
  }

  /**
   * Transaction information
   */
  public com.clover.sdk.v3.payments.TransactionInfo getTransactionInfo() {
    return genClient.cacheGet(CacheKey.transactionInfo);
  }

  /**
   * Information displayed to customer for storing electronic signatures
   */
  public com.clover.sdk.v3.payments.SignatureDisclaimer getSignatureDisclaimer() {
    return genClient.cacheGet(CacheKey.signatureDisclaimer);
  }

  /**
   * The external reference id if associated with the payment
   */
  public java.lang.String getExternalReferenceId() {
    return genClient.cacheGet(CacheKey.externalReferenceId);
  }

  public com.clover.sdk.v3.base.Reference getMerchant() {
    return genClient.cacheGet(CacheKey.merchant);
  }

  public java.util.List<com.clover.sdk.v3.payments.IncrementalAuthorization> getIncrements() {
    return genClient.cacheGet(CacheKey.increments);
  }

  /**
   * Purchase card level 2 data
   */
  public com.clover.sdk.v3.payments.PurchaseCardL2 getPurchaseCardL2() {
    return genClient.cacheGet(CacheKey.purchaseCardL2);
  }

  /**
   * Purchase card level 3 data
   */
  public com.clover.sdk.v3.payments.PurchaseCardL3 getPurchaseCardL3() {
    return genClient.cacheGet(CacheKey.purchaseCardL3);
  }

  /**
   * Ocean Gateway info
   */
  public com.clover.sdk.v3.payments.OceanGatewayInfo getOceanGatewayInfo() {
    return genClient.cacheGet(CacheKey.oceanGatewayInfo);
  }

  /**
   * Terminal management components as defined by Nexo. They contain general information on the terminal, the installed payment app, etc.
   */
  public java.util.List<com.clover.sdk.v3.payments.TerminalManagementComponent> getTerminalManagementComponents() {
    return genClient.cacheGet(CacheKey.terminalManagementComponents);
  }

  /**
   * Associated EMI information
   */
  public com.clover.sdk.v3.payments.PaymentEmiInfo getEmiInfo() {
    return genClient.cacheGet(CacheKey.emiInfo);
  }

  /**
   * Information about the Batch used for payments
   */
  public com.clover.sdk.v3.payments.CloseoutBatchInfo getCloseoutBatchInfo() {
    return genClient.cacheGet(CacheKey.closeoutBatchInfo);
  }

  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    order
            (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    device
            (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    tender
            (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Tender.JSON_CREATOR)),
    amount
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    tipAmount
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    taxAmount
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    cashbackAmount
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    cashTendered
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    externalPaymentId
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    employee
            (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    createdTime
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    clientCreatedTime
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    gatewayProcessingTime
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    modifiedTime
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    offline
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    result
            (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.payments.Result.class)),
    cardTransaction
            (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.CardTransaction.JSON_CREATOR)),
    serviceCharge
            (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.ServiceChargeAmount.JSON_CREATOR)),
    attributes
            (com.clover.sdk.extractors.MapExtractionStrategy.instance()),
    additionalCharges
            (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.payments.AdditionalChargeAmount.JSON_CREATOR)),
    taxRates
            (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.payments.PaymentTaxRate.JSON_CREATOR)),
    refunds
            (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.payments.Refund.JSON_CREATOR)),
    note
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    lineItemPayments
            (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.payments.LineItemPayment.JSON_CREATOR)),
    authorization
            (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    voidPaymentRef
            (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    voidReason
            (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.order.VoidReason.class)),
    voidReasonDetails
            (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.order.VoidReasonDetails.JSON_CREATOR)),
    dccInfo
            (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.DCCInfo.JSON_CREATOR)),
    transactionSettings
            (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.TransactionSettings.JSON_CREATOR)),
    germanInfo
            (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.GermanInfo.JSON_CREATOR)),
    appTracking
            (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.apps.AppTracking.JSON_CREATOR)),
    cashAdvanceExtra
            (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.CashAdvanceExtra.JSON_CREATOR)),
    transactionInfo
            (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.TransactionInfo.JSON_CREATOR)),
    signatureDisclaimer
            (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.SignatureDisclaimer.JSON_CREATOR)),
    externalReferenceId
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    merchant
            (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    increments
            (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.payments.IncrementalAuthorization.JSON_CREATOR)),
    purchaseCardL2
            (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.PurchaseCardL2.JSON_CREATOR)),
    purchaseCardL3
            (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.PurchaseCardL3.JSON_CREATOR)),
    oceanGatewayInfo
            (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.OceanGatewayInfo.JSON_CREATOR)),
    terminalManagementComponents
            (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.payments.TerminalManagementComponent.JSON_CREATOR)),
    emiInfo
            (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.PaymentEmiInfo.JSON_CREATOR)),
    closeoutBatchInfo
            (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.CloseoutBatchInfo.JSON_CREATOR)),
    ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<Payment> genClient;

  /**
   * Constructs a new empty instance.
   */
  public Payment() {
    genClient = new GenericClient<Payment>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected Payment(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public Payment(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public Payment(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public Payment(Payment src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());

    genClient.validateLength(CacheKey.externalPaymentId, getExternalPaymentId(), 32);

    genClient.validateLength(CacheKey.note, getNote(), 255);
    genClient.validateReferences(CacheKey.order);
    genClient.validateReferences(CacheKey.employee);
    genClient.validateReferences(CacheKey.authorization);
    genClient.validateReferences(CacheKey.voidPaymentRef);
    genClient.validateReferences(CacheKey.merchant);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'order' field is set and is not null */
  public boolean isNotNullOrder() {
    return genClient.cacheValueIsNotNull(CacheKey.order);
  }

  /** Checks whether the 'device' field is set and is not null */
  public boolean isNotNullDevice() {
    return genClient.cacheValueIsNotNull(CacheKey.device);
  }

  /** Checks whether the 'tender' field is set and is not null */
  public boolean isNotNullTender() {
    return genClient.cacheValueIsNotNull(CacheKey.tender);
  }

  /** Checks whether the 'amount' field is set and is not null */
  public boolean isNotNullAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.amount);
  }

  /** Checks whether the 'tipAmount' field is set and is not null */
  public boolean isNotNullTipAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.tipAmount);
  }

  /** Checks whether the 'taxAmount' field is set and is not null */
  public boolean isNotNullTaxAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.taxAmount);
  }

  /** Checks whether the 'cashbackAmount' field is set and is not null */
  public boolean isNotNullCashbackAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.cashbackAmount);
  }

  /** Checks whether the 'cashTendered' field is set and is not null */
  public boolean isNotNullCashTendered() {
    return genClient.cacheValueIsNotNull(CacheKey.cashTendered);
  }

  /** Checks whether the 'externalPaymentId' field is set and is not null */
  public boolean isNotNullExternalPaymentId() {
    return genClient.cacheValueIsNotNull(CacheKey.externalPaymentId);
  }

  /** Checks whether the 'employee' field is set and is not null */
  public boolean isNotNullEmployee() {
    return genClient.cacheValueIsNotNull(CacheKey.employee);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'clientCreatedTime' field is set and is not null */
  public boolean isNotNullClientCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.clientCreatedTime);
  }

  /** Checks whether the 'gatewayProcessingTime' field is set and is not null */
  public boolean isNotNullGatewayProcessingTime() {
    return genClient.cacheValueIsNotNull(CacheKey.gatewayProcessingTime);
  }

  /** Checks whether the 'modifiedTime' field is set and is not null */
  public boolean isNotNullModifiedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.modifiedTime);
  }

  /** Checks whether the 'offline' field is set and is not null */
  public boolean isNotNullOffline() {
    return genClient.cacheValueIsNotNull(CacheKey.offline);
  }

  /** Checks whether the 'result' field is set and is not null */
  public boolean isNotNullResult() {
    return genClient.cacheValueIsNotNull(CacheKey.result);
  }

  /** Checks whether the 'cardTransaction' field is set and is not null */
  public boolean isNotNullCardTransaction() {
    return genClient.cacheValueIsNotNull(CacheKey.cardTransaction);
  }

  /** Checks whether the 'serviceCharge' field is set and is not null */
  public boolean isNotNullServiceCharge() {
    return genClient.cacheValueIsNotNull(CacheKey.serviceCharge);
  }

  /** Checks whether the 'attributes' field is set and is not null */
  public boolean isNotNullAttributes() {
    return genClient.cacheValueIsNotNull(CacheKey.attributes);
  }

  /** Checks whether the 'attributes' field is set and is not null and is not empty */
  public boolean isNotEmptyAttributes() { return isNotNullAttributes() && !getAttributes().isEmpty(); }

  /** Checks whether the 'additionalCharges' field is set and is not null */
  public boolean isNotNullAdditionalCharges() {
    return genClient.cacheValueIsNotNull(CacheKey.additionalCharges);
  }

  /** Checks whether the 'additionalCharges' field is set and is not null and is not empty */
  public boolean isNotEmptyAdditionalCharges() { return isNotNullAdditionalCharges() && !getAdditionalCharges().isEmpty(); }

  /** Checks whether the 'taxRates' field is set and is not null */
  public boolean isNotNullTaxRates() {
    return genClient.cacheValueIsNotNull(CacheKey.taxRates);
  }

  /** Checks whether the 'taxRates' field is set and is not null and is not empty */
  public boolean isNotEmptyTaxRates() { return isNotNullTaxRates() && !getTaxRates().isEmpty(); }

  /** Checks whether the 'refunds' field is set and is not null */
  public boolean isNotNullRefunds() {
    return genClient.cacheValueIsNotNull(CacheKey.refunds);
  }

  /** Checks whether the 'refunds' field is set and is not null and is not empty */
  public boolean isNotEmptyRefunds() { return isNotNullRefunds() && !getRefunds().isEmpty(); }

  /** Checks whether the 'note' field is set and is not null */
  public boolean isNotNullNote() {
    return genClient.cacheValueIsNotNull(CacheKey.note);
  }

  /** Checks whether the 'lineItemPayments' field is set and is not null */
  public boolean isNotNullLineItemPayments() {
    return genClient.cacheValueIsNotNull(CacheKey.lineItemPayments);
  }

  /** Checks whether the 'lineItemPayments' field is set and is not null and is not empty */
  public boolean isNotEmptyLineItemPayments() { return isNotNullLineItemPayments() && !getLineItemPayments().isEmpty(); }

  /** Checks whether the 'authorization' field is set and is not null */
  public boolean isNotNullAuthorization() {
    return genClient.cacheValueIsNotNull(CacheKey.authorization);
  }

  /** Checks whether the 'voidPaymentRef' field is set and is not null */
  public boolean isNotNullVoidPaymentRef() {
    return genClient.cacheValueIsNotNull(CacheKey.voidPaymentRef);
  }

  /** Checks whether the 'voidReason' field is set and is not null */
  public boolean isNotNullVoidReason() {
    return genClient.cacheValueIsNotNull(CacheKey.voidReason);
  }

  /** Checks whether the 'voidReasonDetails' field is set and is not null */
  public boolean isNotNullVoidReasonDetails() {
    return genClient.cacheValueIsNotNull(CacheKey.voidReasonDetails);
  }

  /** Checks whether the 'dccInfo' field is set and is not null */
  public boolean isNotNullDccInfo() {
    return genClient.cacheValueIsNotNull(CacheKey.dccInfo);
  }

  /** Checks whether the 'transactionSettings' field is set and is not null */
  public boolean isNotNullTransactionSettings() {
    return genClient.cacheValueIsNotNull(CacheKey.transactionSettings);
  }

  /** Checks whether the 'germanInfo' field is set and is not null */
  public boolean isNotNullGermanInfo() {
    return genClient.cacheValueIsNotNull(CacheKey.germanInfo);
  }

  /** Checks whether the 'appTracking' field is set and is not null */
  public boolean isNotNullAppTracking() {
    return genClient.cacheValueIsNotNull(CacheKey.appTracking);
  }

  /** Checks whether the 'cashAdvanceExtra' field is set and is not null */
  public boolean isNotNullCashAdvanceExtra() {
    return genClient.cacheValueIsNotNull(CacheKey.cashAdvanceExtra);
  }

  /** Checks whether the 'transactionInfo' field is set and is not null */
  public boolean isNotNullTransactionInfo() {
    return genClient.cacheValueIsNotNull(CacheKey.transactionInfo);
  }

  /** Checks whether the 'signatureDisclaimer' field is set and is not null */
  public boolean isNotNullSignatureDisclaimer() {
    return genClient.cacheValueIsNotNull(CacheKey.signatureDisclaimer);
  }

  /** Checks whether the 'externalReferenceId' field is set and is not null */
  public boolean isNotNullExternalReferenceId() {
    return genClient.cacheValueIsNotNull(CacheKey.externalReferenceId);
  }

  /** Checks whether the 'merchant' field is set and is not null */
  public boolean isNotNullMerchant() {
    return genClient.cacheValueIsNotNull(CacheKey.merchant);
  }

  /** Checks whether the 'increments' field is set and is not null */
  public boolean isNotNullIncrements() {
    return genClient.cacheValueIsNotNull(CacheKey.increments);
  }

  /** Checks whether the 'increments' field is set and is not null and is not empty */
  public boolean isNotEmptyIncrements() { return isNotNullIncrements() && !getIncrements().isEmpty(); }

  /** Checks whether the 'purchaseCardL2' field is set and is not null */
  public boolean isNotNullPurchaseCardL2() {
    return genClient.cacheValueIsNotNull(CacheKey.purchaseCardL2);
  }

  /** Checks whether the 'purchaseCardL3' field is set and is not null */
  public boolean isNotNullPurchaseCardL3() {
    return genClient.cacheValueIsNotNull(CacheKey.purchaseCardL3);
  }

  /** Checks whether the 'oceanGatewayInfo' field is set and is not null */
  public boolean isNotNullOceanGatewayInfo() {
    return genClient.cacheValueIsNotNull(CacheKey.oceanGatewayInfo);
  }

  /** Checks whether the 'terminalManagementComponents' field is set and is not null */
  public boolean isNotNullTerminalManagementComponents() {
    return genClient.cacheValueIsNotNull(CacheKey.terminalManagementComponents);
  }

  /** Checks whether the 'terminalManagementComponents' field is set and is not null and is not empty */
  public boolean isNotEmptyTerminalManagementComponents() { return isNotNullTerminalManagementComponents() && !getTerminalManagementComponents().isEmpty(); }

  /** Checks whether the 'emiInfo' field is set and is not null */
  public boolean isNotNullEmiInfo() {
    return genClient.cacheValueIsNotNull(CacheKey.emiInfo);
  }

  /** Checks whether the 'closeoutBatchInfo' field is set and is not null */
  public boolean isNotNullCloseoutBatchInfo() {
    return genClient.cacheValueIsNotNull(CacheKey.closeoutBatchInfo);
  }


  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'order' field has been set, however the value could be null */
  public boolean hasOrder() {
    return genClient.cacheHasKey(CacheKey.order);
  }

  /** Checks whether the 'device' field has been set, however the value could be null */
  public boolean hasDevice() {
    return genClient.cacheHasKey(CacheKey.device);
  }

  /** Checks whether the 'tender' field has been set, however the value could be null */
  public boolean hasTender() {
    return genClient.cacheHasKey(CacheKey.tender);
  }

  /** Checks whether the 'amount' field has been set, however the value could be null */
  public boolean hasAmount() {
    return genClient.cacheHasKey(CacheKey.amount);
  }

  /** Checks whether the 'tipAmount' field has been set, however the value could be null */
  public boolean hasTipAmount() {
    return genClient.cacheHasKey(CacheKey.tipAmount);
  }

  /** Checks whether the 'taxAmount' field has been set, however the value could be null */
  public boolean hasTaxAmount() {
    return genClient.cacheHasKey(CacheKey.taxAmount);
  }

  /** Checks whether the 'cashbackAmount' field has been set, however the value could be null */
  public boolean hasCashbackAmount() {
    return genClient.cacheHasKey(CacheKey.cashbackAmount);
  }

  /** Checks whether the 'cashTendered' field has been set, however the value could be null */
  public boolean hasCashTendered() {
    return genClient.cacheHasKey(CacheKey.cashTendered);
  }

  /** Checks whether the 'externalPaymentId' field has been set, however the value could be null */
  public boolean hasExternalPaymentId() {
    return genClient.cacheHasKey(CacheKey.externalPaymentId);
  }

  /** Checks whether the 'employee' field has been set, however the value could be null */
  public boolean hasEmployee() {
    return genClient.cacheHasKey(CacheKey.employee);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'clientCreatedTime' field has been set, however the value could be null */
  public boolean hasClientCreatedTime() {
    return genClient.cacheHasKey(CacheKey.clientCreatedTime);
  }

  /** Checks whether the 'gatewayProcessingTime' field has been set, however the value could be null */
  public boolean hasGatewayProcessingTime() {
    return genClient.cacheHasKey(CacheKey.gatewayProcessingTime);
  }

  /** Checks whether the 'modifiedTime' field has been set, however the value could be null */
  public boolean hasModifiedTime() {
    return genClient.cacheHasKey(CacheKey.modifiedTime);
  }

  /** Checks whether the 'offline' field has been set, however the value could be null */
  public boolean hasOffline() {
    return genClient.cacheHasKey(CacheKey.offline);
  }

  /** Checks whether the 'result' field has been set, however the value could be null */
  public boolean hasResult() {
    return genClient.cacheHasKey(CacheKey.result);
  }

  /** Checks whether the 'cardTransaction' field has been set, however the value could be null */
  public boolean hasCardTransaction() {
    return genClient.cacheHasKey(CacheKey.cardTransaction);
  }

  /** Checks whether the 'serviceCharge' field has been set, however the value could be null */
  public boolean hasServiceCharge() {
    return genClient.cacheHasKey(CacheKey.serviceCharge);
  }

  /** Checks whether the 'attributes' field has been set, however the value could be null */
  public boolean hasAttributes() {
    return genClient.cacheHasKey(CacheKey.attributes);
  }

  /** Checks whether the 'additionalCharges' field has been set, however the value could be null */
  public boolean hasAdditionalCharges() {
    return genClient.cacheHasKey(CacheKey.additionalCharges);
  }

  /** Checks whether the 'taxRates' field has been set, however the value could be null */
  public boolean hasTaxRates() {
    return genClient.cacheHasKey(CacheKey.taxRates);
  }

  /** Checks whether the 'refunds' field has been set, however the value could be null */
  public boolean hasRefunds() {
    return genClient.cacheHasKey(CacheKey.refunds);
  }

  /** Checks whether the 'note' field has been set, however the value could be null */
  public boolean hasNote() {
    return genClient.cacheHasKey(CacheKey.note);
  }

  /** Checks whether the 'lineItemPayments' field has been set, however the value could be null */
  public boolean hasLineItemPayments() {
    return genClient.cacheHasKey(CacheKey.lineItemPayments);
  }

  /** Checks whether the 'authorization' field has been set, however the value could be null */
  public boolean hasAuthorization() {
    return genClient.cacheHasKey(CacheKey.authorization);
  }

  /** Checks whether the 'voidPaymentRef' field has been set, however the value could be null */
  public boolean hasVoidPaymentRef() {
    return genClient.cacheHasKey(CacheKey.voidPaymentRef);
  }

  /** Checks whether the 'voidReason' field has been set, however the value could be null */
  public boolean hasVoidReason() {
    return genClient.cacheHasKey(CacheKey.voidReason);
  }

  /** Checks whether the 'voidReasonDetails' field has been set, however the value could be null */
  public boolean hasVoidReasonDetails() {
    return genClient.cacheHasKey(CacheKey.voidReasonDetails);
  }

  /** Checks whether the 'dccInfo' field has been set, however the value could be null */
  public boolean hasDccInfo() {
    return genClient.cacheHasKey(CacheKey.dccInfo);
  }

  /** Checks whether the 'transactionSettings' field has been set, however the value could be null */
  public boolean hasTransactionSettings() {
    return genClient.cacheHasKey(CacheKey.transactionSettings);
  }

  /** Checks whether the 'germanInfo' field has been set, however the value could be null */
  public boolean hasGermanInfo() {
    return genClient.cacheHasKey(CacheKey.germanInfo);
  }

  /** Checks whether the 'appTracking' field has been set, however the value could be null */
  public boolean hasAppTracking() {
    return genClient.cacheHasKey(CacheKey.appTracking);
  }

  /** Checks whether the 'cashAdvanceExtra' field has been set, however the value could be null */
  public boolean hasCashAdvanceExtra() {
    return genClient.cacheHasKey(CacheKey.cashAdvanceExtra);
  }

  /** Checks whether the 'transactionInfo' field has been set, however the value could be null */
  public boolean hasTransactionInfo() {
    return genClient.cacheHasKey(CacheKey.transactionInfo);
  }

  /** Checks whether the 'signatureDisclaimer' field has been set, however the value could be null */
  public boolean hasSignatureDisclaimer() {
    return genClient.cacheHasKey(CacheKey.signatureDisclaimer);
  }

  /** Checks whether the 'externalReferenceId' field has been set, however the value could be null */
  public boolean hasExternalReferenceId() {
    return genClient.cacheHasKey(CacheKey.externalReferenceId);
  }

  /** Checks whether the 'merchant' field has been set, however the value could be null */
  public boolean hasMerchant() {
    return genClient.cacheHasKey(CacheKey.merchant);
  }

  /** Checks whether the 'increments' field has been set, however the value could be null */
  public boolean hasIncrements() {
    return genClient.cacheHasKey(CacheKey.increments);
  }

  /** Checks whether the 'purchaseCardL2' field has been set, however the value could be null */
  public boolean hasPurchaseCardL2() {
    return genClient.cacheHasKey(CacheKey.purchaseCardL2);
  }

  /** Checks whether the 'purchaseCardL3' field has been set, however the value could be null */
  public boolean hasPurchaseCardL3() {
    return genClient.cacheHasKey(CacheKey.purchaseCardL3);
  }

  /** Checks whether the 'oceanGatewayInfo' field has been set, however the value could be null */
  public boolean hasOceanGatewayInfo() {
    return genClient.cacheHasKey(CacheKey.oceanGatewayInfo);
  }

  /** Checks whether the 'terminalManagementComponents' field has been set, however the value could be null */
  public boolean hasTerminalManagementComponents() {
    return genClient.cacheHasKey(CacheKey.terminalManagementComponents);
  }

  /** Checks whether the 'emiInfo' field has been set, however the value could be null */
  public boolean hasEmiInfo() {
    return genClient.cacheHasKey(CacheKey.emiInfo);
  }

  /** Checks whether the 'closeoutBatchInfo' field has been set, however the value could be null */
  public boolean hasCloseoutBatchInfo() {
    return genClient.cacheHasKey(CacheKey.closeoutBatchInfo);
  }

  /**
   * Sets the field 'id'.
   */
  public Payment setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'order'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setOrder(com.clover.sdk.v3.base.Reference order) {
    return genClient.setRecord(order, CacheKey.order);
  }

  /**
   * Sets the field 'device'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setDevice(com.clover.sdk.v3.base.Reference device) {
    return genClient.setRecord(device, CacheKey.device);
  }

  /**
   * Sets the field 'tender'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setTender(com.clover.sdk.v3.base.Tender tender) {
    return genClient.setRecord(tender, CacheKey.tender);
  }

  /**
   * Sets the field 'amount'.
   */
  public Payment setAmount(java.lang.Long amount) {
    return genClient.setOther(amount, CacheKey.amount);
  }

  /**
   * Sets the field 'tipAmount'.
   */
  public Payment setTipAmount(java.lang.Long tipAmount) {
    return genClient.setOther(tipAmount, CacheKey.tipAmount);
  }

  /**
   * Sets the field 'taxAmount'.
   */
  public Payment setTaxAmount(java.lang.Long taxAmount) {
    return genClient.setOther(taxAmount, CacheKey.taxAmount);
  }

  /**
   * Sets the field 'cashbackAmount'.
   */
  public Payment setCashbackAmount(java.lang.Long cashbackAmount) {
    return genClient.setOther(cashbackAmount, CacheKey.cashbackAmount);
  }

  /**
   * Sets the field 'cashTendered'.
   */
  public Payment setCashTendered(java.lang.Long cashTendered) {
    return genClient.setOther(cashTendered, CacheKey.cashTendered);
  }

  /**
   * Sets the field 'externalPaymentId'.
   */
  public Payment setExternalPaymentId(java.lang.String externalPaymentId) {
    return genClient.setOther(externalPaymentId, CacheKey.externalPaymentId);
  }

  /**
   * Sets the field 'employee'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setEmployee(com.clover.sdk.v3.base.Reference employee) {
    return genClient.setRecord(employee, CacheKey.employee);
  }

  /**
   * Sets the field 'createdTime'.
   */
  public Payment setCreatedTime(java.lang.Long createdTime) {
    return genClient.setOther(createdTime, CacheKey.createdTime);
  }

  /**
   * Sets the field 'clientCreatedTime'.
   */
  public Payment setClientCreatedTime(java.lang.Long clientCreatedTime) {
    return genClient.setOther(clientCreatedTime, CacheKey.clientCreatedTime);
  }

  /**
   * Sets the field 'gatewayProcessingTime'.
   */
  public Payment setGatewayProcessingTime(java.lang.Long gatewayProcessingTime) {
    return genClient.setOther(gatewayProcessingTime, CacheKey.gatewayProcessingTime);
  }

  /**
   * Sets the field 'modifiedTime'.
   */
  public Payment setModifiedTime(java.lang.Long modifiedTime) {
    return genClient.setOther(modifiedTime, CacheKey.modifiedTime);
  }

  /**
   * Sets the field 'offline'.
   */
  public Payment setOffline(java.lang.Boolean offline) {
    return genClient.setOther(offline, CacheKey.offline);
  }

  /**
   * Sets the field 'result'.
   */
  public Payment setResult(com.clover.sdk.v3.payments.Result result) {
    return genClient.setOther(result, CacheKey.result);
  }

  /**
   * Sets the field 'cardTransaction'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setCardTransaction(com.clover.sdk.v3.payments.CardTransaction cardTransaction) {
    return genClient.setRecord(cardTransaction, CacheKey.cardTransaction);
  }

  /**
   * Sets the field 'serviceCharge'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setServiceCharge(com.clover.sdk.v3.payments.ServiceChargeAmount serviceCharge) {
    return genClient.setRecord(serviceCharge, CacheKey.serviceCharge);
  }

  /**
   * Sets the field 'attributes'.
   */
  public Payment setAttributes(java.util.Map<java.lang.String,java.lang.String> attributes) {
    return genClient.setOther(attributes, CacheKey.attributes);
  }

  /**
   * Sets the field 'additionalCharges'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Payment setAdditionalCharges(java.util.List<com.clover.sdk.v3.payments.AdditionalChargeAmount> additionalCharges) {
    return genClient.setArrayRecord(additionalCharges, CacheKey.additionalCharges);
  }

  /**
   * Sets the field 'taxRates'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Payment setTaxRates(java.util.List<com.clover.sdk.v3.payments.PaymentTaxRate> taxRates) {
    return genClient.setArrayRecord(taxRates, CacheKey.taxRates);
  }

  /**
   * Sets the field 'refunds'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Payment setRefunds(java.util.List<com.clover.sdk.v3.payments.Refund> refunds) {
    return genClient.setArrayRecord(refunds, CacheKey.refunds);
  }

  /**
   * Sets the field 'note'.
   */
  public Payment setNote(java.lang.String note) {
    return genClient.setOther(note, CacheKey.note);
  }

  /**
   * Sets the field 'lineItemPayments'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Payment setLineItemPayments(java.util.List<com.clover.sdk.v3.payments.LineItemPayment> lineItemPayments) {
    return genClient.setArrayRecord(lineItemPayments, CacheKey.lineItemPayments);
  }

  /**
   * Sets the field 'authorization'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setAuthorization(com.clover.sdk.v3.base.Reference authorization) {
    return genClient.setRecord(authorization, CacheKey.authorization);
  }

  /**
   * Sets the field 'voidPaymentRef'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setVoidPaymentRef(com.clover.sdk.v3.base.Reference voidPaymentRef) {
    return genClient.setRecord(voidPaymentRef, CacheKey.voidPaymentRef);
  }

  /**
   * Sets the field 'voidReason'.
   */
  public Payment setVoidReason(com.clover.sdk.v3.order.VoidReason voidReason) {
    return genClient.setOther(voidReason, CacheKey.voidReason);
  }

  /**
   * Sets the field 'voidReasonDetails'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setVoidReasonDetails(com.clover.sdk.v3.order.VoidReasonDetails voidReasonDetails) {
    return genClient.setRecord(voidReasonDetails, CacheKey.voidReasonDetails);
  }

  /**
   * Sets the field 'dccInfo'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setDccInfo(com.clover.sdk.v3.payments.DCCInfo dccInfo) {
    return genClient.setRecord(dccInfo, CacheKey.dccInfo);
  }

  /**
   * Sets the field 'transactionSettings'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setTransactionSettings(com.clover.sdk.v3.payments.TransactionSettings transactionSettings) {
    return genClient.setRecord(transactionSettings, CacheKey.transactionSettings);
  }

  /**
   * Sets the field 'germanInfo'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setGermanInfo(com.clover.sdk.v3.payments.GermanInfo germanInfo) {
    return genClient.setRecord(germanInfo, CacheKey.germanInfo);
  }

  /**
   * Sets the field 'appTracking'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setAppTracking(com.clover.sdk.v3.apps.AppTracking appTracking) {
    return genClient.setRecord(appTracking, CacheKey.appTracking);
  }

  /**
   * Sets the field 'cashAdvanceExtra'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setCashAdvanceExtra(com.clover.sdk.v3.payments.CashAdvanceExtra cashAdvanceExtra) {
    return genClient.setRecord(cashAdvanceExtra, CacheKey.cashAdvanceExtra);
  }

  /**
   * Sets the field 'transactionInfo'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setTransactionInfo(com.clover.sdk.v3.payments.TransactionInfo transactionInfo) {
    return genClient.setRecord(transactionInfo, CacheKey.transactionInfo);
  }

  /**
   * Sets the field 'signatureDisclaimer'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setSignatureDisclaimer(com.clover.sdk.v3.payments.SignatureDisclaimer signatureDisclaimer) {
    return genClient.setRecord(signatureDisclaimer, CacheKey.signatureDisclaimer);
  }

  /**
   * Sets the field 'externalReferenceId'.
   */
  public Payment setExternalReferenceId(java.lang.String externalReferenceId) {
    return genClient.setOther(externalReferenceId, CacheKey.externalReferenceId);
  }

  /**
   * Sets the field 'merchant'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setMerchant(com.clover.sdk.v3.base.Reference merchant) {
    return genClient.setRecord(merchant, CacheKey.merchant);
  }

  /**
   * Sets the field 'increments'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Payment setIncrements(java.util.List<com.clover.sdk.v3.payments.IncrementalAuthorization> increments) {
    return genClient.setArrayRecord(increments, CacheKey.increments);
  }

  /**
   * Sets the field 'purchaseCardL2'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setPurchaseCardL2(com.clover.sdk.v3.payments.PurchaseCardL2 purchaseCardL2) {
    return genClient.setRecord(purchaseCardL2, CacheKey.purchaseCardL2);
  }

  /**
   * Sets the field 'purchaseCardL3'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setPurchaseCardL3(com.clover.sdk.v3.payments.PurchaseCardL3 purchaseCardL3) {
    return genClient.setRecord(purchaseCardL3, CacheKey.purchaseCardL3);
  }

  /**
   * Sets the field 'oceanGatewayInfo'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setOceanGatewayInfo(com.clover.sdk.v3.payments.OceanGatewayInfo oceanGatewayInfo) {
    return genClient.setRecord(oceanGatewayInfo, CacheKey.oceanGatewayInfo);
  }

  /**
   * Sets the field 'terminalManagementComponents'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Payment setTerminalManagementComponents(java.util.List<com.clover.sdk.v3.payments.TerminalManagementComponent> terminalManagementComponents) {
    return genClient.setArrayRecord(terminalManagementComponents, CacheKey.terminalManagementComponents);
  }

  /**
   * Sets the field 'emiInfo'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setEmiInfo(com.clover.sdk.v3.payments.PaymentEmiInfo emiInfo) {
    return genClient.setRecord(emiInfo, CacheKey.emiInfo);
  }

  /**
   * Sets the field 'closeoutBatchInfo'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setCloseoutBatchInfo(com.clover.sdk.v3.payments.CloseoutBatchInfo closeoutBatchInfo) {
    return genClient.setRecord(closeoutBatchInfo, CacheKey.closeoutBatchInfo);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'order' field, the 'has' method for this field will now return false */
  public void clearOrder() {
    genClient.clear(CacheKey.order);
  }
  /** Clears the 'device' field, the 'has' method for this field will now return false */
  public void clearDevice() {
    genClient.clear(CacheKey.device);
  }
  /** Clears the 'tender' field, the 'has' method for this field will now return false */
  public void clearTender() {
    genClient.clear(CacheKey.tender);
  }
  /** Clears the 'amount' field, the 'has' method for this field will now return false */
  public void clearAmount() {
    genClient.clear(CacheKey.amount);
  }
  /** Clears the 'tipAmount' field, the 'has' method for this field will now return false */
  public void clearTipAmount() {
    genClient.clear(CacheKey.tipAmount);
  }
  /** Clears the 'taxAmount' field, the 'has' method for this field will now return false */
  public void clearTaxAmount() {
    genClient.clear(CacheKey.taxAmount);
  }
  /** Clears the 'cashbackAmount' field, the 'has' method for this field will now return false */
  public void clearCashbackAmount() {
    genClient.clear(CacheKey.cashbackAmount);
  }
  /** Clears the 'cashTendered' field, the 'has' method for this field will now return false */
  public void clearCashTendered() {
    genClient.clear(CacheKey.cashTendered);
  }
  /** Clears the 'externalPaymentId' field, the 'has' method for this field will now return false */
  public void clearExternalPaymentId() {
    genClient.clear(CacheKey.externalPaymentId);
  }
  /** Clears the 'employee' field, the 'has' method for this field will now return false */
  public void clearEmployee() {
    genClient.clear(CacheKey.employee);
  }
  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.createdTime);
  }
  /** Clears the 'clientCreatedTime' field, the 'has' method for this field will now return false */
  public void clearClientCreatedTime() {
    genClient.clear(CacheKey.clientCreatedTime);
  }
  /** Clears the 'gatewayProcessingTime' field, the 'has' method for this field will now return false */
  public void clearGatewayProcessingTime() {
    genClient.clear(CacheKey.gatewayProcessingTime);
  }
  /** Clears the 'modifiedTime' field, the 'has' method for this field will now return false */
  public void clearModifiedTime() {
    genClient.clear(CacheKey.modifiedTime);
  }
  /** Clears the 'offline' field, the 'has' method for this field will now return false */
  public void clearOffline() {
    genClient.clear(CacheKey.offline);
  }
  /** Clears the 'result' field, the 'has' method for this field will now return false */
  public void clearResult() {
    genClient.clear(CacheKey.result);
  }
  /** Clears the 'cardTransaction' field, the 'has' method for this field will now return false */
  public void clearCardTransaction() {
    genClient.clear(CacheKey.cardTransaction);
  }
  /** Clears the 'serviceCharge' field, the 'has' method for this field will now return false */
  public void clearServiceCharge() {
    genClient.clear(CacheKey.serviceCharge);
  }
  /** Clears the 'attributes' field, the 'has' method for this field will now return false */
  public void clearAttributes() {
    genClient.clear(CacheKey.attributes);
  }
  /** Clears the 'additionalCharges' field, the 'has' method for this field will now return false */
  public void clearAdditionalCharges() {
    genClient.clear(CacheKey.additionalCharges);
  }
  /** Clears the 'taxRates' field, the 'has' method for this field will now return false */
  public void clearTaxRates() {
    genClient.clear(CacheKey.taxRates);
  }
  /** Clears the 'refunds' field, the 'has' method for this field will now return false */
  public void clearRefunds() {
    genClient.clear(CacheKey.refunds);
  }
  /** Clears the 'note' field, the 'has' method for this field will now return false */
  public void clearNote() {
    genClient.clear(CacheKey.note);
  }
  /** Clears the 'lineItemPayments' field, the 'has' method for this field will now return false */
  public void clearLineItemPayments() {
    genClient.clear(CacheKey.lineItemPayments);
  }
  /** Clears the 'authorization' field, the 'has' method for this field will now return false */
  public void clearAuthorization() {
    genClient.clear(CacheKey.authorization);
  }
  /** Clears the 'voidPaymentRef' field, the 'has' method for this field will now return false */
  public void clearVoidPaymentRef() {
    genClient.clear(CacheKey.voidPaymentRef);
  }
  /** Clears the 'voidReason' field, the 'has' method for this field will now return false */
  public void clearVoidReason() {
    genClient.clear(CacheKey.voidReason);
  }
  /** Clears the 'voidReasonDetails' field, the 'has' method for this field will now return false */
  public void clearVoidReasonDetails() {
    genClient.clear(CacheKey.voidReasonDetails);
  }
  /** Clears the 'dccInfo' field, the 'has' method for this field will now return false */
  public void clearDccInfo() {
    genClient.clear(CacheKey.dccInfo);
  }
  /** Clears the 'transactionSettings' field, the 'has' method for this field will now return false */
  public void clearTransactionSettings() {
    genClient.clear(CacheKey.transactionSettings);
  }
  /** Clears the 'germanInfo' field, the 'has' method for this field will now return false */
  public void clearGermanInfo() {
    genClient.clear(CacheKey.germanInfo);
  }
  /** Clears the 'appTracking' field, the 'has' method for this field will now return false */
  public void clearAppTracking() {
    genClient.clear(CacheKey.appTracking);
  }
  /** Clears the 'cashAdvanceExtra' field, the 'has' method for this field will now return false */
  public void clearCashAdvanceExtra() {
    genClient.clear(CacheKey.cashAdvanceExtra);
  }
  /** Clears the 'transactionInfo' field, the 'has' method for this field will now return false */
  public void clearTransactionInfo() {
    genClient.clear(CacheKey.transactionInfo);
  }
  /** Clears the 'signatureDisclaimer' field, the 'has' method for this field will now return false */
  public void clearSignatureDisclaimer() {
    genClient.clear(CacheKey.signatureDisclaimer);
  }
  /** Clears the 'externalReferenceId' field, the 'has' method for this field will now return false */
  public void clearExternalReferenceId() {
    genClient.clear(CacheKey.externalReferenceId);
  }
  /** Clears the 'merchant' field, the 'has' method for this field will now return false */
  public void clearMerchant() {
    genClient.clear(CacheKey.merchant);
  }
  /** Clears the 'increments' field, the 'has' method for this field will now return false */
  public void clearIncrements() {
    genClient.clear(CacheKey.increments);
  }
  /** Clears the 'purchaseCardL2' field, the 'has' method for this field will now return false */
  public void clearPurchaseCardL2() {
    genClient.clear(CacheKey.purchaseCardL2);
  }
  /** Clears the 'purchaseCardL3' field, the 'has' method for this field will now return false */
  public void clearPurchaseCardL3() {
    genClient.clear(CacheKey.purchaseCardL3);
  }
  /** Clears the 'oceanGatewayInfo' field, the 'has' method for this field will now return false */
  public void clearOceanGatewayInfo() {
    genClient.clear(CacheKey.oceanGatewayInfo);
  }
  /** Clears the 'terminalManagementComponents' field, the 'has' method for this field will now return false */
  public void clearTerminalManagementComponents() {
    genClient.clear(CacheKey.terminalManagementComponents);
  }
  /** Clears the 'emiInfo' field, the 'has' method for this field will now return false */
  public void clearEmiInfo() {
    genClient.clear(CacheKey.emiInfo);
  }
  /** Clears the 'closeoutBatchInfo' field, the 'has' method for this field will now return false */
  public void clearCloseoutBatchInfo() {
    genClient.clear(CacheKey.closeoutBatchInfo);
  }

  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public Payment copyChanges() {
    Payment copy = new Payment();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(Payment src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new Payment(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<Payment> CREATOR = new android.os.Parcelable.Creator<Payment>() {
    @Override
    public Payment createFromParcel(android.os.Parcel in) {
      Payment instance = new Payment(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public Payment[] newArray(int size) {
      return new Payment[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<Payment> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<Payment>() {
    public Class<Payment> getCreatedClass() {
      return Payment.class;
    }

    @Override
    public Payment create(org.json.JSONObject jsonObject) {
      return new Payment(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean ORDER_IS_REQUIRED = false;
    public static final boolean DEVICE_IS_REQUIRED = false;
    public static final boolean TENDER_IS_REQUIRED = false;
    public static final boolean AMOUNT_IS_REQUIRED = false;
    public static final boolean TIPAMOUNT_IS_REQUIRED = false;
    public static final boolean TAXAMOUNT_IS_REQUIRED = false;
    public static final boolean CASHBACKAMOUNT_IS_REQUIRED = false;
    public static final boolean CASHTENDERED_IS_REQUIRED = false;
    public static final boolean EXTERNALPAYMENTID_IS_REQUIRED = false;
    public static final long EXTERNALPAYMENTID_MAX_LEN = 32;
    public static final boolean EMPLOYEE_IS_REQUIRED = false;
    public static final boolean CREATEDTIME_IS_REQUIRED = false;
    public static final boolean CLIENTCREATEDTIME_IS_REQUIRED = false;
    public static final boolean GATEWAYPROCESSINGTIME_IS_REQUIRED = false;
    public static final boolean MODIFIEDTIME_IS_REQUIRED = false;
    public static final boolean OFFLINE_IS_REQUIRED = false;
    public static final boolean RESULT_IS_REQUIRED = false;
    public static final boolean CARDTRANSACTION_IS_REQUIRED = false;
    public static final boolean SERVICECHARGE_IS_REQUIRED = false;
    public static final boolean ATTRIBUTES_IS_REQUIRED = false;
    public static final boolean ADDITIONALCHARGES_IS_REQUIRED = false;
    public static final boolean TAXRATES_IS_REQUIRED = false;
    public static final boolean REFUNDS_IS_REQUIRED = false;
    public static final boolean NOTE_IS_REQUIRED = false;
    public static final long NOTE_MAX_LEN = 255;
    public static final boolean LINEITEMPAYMENTS_IS_REQUIRED = false;
    public static final boolean AUTHORIZATION_IS_REQUIRED = false;
    public static final boolean VOIDPAYMENTREF_IS_REQUIRED = false;
    public static final boolean VOIDREASON_IS_REQUIRED = false;
    public static final boolean VOIDREASONDETAILS_IS_REQUIRED = false;
    public static final boolean DCCINFO_IS_REQUIRED = false;
    public static final boolean TRANSACTIONSETTINGS_IS_REQUIRED = false;
    public static final boolean GERMANINFO_IS_REQUIRED = false;
    public static final boolean APPTRACKING_IS_REQUIRED = false;
    public static final boolean CASHADVANCEEXTRA_IS_REQUIRED = false;
    public static final boolean TRANSACTIONINFO_IS_REQUIRED = false;
    public static final boolean SIGNATUREDISCLAIMER_IS_REQUIRED = false;
    public static final boolean EXTERNALREFERENCEID_IS_REQUIRED = false;
    public static final boolean MERCHANT_IS_REQUIRED = false;
    public static final boolean INCREMENTS_IS_REQUIRED = false;
    public static final boolean PURCHASECARDL2_IS_REQUIRED = false;
    public static final boolean PURCHASECARDL3_IS_REQUIRED = false;
    public static final boolean OCEANGATEWAYINFO_IS_REQUIRED = false;
    public static final boolean TERMINALMANAGEMENTCOMPONENTS_IS_REQUIRED = false;
    public static final boolean EMIINFO_IS_REQUIRED = false;
    public static final boolean CLOSEOUTBATCHINFO_IS_REQUIRED = false;
  }

}