/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.payments;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getMobileNumber mobileNumber}</li>
 * <li>{@link #getIndicator indicator}</li>
 * <li>{@link #getTransactionAmount transactionAmount}</li>
 * <li>{@link #getProductAmount productAmount}</li>
 * <li>{@link #getDiscountAmount discountAmount}</li>
 * <li>{@link #getTenure tenure}</li>
 * <li>{@link #getInterestRate interestRate}</li>
 * <li>{@link #getInterestAmount interestAmount}</li>
 * <li>{@link #getProcessingFee processingFee}</li>
 * <li>{@link #getTotalAmount totalAmount}</li>
 * <li>{@link #getAmountPerMonth amountPerMonth}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class PaymentEmiInfo extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Customer’s mobile phone number
   */
  public String getMobileNumber() {
    return genClient.cacheGet(CacheKey.mobileNumber);
  }

  /**
   * EMI Indicator
   */
  public String getIndicator() {
    return genClient.cacheGet(CacheKey.indicator);
  }

  /**
   * Transaction Amount, i.e., Product Amount - Discount
   */
  public Long getTransactionAmount() {
    return genClient.cacheGet(CacheKey.transactionAmount);
  }

  /**
   * Full product amount (without discount)
   */
  public Long getProductAmount() {
    return genClient.cacheGet(CacheKey.productAmount);
  }

  /**
   * Discount offered for the product
   */
  public Long getDiscountAmount() {
    return genClient.cacheGet(CacheKey.discountAmount);
  }

  /**
   * Tenure in months
   */
  public Integer getTenure() {
    return genClient.cacheGet(CacheKey.tenure);
  }

  /**
   * EMI transaction interest rate
   */
  public Double getInterestRate() {
    return genClient.cacheGet(CacheKey.interestRate);
  }

  /**
   * EMI transaction interest amount
   */
  public Long getInterestAmount() {
    return genClient.cacheGet(CacheKey.interestAmount);
  }

  /**
   * The processing fee for EMI transaction
   */
  public Long getProcessingFee() {
    return genClient.cacheGet(CacheKey.processingFee);
  }

  /**
   * Total amount to be paid by a customer, i.e., EMI per month * Tenure
   */
  public Long getTotalAmount() {
    return genClient.cacheGet(CacheKey.totalAmount);
  }

  /**
   * Transaction amount per month
   */
  public Long getAmountPerMonth() {
    return genClient.cacheGet(CacheKey.amountPerMonth);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    mobileNumber
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    indicator
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    transactionAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
    productAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
    discountAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
    tenure
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Integer.class)),
    interestRate
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Double.class)),
    interestAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
    processingFee
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
    totalAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
    amountPerMonth
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<PaymentEmiInfo> genClient;

  /**
   * Constructs a new empty instance.
   */
  public PaymentEmiInfo() {
    genClient = new GenericClient<PaymentEmiInfo>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected PaymentEmiInfo(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public PaymentEmiInfo(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public PaymentEmiInfo(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public PaymentEmiInfo(PaymentEmiInfo src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'mobileNumber' field is set and is not null */
  public boolean isNotNullMobileNumber() {
    return genClient.cacheValueIsNotNull(CacheKey.mobileNumber);
  }

  /** Checks whether the 'indicator' field is set and is not null */
  public boolean isNotNullIndicator() {
    return genClient.cacheValueIsNotNull(CacheKey.indicator);
  }

  /** Checks whether the 'transactionAmount' field is set and is not null */
  public boolean isNotNullTransactionAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.transactionAmount);
  }

  /** Checks whether the 'productAmount' field is set and is not null */
  public boolean isNotNullProductAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.productAmount);
  }

  /** Checks whether the 'discountAmount' field is set and is not null */
  public boolean isNotNullDiscountAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.discountAmount);
  }

  /** Checks whether the 'tenure' field is set and is not null */
  public boolean isNotNullTenure() {
    return genClient.cacheValueIsNotNull(CacheKey.tenure);
  }

  /** Checks whether the 'interestRate' field is set and is not null */
  public boolean isNotNullInterestRate() {
    return genClient.cacheValueIsNotNull(CacheKey.interestRate);
  }

  /** Checks whether the 'interestAmount' field is set and is not null */
  public boolean isNotNullInterestAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.interestAmount);
  }

  /** Checks whether the 'processingFee' field is set and is not null */
  public boolean isNotNullProcessingFee() {
    return genClient.cacheValueIsNotNull(CacheKey.processingFee);
  }

  /** Checks whether the 'totalAmount' field is set and is not null */
  public boolean isNotNullTotalAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.totalAmount);
  }

  /** Checks whether the 'amountPerMonth' field is set and is not null */
  public boolean isNotNullAmountPerMonth() {
    return genClient.cacheValueIsNotNull(CacheKey.amountPerMonth);
  }



  /** Checks whether the 'mobileNumber' field has been set, however the value could be null */
  public boolean hasMobileNumber() {
    return genClient.cacheHasKey(CacheKey.mobileNumber);
  }

  /** Checks whether the 'indicator' field has been set, however the value could be null */
  public boolean hasIndicator() {
    return genClient.cacheHasKey(CacheKey.indicator);
  }

  /** Checks whether the 'transactionAmount' field has been set, however the value could be null */
  public boolean hasTransactionAmount() {
    return genClient.cacheHasKey(CacheKey.transactionAmount);
  }

  /** Checks whether the 'productAmount' field has been set, however the value could be null */
  public boolean hasProductAmount() {
    return genClient.cacheHasKey(CacheKey.productAmount);
  }

  /** Checks whether the 'discountAmount' field has been set, however the value could be null */
  public boolean hasDiscountAmount() {
    return genClient.cacheHasKey(CacheKey.discountAmount);
  }

  /** Checks whether the 'tenure' field has been set, however the value could be null */
  public boolean hasTenure() {
    return genClient.cacheHasKey(CacheKey.tenure);
  }

  /** Checks whether the 'interestRate' field has been set, however the value could be null */
  public boolean hasInterestRate() {
    return genClient.cacheHasKey(CacheKey.interestRate);
  }

  /** Checks whether the 'interestAmount' field has been set, however the value could be null */
  public boolean hasInterestAmount() {
    return genClient.cacheHasKey(CacheKey.interestAmount);
  }

  /** Checks whether the 'processingFee' field has been set, however the value could be null */
  public boolean hasProcessingFee() {
    return genClient.cacheHasKey(CacheKey.processingFee);
  }

  /** Checks whether the 'totalAmount' field has been set, however the value could be null */
  public boolean hasTotalAmount() {
    return genClient.cacheHasKey(CacheKey.totalAmount);
  }

  /** Checks whether the 'amountPerMonth' field has been set, however the value could be null */
  public boolean hasAmountPerMonth() {
    return genClient.cacheHasKey(CacheKey.amountPerMonth);
  }


  /**
   * Sets the field 'mobileNumber'.
   */
  public PaymentEmiInfo setMobileNumber(String mobileNumber) {
    return genClient.setOther(mobileNumber, CacheKey.mobileNumber);
  }

  /**
   * Sets the field 'indicator'.
   */
  public PaymentEmiInfo setIndicator(String indicator) {
    return genClient.setOther(indicator, CacheKey.indicator);
  }

  /**
   * Sets the field 'transactionAmount'.
   */
  public PaymentEmiInfo setTransactionAmount(Long transactionAmount) {
    return genClient.setOther(transactionAmount, CacheKey.transactionAmount);
  }

  /**
   * Sets the field 'productAmount'.
   */
  public PaymentEmiInfo setProductAmount(Long productAmount) {
    return genClient.setOther(productAmount, CacheKey.productAmount);
  }

  /**
   * Sets the field 'discountAmount'.
   */
  public PaymentEmiInfo setDiscountAmount(Long discountAmount) {
    return genClient.setOther(discountAmount, CacheKey.discountAmount);
  }

  /**
   * Sets the field 'tenure'.
   */
  public PaymentEmiInfo setTenure(Integer tenure) {
    return genClient.setOther(tenure, CacheKey.tenure);
  }

  /**
   * Sets the field 'interestRate'.
   */
  public PaymentEmiInfo setInterestRate(Double interestRate) {
    return genClient.setOther(interestRate, CacheKey.interestRate);
  }

  /**
   * Sets the field 'interestAmount'.
   */
  public PaymentEmiInfo setInterestAmount(Long interestAmount) {
    return genClient.setOther(interestAmount, CacheKey.interestAmount);
  }

  /**
   * Sets the field 'processingFee'.
   */
  public PaymentEmiInfo setProcessingFee(Long processingFee) {
    return genClient.setOther(processingFee, CacheKey.processingFee);
  }

  /**
   * Sets the field 'totalAmount'.
   */
  public PaymentEmiInfo setTotalAmount(Long totalAmount) {
    return genClient.setOther(totalAmount, CacheKey.totalAmount);
  }

  /**
   * Sets the field 'amountPerMonth'.
   */
  public PaymentEmiInfo setAmountPerMonth(Long amountPerMonth) {
    return genClient.setOther(amountPerMonth, CacheKey.amountPerMonth);
  }


  /** Clears the 'mobileNumber' field, the 'has' method for this field will now return false */
  public void clearMobileNumber() {
    genClient.clear(CacheKey.mobileNumber);
  }
  /** Clears the 'indicator' field, the 'has' method for this field will now return false */
  public void clearIndicator() {
    genClient.clear(CacheKey.indicator);
  }
  /** Clears the 'transactionAmount' field, the 'has' method for this field will now return false */
  public void clearTransactionAmount() {
    genClient.clear(CacheKey.transactionAmount);
  }
  /** Clears the 'productAmount' field, the 'has' method for this field will now return false */
  public void clearProductAmount() {
    genClient.clear(CacheKey.productAmount);
  }
  /** Clears the 'discountAmount' field, the 'has' method for this field will now return false */
  public void clearDiscountAmount() {
    genClient.clear(CacheKey.discountAmount);
  }
  /** Clears the 'tenure' field, the 'has' method for this field will now return false */
  public void clearTenure() {
    genClient.clear(CacheKey.tenure);
  }
  /** Clears the 'interestRate' field, the 'has' method for this field will now return false */
  public void clearInterestRate() {
    genClient.clear(CacheKey.interestRate);
  }
  /** Clears the 'interestAmount' field, the 'has' method for this field will now return false */
  public void clearInterestAmount() {
    genClient.clear(CacheKey.interestAmount);
  }
  /** Clears the 'processingFee' field, the 'has' method for this field will now return false */
  public void clearProcessingFee() {
    genClient.clear(CacheKey.processingFee);
  }
  /** Clears the 'totalAmount' field, the 'has' method for this field will now return false */
  public void clearTotalAmount() {
    genClient.clear(CacheKey.totalAmount);
  }
  /** Clears the 'amountPerMonth' field, the 'has' method for this field will now return false */
  public void clearAmountPerMonth() {
    genClient.clear(CacheKey.amountPerMonth);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public PaymentEmiInfo copyChanges() {
    PaymentEmiInfo copy = new PaymentEmiInfo();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(PaymentEmiInfo src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new PaymentEmiInfo(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<PaymentEmiInfo> CREATOR = new android.os.Parcelable.Creator<PaymentEmiInfo>() {
    @Override
    public PaymentEmiInfo createFromParcel(android.os.Parcel in) {
      PaymentEmiInfo instance = new PaymentEmiInfo(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public PaymentEmiInfo[] newArray(int size) {
      return new PaymentEmiInfo[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<PaymentEmiInfo> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<PaymentEmiInfo>() {
    public Class<PaymentEmiInfo> getCreatedClass() {
      return PaymentEmiInfo.class;
    }

    @Override
    public PaymentEmiInfo create(org.json.JSONObject jsonObject) {
      return new PaymentEmiInfo(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean MOBILENUMBER_IS_REQUIRED = false;
    public static final boolean INDICATOR_IS_REQUIRED = false;
    public static final boolean TRANSACTIONAMOUNT_IS_REQUIRED = false;
    public static final boolean PRODUCTAMOUNT_IS_REQUIRED = false;
    public static final boolean DISCOUNTAMOUNT_IS_REQUIRED = false;
    public static final boolean TENURE_IS_REQUIRED = false;
    public static final boolean INTERESTRATE_IS_REQUIRED = false;
    public static final boolean INTERESTAMOUNT_IS_REQUIRED = false;
    public static final boolean PROCESSINGFEE_IS_REQUIRED = false;
    public static final boolean TOTALAMOUNT_IS_REQUIRED = false;
    public static final boolean AMOUNTPERMONTH_IS_REQUIRED = false;
  }

}
