/**
 * Autogenerated by Avro
 *
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.payments;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getOrderRef orderRef}</li>
 * <li>{@link #getDevice device}</li>
 * <li>{@link #getAmount amount}</li>
 * <li>{@link #getTaxAmount taxAmount}</li>
 * <li>{@link #getTipAmount tipAmount}</li>
 * <li>{@link #getCreatedTime createdTime}</li>
 * <li>{@link #getClientCreatedTime clientCreatedTime}</li>
 * <li>{@link #getDeletedTime deletedTime}</li>
 * <li>{@link #getGatewayProcessingTime gatewayProcessingTime}</li>
 * <li>{@link #getPayment payment}</li>
 * <li>{@link #getEmployee employee}</li>
 * <li>{@link #getLineItems lineItems}</li>
 * <li>{@link #getOverrideMerchantTender overrideMerchantTender}</li>
 * <li>{@link #getTaxableAmountRates taxableAmountRates}</li>
 * <li>{@link #getServiceChargeAmount serviceChargeAmount}</li>
 * <li>{@link #getAdditionalCharges additionalCharges}</li>
 * <li>{@link #getAttributes attributes}</li>
 * <li>{@link #getGermanInfo germanInfo}</li>
 * <li>{@link #getAppTracking appTracking}</li>
 * <li>{@link #getVoided voided}</li>
 * <li>{@link #getVoidReason voidReason}</li>
 * <li>{@link #getCardTransaction cardTransaction}</li>
 * <li>{@link #getTransactionInfo transactionInfo}</li>
 * <li>{@link #getMerchant merchant}</li>
 * <li>{@link #getExternalReferenceId externalReferenceId}</li>
 * <li>{@link #getAuthCode authCode}</li>
 * <li>{@link #getStatus status}</li>
 * <li>{@link #getOceanGatewayInfo oceanGatewayInfo}</li>
 * <li>{@link #getReason reason}</li>
 * <li>{@link #getCloseoutBatchInfo closeoutBatchInfo}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class Refund extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * The order with which the refund is associated
   */
  public com.clover.sdk.v3.base.Reference getOrderRef() {
    return genClient.cacheGet(CacheKey.orderRef);
  }

  /**
   * Device which processed the transaction for this refund, a 128-bit UUID, not a normal base-13 Clover ID.
   */
  public com.clover.sdk.v3.base.Reference getDevice() {
    return genClient.cacheGet(CacheKey.device);
  }

  /**
   * Total amount refunded, including tax and tip
   */
  public java.lang.Long getAmount() {
    return genClient.cacheGet(CacheKey.amount);
  }

  /**
   * Tax amount refunded
   */
  public java.lang.Long getTaxAmount() {
    return genClient.cacheGet(CacheKey.taxAmount);
  }

  /**
   * Tip amount refunded
   */
  public java.lang.Long getTipAmount() {
    return genClient.cacheGet(CacheKey.tipAmount);
  }

  /**
   * The time when the refund was recorded on the server
   */
  public java.lang.Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.createdTime);
  }

  /**
   * The time when the refund was recorded on the client
   */
  public java.lang.Long getClientCreatedTime() {
    return genClient.cacheGet(CacheKey.clientCreatedTime);
  }

  /**
   * The time when the refund was deleted on the server
   */
  public java.lang.Long getDeletedTime() {
    return genClient.cacheGet(CacheKey.deletedTime);
  }

  /**
   * The time when the refund was processed by the gateway
   */
  public java.lang.Long getGatewayProcessingTime() {
    return genClient.cacheGet(CacheKey.gatewayProcessingTime);
  }

  /**
   * The payment with which the refund is associated
   */
  public com.clover.sdk.v3.base.Reference getPayment() {
    return genClient.cacheGet(CacheKey.payment);
  }

  public com.clover.sdk.v3.base.Reference getEmployee() {
    return genClient.cacheGet(CacheKey.employee);
  }

  public java.util.List<com.clover.sdk.v3.base.Reference> getLineItems() {
    return genClient.cacheGet(CacheKey.lineItems);
  }

  /**
   * The tender type associated with this payment, e.g. credit card, cash, etc.
   */
  public com.clover.sdk.v3.base.Tender getOverrideMerchantTender() {
    return genClient.cacheGet(CacheKey.overrideMerchantTender);
  }

  public java.util.List<com.clover.sdk.v3.payments.TaxableAmountRate> getTaxableAmountRates() {
    return genClient.cacheGet(CacheKey.taxableAmountRates);
  }

  public com.clover.sdk.v3.payments.ServiceChargeAmount getServiceChargeAmount() {
    return genClient.cacheGet(CacheKey.serviceChargeAmount);
  }

  public java.util.List<com.clover.sdk.v3.payments.AdditionalChargeAmount> getAdditionalCharges() {
    return genClient.cacheGet(CacheKey.additionalCharges);
  }

  public java.util.Map<java.lang.String,java.lang.String> getAttributes() {
    return genClient.cacheGet(CacheKey.attributes);
  }

  /**
   * German region-specific information
   */
  public com.clover.sdk.v3.payments.GermanInfo getGermanInfo() {
    return genClient.cacheGet(CacheKey.germanInfo);
  }

  /**
   * Tracking information for the app that created this refund.
   */
  public com.clover.sdk.v3.apps.AppTracking getAppTracking() {
    return genClient.cacheGet(CacheKey.appTracking);
  }

  public java.lang.Boolean getVoided() {
    return genClient.cacheGet(CacheKey.voided);
  }

  public java.lang.String getVoidReason() {
    return genClient.cacheGet(CacheKey.voidReason);
  }

  /**
   * Information about the card used for credit or debit card refunds
   */
  public com.clover.sdk.v3.payments.CardTransaction getCardTransaction() {
    return genClient.cacheGet(CacheKey.cardTransaction);
  }

  /**
   * Transaction information
   */
  public com.clover.sdk.v3.payments.TransactionInfo getTransactionInfo() {
    return genClient.cacheGet(CacheKey.transactionInfo);
  }

  public com.clover.sdk.v3.base.Reference getMerchant() {
    return genClient.cacheGet(CacheKey.merchant);
  }

  /**
   * The external reference id if associated with the refund
   */
  public java.lang.String getExternalReferenceId() {
    return genClient.cacheGet(CacheKey.externalReferenceId);
  }

  /**
   * Auth code generated by the acquire
   */
  public java.lang.String getAuthCode() {
    return genClient.cacheGet(CacheKey.authCode);
  }

  /**
   * Status of the refund.It can be Fail/Success/Pending
   */
  public com.clover.sdk.v3.payments.RefundStatus getStatus() {
    return genClient.cacheGet(CacheKey.status);
  }

  /**
   * Ocean Gateway info - for India region
   */
  public com.clover.sdk.v3.payments.OceanGatewayInfo getOceanGatewayInfo() {
    return genClient.cacheGet(CacheKey.oceanGatewayInfo);
  }

  /**
   * Reason why the refund was initiated
   */
  public java.lang.String getReason() {
    return genClient.cacheGet(CacheKey.reason);
  }

  /**
   * Information about the Batch used for payments
   */
  public com.clover.sdk.v3.payments.CloseoutBatchInfo getCloseoutBatchInfo() {
    return genClient.cacheGet(CacheKey.closeoutBatchInfo);
  }

  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    orderRef
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    device
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    amount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    taxAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    tipAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    createdTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    clientCreatedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    deletedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    gatewayProcessingTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    payment
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    employee
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    lineItems
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    overrideMerchantTender
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Tender.JSON_CREATOR)),
    taxableAmountRates
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.payments.TaxableAmountRate.JSON_CREATOR)),
    serviceChargeAmount
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.ServiceChargeAmount.JSON_CREATOR)),
    additionalCharges
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.payments.AdditionalChargeAmount.JSON_CREATOR)),
    attributes
        (com.clover.sdk.extractors.MapExtractionStrategy.instance()),
    germanInfo
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.GermanInfo.JSON_CREATOR)),
    appTracking
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.apps.AppTracking.JSON_CREATOR)),
    voided
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    voidReason
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    cardTransaction
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.CardTransaction.JSON_CREATOR)),
    transactionInfo
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.TransactionInfo.JSON_CREATOR)),
    merchant
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    externalReferenceId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    authCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    status
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.payments.RefundStatus.class)),
    oceanGatewayInfo
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.OceanGatewayInfo.JSON_CREATOR)),
    reason
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    closeoutBatchInfo
            (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.CloseoutBatchInfo.JSON_CREATOR)),
    ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<Refund> genClient;

  /**
   * Constructs a new empty instance.
   */
  public Refund() {
    genClient = new GenericClient<Refund>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected Refund(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public Refund(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public Refund(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public Refund(Refund src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());

    genClient.validateLength(CacheKey.reason, getReason(), 255);
    genClient.validateReferences(CacheKey.orderRef);
    genClient.validateReferences(CacheKey.payment);
    genClient.validateReferences(CacheKey.employee);
    genClient.validateReferences(CacheKey.lineItems);
    genClient.validateReferences(CacheKey.merchant);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'orderRef' field is set and is not null */
  public boolean isNotNullOrderRef() {
    return genClient.cacheValueIsNotNull(CacheKey.orderRef);
  }

  /** Checks whether the 'device' field is set and is not null */
  public boolean isNotNullDevice() {
    return genClient.cacheValueIsNotNull(CacheKey.device);
  }

  /** Checks whether the 'amount' field is set and is not null */
  public boolean isNotNullAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.amount);
  }

  /** Checks whether the 'taxAmount' field is set and is not null */
  public boolean isNotNullTaxAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.taxAmount);
  }

  /** Checks whether the 'tipAmount' field is set and is not null */
  public boolean isNotNullTipAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.tipAmount);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'clientCreatedTime' field is set and is not null */
  public boolean isNotNullClientCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.clientCreatedTime);
  }

  /** Checks whether the 'deletedTime' field is set and is not null */
  public boolean isNotNullDeletedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.deletedTime);
  }

  /** Checks whether the 'gatewayProcessingTime' field is set and is not null */
  public boolean isNotNullGatewayProcessingTime() {
    return genClient.cacheValueIsNotNull(CacheKey.gatewayProcessingTime);
  }

  /** Checks whether the 'payment' field is set and is not null */
  public boolean isNotNullPayment() {
    return genClient.cacheValueIsNotNull(CacheKey.payment);
  }

  /** Checks whether the 'employee' field is set and is not null */
  public boolean isNotNullEmployee() {
    return genClient.cacheValueIsNotNull(CacheKey.employee);
  }

  /** Checks whether the 'lineItems' field is set and is not null */
  public boolean isNotNullLineItems() {
    return genClient.cacheValueIsNotNull(CacheKey.lineItems);
  }

  /** Checks whether the 'lineItems' field is set and is not null and is not empty */
  public boolean isNotEmptyLineItems() { return isNotNullLineItems() && !getLineItems().isEmpty(); }

  /** Checks whether the 'overrideMerchantTender' field is set and is not null */
  public boolean isNotNullOverrideMerchantTender() {
    return genClient.cacheValueIsNotNull(CacheKey.overrideMerchantTender);
  }

  /** Checks whether the 'taxableAmountRates' field is set and is not null */
  public boolean isNotNullTaxableAmountRates() {
    return genClient.cacheValueIsNotNull(CacheKey.taxableAmountRates);
  }

  /** Checks whether the 'taxableAmountRates' field is set and is not null and is not empty */
  public boolean isNotEmptyTaxableAmountRates() { return isNotNullTaxableAmountRates() && !getTaxableAmountRates().isEmpty(); }

  /** Checks whether the 'serviceChargeAmount' field is set and is not null */
  public boolean isNotNullServiceChargeAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.serviceChargeAmount);
  }

  /** Checks whether the 'additionalCharges' field is set and is not null */
  public boolean isNotNullAdditionalCharges() {
    return genClient.cacheValueIsNotNull(CacheKey.additionalCharges);
  }

  /** Checks whether the 'additionalCharges' field is set and is not null and is not empty */
  public boolean isNotEmptyAdditionalCharges() { return isNotNullAdditionalCharges() && !getAdditionalCharges().isEmpty(); }

  /** Checks whether the 'attributes' field is set and is not null */
  public boolean isNotNullAttributes() {
    return genClient.cacheValueIsNotNull(CacheKey.attributes);
  }

  /** Checks whether the 'attributes' field is set and is not null and is not empty */
  public boolean isNotEmptyAttributes() { return isNotNullAttributes() && !getAttributes().isEmpty(); }

  /** Checks whether the 'germanInfo' field is set and is not null */
  public boolean isNotNullGermanInfo() {
    return genClient.cacheValueIsNotNull(CacheKey.germanInfo);
  }

  /** Checks whether the 'appTracking' field is set and is not null */
  public boolean isNotNullAppTracking() {
    return genClient.cacheValueIsNotNull(CacheKey.appTracking);
  }

  /** Checks whether the 'voided' field is set and is not null */
  public boolean isNotNullVoided() {
    return genClient.cacheValueIsNotNull(CacheKey.voided);
  }

  /** Checks whether the 'voidReason' field is set and is not null */
  public boolean isNotNullVoidReason() {
    return genClient.cacheValueIsNotNull(CacheKey.voidReason);
  }

  /** Checks whether the 'cardTransaction' field is set and is not null */
  public boolean isNotNullCardTransaction() {
    return genClient.cacheValueIsNotNull(CacheKey.cardTransaction);
  }

  /** Checks whether the 'transactionInfo' field is set and is not null */
  public boolean isNotNullTransactionInfo() {
    return genClient.cacheValueIsNotNull(CacheKey.transactionInfo);
  }

  /** Checks whether the 'merchant' field is set and is not null */
  public boolean isNotNullMerchant() {
    return genClient.cacheValueIsNotNull(CacheKey.merchant);
  }

  /** Checks whether the 'externalReferenceId' field is set and is not null */
  public boolean isNotNullExternalReferenceId() {
    return genClient.cacheValueIsNotNull(CacheKey.externalReferenceId);
  }

  /** Checks whether the 'authCode' field is set and is not null */
  public boolean isNotNullAuthCode() {
    return genClient.cacheValueIsNotNull(CacheKey.authCode);
  }

  /** Checks whether the 'status' field is set and is not null */
  public boolean isNotNullStatus() {
    return genClient.cacheValueIsNotNull(CacheKey.status);
  }

  /** Checks whether the 'oceanGatewayInfo' field is set and is not null */
  public boolean isNotNullOceanGatewayInfo() {
    return genClient.cacheValueIsNotNull(CacheKey.oceanGatewayInfo);
  }

  /** Checks whether the 'reason' field is set and is not null */
  public boolean isNotNullReason() {
    return genClient.cacheValueIsNotNull(CacheKey.reason);
  }

  /** Checks whether the 'closeoutBatchInfo' field is set and is not null */
  public boolean isNotNullCloseoutBatchInfo() {
    return genClient.cacheValueIsNotNull(CacheKey.closeoutBatchInfo);
  }

  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'orderRef' field has been set, however the value could be null */
  public boolean hasOrderRef() {
    return genClient.cacheHasKey(CacheKey.orderRef);
  }

  /** Checks whether the 'device' field has been set, however the value could be null */
  public boolean hasDevice() {
    return genClient.cacheHasKey(CacheKey.device);
  }

  /** Checks whether the 'amount' field has been set, however the value could be null */
  public boolean hasAmount() {
    return genClient.cacheHasKey(CacheKey.amount);
  }

  /** Checks whether the 'taxAmount' field has been set, however the value could be null */
  public boolean hasTaxAmount() {
    return genClient.cacheHasKey(CacheKey.taxAmount);
  }

  /** Checks whether the 'tipAmount' field has been set, however the value could be null */
  public boolean hasTipAmount() {
    return genClient.cacheHasKey(CacheKey.tipAmount);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'clientCreatedTime' field has been set, however the value could be null */
  public boolean hasClientCreatedTime() {
    return genClient.cacheHasKey(CacheKey.clientCreatedTime);
  }

  /** Checks whether the 'deletedTime' field has been set, however the value could be null */
  public boolean hasDeletedTime() {
    return genClient.cacheHasKey(CacheKey.deletedTime);
  }

  /** Checks whether the 'gatewayProcessingTime' field has been set, however the value could be null */
  public boolean hasGatewayProcessingTime() {
    return genClient.cacheHasKey(CacheKey.gatewayProcessingTime);
  }

  /** Checks whether the 'payment' field has been set, however the value could be null */
  public boolean hasPayment() {
    return genClient.cacheHasKey(CacheKey.payment);
  }

  /** Checks whether the 'employee' field has been set, however the value could be null */
  public boolean hasEmployee() {
    return genClient.cacheHasKey(CacheKey.employee);
  }

  /** Checks whether the 'lineItems' field has been set, however the value could be null */
  public boolean hasLineItems() {
    return genClient.cacheHasKey(CacheKey.lineItems);
  }

  /** Checks whether the 'overrideMerchantTender' field has been set, however the value could be null */
  public boolean hasOverrideMerchantTender() {
    return genClient.cacheHasKey(CacheKey.overrideMerchantTender);
  }

  /** Checks whether the 'taxableAmountRates' field has been set, however the value could be null */
  public boolean hasTaxableAmountRates() {
    return genClient.cacheHasKey(CacheKey.taxableAmountRates);
  }

  /** Checks whether the 'serviceChargeAmount' field has been set, however the value could be null */
  public boolean hasServiceChargeAmount() {
    return genClient.cacheHasKey(CacheKey.serviceChargeAmount);
  }

  /** Checks whether the 'additionalCharges' field has been set, however the value could be null */
  public boolean hasAdditionalCharges() {
    return genClient.cacheHasKey(CacheKey.additionalCharges);
  }

  /** Checks whether the 'attributes' field has been set, however the value could be null */
  public boolean hasAttributes() {
    return genClient.cacheHasKey(CacheKey.attributes);
  }

  /** Checks whether the 'germanInfo' field has been set, however the value could be null */
  public boolean hasGermanInfo() {
    return genClient.cacheHasKey(CacheKey.germanInfo);
  }

  /** Checks whether the 'appTracking' field has been set, however the value could be null */
  public boolean hasAppTracking() {
    return genClient.cacheHasKey(CacheKey.appTracking);
  }

  /** Checks whether the 'voided' field has been set, however the value could be null */
  public boolean hasVoided() {
    return genClient.cacheHasKey(CacheKey.voided);
  }

  /** Checks whether the 'voidReason' field has been set, however the value could be null */
  public boolean hasVoidReason() {
    return genClient.cacheHasKey(CacheKey.voidReason);
  }

  /** Checks whether the 'cardTransaction' field has been set, however the value could be null */
  public boolean hasCardTransaction() {
    return genClient.cacheHasKey(CacheKey.cardTransaction);
  }

  /** Checks whether the 'transactionInfo' field has been set, however the value could be null */
  public boolean hasTransactionInfo() {
    return genClient.cacheHasKey(CacheKey.transactionInfo);
  }

  /** Checks whether the 'merchant' field has been set, however the value could be null */
  public boolean hasMerchant() {
    return genClient.cacheHasKey(CacheKey.merchant);
  }

  /** Checks whether the 'externalReferenceId' field has been set, however the value could be null */
  public boolean hasExternalReferenceId() {
    return genClient.cacheHasKey(CacheKey.externalReferenceId);
  }

  /** Checks whether the 'authCode' field has been set, however the value could be null */
  public boolean hasAuthCode() {
    return genClient.cacheHasKey(CacheKey.authCode);
  }

  /** Checks whether the 'status' field has been set, however the value could be null */
  public boolean hasStatus() {
    return genClient.cacheHasKey(CacheKey.status);
  }

  /** Checks whether the 'oceanGatewayInfo' field has been set, however the value could be null */
  public boolean hasOceanGatewayInfo() {
    return genClient.cacheHasKey(CacheKey.oceanGatewayInfo);
  }

  /** Checks whether the 'reason' field has been set, however the value could be null */
  public boolean hasReason() {
    return genClient.cacheHasKey(CacheKey.reason);
  }

  /** Checks whether the 'closeoutBatchInfo' field has been set, however the value could be null */
  public boolean hasCloseoutBatchInfo() {
    return genClient.cacheHasKey(CacheKey.closeoutBatchInfo);
  }

  /**
   * Sets the field 'id'.
   */
  public Refund setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'orderRef'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Refund setOrderRef(com.clover.sdk.v3.base.Reference orderRef) {
    return genClient.setRecord(orderRef, CacheKey.orderRef);
  }

  /**
   * Sets the field 'device'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Refund setDevice(com.clover.sdk.v3.base.Reference device) {
    return genClient.setRecord(device, CacheKey.device);
  }

  /**
   * Sets the field 'amount'.
   */
  public Refund setAmount(java.lang.Long amount) {
    return genClient.setOther(amount, CacheKey.amount);
  }

  /**
   * Sets the field 'taxAmount'.
   */
  public Refund setTaxAmount(java.lang.Long taxAmount) {
    return genClient.setOther(taxAmount, CacheKey.taxAmount);
  }

  /**
   * Sets the field 'tipAmount'.
   */
  public Refund setTipAmount(java.lang.Long tipAmount) {
    return genClient.setOther(tipAmount, CacheKey.tipAmount);
  }

  /**
   * Sets the field 'createdTime'.
   */
  public Refund setCreatedTime(java.lang.Long createdTime) {
    return genClient.setOther(createdTime, CacheKey.createdTime);
  }

  /**
   * Sets the field 'clientCreatedTime'.
   */
  public Refund setClientCreatedTime(java.lang.Long clientCreatedTime) {
    return genClient.setOther(clientCreatedTime, CacheKey.clientCreatedTime);
  }

  /**
   * Sets the field 'deletedTime'.
   */
  public Refund setDeletedTime(java.lang.Long deletedTime) {
    return genClient.setOther(deletedTime, CacheKey.deletedTime);
  }

  /**
   * Sets the field 'gatewayProcessingTime'.
   */
  public Refund setGatewayProcessingTime(java.lang.Long gatewayProcessingTime) {
    return genClient.setOther(gatewayProcessingTime, CacheKey.gatewayProcessingTime);
  }

  /**
   * Sets the field 'payment'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Refund setPayment(com.clover.sdk.v3.base.Reference payment) {
    return genClient.setRecord(payment, CacheKey.payment);
  }

  /**
   * Sets the field 'employee'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Refund setEmployee(com.clover.sdk.v3.base.Reference employee) {
    return genClient.setRecord(employee, CacheKey.employee);
  }

  /**
   * Sets the field 'lineItems'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Refund setLineItems(java.util.List<com.clover.sdk.v3.base.Reference> lineItems) {
    return genClient.setArrayRecord(lineItems, CacheKey.lineItems);
  }

  /**
   * Sets the field 'overrideMerchantTender'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Refund setOverrideMerchantTender(com.clover.sdk.v3.base.Tender overrideMerchantTender) {
    return genClient.setRecord(overrideMerchantTender, CacheKey.overrideMerchantTender);
  }

  /**
   * Sets the field 'taxableAmountRates'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Refund setTaxableAmountRates(java.util.List<com.clover.sdk.v3.payments.TaxableAmountRate> taxableAmountRates) {
    return genClient.setArrayRecord(taxableAmountRates, CacheKey.taxableAmountRates);
  }

  /**
   * Sets the field 'serviceChargeAmount'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Refund setServiceChargeAmount(com.clover.sdk.v3.payments.ServiceChargeAmount serviceChargeAmount) {
    return genClient.setRecord(serviceChargeAmount, CacheKey.serviceChargeAmount);
  }

  /**
   * Sets the field 'additionalCharges'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Refund setAdditionalCharges(java.util.List<com.clover.sdk.v3.payments.AdditionalChargeAmount> additionalCharges) {
    return genClient.setArrayRecord(additionalCharges, CacheKey.additionalCharges);
  }

  /**
   * Sets the field 'attributes'.
   */
  public Refund setAttributes(java.util.Map<java.lang.String,java.lang.String> attributes) {
    return genClient.setOther(attributes, CacheKey.attributes);
  }

  /**
   * Sets the field 'germanInfo'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Refund setGermanInfo(com.clover.sdk.v3.payments.GermanInfo germanInfo) {
    return genClient.setRecord(germanInfo, CacheKey.germanInfo);
  }

  /**
   * Sets the field 'appTracking'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Refund setAppTracking(com.clover.sdk.v3.apps.AppTracking appTracking) {
    return genClient.setRecord(appTracking, CacheKey.appTracking);
  }

  /**
   * Sets the field 'voided'.
   */
  public Refund setVoided(java.lang.Boolean voided) {
    return genClient.setOther(voided, CacheKey.voided);
  }

  /**
   * Sets the field 'voidReason'.
   */
  public Refund setVoidReason(java.lang.String voidReason) {
    return genClient.setOther(voidReason, CacheKey.voidReason);
  }

  /**
   * Sets the field 'cardTransaction'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Refund setCardTransaction(com.clover.sdk.v3.payments.CardTransaction cardTransaction) {
    return genClient.setRecord(cardTransaction, CacheKey.cardTransaction);
  }

  /**
   * Sets the field 'transactionInfo'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Refund setTransactionInfo(com.clover.sdk.v3.payments.TransactionInfo transactionInfo) {
    return genClient.setRecord(transactionInfo, CacheKey.transactionInfo);
  }

  /**
   * Sets the field 'merchant'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Refund setMerchant(com.clover.sdk.v3.base.Reference merchant) {
    return genClient.setRecord(merchant, CacheKey.merchant);
  }

  /**
   * Sets the field 'externalReferenceId'.
   */
  public Refund setExternalReferenceId(java.lang.String externalReferenceId) {
    return genClient.setOther(externalReferenceId, CacheKey.externalReferenceId);
  }

  /**
   * Sets the field 'authCode'.
   */
  public Refund setAuthCode(java.lang.String authCode) {
    return genClient.setOther(authCode, CacheKey.authCode);
  }

  /**
   * Sets the field 'status'.
   */
  public Refund setStatus(com.clover.sdk.v3.payments.RefundStatus status) {
    return genClient.setOther(status, CacheKey.status);
  }

  /**
   * Sets the field 'oceanGatewayInfo'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Refund setOceanGatewayInfo(com.clover.sdk.v3.payments.OceanGatewayInfo oceanGatewayInfo) {
    return genClient.setRecord(oceanGatewayInfo, CacheKey.oceanGatewayInfo);
  }

  /**
   * Sets the field 'reason'.
   */
  public Refund setReason(java.lang.String reason) {
    return genClient.setOther(reason, CacheKey.reason);
  }

  /**
   * Sets the field 'closeoutBatchInfo'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Refund setCloseoutBatchInfo(com.clover.sdk.v3.payments.CloseoutBatchInfo closeoutBatchInfo) {
    return genClient.setRecord(closeoutBatchInfo, CacheKey.closeoutBatchInfo);
  }

  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'orderRef' field, the 'has' method for this field will now return false */
  public void clearOrderRef() {
    genClient.clear(CacheKey.orderRef);
  }
  /** Clears the 'device' field, the 'has' method for this field will now return false */
  public void clearDevice() {
    genClient.clear(CacheKey.device);
  }
  /** Clears the 'amount' field, the 'has' method for this field will now return false */
  public void clearAmount() {
    genClient.clear(CacheKey.amount);
  }
  /** Clears the 'taxAmount' field, the 'has' method for this field will now return false */
  public void clearTaxAmount() {
    genClient.clear(CacheKey.taxAmount);
  }
  /** Clears the 'tipAmount' field, the 'has' method for this field will now return false */
  public void clearTipAmount() {
    genClient.clear(CacheKey.tipAmount);
  }
  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.createdTime);
  }
  /** Clears the 'clientCreatedTime' field, the 'has' method for this field will now return false */
  public void clearClientCreatedTime() {
    genClient.clear(CacheKey.clientCreatedTime);
  }
  /** Clears the 'deletedTime' field, the 'has' method for this field will now return false */
  public void clearDeletedTime() {
    genClient.clear(CacheKey.deletedTime);
  }
  /** Clears the 'gatewayProcessingTime' field, the 'has' method for this field will now return false */
  public void clearGatewayProcessingTime() {
    genClient.clear(CacheKey.gatewayProcessingTime);
  }
  /** Clears the 'payment' field, the 'has' method for this field will now return false */
  public void clearPayment() {
    genClient.clear(CacheKey.payment);
  }
  /** Clears the 'employee' field, the 'has' method for this field will now return false */
  public void clearEmployee() {
    genClient.clear(CacheKey.employee);
  }
  /** Clears the 'lineItems' field, the 'has' method for this field will now return false */
  public void clearLineItems() {
    genClient.clear(CacheKey.lineItems);
  }
  /** Clears the 'overrideMerchantTender' field, the 'has' method for this field will now return false */
  public void clearOverrideMerchantTender() {
    genClient.clear(CacheKey.overrideMerchantTender);
  }
  /** Clears the 'taxableAmountRates' field, the 'has' method for this field will now return false */
  public void clearTaxableAmountRates() {
    genClient.clear(CacheKey.taxableAmountRates);
  }
  /** Clears the 'serviceChargeAmount' field, the 'has' method for this field will now return false */
  public void clearServiceChargeAmount() {
    genClient.clear(CacheKey.serviceChargeAmount);
  }
  /** Clears the 'additionalCharges' field, the 'has' method for this field will now return false */
  public void clearAdditionalCharges() {
    genClient.clear(CacheKey.additionalCharges);
  }
  /** Clears the 'attributes' field, the 'has' method for this field will now return false */
  public void clearAttributes() {
    genClient.clear(CacheKey.attributes);
  }
  /** Clears the 'germanInfo' field, the 'has' method for this field will now return false */
  public void clearGermanInfo() {
    genClient.clear(CacheKey.germanInfo);
  }
  /** Clears the 'appTracking' field, the 'has' method for this field will now return false */
  public void clearAppTracking() {
    genClient.clear(CacheKey.appTracking);
  }
  /** Clears the 'voided' field, the 'has' method for this field will now return false */
  public void clearVoided() {
    genClient.clear(CacheKey.voided);
  }
  /** Clears the 'voidReason' field, the 'has' method for this field will now return false */
  public void clearVoidReason() {
    genClient.clear(CacheKey.voidReason);
  }
  /** Clears the 'cardTransaction' field, the 'has' method for this field will now return false */
  public void clearCardTransaction() {
    genClient.clear(CacheKey.cardTransaction);
  }
  /** Clears the 'transactionInfo' field, the 'has' method for this field will now return false */
  public void clearTransactionInfo() {
    genClient.clear(CacheKey.transactionInfo);
  }
  /** Clears the 'merchant' field, the 'has' method for this field will now return false */
  public void clearMerchant() {
    genClient.clear(CacheKey.merchant);
  }
  /** Clears the 'externalReferenceId' field, the 'has' method for this field will now return false */
  public void clearExternalReferenceId() {
    genClient.clear(CacheKey.externalReferenceId);
  }
  /** Clears the 'authCode' field, the 'has' method for this field will now return false */
  public void clearAuthCode() {
    genClient.clear(CacheKey.authCode);
  }
  /** Clears the 'status' field, the 'has' method for this field will now return false */
  public void clearStatus() {
    genClient.clear(CacheKey.status);
  }
  /** Clears the 'oceanGatewayInfo' field, the 'has' method for this field will now return false */
  public void clearOceanGatewayInfo() {
    genClient.clear(CacheKey.oceanGatewayInfo);
  }
  /** Clears the 'reason' field, the 'has' method for this field will now return false */
  public void clearReason() {
    genClient.clear(CacheKey.reason);
  }
  /** Clears the 'closeoutBatchInfo' field, the 'has' method for this field will now return false */
  public void clearCloseoutBatchInfo() {
    genClient.clear(CacheKey.closeoutBatchInfo);
  }

  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public Refund copyChanges() {
    Refund copy = new Refund();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(Refund src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new Refund(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<Refund> CREATOR = new android.os.Parcelable.Creator<Refund>() {
    @Override
    public Refund createFromParcel(android.os.Parcel in) {
      Refund instance = new Refund(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public Refund[] newArray(int size) {
      return new Refund[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<Refund> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<Refund>() {
    public Class<Refund> getCreatedClass() {
      return Refund.class;
    }

    @Override
    public Refund create(org.json.JSONObject jsonObject) {
      return new Refund(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final boolean ORDERREF_IS_REQUIRED = false;
    public static final boolean DEVICE_IS_REQUIRED = false;
    public static final boolean AMOUNT_IS_REQUIRED = false;
    public static final boolean TAXAMOUNT_IS_REQUIRED = false;
    public static final boolean TIPAMOUNT_IS_REQUIRED = false;
    public static final boolean CREATEDTIME_IS_REQUIRED = false;
    public static final boolean CLIENTCREATEDTIME_IS_REQUIRED = false;
    public static final boolean DELETEDTIME_IS_REQUIRED = false;
    public static final boolean GATEWAYPROCESSINGTIME_IS_REQUIRED = false;
    public static final boolean PAYMENT_IS_REQUIRED = false;
    public static final boolean EMPLOYEE_IS_REQUIRED = false;
    public static final boolean LINEITEMS_IS_REQUIRED = false;
    public static final boolean OVERRIDEMERCHANTTENDER_IS_REQUIRED = false;
    public static final boolean TAXABLEAMOUNTRATES_IS_REQUIRED = false;
    public static final boolean SERVICECHARGEAMOUNT_IS_REQUIRED = false;
    public static final boolean ADDITIONALCHARGES_IS_REQUIRED = false;
    public static final boolean ATTRIBUTES_IS_REQUIRED = false;
    public static final boolean GERMANINFO_IS_REQUIRED = false;
    public static final boolean APPTRACKING_IS_REQUIRED = false;
    public static final boolean VOIDED_IS_REQUIRED = false;
    public static final boolean VOIDREASON_IS_REQUIRED = false;
    public static final boolean CARDTRANSACTION_IS_REQUIRED = false;
    public static final boolean TRANSACTIONINFO_IS_REQUIRED = false;
    public static final boolean MERCHANT_IS_REQUIRED = false;
    public static final boolean EXTERNALREFERENCEID_IS_REQUIRED = false;
    public static final boolean AUTHCODE_IS_REQUIRED = false;
    public static final boolean STATUS_IS_REQUIRED = false;
    public static final boolean OCEANGATEWAYINFO_IS_REQUIRED = false;
    public static final boolean REASON_IS_REQUIRED = false;
    public static final long REASON_MAX_LEN = 255;
    public static final boolean CLOSEOUTBATCHINFO_IS_REQUIRED = false;
  }

}
