/**
 * Autogenerated by Avro
 *
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.payments;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getRequestSuccessful requestSuccessful}</li>
 * <li>{@link #getResponseErrorMessage responseErrorMessage}</li>
 * <li>{@link #getRefund refund}</li>
 * <li>{@link #getPayment payment}</li>
 * <li>{@link #getExtra extra}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class RefundResponse extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  public java.lang.Boolean getRequestSuccessful() {
    return genClient.cacheGet(CacheKey.requestSuccessful);
  }

  public java.lang.String getResponseErrorMessage() {
    return genClient.cacheGet(CacheKey.responseErrorMessage);
  }

  public com.clover.sdk.v3.payments.Refund getRefund() {
    return genClient.cacheGet(CacheKey.refund);
  }

  public com.clover.sdk.v3.payments.Payment getPayment() {
    return genClient.cacheGet(CacheKey.payment);
  }

  /**
   * extra stuff
   */
  public java.util.Map<java.lang.String,java.lang.String> getExtra() {
    return genClient.cacheGet(CacheKey.extra);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    requestSuccessful
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    responseErrorMessage
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    refund
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.Refund.JSON_CREATOR)),
    payment
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.Payment.JSON_CREATOR)),
    extra
        (com.clover.sdk.extractors.MapExtractionStrategy.instance()),
    ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<RefundResponse> genClient;

  /**
   * Constructs a new empty instance.
   */
  public RefundResponse() {
    genClient = new GenericClient<RefundResponse>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected RefundResponse(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public RefundResponse(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public RefundResponse(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public RefundResponse(RefundResponse src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'requestSuccessful' field is set and is not null */
  public boolean isNotNullRequestSuccessful() {
    return genClient.cacheValueIsNotNull(CacheKey.requestSuccessful);
  }

  /** Checks whether the 'responseErrorMessage' field is set and is not null */
  public boolean isNotNullResponseErrorMessage() {
    return genClient.cacheValueIsNotNull(CacheKey.responseErrorMessage);
  }

  /** Checks whether the 'refund' field is set and is not null */
  public boolean isNotNullRefund() {
    return genClient.cacheValueIsNotNull(CacheKey.refund);
  }

  /** Checks whether the 'payment' field is set and is not null */
  public boolean isNotNullPayment() {
    return genClient.cacheValueIsNotNull(CacheKey.payment);
  }

  /** Checks whether the 'extra' field is set and is not null */
  public boolean isNotNullExtra() {
    return genClient.cacheValueIsNotNull(CacheKey.extra);
  }

  /** Checks whether the 'extra' field is set and is not null and is not empty */
  public boolean isNotEmptyExtra() { return isNotNullExtra() && !getExtra().isEmpty(); }



  /** Checks whether the 'requestSuccessful' field has been set, however the value could be null */
  public boolean hasRequestSuccessful() {
    return genClient.cacheHasKey(CacheKey.requestSuccessful);
  }

  /** Checks whether the 'responseErrorMessage' field has been set, however the value could be null */
  public boolean hasResponseErrorMessage() {
    return genClient.cacheHasKey(CacheKey.responseErrorMessage);
  }

  /** Checks whether the 'refund' field has been set, however the value could be null */
  public boolean hasRefund() {
    return genClient.cacheHasKey(CacheKey.refund);
  }

  /** Checks whether the 'payment' field has been set, however the value could be null */
  public boolean hasPayment() {
    return genClient.cacheHasKey(CacheKey.payment);
  }

  /** Checks whether the 'extra' field has been set, however the value could be null */
  public boolean hasExtra() {
    return genClient.cacheHasKey(CacheKey.extra);
  }


  /**
   * Sets the field 'requestSuccessful'.
   */
  public RefundResponse setRequestSuccessful(java.lang.Boolean requestSuccessful) {
    return genClient.setOther(requestSuccessful, CacheKey.requestSuccessful);
  }

  /**
   * Sets the field 'responseErrorMessage'.
   */
  public RefundResponse setResponseErrorMessage(java.lang.String responseErrorMessage) {
    return genClient.setOther(responseErrorMessage, CacheKey.responseErrorMessage);
  }

  /**
   * Sets the field 'refund'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public RefundResponse setRefund(com.clover.sdk.v3.payments.Refund refund) {
    return genClient.setRecord(refund, CacheKey.refund);
  }

  /**
   * Sets the field 'payment'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public RefundResponse setPayment(com.clover.sdk.v3.payments.Payment payment) {
    return genClient.setRecord(payment, CacheKey.payment);
  }

  /**
   * Sets the field 'extra'.
   */
  public RefundResponse setExtra(java.util.Map<java.lang.String,java.lang.String> extra) {
    return genClient.setOther(extra, CacheKey.extra);
  }


  /** Clears the 'requestSuccessful' field, the 'has' method for this field will now return false */
  public void clearRequestSuccessful() {
    genClient.clear(CacheKey.requestSuccessful);
  }
  /** Clears the 'responseErrorMessage' field, the 'has' method for this field will now return false */
  public void clearResponseErrorMessage() {
    genClient.clear(CacheKey.responseErrorMessage);
  }
  /** Clears the 'refund' field, the 'has' method for this field will now return false */
  public void clearRefund() {
    genClient.clear(CacheKey.refund);
  }
  /** Clears the 'payment' field, the 'has' method for this field will now return false */
  public void clearPayment() {
    genClient.clear(CacheKey.payment);
  }
  /** Clears the 'extra' field, the 'has' method for this field will now return false */
  public void clearExtra() {
    genClient.clear(CacheKey.extra);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public RefundResponse copyChanges() {
    RefundResponse copy = new RefundResponse();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(RefundResponse src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new RefundResponse(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<RefundResponse> CREATOR = new android.os.Parcelable.Creator<RefundResponse>() {
    @Override
    public RefundResponse createFromParcel(android.os.Parcel in) {
      RefundResponse instance = new RefundResponse(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public RefundResponse[] newArray(int size) {
      return new RefundResponse[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<RefundResponse> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<RefundResponse>() {
    public Class<RefundResponse> getCreatedClass() {
      return RefundResponse.class;
    }

    @Override
    public RefundResponse create(org.json.JSONObject jsonObject) {
      return new RefundResponse(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean REQUESTSUCCESSFUL_IS_REQUIRED = false;
    public static final boolean RESPONSEERRORMESSAGE_IS_REQUIRED = false;
    public static final boolean REFUND_IS_REQUIRED = false;
    public static final boolean PAYMENT_IS_REQUIRED = false;
    public static final boolean EXTRA_IS_REQUIRED = false;
  }

}
