/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.payments;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getReceiptFormat receiptFormat}</li>
 * <li>{@link #getExtAppLabel extAppLabel}</li>
 * <li>{@link #getPreNotification preNotification}</li>
 * <li>{@link #getMandate mandate}</li>
 * <li>{@link #getCreditorId creditorId}</li>
 * <li>{@link #getMandateId mandateId}</li>
 * <li>{@link #getIban iban}</li>
 * <li>{@link #getIsMerchantForced isMerchantForced}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class SepaElvTransactionInfo extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Value of tag E1.DF8206 from NEXO config.
   */
  public String getReceiptFormat() {
    return genClient.cacheGet(CacheKey.receiptFormat);
  }

  /**
   * Value of tag E6.DF8211 or E6.DF8212 (Online or Offline TX printout).
   */
  public String getExtAppLabel() {
    return genClient.cacheGet(CacheKey.extAppLabel);
  }

  /**
   * Value of tag E6.DF8214 info form NEXO config.
   */
  public String getPreNotification() {
    return genClient.cacheGet(CacheKey.preNotification);
  }

  /**
   * Value of tag E6.DF8215 info from NEXO config.
   */
  public String getMandate() {
    return genClient.cacheGet(CacheKey.mandate);
  }

  /**
   * Value of tag E6.DF8216 info from NEXO config.
   */
  public String getCreditorId() {
    return genClient.cacheGet(CacheKey.creditorId);
  }

  /**
   * Generated by SPA according to ELV – TBD: use Trace number instead of receipt number.
   */
  public String getMandateId() {
    return genClient.cacheGet(CacheKey.mandateId);
  }

  /**
   * Received in ICC related data from IPG (tag 5F53).
   */
  public String getIban() {
    return genClient.cacheGet(CacheKey.iban);
  }

  /**
   * Defines if the corresponding SEPA ELV TX was forced by the merchant (override defined limit).
   */
  public java.lang.Boolean getIsMerchantForced() {
    return genClient.cacheGet(CacheKey.isMerchantForced);
  }


  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    receiptFormat
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    extAppLabel
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    preNotification
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    mandate
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    creditorId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    mandateId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    iban
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    isMerchantForced
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Boolean.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<SepaElvTransactionInfo> genClient;

  /**
   * Constructs a new empty instance.
   */
  public SepaElvTransactionInfo() {
    genClient = new GenericClient<SepaElvTransactionInfo>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected SepaElvTransactionInfo(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public SepaElvTransactionInfo(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public SepaElvTransactionInfo(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public SepaElvTransactionInfo(SepaElvTransactionInfo src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'receiptFormat' field is set and is not null */
  public boolean isNotNullReceiptFormat() {
    return genClient.cacheValueIsNotNull(CacheKey.receiptFormat);
  }

  /** Checks whether the 'extAppLabel' field is set and is not null */
  public boolean isNotNullExtAppLabel() {
    return genClient.cacheValueIsNotNull(CacheKey.extAppLabel);
  }

  /** Checks whether the 'preNotification' field is set and is not null */
  public boolean isNotNullPreNotification() {
    return genClient.cacheValueIsNotNull(CacheKey.preNotification);
  }

  /** Checks whether the 'mandate' field is set and is not null */
  public boolean isNotNullMandate() {
    return genClient.cacheValueIsNotNull(CacheKey.mandate);
  }

  /** Checks whether the 'creditorId' field is set and is not null */
  public boolean isNotNullCreditorId() {
    return genClient.cacheValueIsNotNull(CacheKey.creditorId);
  }

  /** Checks whether the 'mandateId' field is set and is not null */
  public boolean isNotNullMandateId() {
    return genClient.cacheValueIsNotNull(CacheKey.mandateId);
  }

  /** Checks whether the 'iban' field is set and is not null */
  public boolean isNotNullIban() {
    return genClient.cacheValueIsNotNull(CacheKey.iban);
  }



  /** Checks whether the 'receiptFormat' field has been set, however the value could be null */
  public boolean hasReceiptFormat() {
    return genClient.cacheHasKey(CacheKey.receiptFormat);
  }

  /** Checks whether the 'extAppLabel' field has been set, however the value could be null */
  public boolean hasExtAppLabel() {
    return genClient.cacheHasKey(CacheKey.extAppLabel);
  }

  /** Checks whether the 'preNotification' field has been set, however the value could be null */
  public boolean hasPreNotification() {
    return genClient.cacheHasKey(CacheKey.preNotification);
  }

  /** Checks whether the 'mandate' field has been set, however the value could be null */
  public boolean hasMandate() {
    return genClient.cacheHasKey(CacheKey.mandate);
  }

  /** Checks whether the 'creditorId' field has been set, however the value could be null */
  public boolean hasCreditorId() {
    return genClient.cacheHasKey(CacheKey.creditorId);
  }

  /** Checks whether the 'mandateId' field has been set, however the value could be null */
  public boolean hasMandateId() {
    return genClient.cacheHasKey(CacheKey.mandateId);
  }

  /** Checks whether the 'iban' field has been set, however the value could be null */
  public boolean hasIban() {
    return genClient.cacheHasKey(CacheKey.iban);
  }

  /** Checks whether the 'isMerchantForced' field has been set, however the value could be null */
  public boolean hasIsMerchantForced() {
    return genClient.cacheHasKey(CacheKey.isMerchantForced);
  }

  /**
   * Sets the field 'receiptFormat'.
   */
  public SepaElvTransactionInfo setReceiptFormat(String receiptFormat) {
    return genClient.setOther(receiptFormat, CacheKey.receiptFormat);
  }

  /**
   * Sets the field 'extAppLabel'.
   */
  public SepaElvTransactionInfo setExtAppLabel(String extAppLabel) {
    return genClient.setOther(extAppLabel, CacheKey.extAppLabel);
  }

  /**
   * Sets the field 'preNotification'.
   */
  public SepaElvTransactionInfo setPreNotification(String preNotification) {
    return genClient.setOther(preNotification, CacheKey.preNotification);
  }

  /**
   * Sets the field 'mandate'.
   */
  public SepaElvTransactionInfo setMandate(String mandate) {
    return genClient.setOther(mandate, CacheKey.mandate);
  }

  /**
   * Sets the field 'creditorId'.
   */
  public SepaElvTransactionInfo setCreditorId(String creditorId) {
    return genClient.setOther(creditorId, CacheKey.creditorId);
  }

  /**
   * Sets the field 'mandateId'.
   */
  public SepaElvTransactionInfo setMandateId(String mandateId) {
    return genClient.setOther(mandateId, CacheKey.mandateId);
  }

  /**
   * Sets the field 'iban'.
   */
  public SepaElvTransactionInfo setIban(String iban) {
    return genClient.setOther(iban, CacheKey.iban);
  }

  /**
   * Sets the field 'isMerchantForced'.
   */
  public SepaElvTransactionInfo setIsMerchantForced(java.lang.Boolean isMerchantForced) {
    return genClient.setOther(isMerchantForced, CacheKey.isMerchantForced);
  }

  /** Clears the 'receiptFormat' field, the 'has' method for this field will now return false */
  public void clearReceiptFormat() {
    genClient.clear(CacheKey.receiptFormat);
  }
  /** Clears the 'extAppLabel' field, the 'has' method for this field will now return false */
  public void clearExtAppLabel() {
    genClient.clear(CacheKey.extAppLabel);
  }
  /** Clears the 'preNotification' field, the 'has' method for this field will now return false */
  public void clearPreNotification() {
    genClient.clear(CacheKey.preNotification);
  }
  /** Clears the 'mandate' field, the 'has' method for this field will now return false */
  public void clearMandate() {
    genClient.clear(CacheKey.mandate);
  }
  /** Clears the 'creditorId' field, the 'has' method for this field will now return false */
  public void clearCreditorId() {
    genClient.clear(CacheKey.creditorId);
  }
  /** Clears the 'mandateId' field, the 'has' method for this field will now return false */
  public void clearMandateId() {
    genClient.clear(CacheKey.mandateId);
  }
  /** Clears the 'iban' field, the 'has' method for this field will now return false */
  public void clearIban() {
    genClient.clear(CacheKey.iban);
  }
  /** Clears the 'isMerchantForced' field, the 'has' method for this field will now return false */
  public void clearIsMerchantForced() {
    genClient.clear(CacheKey.isMerchantForced);
  }

  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public SepaElvTransactionInfo copyChanges() {
    SepaElvTransactionInfo copy = new SepaElvTransactionInfo();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(SepaElvTransactionInfo src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new SepaElvTransactionInfo(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<SepaElvTransactionInfo> CREATOR = new android.os.Parcelable.Creator<SepaElvTransactionInfo>() {
    @Override
    public SepaElvTransactionInfo createFromParcel(android.os.Parcel in) {
      SepaElvTransactionInfo instance = new SepaElvTransactionInfo(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public SepaElvTransactionInfo[] newArray(int size) {
      return new SepaElvTransactionInfo[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<SepaElvTransactionInfo> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<SepaElvTransactionInfo>() {
    public Class<SepaElvTransactionInfo> getCreatedClass() {
      return SepaElvTransactionInfo.class;
    }

    @Override
    public SepaElvTransactionInfo create(org.json.JSONObject jsonObject) {
      return new SepaElvTransactionInfo(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean RECEIPTFORMAT_IS_REQUIRED = false;
    public static final boolean EXTAPPLABEL_IS_REQUIRED = false;
    public static final boolean PRENOTIFICATION_IS_REQUIRED = false;
    public static final boolean MANDATE_IS_REQUIRED = false;
    public static final boolean CREDITORID_IS_REQUIRED = false;
    public static final boolean MANDATEID_IS_REQUIRED = false;
    public static final boolean IBAN_IS_REQUIRED = false;
    public static final boolean ISMERCHANTFORCED_IS_REQUIRED = false;
  }

}
