/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.payments;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getComponent component}</li>
 * <li>{@link #getIdentification identification}</li>
 * <li>{@link #getVersion version}</li>
 * <li>{@link #getIssuer issuer}</li>
 * <li>{@link #getType type}</li>
 * <li>{@link #getAssigner assigner}</li>
 * <li>{@link #getAssessmentIdentifier assessmentIdentifier}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class TerminalManagementStandard extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * The compnent this standard applies to (e.g. C-2)
   */
  public java.lang.String getComponent() {
    return genClient.cacheGet(CacheKey.component);
  }

  /**
   * The standard identifier e.g. EMV ICC Specifications
   */
  public java.lang.String getIdentification() {
    return genClient.cacheGet(CacheKey.identification);
  }

  /**
   * The standard version
   */
  public java.lang.String getVersion() {
    return genClient.cacheGet(CacheKey.version);
  }

  /**
   * The standard issuer
   */
  public java.lang.String getIssuer() {
    return genClient.cacheGet(CacheKey.issuer);
  }

  /**
   * assessment type for the standard
   */
  public java.lang.String getType() {
    return genClient.cacheGet(CacheKey.type);
  }

  /**
   * the assessment assigner
   */
  public java.lang.String getAssigner() {
    return genClient.cacheGet(CacheKey.assigner);
  }

  /**
   * approval number or other identifier for the assessment
   */
  public java.lang.String getAssessmentIdentifier() {
    return genClient.cacheGet(CacheKey.assessmentIdentifier);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    component
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    identification
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    version
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    issuer
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    type
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    assigner
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    assessmentIdentifier
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<TerminalManagementStandard> genClient;

  /**
   * Constructs a new empty instance.
   */
  public TerminalManagementStandard() {
    genClient = new GenericClient<TerminalManagementStandard>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected TerminalManagementStandard(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public TerminalManagementStandard(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public TerminalManagementStandard(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public TerminalManagementStandard(TerminalManagementStandard src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'component' field is set and is not null */
  public boolean isNotNullComponent() {
    return genClient.cacheValueIsNotNull(CacheKey.component);
  }

  /** Checks whether the 'identification' field is set and is not null */
  public boolean isNotNullIdentification() {
    return genClient.cacheValueIsNotNull(CacheKey.identification);
  }

  /** Checks whether the 'version' field is set and is not null */
  public boolean isNotNullVersion() {
    return genClient.cacheValueIsNotNull(CacheKey.version);
  }

  /** Checks whether the 'issuer' field is set and is not null */
  public boolean isNotNullIssuer() {
    return genClient.cacheValueIsNotNull(CacheKey.issuer);
  }

  /** Checks whether the 'type' field is set and is not null */
  public boolean isNotNullType() {
    return genClient.cacheValueIsNotNull(CacheKey.type);
  }

  /** Checks whether the 'assigner' field is set and is not null */
  public boolean isNotNullAssigner() {
    return genClient.cacheValueIsNotNull(CacheKey.assigner);
  }

  /** Checks whether the 'assessmentIdentifier' field is set and is not null */
  public boolean isNotNullAssessmentIdentifier() {
    return genClient.cacheValueIsNotNull(CacheKey.assessmentIdentifier);
  }



  /** Checks whether the 'component' field has been set, however the value could be null */
  public boolean hasComponent() {
    return genClient.cacheHasKey(CacheKey.component);
  }

  /** Checks whether the 'identification' field has been set, however the value could be null */
  public boolean hasIdentification() {
    return genClient.cacheHasKey(CacheKey.identification);
  }

  /** Checks whether the 'version' field has been set, however the value could be null */
  public boolean hasVersion() {
    return genClient.cacheHasKey(CacheKey.version);
  }

  /** Checks whether the 'issuer' field has been set, however the value could be null */
  public boolean hasIssuer() {
    return genClient.cacheHasKey(CacheKey.issuer);
  }

  /** Checks whether the 'type' field has been set, however the value could be null */
  public boolean hasType() {
    return genClient.cacheHasKey(CacheKey.type);
  }

  /** Checks whether the 'assigner' field has been set, however the value could be null */
  public boolean hasAssigner() {
    return genClient.cacheHasKey(CacheKey.assigner);
  }

  /** Checks whether the 'assessmentIdentifier' field has been set, however the value could be null */
  public boolean hasAssessmentIdentifier() {
    return genClient.cacheHasKey(CacheKey.assessmentIdentifier);
  }


  /**
   * Sets the field 'component'.
   */
  public TerminalManagementStandard setComponent(java.lang.String component) {
    return genClient.setOther(component, CacheKey.component);
  }

  /**
   * Sets the field 'identification'.
   */
  public TerminalManagementStandard setIdentification(java.lang.String identification) {
    return genClient.setOther(identification, CacheKey.identification);
  }

  /**
   * Sets the field 'version'.
   */
  public TerminalManagementStandard setVersion(java.lang.String version) {
    return genClient.setOther(version, CacheKey.version);
  }

  /**
   * Sets the field 'issuer'.
   */
  public TerminalManagementStandard setIssuer(java.lang.String issuer) {
    return genClient.setOther(issuer, CacheKey.issuer);
  }

  /**
   * Sets the field 'type'.
   */
  public TerminalManagementStandard setType(java.lang.String type) {
    return genClient.setOther(type, CacheKey.type);
  }

  /**
   * Sets the field 'assigner'.
   */
  public TerminalManagementStandard setAssigner(java.lang.String assigner) {
    return genClient.setOther(assigner, CacheKey.assigner);
  }

  /**
   * Sets the field 'assessmentIdentifier'.
   */
  public TerminalManagementStandard setAssessmentIdentifier(java.lang.String assessmentIdentifier) {
    return genClient.setOther(assessmentIdentifier, CacheKey.assessmentIdentifier);
  }


  /** Clears the 'component' field, the 'has' method for this field will now return false */
  public void clearComponent() {
    genClient.clear(CacheKey.component);
  }
  /** Clears the 'identification' field, the 'has' method for this field will now return false */
  public void clearIdentification() {
    genClient.clear(CacheKey.identification);
  }
  /** Clears the 'version' field, the 'has' method for this field will now return false */
  public void clearVersion() {
    genClient.clear(CacheKey.version);
  }
  /** Clears the 'issuer' field, the 'has' method for this field will now return false */
  public void clearIssuer() {
    genClient.clear(CacheKey.issuer);
  }
  /** Clears the 'type' field, the 'has' method for this field will now return false */
  public void clearType() {
    genClient.clear(CacheKey.type);
  }
  /** Clears the 'assigner' field, the 'has' method for this field will now return false */
  public void clearAssigner() {
    genClient.clear(CacheKey.assigner);
  }
  /** Clears the 'assessmentIdentifier' field, the 'has' method for this field will now return false */
  public void clearAssessmentIdentifier() {
    genClient.clear(CacheKey.assessmentIdentifier);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public TerminalManagementStandard copyChanges() {
    TerminalManagementStandard copy = new TerminalManagementStandard();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(TerminalManagementStandard src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new TerminalManagementStandard(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<TerminalManagementStandard> CREATOR = new android.os.Parcelable.Creator<TerminalManagementStandard>() {
    @Override
    public TerminalManagementStandard createFromParcel(android.os.Parcel in) {
      TerminalManagementStandard instance = new TerminalManagementStandard(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public TerminalManagementStandard[] newArray(int size) {
      return new TerminalManagementStandard[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<TerminalManagementStandard> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<TerminalManagementStandard>() {
    public Class<TerminalManagementStandard> getCreatedClass() {
      return TerminalManagementStandard.class;
    }

    @Override
    public TerminalManagementStandard create(org.json.JSONObject jsonObject) {
      return new TerminalManagementStandard(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean COMPONENT_IS_REQUIRED = false;
    public static final boolean IDENTIFICATION_IS_REQUIRED = false;
    public static final boolean VERSION_IS_REQUIRED = false;
    public static final boolean ISSUER_IS_REQUIRED = false;
    public static final boolean TYPE_IS_REQUIRED = false;
    public static final boolean ASSIGNER_IS_REQUIRED = false;
    public static final boolean ASSESSMENTIDENTIFIER_IS_REQUIRED = false;
  }

}
