/**
 * Autogenerated by Avro
 *
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.payments;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getLanguageIndicator languageIndicator}</li>
 * <li>{@link #getTransactionLocale transactionLocale}</li>
 * <li>{@link #getAccountSelection accountSelection}</li>
 * <li>{@link #getFiscalInvoiceNumber fiscalInvoiceNumber}</li>
 * <li>{@link #getInstallmentsQuantity installmentsQuantity}</li>
 * <li>{@link #getInstallmentsType installmentsType}</li>
 * <li>{@link #getInstallmentsPlanCode installmentsPlanCode}</li>
 * <li>{@link #getInstallmentsPlanId installmentsPlanId}</li>
 * <li>{@link #getInstallmentsPlanDesc installmentsPlanDesc}</li>
 * <li>{@link #getCardTypeLabel cardTypeLabel}</li>
 * <li>{@link #getCardSymbol cardSymbol}</li>
 * <li>{@link #getStan stan}</li>
 * <li>{@link #getIdentityDocument identityDocument}</li>
 * <li>{@link #getBatchNumber batchNumber}</li>
 * <li>{@link #getReceiptNumber receiptNumber}</li>
 * <li>{@link #getReversalStanRefNum reversalStanRefNum}</li>
 * <li>{@link #getReversalStan reversalStan}</li>
 * <li>{@link #getReversalMac reversalMac}</li>
 * <li>{@link #getReversalMacKsn reversalMacKsn}</li>
 * <li>{@link #getTerminalIdentification terminalIdentification}</li>
 * <li>{@link #getExternalTerminalId externalTerminalId}</li>
 * <li>{@link #getMerchantIdentifier merchantIdentifier}</li>
 * <li>{@link #getMerchantNameLocation merchantNameLocation}</li>
 * <li>{@link #getMaskedTrack2 maskedTrack2}</li>
 * <li>{@link #getReceiptExtraData receiptExtraData}</li>
 * <li>{@link #getSelectedService selectedService}</li>
 * <li>{@link #getTransactionResult transactionResult}</li>
 * <li>{@link #getTransactionTags transactionTags}</li>
 * <li>{@link #getTxFormat txFormat}</li>
 * <li>{@link #getPanMask panMask}</li>
 * <li>{@link #getTransactionSequenceCounter transactionSequenceCounter}</li>
 * <li>{@link #getApplicationPanSequenceNumber applicationPanSequenceNumber}</li>
 * <li>{@link #getApplicationTransactionCounter applicationTransactionCounter}</li>
 * <li>{@link #getReversalReason reversalReason}</li>
 * <li>{@link #getIsTokenBasedTx isTokenBasedTx}</li>
 * <li>{@link #getOrigTransactionSequenceCounter origTransactionSequenceCounter}</li>
 * <li>{@link #getTransactionSequenceCounterUpdate transactionSequenceCounterUpdate}</li>
 * <li>{@link #getEmergencyFlag emergencyFlag}</li>
 * <li>{@link #getCardEntryType cardEntryType}</li>
 * <li>{@link #getPromotionalMessage promotionalMessage}</li>
 * <li>{@link #getECommTransactionInfo eCommTransactionInfo}</li>
 * <li>{@link #getSepaElvTransactionInfo sepaElvTransactionInfo}</li>
 * <li>{@link #getClientCardType clientCardType}</li>
 * <li>{@link #getExplicitlySelectedApp explicitlySelectedApp}</li>
 * <li>{@link #getIsSepaElv isSepaElv}</li>
 * <li>{@link #getPrintMessages printMessages}</li>
 * <li>{@link #getIsPartialApprovedCashbackTransaction isPartialApprovedCashbackTransaction}</li>
 * <li>{@link #getAcquirer acquirer}</li>
 * <li>{@link #getNsuSiTef nsuSiTef}</li>
 * <li>{@link #getNsuHost nsuHost}</li>
 * <li>{@link #getSiTefCustomerReceipt siTefCustomerReceipt}</li>
 * <li>{@link #getSiTefMerchantReceipt siTefMerchantReceipt}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class TransactionInfo extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * 2 character language used for the transaction. Deprecated in factor of transactionLocale.
   */
  @Deprecated
  public java.lang.String getLanguageIndicator() {
    return genClient.cacheGet(CacheKey.languageIndicator);
  }

  /**
   * Locale for the transaction (e.g. en-CA)
   */
  public java.lang.String getTransactionLocale() {
    return genClient.cacheGet(CacheKey.transactionLocale);
  }

  public com.clover.sdk.v3.payments.AccountType getAccountSelection() {
    return genClient.cacheGet(CacheKey.accountSelection);
  }

  /**
   * Consists of 4 digits prefix + 8 digits
   */
  public java.lang.String getFiscalInvoiceNumber() {
    return genClient.cacheGet(CacheKey.fiscalInvoiceNumber);
  }

  /**
   * AR Installments: number of installments
   */
  public java.lang.Integer getInstallmentsQuantity() {
    return genClient.cacheGet(CacheKey.installmentsQuantity);
  }

  /**
   * Name of the type of installments
   */
  public java.lang.String getInstallmentsType() {
    return genClient.cacheGet(CacheKey.installmentsType);
  }

  /**
   * AR Installments: plan alphanum code
   */
  public java.lang.String getInstallmentsPlanCode() {
    return genClient.cacheGet(CacheKey.installmentsPlanCode);
  }

  /**
   * AR Installments: selected plan id
   */
  public java.lang.String getInstallmentsPlanId() {
    return genClient.cacheGet(CacheKey.installmentsPlanId);
  }

  /**
   * AR Installments: selected plan desc
   */
  public java.lang.String getInstallmentsPlanDesc() {
    return genClient.cacheGet(CacheKey.installmentsPlanDesc);
  }

  /**
   * Card type label
   */
  public java.lang.String getCardTypeLabel() {
    return genClient.cacheGet(CacheKey.cardTypeLabel);
  }

  /**
   * Card Symbol for identify in payment_card_config table
   */
  public java.lang.String getCardSymbol() {
    return genClient.cacheGet(CacheKey.cardSymbol);
  }

  /**
   * STAN(System Audit Trace Number)
   */
  public java.lang.Integer getStan() {
    return genClient.cacheGet(CacheKey.stan);
  }

  /**
   * Customers identification number and type
   */
  public com.clover.sdk.v3.customers.IdentityDocument getIdentityDocument() {
    return genClient.cacheGet(CacheKey.identityDocument);
  }

  /**
   * Transaction Batch Number
   */
  public java.lang.String getBatchNumber() {
    return genClient.cacheGet(CacheKey.batchNumber);
  }

  /**
   * Transaction Receipt Number
   */
  public java.lang.String getReceiptNumber() {
    return genClient.cacheGet(CacheKey.receiptNumber);
  }

  /**
   * Reversal STAN Ref Num
   */
  public java.lang.String getReversalStanRefNum() {
    return genClient.cacheGet(CacheKey.reversalStanRefNum);
  }

  /**
   * STAN for reversal
   */
  public java.lang.Integer getReversalStan() {
    return genClient.cacheGet(CacheKey.reversalStan);
  }

  /**
   * MAC for reversal
   */
  public java.lang.String getReversalMac() {
    return genClient.cacheGet(CacheKey.reversalMac);
  }

  /**
   * MAC KSN for reversal
   */
  public java.lang.String getReversalMacKsn() {
    return genClient.cacheGet(CacheKey.reversalMacKsn);
  }

  /**
   * Designates the unique location of a terminal at a merchant
   */
  public java.lang.String getTerminalIdentification() {
    return genClient.cacheGet(CacheKey.terminalIdentification);
  }

  /**
   * Main internal identifier of terminal which should be the same across all Fiserv’s components
   */
  public java.lang.String getExternalTerminalId() {
    return genClient.cacheGet(CacheKey.externalTerminalId);
  }

  /**
   * When concatenated with the Acquirer Identifier, uniquely identifies a given merchant
   */
  public java.lang.String getMerchantIdentifier() {
    return genClient.cacheGet(CacheKey.merchantIdentifier);
  }

  /**
   * Indicates the name and location of the merchant
   */
  public java.lang.String getMerchantNameLocation() {
    return genClient.cacheGet(CacheKey.merchantNameLocation);
  }

  /**
   * Masked track2 data
   */
  public java.lang.String getMaskedTrack2() {
    return genClient.cacheGet(CacheKey.maskedTrack2);
  }

  /**
   * Extra data for receipt
   */
  public java.lang.String getReceiptExtraData() {
    return genClient.cacheGet(CacheKey.receiptExtraData);
  }

  /**
   * Defines the Financial Service selected for the transaction
   */
  public com.clover.sdk.v3.payments.SelectedService getSelectedService() {
    return genClient.cacheGet(CacheKey.selectedService);
  }

  /**
   * Result of the transaction
   */
  public com.clover.sdk.v3.payments.TransactionResult getTransactionResult() {
    return genClient.cacheGet(CacheKey.transactionResult);
  }

  /**
   * Contains a hex string with needed TLV tags for certification
   */
  public java.lang.String getTransactionTags() {
    return genClient.cacheGet(CacheKey.transactionTags);
  }

  /**
   * Contains the information how the data inside transactionTags should be coded - initially we cause default and nexo as formats
   */
  public com.clover.sdk.v3.payments.TxFormat getTxFormat() {
    return genClient.cacheGet(CacheKey.txFormat);
  }

  /**
   * Contains the information how the PAN should masked.
   */
  public java.lang.String getPanMask() {
    return genClient.cacheGet(CacheKey.panMask);
  }

  /**
   * Counter maintained by the terminal that is incremented for each transaction at the beginning of the Perform Service function.
   */
  public java.lang.String getTransactionSequenceCounter() {
    return genClient.cacheGet(CacheKey.transactionSequenceCounter);
  }

  /**
   * Identifies and differentiates cards with the same PAN.
   */
  public java.lang.String getApplicationPanSequenceNumber() {
    return genClient.cacheGet(CacheKey.applicationPanSequenceNumber);
  }

  /**
   * Counter maintained by the application in the ICC
   */
  public java.lang.String getApplicationTransactionCounter() {
    return genClient.cacheGet(CacheKey.applicationTransactionCounter);
  }

  /**
   * Contains the reason why the transaction should be reversed in the host. It has to be mapped in server with the expected value by the corresponding gateway
   */
  public com.clover.sdk.v3.payments.ReversalReason getReversalReason() {
    return genClient.cacheGet(CacheKey.reversalReason);
  }

  /**
   * Boolean to determine if the transaction done using a vaulted card is a token based transaction
   */
  public java.lang.Boolean getIsTokenBasedTx() {
    return genClient.cacheGet(CacheKey.isTokenBasedTx);
  }

  /**
   * For reversal and capture transactions, this contains the reference (transactionSequenceCounter) to the originating transaction.
   */
  public java.lang.String getOrigTransactionSequenceCounter() {
    return genClient.cacheGet(CacheKey.origTransactionSequenceCounter);
  }

  /**
   * This field is populated when the TSC of a terminal is out of sync and is provided with an update.
   */
  public java.lang.String getTransactionSequenceCounterUpdate() {
    return genClient.cacheGet(CacheKey.transactionSequenceCounterUpdate);
  }

  /**
   * Boolean value defining if the corresponding TX was performed in NEXO emergency mode according NEXO IS Spec chapter 10.2
   */
  public java.lang.Boolean getEmergencyFlag() {
    return genClient.cacheGet(CacheKey.emergencyFlag);
  }

  /**
   * This field contains the entry type of a transaction.
   */
  public com.clover.sdk.v3.payments.CardEntryType getCardEntryType() {
    return genClient.cacheGet(CacheKey.cardEntryType);
  }

  public com.clover.sdk.v3.payments.PromotionalMessage getPromotionalMessage() {
    return genClient.cacheGet(CacheKey.promotionalMessage);
  }

  public com.clover.sdk.v3.payments.ECommTransactionInfo getECommTransactionInfo() {
    return genClient.cacheGet(CacheKey.eCommTransactionInfo);
  }

  public com.clover.sdk.v3.payments.SepaElvTransactionInfo getSepaElvTransactionInfo() {
    return genClient.cacheGet(CacheKey.sepaElvTransactionInfo);
  }

  /**
   * Client card type should be used only limited purpose only and should not be confused with cardType in other objects.
  This is a read only field and must not to be overwritten on server or client once set on client.
  This is set on client only for MSR tx for now as the AIDs are not identified for MSR.
  For few MSR tx, the card type was identified incorrectly on client side, and also on server side based on the bin match.
  In order to get the correct card types, this client card type will be sent to the server
   */
  public com.clover.sdk.v3.payments.CardType getClientCardType() {
    return genClient.cacheGet(CacheKey.clientCardType);
  }

  /**
   * The app explicitly selected by the customer via the choice button.
   */
  public java.lang.String getExplicitlySelectedApp() {
    return genClient.cacheGet(CacheKey.explicitlySelectedApp);
  }

  /**
   * Defines if the corresponding TX was performed as SEPA ELV TX.
   */
  public java.lang.Boolean getIsSepaElv() {
    return genClient.cacheGet(CacheKey.isSepaElv);
  }

  public java.util.List<com.clover.sdk.v3.payments.DisplayAndPrintMessage> getPrintMessages() {
    return genClient.cacheGet(CacheKey.printMessages);
  }

  /**
   * Defines if payment amount was approved but cashback amount was declined.
   */
  public java.lang.Boolean getIsPartialApprovedCashbackTransaction() {
    return genClient.cacheGet(CacheKey.isPartialApprovedCashbackTransaction);
  }

  /**
   * Name of the acquirer which processed the transaction
   */
  public java.lang.String getAcquirer() {
    return genClient.cacheGet(CacheKey.acquirer);
  }

  /**
   * Unique transaction number generated by SiTef platform
   */
  public java.lang.String getNsuSiTef() {
    return genClient.cacheGet(CacheKey.nsuSiTef);
  }

  /**
   * Unique transaction number generated by Host
   */
  public java.lang.String getNsuHost() {
    return genClient.cacheGet(CacheKey.nsuHost);
  }

  /**
   * SiTef customer receipt content
   */
  public java.lang.String getSiTefCustomerReceipt() {
    return genClient.cacheGet(CacheKey.siTefCustomerReceipt);
  }

  /**
   * SiTef merchant receipt content
   */
  public java.lang.String getSiTefMerchantReceipt() {
    return genClient.cacheGet(CacheKey.siTefMerchantReceipt);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    languageIndicator
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    transactionLocale
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    accountSelection
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.payments.AccountType.class)),
    fiscalInvoiceNumber
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    installmentsQuantity
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
    installmentsType
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    installmentsPlanCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    installmentsPlanId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    installmentsPlanDesc
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    cardTypeLabel
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    cardSymbol
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    stan
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
    identityDocument
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.customers.IdentityDocument.JSON_CREATOR)),
    batchNumber
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    receiptNumber
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    reversalStanRefNum
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    reversalStan
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
    reversalMac
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    reversalMacKsn
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    terminalIdentification
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    externalTerminalId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    merchantIdentifier
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    merchantNameLocation
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    maskedTrack2
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    receiptExtraData
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    selectedService
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.payments.SelectedService.class)),
    transactionResult
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.payments.TransactionResult.class)),
    transactionTags
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    txFormat
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.payments.TxFormat.class)),
    panMask
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    transactionSequenceCounter
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    applicationPanSequenceNumber
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    applicationTransactionCounter
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    reversalReason
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.payments.ReversalReason.class)),
    isTokenBasedTx
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    origTransactionSequenceCounter
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    transactionSequenceCounterUpdate
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    emergencyFlag
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    cardEntryType
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.payments.CardEntryType.class)),
    promotionalMessage
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.PromotionalMessage.JSON_CREATOR)),
    eCommTransactionInfo
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.ECommTransactionInfo.JSON_CREATOR)),
    sepaElvTransactionInfo
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.SepaElvTransactionInfo.JSON_CREATOR)),
    clientCardType
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.payments.CardType.class)),
    explicitlySelectedApp
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    isSepaElv
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    printMessages
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.payments.DisplayAndPrintMessage.JSON_CREATOR)),
    isPartialApprovedCashbackTransaction
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    acquirer
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    nsuSiTef
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    nsuHost
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    siTefCustomerReceipt
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    siTefMerchantReceipt
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<TransactionInfo> genClient;

  /**
   * Constructs a new empty instance.
   */
  public TransactionInfo() {
    genClient = new GenericClient<TransactionInfo>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected TransactionInfo(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public TransactionInfo(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public TransactionInfo(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public TransactionInfo(TransactionInfo src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateLength(CacheKey.languageIndicator, getLanguageIndicator(), 2);

    genClient.validateLength(CacheKey.fiscalInvoiceNumber, getFiscalInvoiceNumber(), 12);

    genClient.validateLength(CacheKey.installmentsPlanCode, getInstallmentsPlanCode(), 1);

    genClient.validateLength(CacheKey.cardSymbol, getCardSymbol(), 2);

    genClient.validateLength(CacheKey.panMask, getPanMask(), 14);
  }

  /** Checks whether the 'languageIndicator' field is set and is not null */
  public boolean isNotNullLanguageIndicator() {
    return genClient.cacheValueIsNotNull(CacheKey.languageIndicator);
  }

  /** Checks whether the 'transactionLocale' field is set and is not null */
  public boolean isNotNullTransactionLocale() {
    return genClient.cacheValueIsNotNull(CacheKey.transactionLocale);
  }

  /** Checks whether the 'accountSelection' field is set and is not null */
  public boolean isNotNullAccountSelection() {
    return genClient.cacheValueIsNotNull(CacheKey.accountSelection);
  }

  /** Checks whether the 'fiscalInvoiceNumber' field is set and is not null */
  public boolean isNotNullFiscalInvoiceNumber() {
    return genClient.cacheValueIsNotNull(CacheKey.fiscalInvoiceNumber);
  }

  /** Checks whether the 'installmentsQuantity' field is set and is not null */
  public boolean isNotNullInstallmentsQuantity() {
    return genClient.cacheValueIsNotNull(CacheKey.installmentsQuantity);
  }

  /** Checks whether the 'installmentsType' field is set and is not null */
  public boolean isNotNullInstallmentsType() {
    return genClient.cacheValueIsNotNull(CacheKey.installmentsType);
  }

  /** Checks whether the 'installmentsPlanCode' field is set and is not null */
  public boolean isNotNullInstallmentsPlanCode() {
    return genClient.cacheValueIsNotNull(CacheKey.installmentsPlanCode);
  }

  /** Checks whether the 'installmentsPlanId' field is set and is not null */
  public boolean isNotNullInstallmentsPlanId() {
    return genClient.cacheValueIsNotNull(CacheKey.installmentsPlanId);
  }

  /** Checks whether the 'installmentsPlanDesc' field is set and is not null */
  public boolean isNotNullInstallmentsPlanDesc() {
    return genClient.cacheValueIsNotNull(CacheKey.installmentsPlanDesc);
  }

  /** Checks whether the 'cardTypeLabel' field is set and is not null */
  public boolean isNotNullCardTypeLabel() {
    return genClient.cacheValueIsNotNull(CacheKey.cardTypeLabel);
  }

  /** Checks whether the 'cardSymbol' field is set and is not null */
  public boolean isNotNullCardSymbol() {
    return genClient.cacheValueIsNotNull(CacheKey.cardSymbol);
  }

  /** Checks whether the 'stan' field is set and is not null */
  public boolean isNotNullStan() {
    return genClient.cacheValueIsNotNull(CacheKey.stan);
  }

  /** Checks whether the 'identityDocument' field is set and is not null */
  public boolean isNotNullIdentityDocument() {
    return genClient.cacheValueIsNotNull(CacheKey.identityDocument);
  }

  /** Checks whether the 'batchNumber' field is set and is not null */
  public boolean isNotNullBatchNumber() {
    return genClient.cacheValueIsNotNull(CacheKey.batchNumber);
  }

  /** Checks whether the 'receiptNumber' field is set and is not null */
  public boolean isNotNullReceiptNumber() {
    return genClient.cacheValueIsNotNull(CacheKey.receiptNumber);
  }

  /** Checks whether the 'reversalStanRefNum' field is set and is not null */
  public boolean isNotNullReversalStanRefNum() {
    return genClient.cacheValueIsNotNull(CacheKey.reversalStanRefNum);
  }

  /** Checks whether the 'reversalStan' field is set and is not null */
  public boolean isNotNullReversalStan() {
    return genClient.cacheValueIsNotNull(CacheKey.reversalStan);
  }

  /** Checks whether the 'reversalMac' field is set and is not null */
  public boolean isNotNullReversalMac() {
    return genClient.cacheValueIsNotNull(CacheKey.reversalMac);
  }

  /** Checks whether the 'reversalMacKsn' field is set and is not null */
  public boolean isNotNullReversalMacKsn() {
    return genClient.cacheValueIsNotNull(CacheKey.reversalMacKsn);
  }

  /** Checks whether the 'terminalIdentification' field is set and is not null */
  public boolean isNotNullTerminalIdentification() {
    return genClient.cacheValueIsNotNull(CacheKey.terminalIdentification);
  }

  /** Checks whether the 'externalTerminalId' field is set and is not null */
  public boolean isNotNullExternalTerminalId() {
    return genClient.cacheValueIsNotNull(CacheKey.externalTerminalId);
  }

  /** Checks whether the 'merchantIdentifier' field is set and is not null */
  public boolean isNotNullMerchantIdentifier() {
    return genClient.cacheValueIsNotNull(CacheKey.merchantIdentifier);
  }

  /** Checks whether the 'merchantNameLocation' field is set and is not null */
  public boolean isNotNullMerchantNameLocation() {
    return genClient.cacheValueIsNotNull(CacheKey.merchantNameLocation);
  }

  /** Checks whether the 'maskedTrack2' field is set and is not null */
  public boolean isNotNullMaskedTrack2() {
    return genClient.cacheValueIsNotNull(CacheKey.maskedTrack2);
  }

  /** Checks whether the 'receiptExtraData' field is set and is not null */
  public boolean isNotNullReceiptExtraData() {
    return genClient.cacheValueIsNotNull(CacheKey.receiptExtraData);
  }

  /** Checks whether the 'selectedService' field is set and is not null */
  public boolean isNotNullSelectedService() {
    return genClient.cacheValueIsNotNull(CacheKey.selectedService);
  }

  /** Checks whether the 'transactionResult' field is set and is not null */
  public boolean isNotNullTransactionResult() {
    return genClient.cacheValueIsNotNull(CacheKey.transactionResult);
  }

  /** Checks whether the 'transactionTags' field is set and is not null */
  public boolean isNotNullTransactionTags() {
    return genClient.cacheValueIsNotNull(CacheKey.transactionTags);
  }

  /** Checks whether the 'txFormat' field is set and is not null */
  public boolean isNotNullTxFormat() {
    return genClient.cacheValueIsNotNull(CacheKey.txFormat);
  }

  /** Checks whether the 'panMask' field is set and is not null */
  public boolean isNotNullPanMask() {
    return genClient.cacheValueIsNotNull(CacheKey.panMask);
  }

  /** Checks whether the 'transactionSequenceCounter' field is set and is not null */
  public boolean isNotNullTransactionSequenceCounter() {
    return genClient.cacheValueIsNotNull(CacheKey.transactionSequenceCounter);
  }

  /** Checks whether the 'applicationPanSequenceNumber' field is set and is not null */
  public boolean isNotNullApplicationPanSequenceNumber() {
    return genClient.cacheValueIsNotNull(CacheKey.applicationPanSequenceNumber);
  }

  /** Checks whether the 'applicationTransactionCounter' field is set and is not null */
  public boolean isNotNullApplicationTransactionCounter() {
    return genClient.cacheValueIsNotNull(CacheKey.applicationTransactionCounter);
  }

  /** Checks whether the 'reversalReason' field is set and is not null */
  public boolean isNotNullReversalReason() {
    return genClient.cacheValueIsNotNull(CacheKey.reversalReason);
  }

  /** Checks whether the 'isTokenBasedTx' field is set and is not null */
  public boolean isNotNullIsTokenBasedTx() {
    return genClient.cacheValueIsNotNull(CacheKey.isTokenBasedTx);
  }

  /** Checks whether the 'origTransactionSequenceCounter' field is set and is not null */
  public boolean isNotNullOrigTransactionSequenceCounter() {
    return genClient.cacheValueIsNotNull(CacheKey.origTransactionSequenceCounter);
  }

  /** Checks whether the 'transactionSequenceCounterUpdate' field is set and is not null */
  public boolean isNotNullTransactionSequenceCounterUpdate() {
    return genClient.cacheValueIsNotNull(CacheKey.transactionSequenceCounterUpdate);
  }

  /** Checks whether the 'emergencyFlag' field is set and is not null */
  public boolean isNotNullEmergencyFlag() {
    return genClient.cacheValueIsNotNull(CacheKey.emergencyFlag);
  }

  /** Checks whether the 'cardEntryType' field is set and is not null */
  public boolean isNotNullCardEntryType() {
    return genClient.cacheValueIsNotNull(CacheKey.cardEntryType);
  }

  /** Checks whether the 'promotionalMessage' field is set and is not null */
  public boolean isNotNullPromotionalMessage() {
    return genClient.cacheValueIsNotNull(CacheKey.promotionalMessage);
  }

  /** Checks whether the 'eCommTransactionInfo' field is set and is not null */
  public boolean isNotNullECommTransactionInfo() {
    return genClient.cacheValueIsNotNull(CacheKey.eCommTransactionInfo);
  }

  /** Checks whether the 'sepaElvTransactionInfo' field is set and is not null */
  public boolean isNotNullSepaElvTransactionInfo() {
    return genClient.cacheValueIsNotNull(CacheKey.sepaElvTransactionInfo);
  }

  /** Checks whether the 'clientCardType' field is set and is not null */
  public boolean isNotNullClientCardType() {
    return genClient.cacheValueIsNotNull(CacheKey.clientCardType);
  }

  /** Checks whether the 'explicitlySelectedApp' field is set and is not null */
  public boolean isNotNullExplicitlySelectedApp() {
    return genClient.cacheValueIsNotNull(CacheKey.explicitlySelectedApp);
  }

  /** Checks whether the 'isSepaElv' field is set and is not null */
  public boolean isNotNullIsSepaElv() {
    return genClient.cacheValueIsNotNull(CacheKey.isSepaElv);
  }

  /** Checks whether the 'printMessages' field is set and is not null */
  public boolean isNotNullPrintMessages() {
    return genClient.cacheValueIsNotNull(CacheKey.printMessages);
  }

  /** Checks whether the 'printMessages' field is set and is not null and is not empty */
  public boolean isNotEmptyPrintMessages() { return isNotNullPrintMessages() && !getPrintMessages().isEmpty(); }

  /** Checks whether the 'isPartialApprovedCashbackTransaction' field is set and is not null */
  public boolean isNotNullIsPartialApprovedCashbackTransaction() {
    return genClient.cacheValueIsNotNull(CacheKey.isPartialApprovedCashbackTransaction);
  }

  /** Checks whether the 'acquirer' field is set and is not null */
  public boolean isNotNullAcquirer() {
    return genClient.cacheValueIsNotNull(CacheKey.acquirer);
  }

  /** Checks whether the 'nsuSiTef' field is set and is not null */
  public boolean isNotNullNsuSiTef() {
    return genClient.cacheValueIsNotNull(CacheKey.nsuSiTef);
  }

  /** Checks whether the 'nsuHost' field is set and is not null */
  public boolean isNotNullNsuHost() {
    return genClient.cacheValueIsNotNull(CacheKey.nsuHost);
  }

  /** Checks whether the 'siTefCustomerReceipt' field is set and is not null */
  public boolean isNotNullSiTefCustomerReceipt() {
    return genClient.cacheValueIsNotNull(CacheKey.siTefCustomerReceipt);
  }

  /** Checks whether the 'siTefMerchantReceipt' field is set and is not null */
  public boolean isNotNullSiTefMerchantReceipt() {
    return genClient.cacheValueIsNotNull(CacheKey.siTefMerchantReceipt);
  }



  /** Checks whether the 'languageIndicator' field has been set, however the value could be null */
  public boolean hasLanguageIndicator() {
    return genClient.cacheHasKey(CacheKey.languageIndicator);
  }

  /** Checks whether the 'transactionLocale' field has been set, however the value could be null */
  public boolean hasTransactionLocale() {
    return genClient.cacheHasKey(CacheKey.transactionLocale);
  }

  /** Checks whether the 'accountSelection' field has been set, however the value could be null */
  public boolean hasAccountSelection() {
    return genClient.cacheHasKey(CacheKey.accountSelection);
  }

  /** Checks whether the 'fiscalInvoiceNumber' field has been set, however the value could be null */
  public boolean hasFiscalInvoiceNumber() {
    return genClient.cacheHasKey(CacheKey.fiscalInvoiceNumber);
  }

  /** Checks whether the 'installmentsQuantity' field has been set, however the value could be null */
  public boolean hasInstallmentsQuantity() {
    return genClient.cacheHasKey(CacheKey.installmentsQuantity);
  }

  /** Checks whether the 'installmentsType' field has been set, however the value could be null */
  public boolean hasInstallmentsType() {
    return genClient.cacheHasKey(CacheKey.installmentsType);
  }

  /** Checks whether the 'installmentsPlanCode' field has been set, however the value could be null */
  public boolean hasInstallmentsPlanCode() {
    return genClient.cacheHasKey(CacheKey.installmentsPlanCode);
  }

  /** Checks whether the 'installmentsPlanId' field has been set, however the value could be null */
  public boolean hasInstallmentsPlanId() {
    return genClient.cacheHasKey(CacheKey.installmentsPlanId);
  }

  /** Checks whether the 'installmentsPlanDesc' field has been set, however the value could be null */
  public boolean hasInstallmentsPlanDesc() {
    return genClient.cacheHasKey(CacheKey.installmentsPlanDesc);
  }

  /** Checks whether the 'cardTypeLabel' field has been set, however the value could be null */
  public boolean hasCardTypeLabel() {
    return genClient.cacheHasKey(CacheKey.cardTypeLabel);
  }

  /** Checks whether the 'cardSymbol' field has been set, however the value could be null */
  public boolean hasCardSymbol() {
    return genClient.cacheHasKey(CacheKey.cardSymbol);
  }

  /** Checks whether the 'stan' field has been set, however the value could be null */
  public boolean hasStan() {
    return genClient.cacheHasKey(CacheKey.stan);
  }

  /** Checks whether the 'identityDocument' field has been set, however the value could be null */
  public boolean hasIdentityDocument() {
    return genClient.cacheHasKey(CacheKey.identityDocument);
  }

  /** Checks whether the 'batchNumber' field has been set, however the value could be null */
  public boolean hasBatchNumber() {
    return genClient.cacheHasKey(CacheKey.batchNumber);
  }

  /** Checks whether the 'receiptNumber' field has been set, however the value could be null */
  public boolean hasReceiptNumber() {
    return genClient.cacheHasKey(CacheKey.receiptNumber);
  }

  /** Checks whether the 'reversalStanRefNum' field has been set, however the value could be null */
  public boolean hasReversalStanRefNum() {
    return genClient.cacheHasKey(CacheKey.reversalStanRefNum);
  }

  /** Checks whether the 'reversalStan' field has been set, however the value could be null */
  public boolean hasReversalStan() {
    return genClient.cacheHasKey(CacheKey.reversalStan);
  }

  /** Checks whether the 'reversalMac' field has been set, however the value could be null */
  public boolean hasReversalMac() {
    return genClient.cacheHasKey(CacheKey.reversalMac);
  }

  /** Checks whether the 'reversalMacKsn' field has been set, however the value could be null */
  public boolean hasReversalMacKsn() {
    return genClient.cacheHasKey(CacheKey.reversalMacKsn);
  }

  /** Checks whether the 'terminalIdentification' field has been set, however the value could be null */
  public boolean hasTerminalIdentification() {
    return genClient.cacheHasKey(CacheKey.terminalIdentification);
  }

  /** Checks whether the 'externalTerminalId' field has been set, however the value could be null */
  public boolean hasExternalTerminalId() {
    return genClient.cacheHasKey(CacheKey.externalTerminalId);
  }

  /** Checks whether the 'merchantIdentifier' field has been set, however the value could be null */
  public boolean hasMerchantIdentifier() {
    return genClient.cacheHasKey(CacheKey.merchantIdentifier);
  }

  /** Checks whether the 'merchantNameLocation' field has been set, however the value could be null */
  public boolean hasMerchantNameLocation() {
    return genClient.cacheHasKey(CacheKey.merchantNameLocation);
  }

  /** Checks whether the 'maskedTrack2' field has been set, however the value could be null */
  public boolean hasMaskedTrack2() {
    return genClient.cacheHasKey(CacheKey.maskedTrack2);
  }

  /** Checks whether the 'receiptExtraData' field has been set, however the value could be null */
  public boolean hasReceiptExtraData() {
    return genClient.cacheHasKey(CacheKey.receiptExtraData);
  }

  /** Checks whether the 'selectedService' field has been set, however the value could be null */
  public boolean hasSelectedService() {
    return genClient.cacheHasKey(CacheKey.selectedService);
  }

  /** Checks whether the 'transactionResult' field has been set, however the value could be null */
  public boolean hasTransactionResult() {
    return genClient.cacheHasKey(CacheKey.transactionResult);
  }

  /** Checks whether the 'transactionTags' field has been set, however the value could be null */
  public boolean hasTransactionTags() {
    return genClient.cacheHasKey(CacheKey.transactionTags);
  }

  /** Checks whether the 'txFormat' field has been set, however the value could be null */
  public boolean hasTxFormat() {
    return genClient.cacheHasKey(CacheKey.txFormat);
  }

  /** Checks whether the 'panMask' field has been set, however the value could be null */
  public boolean hasPanMask() {
    return genClient.cacheHasKey(CacheKey.panMask);
  }

  /** Checks whether the 'transactionSequenceCounter' field has been set, however the value could be null */
  public boolean hasTransactionSequenceCounter() {
    return genClient.cacheHasKey(CacheKey.transactionSequenceCounter);
  }

  /** Checks whether the 'applicationPanSequenceNumber' field has been set, however the value could be null */
  public boolean hasApplicationPanSequenceNumber() {
    return genClient.cacheHasKey(CacheKey.applicationPanSequenceNumber);
  }

  /** Checks whether the 'applicationTransactionCounter' field has been set, however the value could be null */
  public boolean hasApplicationTransactionCounter() {
    return genClient.cacheHasKey(CacheKey.applicationTransactionCounter);
  }

  /** Checks whether the 'reversalReason' field has been set, however the value could be null */
  public boolean hasReversalReason() {
    return genClient.cacheHasKey(CacheKey.reversalReason);
  }

  /** Checks whether the 'isTokenBasedTx' field has been set, however the value could be null */
  public boolean hasIsTokenBasedTx() {
    return genClient.cacheHasKey(CacheKey.isTokenBasedTx);
  }

  /** Checks whether the 'origTransactionSequenceCounter' field has been set, however the value could be null */
  public boolean hasOrigTransactionSequenceCounter() {
    return genClient.cacheHasKey(CacheKey.origTransactionSequenceCounter);
  }

  /** Checks whether the 'transactionSequenceCounterUpdate' field has been set, however the value could be null */
  public boolean hasTransactionSequenceCounterUpdate() {
    return genClient.cacheHasKey(CacheKey.transactionSequenceCounterUpdate);
  }

  /** Checks whether the 'emergencyFlag' field has been set, however the value could be null */
  public boolean hasEmergencyFlag() {
    return genClient.cacheHasKey(CacheKey.emergencyFlag);
  }

  /** Checks whether the 'cardEntryType' field has been set, however the value could be null */
  public boolean hasCardEntryType() {
    return genClient.cacheHasKey(CacheKey.cardEntryType);
  }

  /** Checks whether the 'promotionalMessage' field has been set, however the value could be null */
  public boolean hasPromotionalMessage() {
    return genClient.cacheHasKey(CacheKey.promotionalMessage);
  }

  /** Checks whether the 'eCommTransactionInfo' field has been set, however the value could be null */
  public boolean hasECommTransactionInfo() {
    return genClient.cacheHasKey(CacheKey.eCommTransactionInfo);
  }

  /** Checks whether the 'sepaElvTransactionInfo' field has been set, however the value could be null */
  public boolean hasSepaElvTransactionInfo() {
    return genClient.cacheHasKey(CacheKey.sepaElvTransactionInfo);
  }

  /** Checks whether the 'clientCardType' field has been set, however the value could be null */
  public boolean hasClientCardType() {
    return genClient.cacheHasKey(CacheKey.clientCardType);
  }

  /** Checks whether the 'explicitlySelectedApp' field has been set, however the value could be null */
  public boolean hasExplicitlySelectedApp() {
    return genClient.cacheHasKey(CacheKey.explicitlySelectedApp);
  }

  /** Checks whether the 'isSepaElv' field has been set, however the value could be null */
  public boolean hasIsSepaElv() {
    return genClient.cacheHasKey(CacheKey.isSepaElv);
  }

  /** Checks whether the 'printMessages' field has been set, however the value could be null */
  public boolean hasPrintMessages() {
    return genClient.cacheHasKey(CacheKey.printMessages);
  }

  /** Checks whether the 'isPartialApprovedCashbackTransaction' field has been set, however the value could be null */
  public boolean hasIsPartialApprovedCashbackTransaction() {
    return genClient.cacheHasKey(CacheKey.isPartialApprovedCashbackTransaction);
  }

  /** Checks whether the 'acquirer' field has been set, however the value could be null */
  public boolean hasAcquirer() {
    return genClient.cacheHasKey(CacheKey.acquirer);
  }

  /** Checks whether the 'nsuSiTef' field has been set, however the value could be null */
  public boolean hasNsuSiTef() {
    return genClient.cacheHasKey(CacheKey.nsuSiTef);
  }

  /** Checks whether the 'nsuHost' field has been set, however the value could be null */
  public boolean hasNsuHost() {
    return genClient.cacheHasKey(CacheKey.nsuHost);
  }

  /** Checks whether the 'siTefCustomerReceipt' field has been set, however the value could be null */
  public boolean hasSiTefCustomerReceipt() {
    return genClient.cacheHasKey(CacheKey.siTefCustomerReceipt);
  }

  /** Checks whether the 'siTefMerchantReceipt' field has been set, however the value could be null */
  public boolean hasSiTefMerchantReceipt() {
    return genClient.cacheHasKey(CacheKey.siTefMerchantReceipt);
  }


  /**
   * Sets the field 'languageIndicator'.
   */
  public TransactionInfo setLanguageIndicator(java.lang.String languageIndicator) {
    return genClient.setOther(languageIndicator, CacheKey.languageIndicator);
  }

  /**
   * Sets the field 'transactionLocale'.
   */
  public TransactionInfo setTransactionLocale(java.lang.String transactionLocale) {
    return genClient.setOther(transactionLocale, CacheKey.transactionLocale);
  }

  /**
   * Sets the field 'accountSelection'.
   */
  public TransactionInfo setAccountSelection(com.clover.sdk.v3.payments.AccountType accountSelection) {
    return genClient.setOther(accountSelection, CacheKey.accountSelection);
  }

  /**
   * Sets the field 'fiscalInvoiceNumber'.
   */
  public TransactionInfo setFiscalInvoiceNumber(java.lang.String fiscalInvoiceNumber) {
    return genClient.setOther(fiscalInvoiceNumber, CacheKey.fiscalInvoiceNumber);
  }

  /**
   * Sets the field 'installmentsQuantity'.
   */
  public TransactionInfo setInstallmentsQuantity(java.lang.Integer installmentsQuantity) {
    return genClient.setOther(installmentsQuantity, CacheKey.installmentsQuantity);
  }

  /**
   * Sets the field 'installmentsType'.
   */
  public TransactionInfo setInstallmentsType(java.lang.String installmentsType) {
    return genClient.setOther(installmentsType, CacheKey.installmentsType);
  }

  /**
   * Sets the field 'installmentsPlanCode'.
   */
  public TransactionInfo setInstallmentsPlanCode(java.lang.String installmentsPlanCode) {
    return genClient.setOther(installmentsPlanCode, CacheKey.installmentsPlanCode);
  }

  /**
   * Sets the field 'installmentsPlanId'.
   */
  public TransactionInfo setInstallmentsPlanId(java.lang.String installmentsPlanId) {
    return genClient.setOther(installmentsPlanId, CacheKey.installmentsPlanId);
  }

  /**
   * Sets the field 'installmentsPlanDesc'.
   */
  public TransactionInfo setInstallmentsPlanDesc(java.lang.String installmentsPlanDesc) {
    return genClient.setOther(installmentsPlanDesc, CacheKey.installmentsPlanDesc);
  }

  /**
   * Sets the field 'cardTypeLabel'.
   */
  public TransactionInfo setCardTypeLabel(java.lang.String cardTypeLabel) {
    return genClient.setOther(cardTypeLabel, CacheKey.cardTypeLabel);
  }

  /**
   * Sets the field 'cardSymbol'.
   */
  public TransactionInfo setCardSymbol(java.lang.String cardSymbol) {
    return genClient.setOther(cardSymbol, CacheKey.cardSymbol);
  }

  /**
   * Sets the field 'stan'.
   */
  public TransactionInfo setStan(java.lang.Integer stan) {
    return genClient.setOther(stan, CacheKey.stan);
  }

  /**
   * Sets the field 'identityDocument'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public TransactionInfo setIdentityDocument(com.clover.sdk.v3.customers.IdentityDocument identityDocument) {
    return genClient.setRecord(identityDocument, CacheKey.identityDocument);
  }

  /**
   * Sets the field 'batchNumber'.
   */
  public TransactionInfo setBatchNumber(java.lang.String batchNumber) {
    return genClient.setOther(batchNumber, CacheKey.batchNumber);
  }

  /**
   * Sets the field 'receiptNumber'.
   */
  public TransactionInfo setReceiptNumber(java.lang.String receiptNumber) {
    return genClient.setOther(receiptNumber, CacheKey.receiptNumber);
  }

  /**
   * Sets the field 'reversalStanRefNum'.
   */
  public TransactionInfo setReversalStanRefNum(java.lang.String reversalStanRefNum) {
    return genClient.setOther(reversalStanRefNum, CacheKey.reversalStanRefNum);
  }

  /**
   * Sets the field 'reversalStan'.
   */
  public TransactionInfo setReversalStan(java.lang.Integer reversalStan) {
    return genClient.setOther(reversalStan, CacheKey.reversalStan);
  }

  /**
   * Sets the field 'reversalMac'.
   */
  public TransactionInfo setReversalMac(java.lang.String reversalMac) {
    return genClient.setOther(reversalMac, CacheKey.reversalMac);
  }

  /**
   * Sets the field 'reversalMacKsn'.
   */
  public TransactionInfo setReversalMacKsn(java.lang.String reversalMacKsn) {
    return genClient.setOther(reversalMacKsn, CacheKey.reversalMacKsn);
  }

  /**
   * Sets the field 'terminalIdentification'.
   */
  public TransactionInfo setTerminalIdentification(java.lang.String terminalIdentification) {
    return genClient.setOther(terminalIdentification, CacheKey.terminalIdentification);
  }

  /**
   * Sets the field 'externalTerminalId'.
   */
  public TransactionInfo setExternalTerminalId(java.lang.String externalTerminalId) {
    return genClient.setOther(externalTerminalId, CacheKey.externalTerminalId);
  }

  /**
   * Sets the field 'merchantIdentifier'.
   */
  public TransactionInfo setMerchantIdentifier(java.lang.String merchantIdentifier) {
    return genClient.setOther(merchantIdentifier, CacheKey.merchantIdentifier);
  }

  /**
   * Sets the field 'merchantNameLocation'.
   */
  public TransactionInfo setMerchantNameLocation(java.lang.String merchantNameLocation) {
    return genClient.setOther(merchantNameLocation, CacheKey.merchantNameLocation);
  }

  /**
   * Sets the field 'maskedTrack2'.
   */
  public TransactionInfo setMaskedTrack2(java.lang.String maskedTrack2) {
    return genClient.setOther(maskedTrack2, CacheKey.maskedTrack2);
  }

  /**
   * Sets the field 'receiptExtraData'.
   */
  public TransactionInfo setReceiptExtraData(java.lang.String receiptExtraData) {
    return genClient.setOther(receiptExtraData, CacheKey.receiptExtraData);
  }

  /**
   * Sets the field 'selectedService'.
   */
  public TransactionInfo setSelectedService(com.clover.sdk.v3.payments.SelectedService selectedService) {
    return genClient.setOther(selectedService, CacheKey.selectedService);
  }

  /**
   * Sets the field 'transactionResult'.
   */
  public TransactionInfo setTransactionResult(com.clover.sdk.v3.payments.TransactionResult transactionResult) {
    return genClient.setOther(transactionResult, CacheKey.transactionResult);
  }

  /**
   * Sets the field 'transactionTags'.
   */
  public TransactionInfo setTransactionTags(java.lang.String transactionTags) {
    return genClient.setOther(transactionTags, CacheKey.transactionTags);
  }

  /**
   * Sets the field 'txFormat'.
   */
  public TransactionInfo setTxFormat(com.clover.sdk.v3.payments.TxFormat txFormat) {
    return genClient.setOther(txFormat, CacheKey.txFormat);
  }

  /**
   * Sets the field 'panMask'.
   */
  public TransactionInfo setPanMask(java.lang.String panMask) {
    return genClient.setOther(panMask, CacheKey.panMask);
  }

  /**
   * Sets the field 'transactionSequenceCounter'.
   */
  public TransactionInfo setTransactionSequenceCounter(java.lang.String transactionSequenceCounter) {
    return genClient.setOther(transactionSequenceCounter, CacheKey.transactionSequenceCounter);
  }

  /**
   * Sets the field 'applicationPanSequenceNumber'.
   */
  public TransactionInfo setApplicationPanSequenceNumber(java.lang.String applicationPanSequenceNumber) {
    return genClient.setOther(applicationPanSequenceNumber, CacheKey.applicationPanSequenceNumber);
  }

  /**
   * Sets the field 'applicationTransactionCounter'.
   */
  public TransactionInfo setApplicationTransactionCounter(java.lang.String applicationTransactionCounter) {
    return genClient.setOther(applicationTransactionCounter, CacheKey.applicationTransactionCounter);
  }

  /**
   * Sets the field 'reversalReason'.
   */
  public TransactionInfo setReversalReason(com.clover.sdk.v3.payments.ReversalReason reversalReason) {
    return genClient.setOther(reversalReason, CacheKey.reversalReason);
  }

  /**
   * Sets the field 'isTokenBasedTx'.
   */
  public TransactionInfo setIsTokenBasedTx(java.lang.Boolean isTokenBasedTx) {
    return genClient.setOther(isTokenBasedTx, CacheKey.isTokenBasedTx);
  }

  /**
   * Sets the field 'origTransactionSequenceCounter'.
   */
  public TransactionInfo setOrigTransactionSequenceCounter(java.lang.String origTransactionSequenceCounter) {
    return genClient.setOther(origTransactionSequenceCounter, CacheKey.origTransactionSequenceCounter);
  }

  /**
   * Sets the field 'transactionSequenceCounterUpdate'.
   */
  public TransactionInfo setTransactionSequenceCounterUpdate(java.lang.String transactionSequenceCounterUpdate) {
    return genClient.setOther(transactionSequenceCounterUpdate, CacheKey.transactionSequenceCounterUpdate);
  }

  /**
   * Sets the field 'emergencyFlag'.
   */
  public TransactionInfo setEmergencyFlag(java.lang.Boolean emergencyFlag) {
    return genClient.setOther(emergencyFlag, CacheKey.emergencyFlag);
  }

  /**
   * Sets the field 'cardEntryType'.
   */
  public TransactionInfo setCardEntryType(com.clover.sdk.v3.payments.CardEntryType cardEntryType) {
    return genClient.setOther(cardEntryType, CacheKey.cardEntryType);
  }

  /**
   * Sets the field 'promotionalMessage'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public TransactionInfo setPromotionalMessage(com.clover.sdk.v3.payments.PromotionalMessage promotionalMessage) {
    return genClient.setRecord(promotionalMessage, CacheKey.promotionalMessage);
  }

  /**
   * Sets the field 'eCommTransactionInfo'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public TransactionInfo setECommTransactionInfo(com.clover.sdk.v3.payments.ECommTransactionInfo eCommTransactionInfo) {
    return genClient.setRecord(eCommTransactionInfo, CacheKey.eCommTransactionInfo);
  }

  /**
   * Sets the field 'sepaElvTransactionInfo'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public TransactionInfo setSepaElvTransactionInfo(com.clover.sdk.v3.payments.SepaElvTransactionInfo sepaElvTransactionInfo) {
    return genClient.setRecord(sepaElvTransactionInfo, CacheKey.sepaElvTransactionInfo);
  }

  /**
   * Sets the field 'clientCardType'.
   */
  public TransactionInfo setClientCardType(com.clover.sdk.v3.payments.CardType clientCardType) {
    return genClient.setOther(clientCardType, CacheKey.clientCardType);
  }

  /**
   * Sets the field 'explicitlySelectedApp'.
   */
  public TransactionInfo setExplicitlySelectedApp(java.lang.String explicitlySelectedApp) {
    return genClient.setOther(explicitlySelectedApp, CacheKey.explicitlySelectedApp);
  }

  /**
   * Sets the field 'isSepaElv'.
   */
  public TransactionInfo setIsSepaElv(java.lang.Boolean isSepaElv) {
    return genClient.setOther(isSepaElv, CacheKey.isSepaElv);
  }

  /**
   * Sets the field 'printMessages'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public TransactionInfo setPrintMessages(java.util.List<com.clover.sdk.v3.payments.DisplayAndPrintMessage> printMessages) {
    return genClient.setArrayRecord(printMessages, CacheKey.printMessages);
  }

  /**
   * Sets the field 'isPartialApprovedCashbackTransaction'.
   */
  public TransactionInfo setIsPartialApprovedCashbackTransaction(java.lang.Boolean isPartialApprovedCashbackTransaction) {
    return genClient.setOther(isPartialApprovedCashbackTransaction, CacheKey.isPartialApprovedCashbackTransaction);
  }

  /**
   * Sets the field 'acquirer'.
   */
  public TransactionInfo setAcquirer(java.lang.String acquirer) {
    return genClient.setOther(acquirer, CacheKey.acquirer);
  }

  /**
   * Sets the field 'nsuSiTef'.
   */
  public TransactionInfo setNsuSiTef(java.lang.String nsuSiTef) {
    return genClient.setOther(nsuSiTef, CacheKey.nsuSiTef);
  }

  /**
   * Sets the field 'nsuHost'.
   */
  public TransactionInfo setNsuHost(java.lang.String nsuHost) {
    return genClient.setOther(nsuHost, CacheKey.nsuHost);
  }

  /**
   * Sets the field 'siTefCustomerReceipt'.
   */
  public TransactionInfo setSiTefCustomerReceipt(java.lang.String siTefCustomerReceipt) {
    return genClient.setOther(siTefCustomerReceipt, CacheKey.siTefCustomerReceipt);
  }

  /**
   * Sets the field 'siTefMerchantReceipt'.
   */
  public TransactionInfo setSiTefMerchantReceipt(java.lang.String siTefMerchantReceipt) {
    return genClient.setOther(siTefMerchantReceipt, CacheKey.siTefMerchantReceipt);
  }


  /** Clears the 'languageIndicator' field, the 'has' method for this field will now return false */
  public void clearLanguageIndicator() {
    genClient.clear(CacheKey.languageIndicator);
  }
  /** Clears the 'transactionLocale' field, the 'has' method for this field will now return false */
  public void clearTransactionLocale() {
    genClient.clear(CacheKey.transactionLocale);
  }
  /** Clears the 'accountSelection' field, the 'has' method for this field will now return false */
  public void clearAccountSelection() {
    genClient.clear(CacheKey.accountSelection);
  }
  /** Clears the 'fiscalInvoiceNumber' field, the 'has' method for this field will now return false */
  public void clearFiscalInvoiceNumber() {
    genClient.clear(CacheKey.fiscalInvoiceNumber);
  }
  /** Clears the 'installmentsQuantity' field, the 'has' method for this field will now return false */
  public void clearInstallmentsQuantity() {
    genClient.clear(CacheKey.installmentsQuantity);
  }
  /** Clears the 'installmentsType' field, the 'has' method for this field will now return false */
  public void clearInstallmentsType() {
    genClient.clear(CacheKey.installmentsType);
  }
  /** Clears the 'installmentsPlanCode' field, the 'has' method for this field will now return false */
  public void clearInstallmentsPlanCode() {
    genClient.clear(CacheKey.installmentsPlanCode);
  }
  /** Clears the 'installmentsPlanId' field, the 'has' method for this field will now return false */
  public void clearInstallmentsPlanId() {
    genClient.clear(CacheKey.installmentsPlanId);
  }
  /** Clears the 'installmentsPlanDesc' field, the 'has' method for this field will now return false */
  public void clearInstallmentsPlanDesc() {
    genClient.clear(CacheKey.installmentsPlanDesc);
  }
  /** Clears the 'cardTypeLabel' field, the 'has' method for this field will now return false */
  public void clearCardTypeLabel() {
    genClient.clear(CacheKey.cardTypeLabel);
  }
  /** Clears the 'cardSymbol' field, the 'has' method for this field will now return false */
  public void clearCardSymbol() {
    genClient.clear(CacheKey.cardSymbol);
  }
  /** Clears the 'stan' field, the 'has' method for this field will now return false */
  public void clearStan() {
    genClient.clear(CacheKey.stan);
  }
  /** Clears the 'identityDocument' field, the 'has' method for this field will now return false */
  public void clearIdentityDocument() {
    genClient.clear(CacheKey.identityDocument);
  }
  /** Clears the 'batchNumber' field, the 'has' method for this field will now return false */
  public void clearBatchNumber() {
    genClient.clear(CacheKey.batchNumber);
  }
  /** Clears the 'receiptNumber' field, the 'has' method for this field will now return false */
  public void clearReceiptNumber() {
    genClient.clear(CacheKey.receiptNumber);
  }
  /** Clears the 'reversalStanRefNum' field, the 'has' method for this field will now return false */
  public void clearReversalStanRefNum() {
    genClient.clear(CacheKey.reversalStanRefNum);
  }
  /** Clears the 'reversalStan' field, the 'has' method for this field will now return false */
  public void clearReversalStan() {
    genClient.clear(CacheKey.reversalStan);
  }
  /** Clears the 'reversalMac' field, the 'has' method for this field will now return false */
  public void clearReversalMac() {
    genClient.clear(CacheKey.reversalMac);
  }
  /** Clears the 'reversalMacKsn' field, the 'has' method for this field will now return false */
  public void clearReversalMacKsn() {
    genClient.clear(CacheKey.reversalMacKsn);
  }
  /** Clears the 'terminalIdentification' field, the 'has' method for this field will now return false */
  public void clearTerminalIdentification() {
    genClient.clear(CacheKey.terminalIdentification);
  }
  /** Clears the 'externalTerminalId' field, the 'has' method for this field will now return false */
  public void clearExternalTerminalId() {
    genClient.clear(CacheKey.externalTerminalId);
  }
  /** Clears the 'merchantIdentifier' field, the 'has' method for this field will now return false */
  public void clearMerchantIdentifier() {
    genClient.clear(CacheKey.merchantIdentifier);
  }
  /** Clears the 'merchantNameLocation' field, the 'has' method for this field will now return false */
  public void clearMerchantNameLocation() {
    genClient.clear(CacheKey.merchantNameLocation);
  }
  /** Clears the 'maskedTrack2' field, the 'has' method for this field will now return false */
  public void clearMaskedTrack2() {
    genClient.clear(CacheKey.maskedTrack2);
  }
  /** Clears the 'receiptExtraData' field, the 'has' method for this field will now return false */
  public void clearReceiptExtraData() {
    genClient.clear(CacheKey.receiptExtraData);
  }
  /** Clears the 'selectedService' field, the 'has' method for this field will now return false */
  public void clearSelectedService() {
    genClient.clear(CacheKey.selectedService);
  }
  /** Clears the 'transactionResult' field, the 'has' method for this field will now return false */
  public void clearTransactionResult() {
    genClient.clear(CacheKey.transactionResult);
  }
  /** Clears the 'transactionTags' field, the 'has' method for this field will now return false */
  public void clearTransactionTags() {
    genClient.clear(CacheKey.transactionTags);
  }
  /** Clears the 'txFormat' field, the 'has' method for this field will now return false */
  public void clearTxFormat() {
    genClient.clear(CacheKey.txFormat);
  }
  /** Clears the 'panMask' field, the 'has' method for this field will now return false */
  public void clearPanMask() {
    genClient.clear(CacheKey.panMask);
  }
  /** Clears the 'transactionSequenceCounter' field, the 'has' method for this field will now return false */
  public void clearTransactionSequenceCounter() {
    genClient.clear(CacheKey.transactionSequenceCounter);
  }
  /** Clears the 'applicationPanSequenceNumber' field, the 'has' method for this field will now return false */
  public void clearApplicationPanSequenceNumber() {
    genClient.clear(CacheKey.applicationPanSequenceNumber);
  }
  /** Clears the 'applicationTransactionCounter' field, the 'has' method for this field will now return false */
  public void clearApplicationTransactionCounter() {
    genClient.clear(CacheKey.applicationTransactionCounter);
  }
  /** Clears the 'reversalReason' field, the 'has' method for this field will now return false */
  public void clearReversalReason() {
    genClient.clear(CacheKey.reversalReason);
  }
  /** Clears the 'isTokenBasedTx' field, the 'has' method for this field will now return false */
  public void clearIsTokenBasedTx() {
    genClient.clear(CacheKey.isTokenBasedTx);
  }
  /** Clears the 'origTransactionSequenceCounter' field, the 'has' method for this field will now return false */
  public void clearOrigTransactionSequenceCounter() {
    genClient.clear(CacheKey.origTransactionSequenceCounter);
  }
  /** Clears the 'transactionSequenceCounterUpdate' field, the 'has' method for this field will now return false */
  public void clearTransactionSequenceCounterUpdate() {
    genClient.clear(CacheKey.transactionSequenceCounterUpdate);
  }
  /** Clears the 'emergencyFlag' field, the 'has' method for this field will now return false */
  public void clearEmergencyFlag() {
    genClient.clear(CacheKey.emergencyFlag);
  }
  /** Clears the 'cardEntryType' field, the 'has' method for this field will now return false */
  public void clearCardEntryType() {
    genClient.clear(CacheKey.cardEntryType);
  }
  /** Clears the 'promotionalMessage' field, the 'has' method for this field will now return false */
  public void clearPromotionalMessage() {
    genClient.clear(CacheKey.promotionalMessage);
  }
  /** Clears the 'eCommTransactionInfo' field, the 'has' method for this field will now return false */
  public void clearECommTransactionInfo() {
    genClient.clear(CacheKey.eCommTransactionInfo);
  }
  /** Clears the 'sepaElvTransactionInfo' field, the 'has' method for this field will now return false */
  public void clearSepaElvTransactionInfo() {
    genClient.clear(CacheKey.sepaElvTransactionInfo);
  }
  /** Clears the 'clientCardType' field, the 'has' method for this field will now return false */
  public void clearClientCardType() {
    genClient.clear(CacheKey.clientCardType);
  }
  /** Clears the 'explicitlySelectedApp' field, the 'has' method for this field will now return false */
  public void clearExplicitlySelectedApp() {
    genClient.clear(CacheKey.explicitlySelectedApp);
  }
  /** Clears the 'isSepaElv' field, the 'has' method for this field will now return false */
  public void clearIsSepaElv() {
    genClient.clear(CacheKey.isSepaElv);
  }
  /** Clears the 'printMessages' field, the 'has' method for this field will now return false */
  public void clearPrintMessages() {
    genClient.clear(CacheKey.printMessages);
  }
  /** Clears the 'isPartialApprovedCashbackTransaction' field, the 'has' method for this field will now return false */
  public void clearIsPartialApprovedCashbackTransaction() {
    genClient.clear(CacheKey.isPartialApprovedCashbackTransaction);
  }
  /** Clears the 'acquirer' field, the 'has' method for this field will now return false */
  public void clearAcquirer() {
    genClient.clear(CacheKey.acquirer);
  }
  /** Clears the 'nsuSiTef' field, the 'has' method for this field will now return false */
  public void clearNsuSiTef() {
    genClient.clear(CacheKey.nsuSiTef);
  }
  /** Clears the 'nsuHost' field, the 'has' method for this field will now return false */
  public void clearNsuHost() {
    genClient.clear(CacheKey.nsuHost);
  }
  /** Clears the 'siTefCustomerReceipt' field, the 'has' method for this field will now return false */
  public void clearSiTefCustomerReceipt() {
    genClient.clear(CacheKey.siTefCustomerReceipt);
  }
  /** Clears the 'siTefMerchantReceipt' field, the 'has' method for this field will now return false */
  public void clearSiTefMerchantReceipt() {
    genClient.clear(CacheKey.siTefMerchantReceipt);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public TransactionInfo copyChanges() {
    TransactionInfo copy = new TransactionInfo();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(TransactionInfo src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new TransactionInfo(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<TransactionInfo> CREATOR = new android.os.Parcelable.Creator<TransactionInfo>() {
    @Override
    public TransactionInfo createFromParcel(android.os.Parcel in) {
      TransactionInfo instance = new TransactionInfo(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public TransactionInfo[] newArray(int size) {
      return new TransactionInfo[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<TransactionInfo> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<TransactionInfo>() {
    public Class<TransactionInfo> getCreatedClass() {
      return TransactionInfo.class;
    }

    @Override
    public TransactionInfo create(org.json.JSONObject jsonObject) {
      return new TransactionInfo(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean LANGUAGEINDICATOR_IS_REQUIRED = false;
    public static final long LANGUAGEINDICATOR_MAX_LEN = 2;
    public static final boolean TRANSACTIONLOCALE_IS_REQUIRED = false;
    public static final boolean ACCOUNTSELECTION_IS_REQUIRED = false;
    public static final boolean FISCALINVOICENUMBER_IS_REQUIRED = false;
    public static final long FISCALINVOICENUMBER_MAX_LEN = 12;
    public static final boolean INSTALLMENTSQUANTITY_IS_REQUIRED = false;
    public static final boolean INSTALLMENTSTYPE_IS_REQUIRED = false;
    public static final boolean INSTALLMENTSPLANCODE_IS_REQUIRED = false;
    public static final long INSTALLMENTSPLANCODE_MAX_LEN = 1;
    public static final boolean INSTALLMENTSPLANID_IS_REQUIRED = false;
    public static final boolean INSTALLMENTSPLANDESC_IS_REQUIRED = false;
    public static final boolean CARDTYPELABEL_IS_REQUIRED = false;
    public static final boolean CARDSYMBOL_IS_REQUIRED = false;
    public static final long CARDSYMBOL_MAX_LEN = 2;
    public static final boolean STAN_IS_REQUIRED = false;
    public static final boolean IDENTITYDOCUMENT_IS_REQUIRED = false;
    public static final boolean BATCHNUMBER_IS_REQUIRED = false;
    public static final boolean RECEIPTNUMBER_IS_REQUIRED = false;
    public static final boolean REVERSALSTANREFNUM_IS_REQUIRED = false;
    public static final boolean REVERSALSTAN_IS_REQUIRED = false;
    public static final boolean REVERSALMAC_IS_REQUIRED = false;
    public static final boolean REVERSALMACKSN_IS_REQUIRED = false;
    public static final boolean TERMINALIDENTIFICATION_IS_REQUIRED = false;
    public static final boolean EXTERNALTERMINALID_IS_REQUIRED = false;
    public static final boolean MERCHANTIDENTIFIER_IS_REQUIRED = false;
    public static final boolean MERCHANTNAMELOCATION_IS_REQUIRED = false;
    public static final boolean MASKEDTRACK2_IS_REQUIRED = false;
    public static final boolean RECEIPTEXTRADATA_IS_REQUIRED = false;
    public static final boolean SELECTEDSERVICE_IS_REQUIRED = false;
    public static final boolean TRANSACTIONRESULT_IS_REQUIRED = false;
    public static final boolean TRANSACTIONTAGS_IS_REQUIRED = false;
    public static final boolean TXFORMAT_IS_REQUIRED = false;
    public static final boolean PANMASK_IS_REQUIRED = false;
    public static final long PANMASK_MAX_LEN = 14;
    public static final boolean TRANSACTIONSEQUENCECOUNTER_IS_REQUIRED = false;
    public static final boolean APPLICATIONPANSEQUENCENUMBER_IS_REQUIRED = false;
    public static final boolean APPLICATIONTRANSACTIONCOUNTER_IS_REQUIRED = false;
    public static final boolean REVERSALREASON_IS_REQUIRED = false;
    public static final boolean ISTOKENBASEDTX_IS_REQUIRED = false;
    public static final boolean ORIGTRANSACTIONSEQUENCECOUNTER_IS_REQUIRED = false;
    public static final boolean TRANSACTIONSEQUENCECOUNTERUPDATE_IS_REQUIRED = false;
    public static final boolean EMERGENCYFLAG_IS_REQUIRED = false;
    public static final boolean CARDENTRYTYPE_IS_REQUIRED = false;
    public static final boolean PROMOTIONALMESSAGE_IS_REQUIRED = false;
    public static final boolean ECOMMTRANSACTIONINFO_IS_REQUIRED = false;
    public static final boolean SEPAELVTRANSACTIONINFO_IS_REQUIRED = false;
    public static final boolean CLIENTCARDTYPE_IS_REQUIRED = false;
    public static final boolean EXPLICITLYSELECTEDAPP_IS_REQUIRED = false;
    public static final boolean ISSEPAELV_IS_REQUIRED = false;
    public static final boolean PRINTMESSAGES_IS_REQUIRED = false;
    public static final boolean ISPARTIALAPPROVEDCASHBACKTRANSACTION_IS_REQUIRED = false;
    public static final boolean ACQUIRER_IS_REQUIRED = false;
    public static final boolean NSUSITEF_IS_REQUIRED = false;
    public static final boolean NSUHOST_IS_REQUIRED = false;
    public static final boolean SITEFCUSTOMERRECEIPT_IS_REQUIRED = false;
    public static final boolean SITEFMERCHANTRECEIPT_IS_REQUIRED = false;
  }

}
