/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.payments;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getDataType dataType}</li>
 * <li>{@link #getResponseFormat responseFormat}</li>
 * <li>{@link #getVasData vasData}</li>
 * <li>{@link #getProtocolId protocolId}</li>
 * <li>{@link #getMerchantId merchantId}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class VasPayloadElement extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Indicates the type of data in this response.
   */
  public com.clover.sdk.v3.payments.VasDataType getDataType() {
    return genClient.cacheGet(CacheKey.dataType);
  }

  /**
   * Format of vasData payload.
   */
  public com.clover.sdk.v3.payments.VasResponseFormat getResponseFormat() {
    return genClient.cacheGet(CacheKey.responseFormat);
  }

  /**
   * Vas data.  For NDEF it will be base64 encoded binary.
   */
  public java.lang.String getVasData() {
    return genClient.cacheGet(CacheKey.vasData);
  }

  /**
   * Protocol this payload element was derived from
   */
  public com.clover.sdk.v3.payments.VasProtocol getProtocolId() {
    return genClient.cacheGet(CacheKey.protocolId);
  }

  /**
   * Merchant id associated with this payload element (hex encoded)
   */
  public java.lang.String getMerchantId() {
    return genClient.cacheGet(CacheKey.merchantId);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    dataType
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.payments.VasDataType.JSON_CREATOR)),
    responseFormat
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.payments.VasResponseFormat.class)),
    vasData
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    protocolId
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.payments.VasProtocol.class)),
    merchantId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<VasPayloadElement> genClient;

  /**
   * Constructs a new empty instance.
   */
  public VasPayloadElement() {
    genClient = new GenericClient<VasPayloadElement>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected VasPayloadElement(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public VasPayloadElement(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public VasPayloadElement(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public VasPayloadElement(VasPayloadElement src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'dataType' field is set and is not null */
  public boolean isNotNullDataType() {
    return genClient.cacheValueIsNotNull(CacheKey.dataType);
  }

  /** Checks whether the 'responseFormat' field is set and is not null */
  public boolean isNotNullResponseFormat() {
    return genClient.cacheValueIsNotNull(CacheKey.responseFormat);
  }

  /** Checks whether the 'vasData' field is set and is not null */
  public boolean isNotNullVasData() {
    return genClient.cacheValueIsNotNull(CacheKey.vasData);
  }

  /** Checks whether the 'protocolId' field is set and is not null */
  public boolean isNotNullProtocolId() {
    return genClient.cacheValueIsNotNull(CacheKey.protocolId);
  }

  /** Checks whether the 'merchantId' field is set and is not null */
  public boolean isNotNullMerchantId() {
    return genClient.cacheValueIsNotNull(CacheKey.merchantId);
  }



  /** Checks whether the 'dataType' field has been set, however the value could be null */
  public boolean hasDataType() {
    return genClient.cacheHasKey(CacheKey.dataType);
  }

  /** Checks whether the 'responseFormat' field has been set, however the value could be null */
  public boolean hasResponseFormat() {
    return genClient.cacheHasKey(CacheKey.responseFormat);
  }

  /** Checks whether the 'vasData' field has been set, however the value could be null */
  public boolean hasVasData() {
    return genClient.cacheHasKey(CacheKey.vasData);
  }

  /** Checks whether the 'protocolId' field has been set, however the value could be null */
  public boolean hasProtocolId() {
    return genClient.cacheHasKey(CacheKey.protocolId);
  }

  /** Checks whether the 'merchantId' field has been set, however the value could be null */
  public boolean hasMerchantId() {
    return genClient.cacheHasKey(CacheKey.merchantId);
  }


  /**
   * Sets the field 'dataType'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public VasPayloadElement setDataType(com.clover.sdk.v3.payments.VasDataType dataType) {
    return genClient.setRecord(dataType, CacheKey.dataType);
  }

  /**
   * Sets the field 'responseFormat'.
   */
  public VasPayloadElement setResponseFormat(com.clover.sdk.v3.payments.VasResponseFormat responseFormat) {
    return genClient.setOther(responseFormat, CacheKey.responseFormat);
  }

  /**
   * Sets the field 'vasData'.
   */
  public VasPayloadElement setVasData(java.lang.String vasData) {
    return genClient.setOther(vasData, CacheKey.vasData);
  }

  /**
   * Sets the field 'protocolId'.
   */
  public VasPayloadElement setProtocolId(com.clover.sdk.v3.payments.VasProtocol protocolId) {
    return genClient.setOther(protocolId, CacheKey.protocolId);
  }

  /**
   * Sets the field 'merchantId'.
   */
  public VasPayloadElement setMerchantId(java.lang.String merchantId) {
    return genClient.setOther(merchantId, CacheKey.merchantId);
  }


  /** Clears the 'dataType' field, the 'has' method for this field will now return false */
  public void clearDataType() {
    genClient.clear(CacheKey.dataType);
  }
  /** Clears the 'responseFormat' field, the 'has' method for this field will now return false */
  public void clearResponseFormat() {
    genClient.clear(CacheKey.responseFormat);
  }
  /** Clears the 'vasData' field, the 'has' method for this field will now return false */
  public void clearVasData() {
    genClient.clear(CacheKey.vasData);
  }
  /** Clears the 'protocolId' field, the 'has' method for this field will now return false */
  public void clearProtocolId() {
    genClient.clear(CacheKey.protocolId);
  }
  /** Clears the 'merchantId' field, the 'has' method for this field will now return false */
  public void clearMerchantId() {
    genClient.clear(CacheKey.merchantId);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public VasPayloadElement copyChanges() {
    VasPayloadElement copy = new VasPayloadElement();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(VasPayloadElement src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new VasPayloadElement(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<VasPayloadElement> CREATOR = new android.os.Parcelable.Creator<VasPayloadElement>() {
    @Override
    public VasPayloadElement createFromParcel(android.os.Parcel in) {
      VasPayloadElement instance = new VasPayloadElement(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public VasPayloadElement[] newArray(int size) {
      return new VasPayloadElement[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<VasPayloadElement> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<VasPayloadElement>() {
    public Class<VasPayloadElement> getCreatedClass() {
      return VasPayloadElement.class;
    }

    @Override
    public VasPayloadElement create(org.json.JSONObject jsonObject) {
      return new VasPayloadElement(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean DATATYPE_IS_REQUIRED = false;
    public static final boolean RESPONSEFORMAT_IS_REQUIRED = false;
    public static final boolean VASDATA_IS_REQUIRED = false;
    public static final boolean PROTOCOLID_IS_REQUIRED = false;
    public static final boolean MERCHANTID_IS_REQUIRED = false;
  }

}
