/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.payments;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getZip zip}</li>
 * <li>{@link #getSurchargeProhibited surchargeProhibited}</li>
 * <li>{@link #getModifiedTime modifiedTime}</li>
 * <li>{@link #getDeletedTime deletedTime}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class ZipcodeProperties extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * The zipcode
   */
  public java.lang.String getZip() {
    return genClient.cacheGet(CacheKey.zip);
  }

  /**
   * If the zip code has surcharge prohibited.
   */
  public java.lang.Boolean getSurchargeProhibited() {
    return genClient.cacheGet(CacheKey.surchargeProhibited);
  }

  /**
   * Last modified time
   */
  public java.lang.Long getModifiedTime() {
    return genClient.cacheGet(CacheKey.modifiedTime);
  }

  /**
   * Deleted time
   */
  public java.lang.Long getDeletedTime() {
    return genClient.cacheGet(CacheKey.deletedTime);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    zip
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    surchargeProhibited
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    modifiedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    deletedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<ZipcodeProperties> genClient;

  /**
   * Constructs a new empty instance.
   */
  public ZipcodeProperties() {
    genClient = new GenericClient<ZipcodeProperties>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected ZipcodeProperties(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public ZipcodeProperties(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public ZipcodeProperties(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public ZipcodeProperties(ZipcodeProperties src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'zip' field is set and is not null */
  public boolean isNotNullZip() {
    return genClient.cacheValueIsNotNull(CacheKey.zip);
  }

  /** Checks whether the 'surchargeProhibited' field is set and is not null */
  public boolean isNotNullSurchargeProhibited() {
    return genClient.cacheValueIsNotNull(CacheKey.surchargeProhibited);
  }

  /** Checks whether the 'modifiedTime' field is set and is not null */
  public boolean isNotNullModifiedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.modifiedTime);
  }

  /** Checks whether the 'deletedTime' field is set and is not null */
  public boolean isNotNullDeletedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.deletedTime);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'zip' field has been set, however the value could be null */
  public boolean hasZip() {
    return genClient.cacheHasKey(CacheKey.zip);
  }

  /** Checks whether the 'surchargeProhibited' field has been set, however the value could be null */
  public boolean hasSurchargeProhibited() {
    return genClient.cacheHasKey(CacheKey.surchargeProhibited);
  }

  /** Checks whether the 'modifiedTime' field has been set, however the value could be null */
  public boolean hasModifiedTime() {
    return genClient.cacheHasKey(CacheKey.modifiedTime);
  }

  /** Checks whether the 'deletedTime' field has been set, however the value could be null */
  public boolean hasDeletedTime() {
    return genClient.cacheHasKey(CacheKey.deletedTime);
  }


  /**
   * Sets the field 'id'.
   */
  public ZipcodeProperties setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'zip'.
   */
  public ZipcodeProperties setZip(java.lang.String zip) {
    return genClient.setOther(zip, CacheKey.zip);
  }

  /**
   * Sets the field 'surchargeProhibited'.
   */
  public ZipcodeProperties setSurchargeProhibited(java.lang.Boolean surchargeProhibited) {
    return genClient.setOther(surchargeProhibited, CacheKey.surchargeProhibited);
  }

  /**
   * Sets the field 'modifiedTime'.
   */
  public ZipcodeProperties setModifiedTime(java.lang.Long modifiedTime) {
    return genClient.setOther(modifiedTime, CacheKey.modifiedTime);
  }

  /**
   * Sets the field 'deletedTime'.
   */
  public ZipcodeProperties setDeletedTime(java.lang.Long deletedTime) {
    return genClient.setOther(deletedTime, CacheKey.deletedTime);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'zip' field, the 'has' method for this field will now return false */
  public void clearZip() {
    genClient.clear(CacheKey.zip);
  }
  /** Clears the 'surchargeProhibited' field, the 'has' method for this field will now return false */
  public void clearSurchargeProhibited() {
    genClient.clear(CacheKey.surchargeProhibited);
  }
  /** Clears the 'modifiedTime' field, the 'has' method for this field will now return false */
  public void clearModifiedTime() {
    genClient.clear(CacheKey.modifiedTime);
  }
  /** Clears the 'deletedTime' field, the 'has' method for this field will now return false */
  public void clearDeletedTime() {
    genClient.clear(CacheKey.deletedTime);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public ZipcodeProperties copyChanges() {
    ZipcodeProperties copy = new ZipcodeProperties();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(ZipcodeProperties src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new ZipcodeProperties(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<ZipcodeProperties> CREATOR = new android.os.Parcelable.Creator<ZipcodeProperties>() {
    @Override
    public ZipcodeProperties createFromParcel(android.os.Parcel in) {
      ZipcodeProperties instance = new ZipcodeProperties(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public ZipcodeProperties[] newArray(int size) {
      return new ZipcodeProperties[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<ZipcodeProperties> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<ZipcodeProperties>() {
    public Class<ZipcodeProperties> getCreatedClass() {
      return ZipcodeProperties.class;
    }

    @Override
    public ZipcodeProperties create(org.json.JSONObject jsonObject) {
      return new ZipcodeProperties(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean ZIP_IS_REQUIRED = false;
    public static final boolean SURCHARGEPROHIBITED_IS_REQUIRED = false;
    public static final boolean MODIFIEDTIME_IS_REQUIRED = false;
    public static final boolean DELETEDTIME_IS_REQUIRED = false;
  }

}
