/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.report;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * Total and details on cash added or removed from cash drawer, grouped by device
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getRows rows}</li>
 * <li>{@link #getDevice device}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class CashAdjustmentsByDevice extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Details on cash added or removed from cash drawer for each employee
   */
  public java.util.List<com.clover.sdk.v3.report.CashAdjustmentsByEmployee> getRows() {
    return genClient.cacheGet(CacheKey.rows);
  }

  /**
   * The device that initiated these events
   */
  public com.clover.sdk.v3.device.Device getDevice() {
    return genClient.cacheGet(CacheKey.device);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    rows
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.report.CashAdjustmentsByEmployee.JSON_CREATOR)),
    device
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.device.Device.JSON_CREATOR)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<CashAdjustmentsByDevice> genClient;

  /**
   * Constructs a new empty instance.
   */
  public CashAdjustmentsByDevice() {
    genClient = new GenericClient<CashAdjustmentsByDevice>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected CashAdjustmentsByDevice(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public CashAdjustmentsByDevice(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public CashAdjustmentsByDevice(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public CashAdjustmentsByDevice(CashAdjustmentsByDevice src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'rows' field is set and is not null */
  public boolean isNotNullRows() {
    return genClient.cacheValueIsNotNull(CacheKey.rows);
  }

  /** Checks whether the 'rows' field is set and is not null and is not empty */
  public boolean isNotEmptyRows() { return isNotNullRows() && !getRows().isEmpty(); }

  /** Checks whether the 'device' field is set and is not null */
  public boolean isNotNullDevice() {
    return genClient.cacheValueIsNotNull(CacheKey.device);
  }



  /** Checks whether the 'rows' field has been set, however the value could be null */
  public boolean hasRows() {
    return genClient.cacheHasKey(CacheKey.rows);
  }

  /** Checks whether the 'device' field has been set, however the value could be null */
  public boolean hasDevice() {
    return genClient.cacheHasKey(CacheKey.device);
  }


  /**
   * Sets the field 'rows'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public CashAdjustmentsByDevice setRows(java.util.List<com.clover.sdk.v3.report.CashAdjustmentsByEmployee> rows) {
    return genClient.setArrayRecord(rows, CacheKey.rows);
  }

  /**
   * Sets the field 'device'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public CashAdjustmentsByDevice setDevice(com.clover.sdk.v3.device.Device device) {
    return genClient.setRecord(device, CacheKey.device);
  }


  /** Clears the 'rows' field, the 'has' method for this field will now return false */
  public void clearRows() {
    genClient.clear(CacheKey.rows);
  }
  /** Clears the 'device' field, the 'has' method for this field will now return false */
  public void clearDevice() {
    genClient.clear(CacheKey.device);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public CashAdjustmentsByDevice copyChanges() {
    CashAdjustmentsByDevice copy = new CashAdjustmentsByDevice();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(CashAdjustmentsByDevice src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new CashAdjustmentsByDevice(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<CashAdjustmentsByDevice> CREATOR = new android.os.Parcelable.Creator<CashAdjustmentsByDevice>() {
    @Override
    public CashAdjustmentsByDevice createFromParcel(android.os.Parcel in) {
      CashAdjustmentsByDevice instance = new CashAdjustmentsByDevice(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public CashAdjustmentsByDevice[] newArray(int size) {
      return new CashAdjustmentsByDevice[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<CashAdjustmentsByDevice> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<CashAdjustmentsByDevice>() {
    public Class<CashAdjustmentsByDevice> getCreatedClass() {
      return CashAdjustmentsByDevice.class;
    }

    @Override
    public CashAdjustmentsByDevice create(org.json.JSONObject jsonObject) {
      return new CashAdjustmentsByDevice(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ROWS_IS_REQUIRED = false;
    public static final boolean DEVICE_IS_REQUIRED = false;
  }

}
